#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
# Ref: PhpGroupWare Team
# This script is released under the GNU GPLv2


if(description)
{
 script_id(14296);
 script_bugtraq_id(9386);
 script_version ("$Revision: 1.4 $");
 if ( defined_func("script_xref") ) 
 {
	script_xref(name:"OSVDB", value:"2691");
	script_xref(name:"OSVDB", value:"6857");
 }
 script_cve_id("CAN-2004-0017");
 name["english"] = "PhpGroupWare multiple module SQL injection vulnerabilities";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host seems to be running PhpGroupWare, is a multi-user groupware 
suite written in PHP.

It has been reported that this version may be prone to multiple SQL injection 
vulnerabilities  in the 'calendar' and 'infolog' modules. 

The problems exist due to insufficient sanitization of user-supplied data. 

A remote attacker may exploit these issues to influence SQL query logic to disclose 
sensitive information that could be used to gain unauthorized access. 

Solution : Update to version 0.9.14.007 or newer

See also: http://www.phpgroupware.org/

Risk factor : Medium";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for PhpGroupWare version";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))
	exit(0);

if(http_is_dead(port:port))
	exit(0);

function check(url)
{
	req = http_get(item:string(url, "login.php"), port:port);
	r = http_keepalive_send_recv(port:port, data:req);
	if ( r == NULL ) 
		exit(0);

    	#We need to match this
    	#<META name="AUTHOR" content="phpGroupWare http://www.phpgroupware.org">.*phpGroupWare.*0.9.14.006
    
	if ("phpGroupWare http://www.phpgroupware.org" >< r)
	{
    		if(egrep(pattern:"0\.9\.(12|13|14\.(003|005|006))", string:r))
    		{
 			security_warning(port);
			exit(0);
		}
    	}
 
}

check(url:"");
check(url:"/phpGroupWare/");
check(url:"/phpgw/");

foreach dir (cgi_dirs())
{
 check(url:dir);
}
