#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12622);
 script_bugtraq_id(9832);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CAN-2004-0148");
 name["english"] = "FreeBSD Ports : wu-ftpd <= 2.6.2_3";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an old version of the wu-ftpd (or wu-ftp+ipv6) package 
installed.

wu-ftpd is a FTP daemon. There is a bug in the remote version of this software
which may allow an attacker to bypass the ftpaccess' 'restricted-uid' and
'restricted-gid' directives.

Solution : http://www.vuxml.org/freebsd/3b7c7f6c-7102-11d8-873f-0020ed76ef5a.html
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the apache package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
if ( ! pkgs ) exit(0);

package = egrep(pattern:"^wu-ftpd-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"wu-ftpd-2.6.2_4") < 0 ) 
	security_warning(0);

package = egrep(pattern:"^wu-ftpd+ipv6", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"wu-ftpd-2.6.2_6") < 0 ) 
	security_warning(0);
