#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14385);
 script_version ("$Revision: 1.2 $");
 if ( defined_func("script_xref") ) {
	script_xref(name:"OSVDB", value:"8194");
	script_xref(name:"OSVDB", value:"8195");
  }
 name["english"] = "FreeBSD Ports: moinmoin < 1.2.3";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of moinmoin installed which is older than 1.2.3 

MoinMoin is a Wiki-type program written in python. There is a bug 
in the remote version of this software which may allow a user to override
the ACLs when logged in as an anonymous user, which may result in the ability for
an anonymous user to execute arbitrary administrative commands on the remote 
wiki.


Solution : http://www.vuxml.org/freebsd/1ecf4ca1-f7ad-11d8-96c9-00061bc2ad93.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the moimoin package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^moinmoin-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"moinmoin-1.2.3") < 0 ) 
	security_hole(0);
