#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(14271);
 script_bugtraq_id(10438);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2004-0448");
 name["english"] = "FreeBSD Ports : jftpgw < 0.13.5";

 script_name(english:name["english"]);

 desc["english"] = "
The remote host is running a version of jftpgw less than 0.13.5.

Jftpgw is an FTP/Web proxy.  There is a format string error in 
the logging function which can allow a remote user to subvert
the server and execute arbitrary code.  An attacker, exploiting
this flaw, would need to be able to generate traffic To/From the
proxy which would then be logged.  

Solution : http://www.vuxml.org/freebsd/65a17a3f-ed6e-11d8-aff1-00061bc2ad93.html 

Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the gaim package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");
package = egrep(pattern:"^jftpgw-", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"jftpgw-0.13.5") < 0 )
        security_hole(0);



