<?php

# Rebuild interwiki table using the file on meta and the language list
# Wikimedia specific!
$oldCwd = getcwd();

$optionsWithArgs = array( "o" );
include_once( "commandLine.inc" );

class Site {
	var $suffix, $lateral, $url;

	function Site( $s, $l, $u ) {
		$this->suffix = $s;
		$this->lateral = $l;
		$this->url = $u;
	}

	function getURL( $lang ) {
		return "http://$lang.{$this->url}/wiki/\$1";
	}
}

function getRebuildInterwikiSQL() {
	global $langlist, $languageAliases;

	# Initialise lists of wikis
	$sites = array( 
		'wiki' => new Site( 'wiki', 'w', 'wikipedia.org' ),
		'wiktionary' => new Site( 'wiktionary', 'wikt', 'wiktionary.org' ),
		'wikiquote' => new Site( 'wikiquote', 'q', 'wikiquote.org' ),
		'wikibooks' => new Site( 'wikibooks', 'b', 'wikibooks.org' )
	);
	$langlist = array_map( "trim", file( "/home/wikipedia/common/langlist" ) );
	$dblist = array_map( "trim", file( "/home/wikipedia/common/all.dblist" ) );
	
	$specials = array( 
		'sourceswiki' => 'sources.wikipedia.org',
		'quotewiki' => 'wikiquote.org',
		'textbookwiki' => 'wikibooks.org',
		'sep11wiki' => 'sep11.wikipedia.org',
		'metawiki' => 'meta.wikimedia.org',
	);

	$extraLinks = array(
		array( 'm', 'http://meta.wikimedia.org/wiki/$1', 1 ),
		array( 'meta', 'http://meta.wikimedia.org/wiki/$1', 1 ),
		array( 'sep11', 'http://sep11.wikipedia.org/wiki/$1', 1 ),
	);

	$languageAliases = array(
		'zh-cn' => 'zh',
		'zh-tw' => 'zh',
		'dk' => 'da',
	);

	# Construct a list of reserved prefixes
	$reserved = array();
	foreach ( $langlist as $lang ) {
		$reserved[$lang] = 1;
	}
	foreach ( $languageAliases as $alias => $lang ) {
		$reserved[$alias] = 1;
	}
	foreach( $sites as $site ) {
		$reserved[$site->lateral] = 1;
	}

	# Extract the intermap from meta
	$dbr =& wfGetDB( DB_WRITE );
	$row = $dbr->getArray( "metawiki.cur", array( "cur_text" ), 
		array( "cur_namespace" => 0, "cur_title" => "Interwiki_map" ) );

	if ( !$row ) {
		die( "m:Interwiki_map not found" );
	}

	$lines = explode( "\n", $row->cur_text );
	$iwArray = array();

	foreach ( $lines as $line ) {
		if ( preg_match( '/^\|\s*(.*?)\s*\|\|\s*(.*?)\s*$/', $line, $matches ) ) {
			$prefix = strtolower( $matches[1] );
			$url = $matches[2];
			if ( preg_match( '/(wikipedia|wiktionary|wikisource|wikiquote|wikibooks)\.org/', $url ) ) {
				$local = 1;
			} else {
				$local = 0;
			}
			
			if ( empty( $reserved[$prefix] ) ) {
				$iwArray[] = array( "iw_prefix" => $prefix, "iw_url" => $url, "iw_local" => $local );
			}
		}
	}
	
	$sql = "-- Generated by rebuildInterwiki.php";


	foreach ( $dblist as $db ) {
		if ( isset( $specials[$db] ) ) {
			# Special wiki
			# Has interwiki links and interlanguage links to wikipedia
			
			$host = $specials[$db];
			$sql .= "\n--$host\n\n";
			$sql .= "USE $db;\n" .
					"TRUNCATE TABLE interwiki;\n" . 
					"INSERT INTO interwiki (iw_prefix, iw_url, iw_local) VALUES \n";
			$first = true;
			
			# Intermap links
			foreach ( $iwArray as $iwEntry ) {
				$sql .= makeLink( $iwEntry, $first );
			}

			# Links to multilanguage sites
			foreach ( $sites as $targetSite ) {
				$sql .= makeLink( array( $targetSite->lateral, $targetSite->getURL( 'en' ), 1 ), $first );
			}
			
			# Interlanguage links to wikipedia
			$sql .= makeLanguageLinks( $sites['wiki'], $first );

			# Extra links
			foreach ( $extraLinks as $link ) {
				$sql .= makeLink( $link, $first );
			}
			
			$sql .= ";\n";
		} else {
			# Find out which site this DB belongs to
			$site = false;
			foreach( $sites as $candidateSite ) {
				$suffix = $candidateSite->suffix;
				if ( preg_match( "/(.*)$suffix$/", $db, $matches ) ) {
					$site = $candidateSite;
					break;
				}
			}
			if ( !$site ) {
				print "Invalid database $db\n";
				continue;
			}
			$lang = $matches[1];
			$host = "$lang." . $site->url;
			$sql .= "\n--$host\n\n";
			
			$sql .= "USE $db;\n" .
					"TRUNCATE TABLE interwiki;\n" .
					"INSERT INTO interwiki (iw_prefix,iw_url,iw_local) VALUES\n";
			$first = true;

			# Intermap links
			foreach ( $iwArray as $iwEntry ) {
				# Suppress links with the same name as the site
				if ( ( $suffix == 'wiki' && $iwEntry['iw_prefix'] != 'wikipedia' ) || 
				  ( $suffix != 'wiki' && $suffix != $iwEntry['iw_prefix'] ) ) 
				{
					$sql .= makeLink( $iwEntry, $first );
				}
			}

			# Lateral links
			foreach ( $sites as $targetSite ) {
				# Suppress link to self
				if ( $targetSite->suffix != $site->suffix ) {
					$sql .= makeLink( array( $targetSite->lateral, $targetSite->getURL( $lang ), 1 ), $first );
				}
			}

			# Interlanguage links
			$sql .= makeLanguageLinks( $site, $first );

			# w link within wikipedias
			# Other sites already have it as a lateral link
			if ( $site->suffix == "wiki" ) {
				$sql .= makeLink( array("w", "http://en.wikipedia.org/wiki/$1", 1), $first );
			}
			
			# Extra links
			foreach ( $extraLinks as $link ){ 
					$sql .= makeLink( $link, $first );
			}
			$sql .= ";\n\n";
		}
	}
	return $sql;
}

# ------------------------------------------------------------------------------------------

# Returns part of an INSERT statement, corresponding to all interlanguage links to a particular site
function makeLanguageLinks( &$site, &$first ) {
	global $langlist, $languageAliases;

	$sql = "";

	# Actual languages with their own databases
	foreach ( $langlist as $targetLang ) {
		$sql .= makeLink( array( $targetLang, $site->getURL( $targetLang ), 1 ), $first );
	}

	# Language aliases
	foreach ( $languageAliases as $alias => $lang ) {
		$sql .= makeLink( array( $alias, $site->getURL( $lang ), 1 ), $first );
	}
	return $sql;
}

# Make SQL for a single link from an array
function makeLink( $entry, &$first ) {
	$sql = "";
	# Add comma
	if ( $first ) {
		$first = false;
	} else {
		$sql .= ",\n";
	}
	$sql .= "(" . Database::makeList( $entry ) . ")";
	return $sql;
}

?>
