/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#ifndef _ERL_RESOLVE_H
#define _ERL_RESOLVE_H

struct hostent *erl_gethostbyname(const char *);
struct hostent *erl_gethostbyaddr(const char *, int, int);

#if !defined (__WIN32__)
struct hostent *erl_gethostbyname_r(const char *, struct hostent *, char *, int, int *);
struct hostent *erl_gethostbyaddr_r(const char *, int, int, struct hostent *, char *, int, int *);

#ifdef VXWORKS
#include "resolver_vxworks/netdb.h"
extern int h_errno;
#endif
#endif


#endif /* _ERL_RESOLVE_H */
