%% ``The contents of this file are subject to the Erlang Public License,
%% Version 1.0, (the "License"); you may not use this file except in
%% compliance with the License. You may obtain a copy of the License at
%% http://www.erlang.org/EPL1_0.txt
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% The Original Code is Erlang-4.7.3, December, 1998.
%% 
%% The Initial Developer of the Original Code is Ericsson Telecom
%% AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
%% Telecom AB. All Rights Reserved.
%% 
%% Contributor(s): ______________________________________.''
%%
%% Copyright (C) 1991, Ellemtel Telecommunications Systems Laboratories
%% File	   : shell_default.erl
%% Author  : Joe Armstrong, Robert Virding
%% Purpose : Utilities to use from shell.
%%         : Just calls the utilities in 'c' and 'i'
%%
%% Modified: 95-01-27 by Magnus Froberg
%%           Added the interpreter 'i' module interface.
%%           All functions starts with i... !

%% shell_default is intended for 'rolling you own'
%% add or remove code as you feel free
%% This is just a empty template which calls routoines in the modulke c
%% to do all the work!

-module(shell_default).
-copyright('Copyright (c) 1991-97 Ericsson Telecom AB').
-vsn('$Revision: /main/release/free/1').

-export([help/0,lc/1,c/1,c/2,nc/1,nl/1,l/1,i/0,pid/3,i/3,m/0,m/1,
	 erlangrc/1,bi/1, regs/0, flush/0,pwd/0,ls/0,ls/1,cd/1, 
	 ni/0, nregs/0]).

-export([ih/0,iv/0,im/0,ii/1,ii/2,iq/1,ini/1,ini/2,inq/1,ib/2,ib/3,
	 ir/2,ir/3,ibd/2,ibe/2,iba/3,ibc/3,
	 ic/0,ir/1,ir/0,il/0,ipb/0,ipb/1,iaa/1,iaa/2,ist/1,ia/1,ia/2,ia/3,
	 ia/4,ip/0]).

-import(io, [format/1]).

help() ->
    format('** shell internal commands **~n'),
    format('b()        -- display all variable bindings~n'),
    format('e(N)       -- repeat the expression in query <N>~n'),
    format('f()        -- forget all variable bindings~n'),
    format('h()        -- history~n'),    
    format('v(N)       -- use the value of query <N>~n'),
    format('** commands in module c **~n'),
    c:help(),
    format('** commands in module i (interpreter interface) **~n'),
    format('ih()       -- print help for the i module~n'),
    %% format('** private commands ** ~n'),
    %% format('myfunc()   -- does my operation ...\n'),
    true.

%% these are in alphabetic order it would be nice if they
%% were to *stay* so!

bi(I) 		-> c:bi(I).
c(File) 	-> c:c(File).
c(File, Opt)    -> c:c(File, Opt).
cd(D)           -> c:cd(D).
erlangrc(X) 	-> c:erlangrc(X).
flush()         -> c:flush().
i() 		-> c:i().
i(X,Y,Z) 	-> c:i(X,Y,Z).
l(Mod)       	-> c:l(Mod).
lc(X)  		-> c:lc(X).
ls()            -> c:ls().
ls(S)           -> c:ls(S).
m() 		-> c:m().
m(Mod) 		-> c:m(Mod).
nc(X)     	-> c:nc(X).
ni()            -> c:ni().
nl(Mod) 	-> c:nl(Mod).
nregs()         -> c:nregs().
pid(X,Y,Z) 	-> c:pid(X,Y,Z).
pwd()           -> c:pwd().
regs()          -> c:regs().

iaa(Flag)       -> i:iaa(Flag).
iaa(Flag,Fnk)   -> i:iaa(Flag,Fnk).
ist(Flag)       -> i:ist(Flag).
ia(Pid)         -> i:ia(Pid).
ia(X,Y,Z)       -> i:ia(X,Y,Z).
ia(Pid,Fnk)     -> i:ia(Pid,Fnk).
ia(X,Y,Z,Fnk)   -> i:ia(X,Y,Z,Fnk).
ib(Mod,Line)    -> i:ib(Mod,Line).
ib(Mod,Fnk,Arity) -> i:ib(Mod,Fnk,Arity).
ibd(Mod,Line)   -> i:ibd(Mod,Line).
ibe(Mod,Line)   -> i:ibe(Mod,Line).
iba(M,L,Action) -> i:iba(M,L,Action).
ibc(M,L,Cond)   -> i:ibc(M,L,Cond).
ic()            -> i:ic().
ih()            -> i:help().
ii(Mod)         -> i:ii(Mod).
ii(Mod,Op)      -> i:ii(Mod,Op).
il()            -> i:il().
im()            -> i:im().
ini(Mod)        -> i:ini(Mod).
ini(Mod,Op)     -> i:ini(Mod,Op).
inq(Mod)        -> i:inq(Mod).
ip()            -> i:ip().
ipb()           -> i:ipb().
ipb(Mod)        -> i:ipb(Mod).
iq(Mod)         -> i:iq(Mod).
ir(Mod,Line)    -> i:ir(Mod,Line).
ir(Mod,Fnk,Arity) -> i:ir(Mod,Fnk,Arity).
ir(Mod)         -> i:ir(Mod).
ir()            -> i:ir().
iv()            -> i:iv().


    
