# Author:  Chao-Kuei Hung
# For more info, including license, please see doc/index.html

package PQueue;

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);

require Exporter;
use Carp;
use Data::Dumper;
use overload
    '""' => 'stringify',
    'fallback' => undef
;

@ISA = qw(Exporter);
@EXPORT = qw();
@EXPORT_OK = qw();
%EXPORT_TAGS = (all => [@EXPORT_OK]);

$VERSION = '0.1';

sub new {
    my ($class, %opts) = @_;
    $class = ref($class) if ref($class);
    my ($updated_opt) = ::merge_config_opts($class, \%opts);
    my ($self) = bless {"#data"=>[0]}, $class;
    # the following options need only be stored and need no further processing
    my ($k);
    foreach $k (qw(-compare)) {
	$self->{$k} = exists $opts{$k} ? delete $opts{$k} : undef;
    }
#    if (ref($class)) {
#	$Data::Dumper::Terse = 1;
#	return eval(Dumper($class));	# cloning
#    }
    return $self;
}

sub size {
    my ($self, $newsize) = @_;
    $#{$self->{"#data"}} = $newsize if (defined $newsize);
    return $#{$self->{"#data"}};
}

sub is_empty {
    my ($self) = @_;
    return $self->size() <= 0;
}

sub stringify {
    my ($self) = @_;
    return "PQ[" . join(" ", @{$self->{'#data'}}[1..$self->size()]) . "]";
}

sub find {
    my ($self, $target) = @_;
    my ($i);
    for ($i=$self->size(); $i>0; --$i) {
	last if $self->{"#data"}[$i] eq $target;
    }
    return $i;
}

if ($0 =~ /PQueue.pm$/) {
# being tested as a stand-alone program, so run test code.

require ".algotutor";
my ($q) = PQueue->new();
print "<$q>\n";

}

1;

