\name{TclInterface}
\title{Low-level Tcl/Tk Interface}
%
\alias{TclInterface}
\alias{.Tcl}
\alias{.Tcl.objv}
\alias{.Tcl.callback}
\alias{.Tcl.args}
\alias{.Tcl.args.objv}
\alias{$.tclvar}
\alias{$<-.tclvar}
\alias{tclvar}
\alias{tclVar}
\alias{as.character.tclVar}
\alias{tclArray}
\alias{[[.tclArray}
\alias{[[<-.tclArray}
\alias{$.tclArray}
\alias{$<-.tclArray}
\alias{names.tclArray}
\alias{length.tclArray}
\alias{names<-.tclArray}
\alias{length<-.tclArray}
\alias{tclvalue}
\alias{tclvalue<-}
\alias{tclvalue.default}
\alias{tclvalue<-.default}
\alias{tclvalue.tclVar}
\alias{tclvalue<-.tclVar}
\alias{tclvalue.tclObj}
\alias{as.character.tclObj}
\alias{as.integer.tclObj}
\alias{as.double.tclObj}
\alias{as.tclObj}
\alias{is.tclObj}
\alias{tclObj}
\alias{print.tclObj}
\alias{tclObj<-}
\alias{tclObj.tclVar}
\alias{tclObj<-.tclVar}
\alias{.Tk.ID}
\alias{.Tk.newwin}
\alias{.Tk.subwin}
\alias{is.tkwin}
\alias{tkdestroy}
\alias{.TkWin}
\alias{.TkRoot}
\alias{addTclPath}
\alias{tclRequire}
\description{
  These functions and variables provide the basic glue between \R and the
  Tcl interpreter and Tk GUI toolkit. Tk
  windows may be represented via \R objects. Tcl variables can be accessed
  via objects of class \code{tclVar} and the C level interface to Tcl
  objects is accessed via objects of class \code{tclObj}.
}
\usage{
.Tcl(...)
.Tcl.objv(objv)
.Tcl.args(...)
.Tcl.args.objv(...)
.Tcl.callback(...)
.Tk.ID(win)
.Tk.newwin(ID)
.Tk.subwin(parent)
.TkWin
.TkRoot

tkdestroy(win)
is.tkwin(x)

tclvalue(x)
tclvalue(x) <- value

tclVar(init="")
\method{as.character}{tclVar}(x)
\method{tclvalue}{tclVar}(x)
\method{tclvalue}{tclVar}(x) <- value

tclArray()
\method{[[}{tclArray}(x,...)
\method{[[}{tclArray}(x,...) <- value
\method{$}{tclArray}(x, i)
\method{$}{tclArray}(x, i) <- value
\method{names}{tclArray}
\method{length}{tclArray}

tclObj(x)
tclObj(x) <- value
\method{tclObj}{tclVar}(x)
\method{tclObj}{tclVar}(x) <- value

as.tclObj(x, drop=FALSE)
is.tclObj(x)

\method{as.character}{tclObj}(x)
\method{as.integer}{tclObj}(x, ...)
\method{as.double}{tclObj}(x, ...)
\method{tclvalue}{tclObj}(x)

\method{tclvalue}{default}(x)
\method{tclvalue}{default}(x) <- value


addTclPath(path = ".")
tclRequire(package, warn = TRUE)
}
\arguments{
  \item{objv}{a named vector of Tcl objects}
  \item{win}{a window structure}
  \item{x}{an object}
  \item{drop}{logical. Indicates whether a single-element vector should
    be made into a simple Tcl object or a list of length one}
  \item{value}{For \code{tclvalue} assignments, a character string. For
    \code{tclObj} assignments, an object of class \code{tclObj}}
  \item{ID}{a window ID}
  \item{parent}{a window which becomes the parent of the resulting window}
  \item{path}{path to a directory containing Tcl packages}
  \item{package}{a Tcl package name}
  \item{warn}{logical. Warn if not found?}
  \item{...}{Additional arguments. See below.}
  \item{init}{initialization value}
}
\details{
  Many of these functions are not intended for general use but are used
  internally by the commands that create and manipulate Tk widgets and
  Tcl objects.  At the lowest level \code{.Tcl} sends a command as a text
  string to the Tcl interpreter and returns the result as an object of
  class \code{tclObj} (see below). A newer variant \code{.Tcl.objv}
  accepts arguments in the form of a named list of \code{tclObj}
  objects. 

  \code{.Tcl.args} converts an R argument list of \code{tag=value} pairs
  to the Tcl \code{-option value} style, thus
  enabling a simple translation between the two languages. To send a
  value with no preceding option flag to Tcl, just use an untagged
  argument. In the rare case one needs an option with no subsequent
  value \code{tag=NULL} can be used. Most values are just converted to
  character mode and inserted in the command string, but window objects
  are passed using their ID string, and callbacks are passed via the
  result of \code{.Tcl.callback}. Tags are converted to option flags
  simply by prepending a \code{-}

  \code{.Tcl.args.objv} serves a similar purpose as \code{.Tcl.args} but
  produces a list of \code{tclObj} objects suitable for passing to
  \code{.Tcl.objv}. The names of the list are converted to Tcl option
  style internally by \code{.Tcl.objv}. 
  
  Callbacks can be either \emph{atomic callbacks} handled by
  \code{.Tcl.callback} or expressions. An expression is treated as a
  list of atomic callbacks, with the following exceptions: if an
  element is a name, it is first evaluated in the callers frame, and
  likewise if it is an explicit function definition; the \code{break}
  expression is translated directly to the Tcl counterpart.
  \code{.Tcl.callback} converts \R functions and unevaluated calls to
  Tcl command strings.  The argument must be either a function closure
  or an object of mode \code{"call"} followed by an environment.  The
  return value in the first case is of the form \code{R_call
  0x408b94d4} in which the hexadecimal number is the memory address of
  the function. In the second case it will be of the form
  \code{R_call_lang 0x8a95904 0x819bfd0}. For expressions, a sequence
  of similar items is generated, separated by
  semicolons. \code{.Tcl.args} takes special precautions to ensure
  that functions or calls will continue to exist at the specified
  address by assigning the
  callback into the relevant window environment (see below).

  Tk windows are represented as objects of class \code{tkwin} which are
  lists containing  a \code{ID} field and an \code{env} field which is
  an \R environments, enclosed in the global environment.  The value of
  the \code{ID} field is identical to the Tk window name. The \code{env}
  environment contains a \code{parent} variable and a \code{num.subwin}
  variable.  If the   window obtains subwindows and  callbacks, they are
  added as variables to the environment.   \code{.TkRoot} is the top
  window with ID "."; this window is not  displayed in order to avoid
  ill effects of closing it via window  manager controls. The
  \code{parent} variable is undefined for \code{.TkRoot}.

  \code{.Tk.ID} extracts the \code{ID} of a window,
  \code{.Tk.newwin} creates a new window environment with a given ID and
  \code{.Tk.subwin} creates a new window which is a subwindow of a given
  parent window.

  \code{tkdestroy} destroys a window and also removes the reference to a
  window from its parent.

  \code{is.tkwin} can be used to test whether a given object is a window
  environment.

  \code{tclVar} creates a new Tcl variable and initializes it to
  \code{init}. An R object of class \code{tclVar} is created to
  represent it. Using \code{as.character} on the object returns the Tcl
  variable name. Accessing the Tcl variable from R is done using the 
  \code{tclvalue} function, which can also occur on the left sie of
  assignments. If \code{tclvalue} is passed an argument which is not a
  \code{tclVar} object, then it will assume that it is a character string
  explicitly naming global Tcl variable. Tcl variables created by 
  \code{tclVar}  are  uniquely named and automatically unset by the 
  garbage collector when the representing object is no longer in use. 

  \code{tclArray} creates a new Tcl array and initalizes it to the empty
  array. An R object of class \code{tclArray} and inheriting from class
  \code{tclVar} is created to represent it. You can access elements of
  the Tcl array using indexing with \code{[[} or \code{$}, which also
  allow replacement forms. Notice that Tcl arrays are associative by
  nature and hence unordered; indexing with a numeric index \code{i}
  refers to the element with the \emph{name}
  \code{as.character(i)}. Multiple indices are pasted together separated
  by commas to form a single name. You can query the
  length and the set of names in an array using methods for
  \code{length} and \code{names}, respectively; these cannot
  meaningfully be set so assignment forms exist only to print an error
  message. 

  It is possible to access Tcl's \sQuote{dual-ported} objects directly,
  thus avoiding parsing and deparsing of their string representation.
  This works by using objects of class \code{tclObj}.  The string
  representation of such objects can be extracted (but not set) using
  \code{tclvalue} and conversion to vectors of mode \code{"character"},
  \code{"double"}, or \code{"integer"}. Conversely, such vectors can be
  converted using \code{as.tclObj}. There is an ambiguity as to what
  should happen for length one vectors, controlled by the \code{drop}
  argument; there are cases where the distiction matters to Tcl,
  although mostly it treats them equivalently. Notice that
  \code{tclvalue} and \code{as.character} differ on an object whose
  string representation has embedded spaces, the former is sometimes to
  be preferred, in particular when applied to the result of
  \code{tkread}, \code{tkgetOpenFile}, and similar functions. 

  The object behind a \code{tclVar} object
  is extracted using \code{tclObj(x)} which also allows an assignment
  form, in which the right hand side of the assignment is automatically
  converted using \code{as.tclObj}. There is a print method for
  \code{tclObj} objects; it prints \code{<Tcl>} followed by the string
  representation of the object. Notice that \code{as.character} on a
  \code{tclVar} object is the \emph{name} of the corresponding Tcl
  variable and not the value. 
  
  Tcl packages can be loaded with \code{tclRequire}; it may be necessary
  to add the directory where they are found to the Tcl search path with
  \code{addTclPath}.
}
\note{ Strings containing unbalanced braces are currently not handled
  well in many circumstances.
}
\seealso{
  \code{\link{TkWidgets}},
  \code{\link{TkCommands}},
  \code{\link{TkWidgetcmds}}.

  \code{\link{capabilities}("tcltk")} to see if Tcl/Tk support was
  compiled into this build of \R.
#ifdef windows
  (It is possible to build with Tcl/Tk support but not be able to run it,
  if the DLLs are not available or \code{TCL_LIBRARY)} is not set.)
#endif
}
\examples{
\dontrun{
## These cannot be run by example() but should be OK when pasted
## into an interactive R session with the tcltk package loaded
.Tcl("format \"\%s\\n\" \"Hello, World!\"")
f <- function()cat("HI!\n")
.Tcl.callback(f)
.Tcl.args(text="Push!", command=f) # NB: Different address

xyzzy <- tclVar(7913)
tclvalue(xyzzy)
tclvalue(xyzzy) <- "foo"
as.character(xyzzy)
tkcmd("set", as.character(xyzzy))

top <- tktoplevel() # a Tk widget, see Tk-widgets
ls(envir=top$env, all=TRUE)
ls(envir=.TkRoot$env, all=TRUE)# .Tcl.args put a callback ref in here
}
}
\keyword{ misc }

\eof
\name{TkCommands}
\alias{TkCommands}
\alias{tkcmd}
\alias{tktitle}
\alias{tktitle<-}
\alias{tkbell}
\alias{tkbind}
\alias{tkbindtags}
\alias{tkfocus}
\alias{tklower}
\alias{tkraise}
\alias{tkclipboard.append}
\alias{tkclipboard.clear}
\alias{tkevent.add}
\alias{tkevent.delete}
\alias{tkevent.generate}
\alias{tkevent.info}
\alias{tkfont.actual}
\alias{tkfont.configure}
\alias{tkfont.create}
\alias{tkfont.delete}
\alias{tkfont.families}
\alias{tkfont.measure}
\alias{tkfont.metrics}
\alias{tkfont.names}
\alias{tkgrab}
\alias{tkgrab.current}
\alias{tkgrab.release}
\alias{tkgrab.set}
\alias{tkgrab.status}
\alias{tkimage.cget}
\alias{tkimage.configure}
\alias{tkimage.create}
\alias{tkimage.names}
\alias{tkXselection.clear}
\alias{tkXselection.get}
\alias{tkXselection.handle}
\alias{tkXselection.own}
\alias{tkwait.variable}
\alias{tkwait.visibility}
\alias{tkwait.window}
\alias{tkwinfo}
\alias{tkwm.aspect}
\alias{tkwm.client}
\alias{tkwm.colormapwindows}
\alias{tkwm.command}
\alias{tkwm.deiconify}
\alias{tkwm.focusmodel}
\alias{tkwm.frame}
\alias{tkwm.geometry}
\alias{tkwm.grid}
\alias{tkwm.group}
\alias{tkwm.iconbitmap}
\alias{tkwm.iconify}
\alias{tkwm.iconmask}
\alias{tkwm.iconname}
\alias{tkwm.iconposition}
\alias{tkwm.iconwindow}
\alias{tkwm.maxsize}
\alias{tkwm.minsize}
\alias{tkwm.overrideredirect}
\alias{tkwm.positionfrom}
\alias{tkwm.protocol}
\alias{tkwm.resizable}
\alias{tkwm.sizefrom}
\alias{tkwm.state}
\alias{tkwm.title}
\alias{tkwm.transient}
\alias{tkwm.withdraw}
\alias{tkgrid}
\alias{tkgrid.bbox}
\alias{tkgrid.columnconfigure}
\alias{tkgrid.configure}
\alias{tkgrid.forget}
\alias{tkgrid.info}
\alias{tkgrid.location}
\alias{tkgrid.propagate}
\alias{tkgrid.rowconfigure}
\alias{tkgrid.remove}
\alias{tkgrid.size}
\alias{tkgrid.slaves}
\alias{tkpack}
\alias{tkpack.configure}
\alias{tkpack.forget}
\alias{tkpack.info}
\alias{tkpack.propagate}
\alias{tkpack.slaves}
\alias{tkplace}
\alias{tkplace.configure}
\alias{tkplace.forget}
\alias{tkplace.info}
\alias{tkplace.slaves}
\alias{tkgetOpenFile}
\alias{tkgetSaveFile} 
\alias{tkchooseDirectory}        
\alias{tkmessageBox}  
\alias{tkdialog}        
\alias{tkpopup}        
\alias{tkfile.tail}
\alias{tkfile.dir}
\alias{tkopen}
\alias{tkclose}
\alias{tkputs}        
\alias{tkread}        

\title{Tk non-widget commands}
\description{
  These functions interface to Tk non-widget commands, such as the
  window manager interface commands and the geometry managers.
}
\usage{
tkcmd(...)
tktitle(x)

tktitle(x) <- value

tkbell(...)
tkbind(...)
tkbindtags(...)
tkfocus(...)
tklower(...)
tkraise(...)

tkclipboard.append(...)
tkclipboard.clear(...)

tkevent.add(...)
tkevent.delete(...)
tkevent.generate(...)
tkevent.info(...)

tkfont.actual(...)
tkfont.configure(...)
tkfont.create(...)
tkfont.delete(...)
tkfont.families(...)
tkfont.measure(...)
tkfont.metrics(...)
tkfont.names(...)

tkgrab(...)
tkgrab.current(...)
tkgrab.release(...)
tkgrab.set(...)
tkgrab.status(...)

tkimage.cget(...)
tkimage.configure(...)
tkimage.create(...)
tkimage.names(...)

## NB: some widgets also have a selection.clear command, hence the "X".

tkXselection.clear(...)
tkXselection.get(...)
tkXselection.handle(...)
tkXselection.own(...)

tkwait.variable(...)
tkwait.visibility(...)
tkwait.window(...)

## winfo actually has a large number of subcommands, but it's rarely
## used, so use tkwinfo("atom", ...) etc. instead.

tkwinfo(...)

# Window manager interface

tkwm.aspect(...)
tkwm.client(...)
tkwm.colormapwindows(...)
tkwm.command(...)
tkwm.deiconify(...)
tkwm.focusmodel(...)
tkwm.frame(...)
tkwm.geometry(...)
tkwm.grid(...)
tkwm.group(...)
tkwm.iconbitmap(...)
tkwm.iconify(...)
tkwm.iconmask(...)
tkwm.iconname(...)
tkwm.iconposition(...)
tkwm.iconwindow(...)
tkwm.maxsize(...)
tkwm.minsize(...)
tkwm.overrideredirect(...)
tkwm.positionfrom(...)
tkwm.protocol(...)
tkwm.resizable(...)
tkwm.sizefrom(...)
tkwm.state(...)
tkwm.title(...)
tkwm.transient(...)
tkwm.withdraw(...)


### Geometry managers

tkgrid(...)
tkgrid.bbox(...)
tkgrid.columnconfigure(...)
tkgrid.configure(...)
tkgrid.forget(...)
tkgrid.info(...)
tkgrid.location(...)
tkgrid.propagate(...)
tkgrid.rowconfigure(...)
tkgrid.remove(...)
tkgrid.size(...)
tkgrid.slaves(...)

tkpack(...)
tkpack.configure(...)
tkpack.forget(...)
tkpack.info(...)
tkpack.propagate(...)
tkpack.slaves(...)

tkplace(...)
tkplace.configure(...)
tkplace.forget(...)
tkplace.info(...)
tkplace.slaves(...)

## Standard dialogs
tkgetOpenFile(...)
tkgetSaveFile(...)
tkchooseDirectory(...)
tkmessageBox(...)
tkdialog(...)
tkpopup(...)


## File handling functions
tkfile.tail(...)
tkfile.dir(...)
tkopen(...)
tkclose(...)
tkputs(...)
tkread(...)
}
\arguments{
  \item{x}{A window object}
  \item{value}{For \code{tktitle} assignments, a character string.}
  \item{\dots}{Handled via \code{.Tcl.args}}
}
\details{
   
  \code{tkcmd} provides a generic interface to calling any Tk or Tcl
  command by simply running \code{.Tcl.args.objv} on the argument list
  and passing the
  result to \code{.Tcl.objv}. Most of the other commands simply call
  \code{tkcmd} with a particular
  first argument and sometimes also a second argument giving the
  subcommand.

  \code{tktitle} and its assignment form provides an alternate interface
  to Tk's \code{wm title}
  
  There are far too many of these commands to describe them and their
  arguments in full. Please refer to the Tcl/Tk documentation for details.
  Except for a few exceptions, the pattern is that  Tcl subcommands like
  \code{pack configure} are converted to function names like
  \code{tkpack.configure}. 
}
\seealso{\code{\link{TclInterface}}, \code{\link{TkWidgets}},
  \code{\link{TkWidgetcmds}}}

\examples{
\dontrun{
## These cannot be run by examples() but should be OK when pasted
## into an interactive R session with the tcltk package loaded

tt <- tktoplevel()
tkpack(l1<-tklabel(tt,text="Heave"),l2<-tklabel(tt,text="Ho"))
tkpack.configure(l1,side="left")

## Try stretching the window and then

tkdestroy(tt)
}

}
\keyword{misc}%-- one or more ...
\eof
\name{TkWidgetcmds}
\alias{TkWidgetcmds}
\alias{tkactivate}
\alias{tkadd}
\alias{tkaddtag}
\alias{tkbbox}
\alias{tkcanvasx}
\alias{tkcanvasy}
\alias{tkcget}
\alias{tkcompare}
\alias{tkconfigure}
\alias{tkcoords}
\alias{tkcreate}
\alias{tkcurselection}
\alias{tkdchars}
\alias{tkdebug}
\alias{tkdelete}
\alias{tkdelta}
\alias{tkdeselect}
\alias{tkdlineinfo}
\alias{tkdtag}
\alias{tkdump}
\alias{tkentrycget}
\alias{tkentryconfigure}
\alias{tkfind}
\alias{tkflash}
\alias{tkfraction}
\alias{tkget}
\alias{tkgettags}
\alias{tkicursor}
\alias{tkidentify}
\alias{tkindex}
\alias{tkinsert}
\alias{tkinvoke}
\alias{tkitembind}
\alias{tkitemcget}
\alias{tkitemconfigure}
\alias{tkitemfocus}
\alias{tkitemlower}
\alias{tkitemraise}
\alias{tkitemscale}
\alias{tkmark.gravity}
\alias{tkmark.names}
\alias{tkmark.next}
\alias{tkmark.previous}
\alias{tkmark.set}
\alias{tkmark.unset}
\alias{tkmove}
\alias{tknearest}
\alias{tkpost}
\alias{tkpostcascade}
\alias{tkpostscript}
\alias{tkscan.mark}
\alias{tkscan.dragto}
\alias{tksearch}
\alias{tksee}
\alias{tkselect}
\alias{tkselection.adjust}
\alias{tkselection.anchor}
\alias{tkselection.clear}
\alias{tkselection.from}
\alias{tkselection.includes}
\alias{tkselection.present}
\alias{tkselection.range}
\alias{tkselection.set}
\alias{tkselection.to}
\alias{tkset}
\alias{tksize}
\alias{tktoggle}
\alias{tktag.add}
\alias{tktag.bind}
\alias{tktag.cget}
\alias{tktag.configure}
\alias{tktag.delete}
\alias{tktag.lower}
\alias{tktag.names}
\alias{tktag.nextrange}
\alias{tktag.prevrange}
\alias{tktag.raise}
\alias{tktag.ranges}
\alias{tktag.remove}
\alias{tktype}
\alias{tkunpost}
\alias{tkwindow.cget}
\alias{tkwindow.configure}
\alias{tkwindow.create}
\alias{tkwindow.names}
\alias{tkxview}
\alias{tkxview.moveto}
\alias{tkxview.scroll}
\alias{tkyposition}
\alias{tkyview}
\alias{tkyview.moveto}
\alias{tkyview.scroll}


\title{Tk widget commands}
\description{
  These functions interface to Tk widget commands.
}
\usage{
tkactivate(widget, ...)
tkadd(widget, ...)
tkaddtag(widget, ...)
tkbbox(widget, ...)
tkcanvasx(widget, ...)
tkcanvasy(widget, ...)
tkcget(widget, ...)
tkcompare(widget, ...)
tkconfigure(widget, ...)
tkcoords(widget, ...)
tkcreate(widget, ...)
tkcurselection(widget,...)
tkdchars(widget, ...)
tkdebug(widget, ...)
tkdelete(widget, ...)
tkdelta(widget, ...)
tkdeselect(widget, ...)
tkdlineinfo(widget, ...)
tkdtag(widget, ...)
tkdump(widget, ...)
tkentrycget(widget, ...)
tkentryconfigure(widget, ...)
tkfind(widget, ...)
tkflash(widget, ...)
tkfraction(widget, ...)
tkget(widget, ...)
tkgettags(widget, ...)
tkicursor(widget, ...)
tkidentify(widget, ...)
tkindex(widget, ...)
tkinsert(widget, ...)
tkinvoke(widget, ...)
tkitembind(widget, ...)
tkitemcget(widget, ...)
tkitemconfigure(widget, ...)
tkitemfocus(widget, ...)
tkitemlower(widget, ...)
tkitemraise(widget, ...)
tkitemscale(widget, ...)
tkmark.gravity(widget, ...)
tkmark.names(widget, ...)
tkmark.next(widget, ...)
tkmark.previous(widget, ...)
tkmark.set(widget, ...)
tkmark.unset(widget, ...)
tkmove(widget, ...)
tknearest(widget, ...)
tkpost(widget, ...)
tkpostcascade(widget, ...)
tkpostscript(widget, ...)
tkscan.mark(widget, ...)
tkscan.dragto(widget, ...)
tksearch(widget, ...)
tksee(widget, ...)
tkselect(widget, ...)
tkselection.adjust(widget, ...)
tkselection.anchor(widget, ...)
tkselection.clear(widget, ...)
tkselection.from(widget, ...)
tkselection.includes(widget, ...)
tkselection.present(widget, ...)
tkselection.range(widget, ...)
tkselection.set(widget, ...)
tkselection.to(widget,...)
tkset(widget, ...)
tksize(widget, ...)
tktoggle(widget, ...)
tktag.add(widget, ...)
tktag.bind(widget, ...)
tktag.cget(widget, ...)
tktag.configure(widget, ...)
tktag.delete(widget, ...)
tktag.lower(widget, ...)
tktag.names(widget, ...)
tktag.nextrange(widget, ...)
tktag.prevrange(widget, ...)
tktag.raise(widget, ...)
tktag.ranges(widget, ...)
tktag.remove(widget, ...)
tktype(widget, ...)
tkunpost(widget, ...)
tkwindow.cget(widget, ...)
tkwindow.configure(widget, ...)
tkwindow.create(widget, ...)
tkwindow.names(widget, ...)
tkxview(widget, ...)
tkxview.moveto(widget, ...)
tkxview.scroll(widget, ...)
tkyposition(widget, ...)
tkyview(widget, ...)
tkyview.moveto(widget, ...)
tkyview.scroll(widget, ...)
}
\arguments{
  \item{widget}{The widget this applies to}
  \item{\dots}{Handled via \code{.Tcl.args}}
}
\details{
  There are far too many of these commands to describe them and their
  arguments in full. Please refer to the Tcl/Tk documentation for details.
  Except for a few exceptions, the pattern is that  Tcl widget commands
  possibly with subcommands like
  \code{.a.b selection clear} are converted to function names like
  \code{tkselection.clear} and the widget is given as the first argument. 
}
\seealso{\code{\link{TclInterface}}, \code{\link{TkWidgets}},
  \code{\link{TkCommands}}} 

\examples{
\dontrun{
## These cannot be run by examples() but should be OK when pasted
## into an interactive R session with the tcltk package loaded

tt <- tktoplevel()
tkpack(txt.w <- tktext(tt))
tkinsert(txt.w, "0.0", "plot(1:10)")

# callback function 
eval.txt <- function()
   eval(parse(text=tclvalue(tkget(txt.w, "0.0", "end"))))
tkpack(but.w <- tkbutton(tt,text="Submit", command=eval.txt))

## Try pressing the button, edit the text and when finished:

tkdestroy(tt)
}

}
\keyword{ misc }%-- one or more ...
\eof
\name{TkWidgets}
\alias{TkWidgets}
\alias{tkwidget}
\alias{tkbutton}
\alias{tkcanvas}
\alias{tkcheckbutton}
\alias{tkentry}
\alias{tkframe}
\alias{tklabel}
\alias{tklistbox}
\alias{tkmenu}
\alias{tkmenubutton}
\alias{tkmessage}
\alias{tkradiobutton}
\alias{tkscale}
\alias{tkscrollbar}
\alias{tktext}
\alias{tktoplevel}
\title{Tk widgets}
\description{
  Create Tk widgets and associated \R objects.
}
\usage{
tkwidget(parent, type, ...)
tkbutton(parent, ...)
tkcanvas(parent, ...)
tkcheckbutton(parent, ...)
tkentry(parent, ...)
tkframe(parent, ...)
tklabel(parent, ...)
tklistbox(parent, ...)
tkmenu(parent, ...)
tkmenubutton(parent, ...)
tkmessage(parent, ...)
tkradiobutton(parent, ...)
tkscale(parent, ...)
tkscrollbar(parent, ...)
tktext(parent, ...)
tktoplevel(parent=.TkRoot, ...)
}
\arguments{
  \item{parent}{ Parent of widget window }
  \item{type}{string describing the type of widget desired}
  \item{\dots}{handled via \code{.Tcl.args}}
}
\details{
  These functions create Tk widgets.  \code{tkwidget} creates a widget of
  a given type, the others simply call \code{tkwidget} with the
  respective \code{type} argument.

  It is not possible to describe the widgets and their arguments in
  full.  Please refer to the Tcl/Tk documentation.
}
\seealso{\code{\link{TclInterface}}, \code{\link{TkCommands}},
  \code{\link{TkWidgetcmds}}}

\examples{
\dontrun{
## These cannot be run by examples() but should be OK when pasted
## into an interactive R session with the tcltk package loaded

tt <- tktoplevel()
label.widget <- tklabel(tt, text="Hello, World!")
button.widget <- tkbutton(tt, text="Push",
                          command=function()cat("OW!\n"))
tkpack(label.widget, button.widget) # geometry manager
                                    # see Tk-commands

## Push the button and then...

tkdestroy(tt)
}
}
\keyword{ misc }%-- one or more ...
\eof
\name{tkStartGUI}
\alias{tkStartGUI}
\title{Tcl/Tk GUI startup}
\description{
  Starts up the Tcl/Tk GUI
}
\usage{
tkStartGUI()
}
\details{
  Starts a GUI console implemented via a Tk text widget. This should
  probably be called at most once per session. Also redefines the file
  pager (as used by \code{help()}) to be the Tk pager. 
}
\author{Peter Dalgaard}
\note{\code{tkStartGUI()} saves its evaluation environment as
  \code{.GUIenv}. This means that the user interface elements can be
  accessed in order to extend the interface. The three main objects are
  named \code{Term}, \code{Menu}, and \code{Toolbar}, and the various
  submenus and callback functions can be seen with
  \code{ls(envir=.GUIenv)}. }

  
\keyword{misc}

\eof
\name{tkpager}
\alias{tkpager}
\title{Page file using Tk text widget}
\description{
  This plugs into \code{file.show}, showing files in separate windows. 
}
\usage{
tkpager(file, header, title, delete.file)
}
\arguments{
  \item{file}{character vector containing the names of the
          files to be displayed}
  \item{header}{headers to use for each file}
  \item{title}{common title to use for the window(s). Pasted together
  with the \code{header} to form actual window title.}
  \item{delete.file}{logical. Should file(s) be deleted after display?}
}
\note{  The \code{"\b_"} string used for underlining is currently
  quietly removed. The font and background colour are currently
  hardcoded to Courier and gray90.
}
\seealso{
  \code{\link{file.show}}
}
\keyword{misc}
\eof
