\name{car.test.frame}
\alias{car.test.frame}
\non_function{}
\title{Automobile Data from 'Consumer Reports' 1990}
\description{
  The \code{car.test.frame} data frame has 60 rows and 8 columns,
  giving data on makes of cars taken from the April, 1990 issue of
  \emph{Consumer Reports}. This is part of a larger dataset, some
  columns of which are given in \code{\link{cu.summary}}.
}
\usage{
data(car.test.frame)
}
\format{
This data frame contains the following columns:
\describe{
\item{\code{Price}}{
a numeric vector giving the list price in US dollars of a standard model
}
\item{\code{Country}}{
of origin, a factor with levels
\code{France} 
\code{Germany} 
\code{Japan} 
\code{Japan/USA} 
\code{Korea} 
\code{Mexico} 
\code{Sweden} 
\code{USA} 
}
\item{\code{Reliability}}{
a numeric vector coded \code{1} to \code{5}.
}
\item{\code{Mileage}}{
fuel consumption miles per US gallon, as tested. 
}
\item{\code{Type}}{
a factor with levels
\code{Compact} 
\code{Large} 
\code{Medium} 
\code{Small} 
\code{Sporty} 
\code{Van} 
}
\item{\code{Weight}}{
kerb weight in pounds.
}
\item{\code{Disp.}}{
the engine capacity (displacement) in litres.
}
\item{\code{HP}}{
the net horsepower of the vehicle.
}
}}
\source{
  \emph{Consumer Reports}, April, 1990, pp. 235--288 quoted in

  John M. Chambers and Trevor J. Hastie eds. (1992)
  \emph{Statistical Models in S}, Wadsworth and Brooks/Cole,
  Pacific Grove, CA 1992, pp. 46--47.
}
\seealso{\code{\link{cu.summary}}}
\examples{
data(car.test.frame)
z.auto <- rpart(Mileage ~ Weight, car.test.frame)
summary(z.auto)
}
\keyword{datasets}

\eof
\name{cu.summary}
\alias{cu.summary}
\non_function{}
\title{Automobile Data from 'Consumer Reports' 1990}
\description{
  The \code{cu.summary} data frame has 117 rows and 5 columns,
  giving data on makes of cars taken from the April, 1990 issue of
  \emph{Consumer Reports}.
}
\usage{
data(cu.summary)
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{\code{Price}}{
      a numeric vector giving the list price in US dollars of a standard model
    }
    \item{\code{Country}}{
      of origin, a factor with levels
      \code{Brazil}
      \code{England}
      \code{France}
      \code{Germany}
      \code{Japan}
      \code{Japan/USA}
      \code{Korea}
      \code{Mexico}
      \code{Sweden}
      \code{USA}
    }
    \item{\code{Reliability}}{
      an ordered factor with levels
      \code{Much worse} < \code{worse} < \code{average} < \code{better} < \code{Much better}
    }
    \item{\code{Mileage}}{
      fuel consumption miles per US gallon, as tested.
    }
    \item{\code{Type}}{
      a factor with levels
      \code{Compact}
      \code{Large}
      \code{Medium}
      \code{Small}
      \code{Sporty}
      \code{Van}
    }
  }
}
\source{
  \emph{Consumer Reports}, April, 1990, pp. 235--288 quoted in

  John M. Chambers and Trevor J. Hastie eds. (1992)
  \emph{Statistical Models in S}, Wadsworth and Brooks/Cole,
  Pacific Grove, CA 1992, pp. 46--47.
}
\seealso{\code{\link{car.test.frame}}}
\examples{
data(cu.summary)
fit <- rpart(Price ~ Mileage + Type + Country, cu.summary)
plot(fit, compress=TRUE)
text(fit, use.n=TRUE)
}
\keyword{datasets}

\eof
\name{kyphosis}
\alias{kyphosis}
\non_function{}
\title{Data on Children who have had Corrective Spinal Surgery}
\description{
  The \code{kyphosis} data frame has 81 rows and 4 columns.
  representing data on children who have had corrective spinal surgery
}
\usage{
data(kyphosis)
}
\format{
This data frame contains the following columns:
\describe{
\item{\code{Kyphosis}}{
a factor with levels
\code{absent} 
\code{present}
indicating if a kyphosis (a type of deformation)
was present after the operation.
}
\item{\code{Age}}{
in months
}
\item{\code{Number}}{
the number of vertebrae involved 
}
\item{\code{Start}}{
the number of the first (topmost) vertebra operated on.
}
}}
\source{
   John M. Chambers and Trevor J. Hastie eds. (1992)
  \emph{Statistical Models in S}, Wadsworth and Brooks/Cole,
  Pacific Grove, CA 1992.
}
\examples{
data(kyphosis)
fit <- rpart(Kyphosis ~ Age + Number + Start, data=kyphosis)
fit2 <- rpart(Kyphosis ~ Age + Number + Start, data=kyphosis,
              parms=list(prior=c(.65,.35), split='information'))
fit3 <- rpart(Kyphosis ~ Age + Number + Start, data=kyphosis,
              control=rpart.control(cp=.05))
par(mfrow=c(1,2))
plot(fit)
text(fit, use.n=TRUE)
plot(fit2)
text(fit2, use.n=TRUE)
}
\keyword{datasets}

\eof
\name{labels.rpart}
\alias{labels.rpart}
\title{
  Create Split Labels For an Rpart Object 
}
\description{
This function provides labels for the branches of an
 \code{rpart} tree.
}
\usage{
\method{labels}{rpart}(object, digits=4, minlength=1, pretty, collapse=TRUE, ...)
}
\arguments{
\item{object}{
fitted model object of class \code{rpart}.  This is 
assumed to be the result 
of some function that produces an object with the same named 
components as that returned by the \code{rpart} function.
}
\item{digits}{
the number of digits to be used for numeric values.  
All of the \code{rpart} functions that call labels
explicitly set this value, with \code{options("digits")}
as the default.
}
\item{minlength}{
the minimum length for abbreviation of character or factor variables.
If 0 no abbreviation is done; if 1 then single letters are used with
\code{"a"} for the first level, \code{"b"} for the second and so on.
If the value is greater than 1, the 
\code{abbreviate} function is used.
}
\item{pretty}{
an argument included for backwards compatibility:
\code{pretty=0} implies \code{minlength=0},
\code{pretty=NULL} implies \code{minlength=1}, and
\code{pretty=TRUE} implies \code{minlength=4}.
}
\item{collapse}{
logical.
The returned set of labels is always of the same length as the number
of nodes in the tree.  
If \code{collapse=TRUE} (default), 
the returned value is a vector of labels for the branch leading into
each node, with \code{"root"} as the label for the top node.
If \code{FALSE}, the returned value is a two
column matrix of labels for the left and right branches leading 
out from each node, with \code{"leaf"} as the branch labels for terminal
nodes.
}
\item{\dots}{
optional arguments to \code{abbreviate}.
}
}
\value{
Vector of split labels (\code{collapse=TRUE}) or matrix 
of left and right splits 
(\code{collapse=FALSE}) for the supplied 
\code{rpart} object.  This function is called 
by printing methods for \code{rpart} and is not 
intended to be called 
directly by the users. 
}
\seealso{
\code{\link{abbreviate}} 
}
\keyword{tree}
% docclass is function
% Converted by Sd2Rd version 1.20.

\eof
\name{meanvar.rpart}
\alias{meanvar}
\alias{meanvar.rpart}
\title{
  Mean-Variance Plot for an Rpart Object 
}
\description{
Creates a plot on the current graphics device of the deviance of the 
node divided by the number of observations at the node.  Also returns 
the node number. 
}
\usage{
meanvar(tree, \dots)

\method{meanvar}{rpart}(tree, xlab="ave(y)", ylab="ave(deviance)", \dots)
}
\arguments{
\item{tree}{
fitted model object of class \code{rpart}.  This is asumed to be the result 
of some function that produces an object with the same named 
components as that returned by the \code{rpart} function. 
}
\item{xlab}{
x-axis label for the plot. 
}
\item{ylab}{
y-axis label for the plot. 
}
\item{\dots}{
additional graphical parameters may be supplied as arguments to this function. 
}
}
\value{
an invisible list containing the following vectors is returned. 

\item{x}{
fitted value at terminal nodes (\code{yval}). 
}
\item{y}{
deviance of node divided by number of observations at node. 
}
\item{label}{
node number. 
}
}
\section{Side Effects}{
a plot is put on the current graphics device. 
}
\seealso{
 \code{\link{plot.rpart}}.   
}
\examples{
data(car.test.frame)
z.auto <- rpart(Mileage ~ Weight, car.test.frame)
meanvar(z.auto, log='xy')
}
\keyword{tree}
% docclass is function
% Converted by Sd2Rd version 1.20.

\eof
\name{na.rpart}
\alias{na.rpart}
\title{
  Handles Missing Values in an Rpart Object 
}
\usage{
na.rpart(x)
}
\description{
  Handles missing values in an \code{rpart} object.
}
\arguments{
\item{x}{
  a model frame.
}}
\details{
  Internal function that handles missing values when calling the
  function \code{rpart}.
}
\keyword{tree}
% docclass is function
% Converted by Sd2Rd version 1.20.

\eof
\name{path.rpart}
\alias{path.rpart}
\title{
  Follow Paths to Selected Nodes of an Rpart Object
}
\description{
  Returns a names list where each element contains the splits on the
  path from the root to the selected nodes.
}
\usage{
path.rpart(tree, nodes, pretty=0, print.it=TRUE)
}
\arguments{
\item{tree}{
  fitted model object of class \code{rpart}.  This is assumed to be the
  result of some function that produces an object with the same named
  components as that returned by the \code{rpart} function.
}
\item{nodes}{
  an integer vector containing indices (node numbers) of all nodes for
  which paths are desired.  If missing, user selects nodes as described
  below. 
}
\item{pretty}{
  an integer denoting the extent to which factor levels in split labels
  will be abbreviated.  A value of (0) signifies no abbreviation.  A
  \code{NULL}, the default, signifies using elements of letters to represent
  the different factor levels.
}
\item{print.it}{
  Logical. Denotes whether paths will be printed out as
  nodes are interactively selected.   Irrelevant if \code{nodes}
  argument is supplied.
}}
\value{
  A named (by node) list, each element of which contains all
  the  splits  on the path from the root to the specified or
  selected nodes.
}
\section{Graphical Interaction}{
  A dendrogram of the \code{rpart} object is expected to be visible 
  on the graphics  device, and a graphics input device (eg a mouse)
  is required.  Clicking (the selection button)  on  a  node
  selects  that  node.   This  process  may  be repeated any
  number of times.  Clicking the exit button will  stop  the
  selection process and return the list of paths.
}
\details{
  The function has a required argument as an \code{rpart} object  and
  a list of nodes as optional arguments.  Omitting a list of
  nodes will cause the function to  wait  for  the  user  to
  select  nodes  from the dendogram.  It will return a list,
  with one component for each node  specified  or  selected.
  The  component  contains the sequence of splits leading to
  that node.  In the graphical  interation,  the  individual
  paths are printed out as nodes are selected.
}
\references{
  This function was modified from \code{path.tree} in S. 
}
\seealso{
  \code{\link{rpart}}
}
\examples{
data(kyphosis)
fit <- rpart(Kyphosis ~ Age + Number + Start, data=kyphosis)
summary(fit)
path.rpart(fit, node=c(11, 22))
}
\keyword{tree}
% docclass is function
% Converted by Sd2Rd version 1.20.

\eof
\name{plot.rpart}
\alias{plot.rpart}
\title{
Plot an Rpart Object
}
\description{
Plots an rpart object on the current graphics device.
}
\usage{
\method{plot}{rpart}(x, uniform=FALSE, branch=1, compress=FALSE, nspace,
     margin=0, minbranch=.3, \dots)
}
\arguments{
\item{x}{
  a fitted object of class \code{rpart}, containing a classification,
  regression, or rate tree.
}
\item{uniform}{
if \code{TRUE}, uniform vertical spacing of the nodes is used; this may be
less cluttered when fitting a large plot onto a page.
The default is to use a non-uniform spacing proportional to the 
error in the fit.
}
\item{branch}{
controls the shape of the branches from parent to child node.
Any number from 0 to 1 is allowed.  A value of 1 gives square
shouldered branches, a value of 0 give V shaped branches, 
with other values being intermediate.
}
\item{compress}{
if \code{FALSE}, the leaf nodes will be at the horzontal plot coordinates of
\code{1:nleaves}.  
If \code{TRUE}, the routine attempts a more compact arrangement of
the tree.
The compaction algorithm assumes \code{uniform=TRUE}; surprisingly, the result
is usually an improvement even when that is not the case.
}
\item{nspace}{
the amount of extra space between a node with children and
a leaf, as compared to the minimal space between leaves.  
Applies to compressed trees only.  The default is the value of
\code{branch}.
}
\item{margin}{
an extra percentage of white space to leave around the borders of the tree.
(Long labels sometimes get cut off by the default computation).
}
\item{minbranch}{
set the minimum length for a branch to \code{minbranch} times the average
branch length.  This parameter is ignored if \code{uniform=TRUE}.
Sometimes a split will give very little improvement, or even (in
the classification case) no improvement at all.  
A tree with branch lengths strictly proportional to improvement
leaves no room to squeeze in node labels.
}
\item{\dots}{
  arguments to be passed to or from other methods.
}}
\value{
the coordinates of the nodes are returned as a list, with
components \code{x} and \code{y}.
}
\section{Side Effects}{
an unlabeled plot is produced on the current graphics device.
}
\details{
This function is a method for the generic function \code{plot}, for objects
of class \code{rpart}.
The y-coordinate of the top node of the tree will always be 1.
}
\seealso{
\code{\link{rpart}}, \code{\link{text.rpart}}
}
\examples{
data(cu.summary)
fit <- rpart(Price ~ Mileage + Type + Country, cu.summary)
plot(fit, compress=TRUE)
text(fit, use.n=TRUE)
}
\keyword{tree}
% docclass is function
% Converted by Sd2Rd version 1.20.

\eof
\name{plotcp}
\alias{plotcp}
\title{
  Plot a Complexity Parameter Table for an Rpart Fit 
}
\description{
Gives a visual representation of the cross-validation results in an 
\code{rpart} object. 
}
\usage{
plotcp(x, minline = TRUE, lty = 3, col = 1,
       upper = c("size", "splits", "none"), \dots)
}
\synopsis{
plotcp(x, minline = TRUE, lty = 3, col = 1,
       upper = c("size", "splits", "none"), ylim, ...)
}
\arguments{
\item{x}{
an object of class \code{rpart} 
}
\item{minline}{
whether a horizontal line is drawn 1SE above the minimum of the curve. 
}
\item{lty}{
line type for this line 
}
\item{col}{
colour for this line 
}
\item{upper}{
what is plotted on the top axis: the size of the tree (the number of
leaves), the number of splits or nothing. 
}
\item{\dots}{
additional plotting parameters 
}
}
\value{
None. 
}
\section{Side Effects}{
A plot is produced on the current graphical device. 
}
\details{
The set of possible cost-complexity prunings of a tree from a nested
set. For the geometric means of the intervals of values of \code{cp} for which
a pruning is optimal, a cross-validation has (usually) been done in
the initial construction by \code{\link{rpart}}. The \code{cptable} in the fit contains
the mean and standard deviation of the errors in the cross-validated
prediction against each of the geometric means, and these are plotted
by this function. A good choice of \code{cp} for pruning is often the
leftmost value for which the mean lies below the horizontal line.
}
\seealso{
\code{\link{rpart}},  \code{\link{printcp}},  \code{\link{rpart.object}}   
}
\keyword{tree}
% docclass is function
% Converted by Sd2Rd version 1.20.

\eof
\name{post.rpart}
\alias{post.rpart}
\alias{post}
\title{
  PostScript Presentation Plot of an Rpart Object 
}
\description{
Generates a PostScript presentation plot of an \code{rpart} object. 
}
\usage{
post(tree, \dots)

\method{post}{rpart}(tree, title., 
     filename = paste(deparse(substitute(tree)), ".ps", sep = ""), 
     digits = getOption("digits") - 3, pretty = TRUE,
     use.n = TRUE, horizontal = TRUE, \dots)
}
\arguments{
\item{tree}{
fitted model object of class \code{rpart}.  This is assumed to be the result 
of some function that produces an object with the same named 
components as that returned by the \code{rpart} function. 
}
\item{title.}{
a title which appears at the top of the plot.  By default, the 
name of the \code{rpart} endpoint is printed out. 
}
\item{filename}{
ASCII file to contain the output.  By default, the name of the file is 
the name of the object given by \code{rpart} (with the suffix \code{.ps} added). If 
\code{filename = ""}, the plot appears on the current graphical device. 
}
\item{digits}{
number of significant digits to include in numerical data. 
}
\item{pretty}{
an integer denoting the extent to which factor levels will be 
abbreviated in the character strings defining the splits; 
(0) signifies no abbreviation of levels.  A \code{NULL} signifies using 
elements of letters to represent the different factor levels.  The 
default (\code{TRUE}) indicates the maximum possible abbreviation. 
}
\item{use.n}{
Logical.  If \code{TRUE} (default), adds to label 
(\#events level1/ \#events level2/etc. for method \code{class}, \code{n} for 
method \code{anova}, and \#events/n for methods \code{poisson} and \code{exp}).
}
\item{horizontal}{
Logical.  If \code{TRUE} (default), plot is horizontal. If \code{FALSE}, plot 
appears as landscape. 
}
\item{\dots}{
other arguments to the \code{postscript} function. 
}
}
\section{Side Effects}{
a plot of \code{rpart} is created using the \code{postscript} driver, or
the current device if \code{filename = ""}.
}
\details{
The plot created uses the functions \code{plot.rpart} and \code{text.rpart} (with 
the \code{fancy} option).  The settings were chosen because they looked 
good to us, but other options may be better, depending on the \code{rpart} 
object.   
Users are encouraged to write their own function containing favorite 
options. 
}
\seealso{
\code{\link{plot.rpart}},  \code{\link{rpart}},  \code{\link{text.rpart}},  \code{\link{abbreviate}}   
}
\examples{
data(car.test.frame)
z.auto <- rpart(Mileage ~ Weight, car.test.frame)
post(z.auto, file = "")   # display tree on active device
   # now construct postscript version on file "pretty.ps"
   # with no title
post(z.auto, file = "pretty.ps", title = " ")
z.hp <- rpart(Mileage ~ Weight + HP, car.test.frame)
post(z.hp)
}
\keyword{tree}

\eof
\name{predict.rpart}
\alias{predict.rpart}
\title{
  Predictions from a Fitted Rpart Object 
}
\description{
  Returns a vector of predicted responses from a fitted \code{rpart} object. 
}
\usage{
\method{predict}{rpart}(object, newdata = list(),
       type = c("vector", "prob", "class", "matrix"), ...)
}
\arguments{
  \item{object}{
    fitted model object of class \code{rpart}.  This is assumed to be
    the result of some function that produces an object with the same named 
    components as that returned by the \code{rpart} function. 
  }
  \item{newdata}{
    data frame containing the values at which predictions are required. 
    The predictors referred to in the right side of
    \code{formula(object)} must be present by name in \code{newdata}.
    If missing, the fitted values are returned. 
  }
  \item{type}{
    character string denoting the type of predicted value returned.  If
    the \code{rpart} object is a classification tree, then the default is to
    return \code{prob} predictions, a matrix whose columns are the
    probability of the first, second, etc. class.  (This agrees with the
    default behavior of \code{\link[tree]{tree}}).  Otherwise, a vector
    result is returned.
  }
  \item{\dots}{further arguments passed to or from other methods.}
}
\value{
  A new object is obtained by
  dropping \code{newdata} down the object.  For factor predictors, if an
  observation contains a level not used to grow the tree, it is left at
  the deepest possible node and \code{frame$yval} at the node is the
  prediction.

  If \code{type="vector"}:\cr
  vector of predicted responses.
  For regression trees this is the mean response at the node, for Poisson
  trees it is the estimated response rate, and for classification trees
  it is the predicted class.
  
  If \code{type="prob"}:\cr
  (for a classification tree) a matrix of class probabilities.

  If \code{type="matrix"}:\cr
  a matrix of the full responses (\code{frame$yval2} if this exists,
  otherwise \code{frame$yval}).
  For regression trees, this is the mean response, for Poisson trees it
  is the response rate and the number of events at that node in the fitted
  tree, and for classification trees it is the concatonation of the
  predicted class, the class counts at that node in the fitted tree, and
  the class probabilities.

  If \code{type="class"}:\cr
  (for a classification tree) a factor of classifications based on the
  responses.
}
\details{
  This function is a method for the generic function predict for class
  \code{rpart}. It can be invoked by calling \code{predict} for an object
  of the appropriate class, or directly by calling \code{predict.rpart}
  regardless of the class of the object.
}
\seealso{
\code{\link{predict}},  \code{\link{rpart.object}}   
}
\examples{
data(car.test.frame)
z.auto <- rpart(Mileage ~ Weight, car.test.frame)
predict(z.auto)

data(kyphosis)
fit <- rpart(Kyphosis ~ Age + Number + Start, data=kyphosis)
predict(fit, type="prob")   # class probabilities (default)
predict(fit, type="vector") # level numbers
predict(fit, type="class")  # factor
predict(fit, type="matrix") # level number, class frequencies, probabilities

data(iris)
sub <- c(sample(1:50, 25), sample(51:100, 25), sample(101:150, 25))
fit <- rpart(Species ~ ., data=iris, subset=sub)
fit
table(predict(fit, iris[-sub,], type="class"), iris[-sub, "Species"])
}
\keyword{tree}
% docclass is function
% Converted by Sd2Rd version 1.20.

\eof
\name{print.rpart}
\alias{print.rpart}
\title{
  Print an Rpart Object 
}
\description{
This function prints an \code{rpart} object.  It is a method for the generic 
function \code{print} of class \code{rpart}. 
}
\usage{
\method{print}{rpart}(x, minlength=0, spaces=2, cp, digits= getOption("digits"), \dots)
}
\arguments{
\item{x}{
fitted model object of class \code{rpart}.  This is assumed to be the result 
of some function that produces an object with the same named 
components as that returned by the \code{rpart} function. 
}
\item{minlength}{
Controls the abbreviation of labels: see \code{\link{labels.rpart}}.
}
\item{spaces}{
the number of spaces to indent nodes of increasing depth. 
}
\item{digits}{
the number of digits of numbers to print. 
}
\item{cp}{
  prune all nodes with a complexity less than \code{cp} from the
  printout. Ignored if unspecified.
}
\item{\dots}{
  arguments to be passed to or from other methods.
}}
\section{Side Effects}{
  A semi-graphical layout of the contents of \code{x$frame} is
  printed.  Indentation is used to convey the tree topology.
  Information for each node includes the node number, split, size,
  deviance, and fitted value.  For the \code{"class"} method, the
  class probabilties are also printed. 
}
\details{
  This function is a method for the generic function \code{print} for class 
  \code{"rpart"}.  It can be invoked by calling print for an object of the 
  appropriate class, or directly by calling \code{print.rpart} regardless of 
  the class of the object. 
}
\seealso{
  \code{\link{print}},  \code{\link{rpart.object}},
  \code{\link{summary.rpart}},  \code{\link{printcp}}   
}
\examples{
data(car.test.frame)
z.auto <- rpart(Mileage ~ Weight, car.test.frame)
z.auto
\dontrun{node), split, n, deviance, yval
      * denotes terminal node

 1) root 60 1354.58300 24.58333  
   2) Weight>=2567.5 45  361.20000 22.46667  
     4) Weight>=3087.5 22   61.31818 20.40909 *
     5) Weight<3087.5 23  117.65220 24.43478  
      10) Weight>=2747.5 15   60.40000 23.80000 *
      11) Weight<2747.5 8   39.87500 25.62500 *
   3) Weight<2567.5 15  186.93330 30.93333 *
}}
\keyword{tree}
% docclass is function

\eof
\name{printcp}
\alias{printcp}
\title{
  Displays CP table for Fitted Rpart Object 
}
\description{
  Displays the \code{cp} table for fitted \code{rpart} object.
}
\usage{
printcp(x, digits=getOption("digits") - 2)
}
\arguments{
\item{x}{
fitted model object of class \code{rpart}.  This is assumed to be the result 
of some function that produces an object with the same named 
components as that returned by the \code{rpart} function. 
}
\item{digits}{
  the number of digits of numbers to print.
}}
\details{
Prints a table of optimal prunings based on a complexity parameter. 
}
\seealso{
\code{\link{summary.rpart}},  \code{\link{rpart.object}}   
}
\examples{
data(car.test.frame)
z.auto <- rpart(Mileage ~ Weight, car.test.frame)
printcp(z.auto)
\dontrun{
Regression tree:
rpart(formula = Mileage ~ Weight, data = car.test.frame)

Variables actually used in tree construction:
[1] Weight

Root node error: 1354.6/60 = 22.576

        CP nsplit rel error  xerror     xstd 
1 0.595349      0   1.00000 1.03436 0.178526
2 0.134528      1   0.40465 0.60508 0.105217
3 0.012828      2   0.27012 0.45153 0.083330
4 0.010000      3   0.25729 0.44826 0.076998
}}
\keyword{tree}
% docclass is function
% Converted by Sd2Rd version 1.20.

\eof
\name{prune.rpart}
\alias{prune.rpart}
\alias{prune}
\title{
  Cost-complexity Pruning of an Rpart Object 
}
\description{
Determines a nested sequence of subtrees of the supplied \code{rpart} object 
by recursively \code{snipping} off the least important splits, based on the 
complexity parameter (\code{cp}). 
}
\usage{
prune(tree, \dots)

\method{prune}{rpart}(tree, cp, \dots)
}
\arguments{
\item{tree}{
fitted model object of class \code{rpart}.  This is assumed to be the result 
of some function that produces an object with the same named 
components as that returned by the \code{rpart} function. 
}
\item{cp}{
  Complexity parameter to which the \code{rpart} object will be trimmed.
}
\item{\dots}{further arguments passed to or from other methods.}
}
\value{
A new \code{rpart} object that is trimmed to the value \code{cp}. 
}
\seealso{
\code{\link{rpart}} 
}
\examples{
data(car.test.frame)
z.auto <- rpart(Mileage ~ Weight, car.test.frame)
zp <- prune(z.auto, cp=0.1)
plot(zp) #plot smaller rpart object
}
\keyword{tree}
% docclass is function
% Converted by Sd2Rd version 1.20.

\eof
\name{residuals.rpart}
\alias{residuals.rpart}
\title{
  Residuals From a Fitted Rpart Object 
}
\usage{
\method{residuals}{rpart}(object, type = c("usual", "pearson", "deviance"), ...)
}
\description{
  Method for \code{residuals} for an \code{rpart} object.
}
\arguments{
\item{object}{
  fitted model object of class \code{"rpart"}.
}
\item{type}{
  Indicates the type of residual desired.

  For regression or \code{anova} trees all three residual
  definitions reduce to \code{y - fitted}.  This is the residual returned for
  \code{user} method trees as well.

  For classification trees the \code{usual} residuals
  are the missclassification losses L(actual, predicted) where L is the
  loss matrix.  With default losses this residual is
  0/1 for correct/incorrect classification.
  The \code{pearson} residual is 
  (1-fitted)/sqrt(fitted(1-fitted)) and the \code{deviance} residual is 
  sqrt(minus twice logarithm of fitted).

  For \code{poisson} and \code{exp}
  (or survival) trees, the \code{usual} residual
  is the observed - expected number of events.
  The \code{pearson} and \code{deviance} residuals are as defined in
  McCullagh and Nelder.
}
\item{\dots}{further arguments passed to or from other methods.}

}
\value{
vector of residuals of type \code{type} from a fitted \code{rpart} object. 
}
\references{
  McCullagh P. and Nelder, J. A. (1989)
  \emph{Generalized Linear Models}.
  London: Chapman and Hall.
}
\examples{
data(solder)
fit <- rpart(skips ~ Opening + Solder + Mask + PadType + Panel,
       data=solder, method='anova')
summary(residuals(fit))
plot(predict(fit),residuals(fit))
}
\keyword{tree}
% docclass is function
% Converted by Sd2Rd version 1.20.

\eof
\name{rpart-internal}
\alias{pred.rpart}
\alias{rpart.matrix}
\title{
  Internal Functions 
}
\description{
  Internal functions, only used by packages \pkg{rpart} and \pkg{ipred}.
}
\usage{
pred.rpart(fit, x)
rpart.anova(y, offset, parms, wt)
rpart.class(y, offset, parms, wt)
rpart.exp(y, offset, parms, wt)
rpart.matrix(frame)
rpart.poisson(y, offset, parms, wt)
}
\arguments{
  \item{fit}{a tree fitted by \code{rpart}.}
  \item{x}{a matrix of predictors.}
  \item{y}{the responses.}
  \item{offset}{an offset, or \code{NULL}.}
  \item{parms}{a list of parameters, usually empty.}
  \item{wt}{case weights.}
  \item{frame}{model frame (from call to \code{rpart})}
}
\value{
  \code{rpart.anova}, \code{rpart.class}, \code{rpart.exp} and
  \code{rpart.poisson} return a list with components
  
  \item{y}{(adjusting for \code{offset} if necessary),}
  \item{parms}{as input,}
  \item{numresp}{the number of responses,}
  \item{summary}{a function to be invoked by \code{\link{summary.rpart}},}
  \item{text}{a function to be invoked by \code{\link{text.rpart}}.}
}
\keyword{internal}

\eof
\name{rpart}
\alias{rpart}
\alias{rpartcallback}
\title{
Recursive Partitioning and Regression Trees
}
\description{
Fit a \code{rpart} model
}
\usage{
rpart(formula, data, weights, subset, na.action = na.rpart, method,
      model = FALSE, x = FALSE, y = TRUE, parms, control, cost, \dots)
}
\arguments{
\item{formula}{
a formula, as in the \code{lm} function.
}
\item{data}{
an optional data frame in which to interpret the variables named in the
formula
}
\item{weights}{
optional case weights.
}
\item{subset}{
optional expression saying that only a subset of the rows of the data
should be used in the fit.
}
\item{na.action}{
The default action deletes all observations for which \code{y} is missing,
but keeps those in which one or more predictors are missing.
}
\item{method}{
one of \code{"anova"}, \code{"poisson"}, \code{"class"} or \code{"exp"}.
If \code{method} is missing then the routine tries to make an intellegent guess.
If \code{y} is a survival object, then \code{method="exp"} is assumed,
if \code{y} has 2 columns then \code{method="poisson"} is assumed,
if \code{y} is a factor then \code{method="class"} is assumed, otherwise \code{method="anova"}
is assumed.  It is wisest to specifiy the method directly, especially as
more criteria are added to the function.

Alternatively, \code{method} can be a list of functions named
\code{init}, \code{split} and \code{eval}.
}
\item{model}{
  if logical: keep a copy of the model frame in the result?  If the input
  value for \code{model} is a model frame (likely from an earlier call to
  the \code{rpart} function), then this frame is used rather than
  constructing new data.
}
\item{x}{
keep a copy of the \code{x} matrix in the result.
}
\item{y}{
keep a copy of the dependent variable in the result. If missing and
\code{model} is supplied this defaults to \code{FALSE}.
}
\item{parms}{
optional parameters for the splitting function.
Anova splitting has no parameters.
Poisson splitting has a single parameter, the coefficient of variation of
the prior distribution on the rates.  The default value is 1.
Exponential splitting has the same parameter as Poisson.
For classification splitting, the list can contain any of:
the vector of prior probabilities (component \code{prior}), the loss matrix
(component \code{loss}) or the splitting index (component \code{split}).  The
priors must be positive and sum to 1.  The loss matrix must have zeros
on the diagnoal and positive off-diagonal elements.  The splitting
index can be \code{gini} or \code{information}.  The default priors are
proportional to the data counts, the losses default to 1,
and the split defaults to \code{gini}.
}
\item{control}{
options that control details of the \code{rpart} algorithm.
}
\item{cost}{
a vector of non-negative costs, one for each variable in the
model. Defaults to one for all variables.  These are scalings to be
applied when considering splits, so the improvement on splitting on a
variable is divided by its cost in deciding which split to choose.
}
\item{\dots}{
arguments to \code{rpart.control} may also be specified in the call to
\code{rpart}.  They are checked against the list of valid arguments.
}
}
\value{
an object of class \code{rpart}, a superset of class \code{tree}.
}
\details{
This differs from the \code{tree} function mainly in its handling of surrogate
variables.  In most details it follows Breiman et. al. quite closely.
}
\references{
Breiman, Friedman, Olshen, and Stone. (1984)
\emph{Classification and Regression Trees.}
Wadsworth.
}
\seealso{
  \code{\link{rpart.control}}, \code{\link{rpart.object}},
  \code{\link{summary.rpart}}, \code{\link{print.rpart}}
}
\examples{
data(kyphosis)
fit <- rpart(Kyphosis ~ Age + Number + Start, data=kyphosis)
fit2 <- rpart(Kyphosis ~ Age + Number + Start, data=kyphosis,
              parms=list(prior=c(.65,.35), split='information'))
fit3 <- rpart(Kyphosis ~ Age + Number + Start, data=kyphosis,
              control=rpart.control(cp=.05))
par(mfrow=c(1,2))
plot(fit)
text(fit, use.n=TRUE)
plot(fit2)
text(fit2, use.n=TRUE)
}
\keyword{tree}

\eof
\name{rpart.control}
\alias{rpart.control}
\title{
  Control for Rpart Models
}
\description{
Various parameters that control aspects of the \code{rpart} fit. 
}
\usage{
rpart.control(minsplit=20, minbucket=round(minsplit/3), cp=0.01, 
              maxcompete=4, maxsurrogate=5, usesurrogate=2, xval=10,
	      surrogatestyle=0, maxdepth=30, \dots)
}
\arguments{
\item{minsplit}{
the minimum number of observations that must exist in a node, in order for 
a split to be attempted. 
}
\item{minbucket}{
  the minimum number of observations in any terminal \code{<leaf>} node.
  If only one of \code{minbucket} or \code{minsplit} is specified,
  the code either sets \code{minsplit} to \code{minbucket*3}
  or \code{minbucket} to \code{minsplit/3}, as appropriate.
}
\item{cp}{
  complexity parameter.  Any split that does not decrease the overall
  lack of fit by a factor of \code{cp} is not attempted.  For instance,
  with \code{anova} splitting, this means that the overall Rsquare must
  increase by \code{cp} at each step. The main role of this parameter
  is to save computing time by pruning off splits that are obviously
  not worthwhile. Essentially,the user informs the program that any
  split which does not improve the fit by \code{cp} will likely be
  pruned off by cross-validation, and that hence the program need
  not pursue it.
}
\item{maxcompete}{
  the number of competitor splits retained in the output.  It is useful to
  know not just which split was chosen, but which variable came in second,
  third, etc.
}
\item{maxsurrogate}{
  the number of surrogate splits retained in the output.  If this is set to
  zero the compute time will be shortened, since approximately half of the
  computational time (other than setup) is used in the search for surrogate
  splits.
}
\item{usesurrogate}{
  how to use surrogates in the splitting process.  0= display only; an
  observation with a missing value for the primary split rule is not sent
  further down the tree.  1= use surrogates, in order, to split subjects
  missing the primary variable; if all surrogates are missing the observation
  is not split.  2= if all surrogates are missing, then send the observation
  in the majority direction.  A value of 0 corresponds to the action of
  \code{tree}, and 2 to the recommendations of Breiman, et.al.
}
\item{xval}{
number of cross-validations 
}
\item{surrogatestyle}{
  controls the selection of a best surrogate.
  If set to 0 (default) the program uses the total number of correct
  classification for a potential surrogate variable,
  if set to 1 it uses the percent correct, calculated over the non-missing
  values of the surrogate.
  The first option more severely penalizes covariates with a large number of
  missing values.
}
\item{maxdepth}{
  Set the maximum depth of any node of the final tree, with the root
  node counted as depth 0 (past 30 \code{rpart} will give nonsense results on
  32-bit machines).
}
\item{\dots}{
  mop up other arguments.
}
}
\value{
  a list containing the options.
}
\seealso{
\code{\link{rpart}}
}
\keyword{tree}
% docclass is function
% Converted by Sd2Rd version 1.20.

\eof
\name{rpart.object}
\alias{rpart.object}
\title{
  Recursive Partitioning and Regression Trees Object 
}
\description{
These are objects representing fitted \code{rpart} trees. 
}
\section{Structure}{
The following components must be included in a legitimate \code{rpart} object. 
Of these, only the \code{where} component has the same length as  
the data used to fit the \code{rpart} object. 
}
\value{

\item{frame}{
data frame with one row for each node in the tree.
The \code{row.names} of \code{frame} contain the (unique) node numbers that
follow a binary ordering indexed by node depth.
Elements of \code{frame} include \code{var},
the variable used in the split at each node
(leaf nodes are denoted by the string \code{<leaf>}), \code{n}, the size of each node,
\code{wt}, the sum of case weights for the node,
\code{dev}, the deviance of each node,
\code{yval}, the fitted value of the response at each node,
and \code{splits}, a two column matrix of left and right split labels
for each node.
All of these are the same as for an \code{rpart} object.

Extra response information is in \code{yval2}, which contains the number
of events at the node (poisson), or a matrix containing the fitted
class, the class counts for each node and the class probabilities
(classification).  Also included in the frame are \code{complexity}, the
complexity parameter at which this split will collapse, \code{ncompete},
the number of competitor splits retained, and \code{nsurrogate}, the
number of surrogate splits retained.
}
\item{where}{
vector, the same length as the number of observations in the root node, 
containing the row number of \code{frame} corresponding to the leaf node 
that each observation falls into. 
}
\item{splits}{
a matrix describing the splits.  The row label is the name of the split
variable, and columns are \code{count}, the number of observations sent left
or right by the split (for competitor splits this is the number that
would have been sent left or right had this split been used, for surrogate
splits it is the number missing the primary split variable which were decided
using this surrogate), \code{ncat}, the number of categories or levels for the
variable (\code{+/-1} for a continuous variable), \code{improve}, which is the improvement
in deviance given by this split, or, for surrogates, the concordance of the
surrogate with the primary, and \code{split}, the numeric split point.  
The last column \code{adj} gives the adjusted concordance for surrogate splits.
For
a factor, the \code{split} column contains the row number of the csplit matrix.
For a continuous variable, the sign of \code{ncat} determines whether the
subset \code{x < cutpoint} or \code{x > cutpoint} is sent to the left.
}
\item{csplit}{
this will be present only if one of the split variables is a factor. There
is one row for each such split, and column \code{i = -1} if this level of the
factor goes to the left, \code{+1} if it goes to the right, and 0 if that level
is not present at this node of the tree.
For an ordered categorical variable all levels are marked as \code{R/L}, 
including levels that are not present.
}
\item{method}{
the method used to grow the tree. 
}
\item{cptable}{
the table of optimal prunings based on a complexity parameter. 
}
\item{terms}{
an object of mode \code{expression} and class \code{term} summarizing the formula. 
Used by various methods, but typically not of direct relevance to users. 
}
\item{call}{
an image of the call that produced the object, but with the arguments 
all named and with the actual formula included as the formula argument. 
To re-evaluate the call, say \code{update(tree)}. 

Optional components include the matrix of predictors (\code{x}) and the 
response variable (\code{y}) used to construct the \code{rpart} object. 
}
}
\seealso{
\code{\link{rpart}}.
}
\keyword{tree}
\keyword{methods}
% docclass is function
% Converted by Sd2Rd version 1.20.

\eof
\name{rpconvert}
\alias{rpconvert}
\title{
  Update an rpart object
}
\description{
Rpart objects changed (slightly) in their internal format in order to
accomdate the changes for user-written split functions.  This routine
updates an old object to the new format.
}
\usage{
rpconvert(x)
}
\arguments{
\item{x}{
an \code{rpart} object
}
}
\value{
an updated object
}
\seealso{
\code{rpart}
}
\keyword{tree}
% docclass is function

\eof
\name{rsq.rpart}
\alias{rsq.rpart}
\title{
  Plots the Approximate R-Square for the Different Splits 
}
\description{
  Produces 2 plots.  The first plots the r-square (apparent and
  apparent - from cross-validation) versus the number of splits.  
  The second plots the Relative Error(cross-validation) +/- 1-SE from
  cross-validation versus the number of splits.
}
\usage{
rsq.rpart(x)
}
\arguments{
\item{x}{
  fitted model object of class \code{rpart}.  This is assumed to be the result
  of some function that produces an object with the same named
  components as that returned by the \code{rpart} function.
}}
\section{Side Effects}{
  Two plots are produced.
}
\note{
  The labels are only appropriate for the \code{"anova"} method.
}
\examples{
data(car.test.frame)
z.auto <- rpart(Mileage ~ Weight, car.test.frame)
rsq.rpart(z.auto)
}
\keyword{tree}
% docclass is function
% Converted by Sd2Rd version 1.20.

\eof
\name{snip.rpart}
\alias{snip.rpart}
\title{
  Snip Subtrees of an Rpart Object 
}
\description{
  Creates a "snipped" rpart object, containing the nodes that remain
  after selected subtrees have been snipped off.  The user can snip
  nodes using the toss arguement, or interactively by clicking the mouse
  button on specified nodes within the graphics window.
}
\usage{
snip.rpart(x, toss)
}
\arguments{
\item{x}{
  fitted model object of class \code{rpart}.  This is assumed to be the result
  of some function that produces an object with the same named
  components as that returned by the \code{rpart} function.
}
\item{toss}{
  an integer vector containing indices (node numbers) of all subtrees to
  be snipped off.  If missing, user selects branches to snip off as
  described below.
}}
\value{
  a \code{rpart} object containing the nodes that remain after specified or
  selected subtrees have been snipped off.  
}
\details{
  A dendrogram of \code{rpart} is expected to be visible on the graphics
  device, and a graphics input device (e.g., a mouse) is required.  Clicking
  (the selection button) on a node displays the node number, sample
  size, response yvalue, and Error (dev). Clicking a second time on the
  same node snips that subtree off and visually erases the subtree.
  This process may be repeated an number of times.  Warnings result from
  selecting the root or leaf nodes.  Clicking the exit button will stop
  the snipping process and return the resulting \code{rpart} object.

  See the documentation for the specific graphics device for details on
  graphical input techniques.
}
\section{Warning}{
  Visually erasing the plot is done by over-plotting with the background
  colour.  This will do nothing if the background is transparent
  (often true for screen devices).
}
\seealso{
  \code{\link{plot.rpart}}
}
\examples{
## dataset not in R
\dontrun{
z.survey <- rpart(market.survey) #grow the rpart object
plot(z.survey) #plot the tree
z.survey2 <- snip.rpart(z.survey,toss=2) #trim subtree at node 2
plot(z.survey2) #plot new tree

# can also interactively select the node using the mouse in the
# graphics window
}}
\keyword{tree}

\eof
\name{solder}
\alias{solder}
\non_function{}
\title{Soldering of Components on Printed-Circuit Boards}
\description{
  The \code{solder} data frame has 720 rows and 6 columns, representing
  a balanced subset of a designed experiment varying 5 factors on the
  soldering of components on printed-circuit boards.
}
\usage{
data(solder)
}
\format{
This data frame contains the following columns:
\describe{
\item{\code{Opening}}{
a factor with levels
\code{L} 
\code{M} 
\code{S}
indicating the amount of clearance around the mounting pad.
}
\item{\code{Solder}}{
a factor with levels
\code{Thick} 
\code{Thin}
giving the thickness of the solder used.
}
\item{\code{Mask}}{
a factor with levels
\code{A1.5} 
\code{A3} 
\code{B3} 
\code{B6}
indicating the type and thickness of mask used.
}
\item{\code{PadType}}{
a factor with levels
\code{D4} 
\code{D6} 
\code{D7} 
\code{L4} 
\code{L6} 
\code{L7} 
\code{L8} 
\code{L9} 
\code{W4} 
\code{W9}
giving the size and geometry of the mounting pad.
}
\item{\code{Panel}}{
 \code{1:3} indicating the panel on a board being tested.
}
\item{\code{skips}}{
a numeric vector giving the number of visible solder skips.
}
}}
\source{
   John M. Chambers and Trevor J. Hastie eds. (1992)
  \emph{Statistical Models in S}, Wadsworth and Brooks/Cole,
  Pacific Grove, CA 1992.
}
\examples{
data(solder)
fit <- rpart(skips ~ Opening + Solder + Mask + PadType + Panel,
       data=solder, method='anova')
summary(residuals(fit))
plot(predict(fit),residuals(fit))
}
\keyword{datasets}

\eof
\name{summary.rpart}
\alias{summary.rpart}
\title{
  Summarize a Fitted Rpart Object 
}
\description{
  Returns a detailed listing of a fitted \code{rpart} object.
}
\usage{
\method{summary}{rpart}(object, cp=0, digits=getOption("digits"), file, \dots)
}
\arguments{
\item{object}{
  fitted model object of class \code{rpart}.  This is assumed to be the result
  of some function that produces an object with the same named
  components as that returned by the \code{rpart} function.
}
\item{digits}{
    Number of significant digits to be used in the result.
}
\item{cp}{
  trim nodes with a complexity of less than \code{cp} from the listing.
}
\item{file}{
  write the output to a given file name. (Full listings of a tree are
  often quite long).
}
\item{\dots}{
  arguments to be passed to or from other methods.
}}
\details{
  This function is a method for the generic function summary for class
  \code{"rpart"}.  It can be invoked by calling \code{summary}
  for an object of the appropriate class, or directly by calling
  \code{summary.rpart} regardless of the class of the object.
}
\seealso{
  \code{\link{summary}}, \code{\link{rpart.object}}, \code{\link{printcp}}.
}
\examples{
data(car.test.frame)
z.auto <- rpart(Mileage ~ Weight, car.test.frame)
summary(z.auto)
}
\keyword{tree}
% docclass is function
% Converted by Sd2Rd version 1.20.

\eof
\name{text.rpart}
\alias{text.rpart}
\title{
  Place Text on a Dendrogram 
}
\description{
  Labels the current plot of the tree dendrogram with text.
}
\usage{
\method{text}{rpart}(x, splits=TRUE, label="yval", FUN=text, all=FALSE,
     pretty=NULL, digits=getOption("digits") - 3, use.n=FALSE,
     fancy=FALSE, fwidth=0.8, fheight=0.8, \dots)
}
\arguments{
\item{x}{
  fitted model object of class \code{rpart}.  This is assumed to be the result
  of some function that produces an object with the same named
  components as that returned by the \code{rpart} function.
}
\item{splits}{
  logical flag.  If \code{TRUE} (default), then the splits in the tree are
  labeled with the criterion for the split.
}
\item{label}{
a column name of \code{x$frame};  values of this
will label the nodes.  For the \code{"class"} method,
\code{label="yval"} results in the factor levels
being used, \code{"yprob"} results in the probability of the winning factor
level being used, and \sQuote{specific yval level} results in the probability
of that factor level.   
}
\item{FUN}{
  the name of a labeling function, e.g. \code{text}.  
}
\item{all}{
  Logical.  If \code{TRUE}, all nodes are labeled, otherwise just
  terminal nodes.
}
\item{pretty}{
  an integer denoting the extent to which factor levels in split labels
  will be abbreviated.  A value of (0) signifies no abbreviation.  A
  \code{NULL}, the default, signifies using elements of letters to represent
  the different factor levels.
}
\item{digits}{
  number of significant digits to include in numerical labels.
}
\item{use.n}{
  Logical.  If \code{TRUE} (default), adds to label 
  (\#events level1/ \#events level2/etc. for \code{class},
  \code{n} for \code{anova}, and \#events/n for \code{poisson} and \code{exp}).
}
\item{fancy}{
  Logical.  If \code{TRUE}, nodes are represented by ellipses (interior nodes)
  and rectangles (leaves) and labeled by \code{yval}.  The edges connecting the
  nodes are labeled by left and right splits.
}
\item{fwidth}{
  Relates to option \code{fancy} and the width of the ellipses and rectangles.
  If \code{fwidth < 1} then it is a scaling factor (default = 0.8).  If 
  \code{fwidth > 1} then it representes the number of character widths 
  (for current graphical device) to use.
}
\item{fheight}{
  Relates to option \code{fancy} and the height of the ellipses and rectangles.
  If \code{fheight <1} then it is a scaling factor (default = 0.8).  If
  \code{fheight > 1} then it represents the number of character heights 
  (for current graphical device) to use.
}
\item{\dots}{
  Graphical parameters may also be supplied as arguments to this
  function (see \code{par}).
}}
\section{Side Effects}{
  the current plot of a tree dendrogram is labeled.
}
\seealso{
  \code{\link{text}}, \code{\link{plot.rpart}}, \code{\link{rpart}},
  \code{\link{post.rpart}}, \code{\link{abbreviate}} 
}
\examples{
data(freeny)
freen.tr <- rpart(y ~ ., freeny)
plot(freen.tr)
text(freen.tr, use.n=TRUE, all=TRUE)
}
\keyword{tree}
% docclass is function
% Converted by Sd2Rd version 1.20.

\eof
\name{xpred.rpart}
\alias{xpred.rpart}
\title{
  Return Cross-Validated Predictions 
}
\description{
  Gives the predicted values for an \code{rpart} fit, under
  cross validation, for a set of complexity parameter values.
}
\usage{
xpred.rpart(fit, xval=10, cp)
}
\arguments{
\item{fit}{
a \code{rpart} object. 
}
\item{xval}{
  number of cross-validation groups.  This may also be an explicit list of
  integers that define the cross-validation groups.
}
\item{cp}{
  the desired list of complexity values.  By default it is taken from the
  \code{cptable} component of the fit.
}}
\value{
  a matrix with one row for each observation and one column for each complexity
  value.
}
\details{
  Complexity penalties are actually ranges, not values.  If the
  \code{cp} values found in the table were \eqn{.36}, \eqn{.28},
  and \eqn{.13}, for instance, this means that the first row of the
  table holds for all complexity penalties in the range \eqn{[.36, 1]},
  the second row for \code{cp} in the range \eqn{[.28, .36)} and
  the third row for \eqn{[.13,.28)}.  By default, the geometric mean
  of each interval is used for cross validation.
}
\seealso{
\code{\link{rpart}} 
}
\examples{
data(car.test.frame)
fit <- rpart(Mileage ~ Weight, car.test.frame)
xmat <- xpred.rpart(fit)
xerr <- (xmat - car.test.frame$Mileage)^2
apply(xerr, 2, sum)   # cross-validated error estimate

# approx same result as rel. error from printcp(fit)
apply(xerr, 2, sum)/var(car.test.frame$Mileage) 
printcp(fit)
}
\keyword{tree}
% docclass is function
% Converted by Sd2Rd version 1.20.

\eof
