require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&X25_CALL)) {
    sub X25_CALL () {	11;}
}
unless(defined(&X25_CALL_ACCEPTED)) {
    sub X25_CALL_ACCEPTED () {	15;}
}
unless(defined(&X25_CLEAR)) {
    sub X25_CLEAR () {	19;}
}
unless(defined(&X25_CLEAR_CONFIRM)) {
    sub X25_CLEAR_CONFIRM () {	23;}
}
unless(defined(&X25_DATA)) {
    sub X25_DATA () {	0;}
}
unless(defined(&X25_INTERRUPT)) {
    sub X25_INTERRUPT () {	35;}
}
unless(defined(&X25_INTERRUPT_CONFIRM)) {
    sub X25_INTERRUPT_CONFIRM () {	39;}
}
unless(defined(&X25_RR)) {
    sub X25_RR () {	1;}
}
unless(defined(&X25_RNR)) {
    sub X25_RNR () {	5;}
}
unless(defined(&X25_REJECT)) {
    sub X25_REJECT () {	9;}
}
unless(defined(&X25_RESET)) {
    sub X25_RESET () {	27;}
}
unless(defined(&X25_RESET_CONFIRM)) {
    sub X25_RESET_CONFIRM () {	31;}
}
unless(defined(&X25_DIAGNOSTIC)) {
    sub X25_DIAGNOSTIC () {	241;}
}
unless(defined(&X25_RESTART)) {
    sub X25_RESTART () {	251;}
}
unless(defined(&X25_RESTART_CONFIRM)) {
    sub X25_RESTART_CONFIRM () {	255;}
}
unless(defined(&X25_RESTART_DTE_ORIGINATED)) {
    sub X25_RESTART_DTE_ORIGINATED () {	0;}
}
unless(defined(&X25_RESTART_LOCAL_PROCEDURE_ERROR)) {
    sub X25_RESTART_LOCAL_PROCEDURE_ERROR () {	1;}
}
unless(defined(&X25_RESTART_NETWORK_CONGESTION)) {
    sub X25_RESTART_NETWORK_CONGESTION () {	3;}
}
unless(defined(&X25_RESTART_NETWORK_OPERATIONAL)) {
    sub X25_RESTART_NETWORK_OPERATIONAL () {	7;}
}
unless(defined(&X25_RESTART_DTE_ORIGINATED2)) {
    sub X25_RESTART_DTE_ORIGINATED2 () {	128;}
}
unless(defined(&DATA_PACKET_DESIGNATOR)) {
    sub DATA_PACKET_DESIGNATOR () {	0x1;}
}
unless(defined(&RR_OR_RNR_PACKET_DESIGNATOR)) {
    sub RR_OR_RNR_PACKET_DESIGNATOR () {	0x2;}
}
unless(defined(&RR_PACKET_DESIGNATOR)) {
    sub RR_PACKET_DESIGNATOR () {	0x4;}
}
unless(defined(&DEFAULT_WINDOW_SIZE)) {
    sub DEFAULT_WINDOW_SIZE () {	2;}
}
unless(defined(&MODULUS)) {
    sub MODULUS () {	8;}
}
unless(defined(&ADDRLN)) {
    sub ADDRLN () {	1;}
}
unless(defined(&MAXADDRLN)) {
    sub MAXADDRLN () {	15;}
}
unless(defined(&FACILITIESLN)) {
    sub FACILITIESLN () {	1;}
}
unless(defined(&MAXFACILITIESLN)) {
    sub MAXFACILITIESLN () {	10;}
}
unless(defined(&MAXUSERDATA)) {
    sub MAXUSERDATA () {	16;}
}
unless(defined(&MAXCALLINFOLN)) {
    sub MAXCALLINFOLN () {	1+15+1+10+16;}
}
unless(defined(&PACKET_OK)) {
    sub PACKET_OK () {	0;}
}
unless(defined(&IGNORE_PACKET)) {
    sub IGNORE_PACKET () {	1;}
}
unless(defined(&ERROR_PACKET)) {
    sub ERROR_PACKET () {	2;}
}
unless(defined(&CCITT_TYPES_DEFINED)) {
    eval 'sub CCITT_TYPES_DEFINED () {1;}' unless defined(&CCITT_TYPES_DEFINED);
    eval 'sub FALSE () {0;}' unless defined(&FALSE);
    eval 'sub TRUE () {1;}' unless defined(&TRUE);
}
unless(defined(&packet_cause)) {
    sub packet_cause () {	 &packet_data;}
}
unless(defined(&FACILITIES_REVERSE_CHARGE)) {
    sub FACILITIES_REVERSE_CHARGE () {	0x1;}
}
unless(defined(&FACILITIES_THROUGHPUT)) {
    sub FACILITIES_THROUGHPUT () {	0x2;}
}
unless(defined(&FACILITIES_PACKETSIZE)) {
    sub FACILITIES_PACKETSIZE () {	0x42;}
}
unless(defined(&FACILITIES_WINDOWSIZE)) {
    sub FACILITIES_WINDOWSIZE () {	0x43;}
}
unless(defined(&PKHEADERLN)) {
    sub PKHEADERLN () {	3;}
}
unless(defined(&DP)) {
    sub DP {
	local($xp) = @_;
	eval q(((($xp) ->  &packet_type) ->  &bits));
    }
}
unless(defined(&PS)) {
    sub PS {
	local($xp) = @_;
	eval q( &X25GBITS( &DP($xp),  &p_s));
    }
}
unless(defined(&PR)) {
    sub PR {
	local($xp) = @_;
	eval q( &X25GBITS( &DP($xp),  &p_r));
    }
}
unless(defined(&MBIT)) {
    sub MBIT {
	local($xp) = @_;
	eval q( &X25GBITS( &DP($xp),  &m_bit));
    }
}
unless(defined(&SPR)) {
    sub SPR {
	local($xp, $v) = @_;
	eval q( &X25SBITS( &DP($xp),  &p_r, ($v)));
    }
}
unless(defined(&SPS)) {
    sub SPS {
	local($xp, $v) = @_;
	eval q( &X25SBITS( &DP($xp),  &p_s, ($v)));
    }
}
unless(defined(&SMBIT)) {
    sub SMBIT {
	local($xp, $v) = @_;
	eval q( &X25SBITS( &DP($xp),  &m_bit, ($v)));
    }
}
unless(defined(&LCN)) {
    sub LCN {
	local($xp) = @_;
	eval q(($xp ->  &logical_channel_number + ( &X25GBITS($xp ->  &bits,  &lc_group_number) ? ( &X25GBITS($xp ->  &bits,  &lc_group_number) << 8) : 0)));
    }
}
unless(defined(&SET_LCN)) {
    sub SET_LCN {
	local($xp, $lcn) = @_;
	eval q((($xp ->  &logical_channel_number = $lcn), ( &X25SBITS($xp ->  &bits,  &lc_group_number, $lcn > 255? $lcn >> 8: 0))));
    }
}
unless(defined(&LISTEN)) {
    sub LISTEN () {	0;}
}
unless(defined(&READY)) {
    sub READY () {	1;}
}
unless(defined(&RECEIVED_CALL)) {
    sub RECEIVED_CALL () {	2;}
}
unless(defined(&SENT_CALL)) {
    sub SENT_CALL () {	3;}
}
unless(defined(&DATA_TRANSFER)) {
    sub DATA_TRANSFER () {	4;}
}
unless(defined(&RECEIVED_CLEAR)) {
    sub RECEIVED_CLEAR () {	5;}
}
unless(defined(&SENT_CLEAR)) {
    sub SENT_CLEAR () {	6;}
}
unless(defined(&DTE_WAITING)) {
    sub DTE_WAITING () {	7;}
}
unless(defined(&DTE_RECEIVED_RESTART)) {
    sub DTE_RECEIVED_RESTART () {	8;}
}
unless(defined(&DTE_SENT_RESTART)) {
    sub DTE_SENT_RESTART () {	9;}
}
unless(defined(&DTE_READY)) {
    sub DTE_READY () {	0;}
}
unless(defined(&LCN_ZOMBIE)) {
    sub LCN_ZOMBIE () {	10;}
}
unless(defined(&MAXSTATES)) {
    sub MAXSTATES () {	11;}
}
unless(defined(&PK_CALL)) {
    sub PK_CALL () {	(0*  &MAXSTATES);}
}
unless(defined(&PK_CALL_ACCEPTED)) {
    sub PK_CALL_ACCEPTED () {	(1*  &MAXSTATES);}
}
unless(defined(&PK_CLEAR)) {
    sub PK_CLEAR () {	(2*  &MAXSTATES);}
}
unless(defined(&PK_CLEAR_CONF)) {
    sub PK_CLEAR_CONF () {	(3*  &MAXSTATES);}
}
unless(defined(&PK_DATA)) {
    sub PK_DATA () {	(4*  &MAXSTATES);}
}
unless(defined(&PK_INTERRUPT)) {
    sub PK_INTERRUPT () {	(5*  &MAXSTATES);}
}
unless(defined(&PK_INTERRUPT_CONF)) {
    sub PK_INTERRUPT_CONF () {	(6*  &MAXSTATES);}
}
unless(defined(&PK_RR)) {
    sub PK_RR () {	(7*  &MAXSTATES);}
}
unless(defined(&PK_RNR)) {
    sub PK_RNR () {	(8*  &MAXSTATES);}
}
unless(defined(&PK_RESET)) {
    sub PK_RESET () {	(9*  &MAXSTATES);}
}
unless(defined(&PK_RESET_CONF)) {
    sub PK_RESET_CONF () {	(10*  &MAXSTATES);}
}
unless(defined(&PK_RESTART)) {
    sub PK_RESTART () {	(11*  &MAXSTATES);}
}
unless(defined(&PK_RESTART_CONF)) {
    sub PK_RESTART_CONF () {	(12*  &MAXSTATES);}
}
unless(defined(&PK_REJECT)) {
    sub PK_REJECT () {	(13*  &MAXSTATES);}
}
unless(defined(&PK_DIAG_TYPE)) {
    sub PK_DIAG_TYPE () {	(14*  &MAXSTATES);}
}
unless(defined(&PK_INVALID_PACKET)) {
    sub PK_INVALID_PACKET () {	(15*  &MAXSTATES);}
}
unless(defined(&PK_DELETE_PACKET)) {
    sub PK_DELETE_PACKET () {	( &PK_INVALID_PACKET);}
}
unless(defined(&DTE_DXERESOLVING)) {
    sub DTE_DXERESOLVING () {	0x1;}
}
unless(defined(&DTE_PLAYDTE)) {
    sub DTE_PLAYDTE () {	0x2;}
}
unless(defined(&DTE_PLAYDCE)) {
    sub DTE_PLAYDCE () {	0x4;}
}
unless(defined(&DTE_CONNECTPENDING)) {
    sub DTE_CONNECTPENDING () {	0x10;}
}
unless(defined(&DTE_PRETENDDTE)) {
    sub DTE_PRETENDDTE () {	0x20;}
}
unless(defined(&MAXRESTARTCOLLISIONS)) {
    sub MAXRESTARTCOLLISIONS () {	10;}
}
1;
