require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_DEV_IC_MPT_OPENBSD_H_)) {
    eval 'sub _DEV_IC_MPT_OPENBSD_H_ () {1;}' unless defined(&_DEV_IC_MPT_OPENBSD_H_);
    require 'sys/param.ph';
    require 'sys/systm.ph';
    require 'sys/malloc.ph';
    require 'sys/device.ph';
    require 'sys/kernel.ph';
    require 'sys/timeout.ph';
    require 'sys/errno.ph';
    require 'sys/buf.ph';
    require 'sys/queue.ph';
    require 'uvm/uvm_extern.ph';
    require 'machine/bus.ph';
    require 'machine/intr.ph';
    require 'scsi/scsi_all.ph';
    require 'scsi/scsiconf.ph';
    require 'dev/ic/mpt_mpilib.ph';
    unless(defined(&mstohz)) {
	eval 'sub mstohz {
	    local($ms) = @_;
    	    eval q(((($ms +0) / 1000) *  &hz));
	}' unless defined(&mstohz);
    }
    eval 'sub MPT_REPLY_SIZE () {128;}' unless defined(&MPT_REPLY_SIZE);
    eval 'sub MPT_MAX_REQUESTS {
        local($mpt) = @_;
	    eval q((($mpt)-> &is_fc ? 1024: 256));
    }' unless defined(&MPT_MAX_REQUESTS);
    eval 'sub MPT_REQUEST_AREA () {512;}' unless defined(&MPT_REQUEST_AREA);
    eval 'sub MPT_SENSE_SIZE () {32;}' unless defined(&MPT_SENSE_SIZE);
    eval 'sub MPT_REQ_MEM_SIZE {
        local($mpt) = @_;
	    eval q(( &MPT_MAX_REQUESTS($mpt) *  &MPT_REQUEST_AREA));
    }' unless defined(&MPT_REQ_MEM_SIZE);
    eval 'sub MPT_SGL_MAX () {49;}' unless defined(&MPT_SGL_MAX);
    eval 'sub MPT_RQSL {
        local($mpt) = @_;
	    eval q((($mpt)-> &request_frame_size << 2));
    }' unless defined(&MPT_RQSL);
    eval 'sub MPT_NSGL {
        local($mpt) = @_;
	    eval q(( &MPT_RQSL($mpt) / $sizeof{ &SGE_SIMPLE32}));
    }' unless defined(&MPT_NSGL);
    eval 'sub MPT_NSGL_FIRST {
        local($mpt) = @_;
	    eval q((((($mpt)-> &request_frame_size << 2) - $sizeof{ &MSG_SCSI_IO_REQUEST} - $sizeof{ &SGE_IO_UNION}) / $sizeof{ &SGE_SIMPLE32}));
    }' unless defined(&MPT_NSGL_FIRST);
    eval 'sub MPT_REPLY_PTOV {
        local($m, $x) = @_;
	    eval q((( &void *)(($m)-> $reply[((($x) << 1) - ($m)-> &reply_phys)])));
    }' unless defined(&MPT_REPLY_PTOV);
    eval("sub REQ_FREE () { 0; }") unless defined(&REQ_FREE);
    eval("sub REQ_IN_PROGRESS () { 1; }") unless defined(&REQ_IN_PROGRESS);
    eval("sub REQ_TIMEOUT () { 2; }") unless defined(&REQ_TIMEOUT);
    eval("sub REQ_ON_CHIP () { 3; }") unless defined(&REQ_ON_CHIP);
    eval("sub REQ_DONE () { 4; }") unless defined(&REQ_DONE);
    eval 'sub mpt_port_page0 () { ($cfg->{spi}->{_port_page0});}' unless defined(&mpt_port_page0);
    eval 'sub mpt_port_page1 () { ($cfg->{spi}->{_port_page1});}' unless defined(&mpt_port_page1);
    eval 'sub mpt_port_page2 () { ($cfg->{spi}->{_port_page2});}' unless defined(&mpt_port_page2);
    eval 'sub mpt_dev_page0 () { ($cfg->{spi}->{_dev_page0});}' unless defined(&mpt_dev_page0);
    eval 'sub mpt_dev_page1 () { ($cfg->{spi}->{_dev_page1});}' unless defined(&mpt_dev_page1);
    eval 'sub mpt_negotiated_speed () { ($cfg->{spi}->{_negotiated_speed});}' unless defined(&mpt_negotiated_speed);
    eval 'sub mpt_tag_enable () { ($cfg->{spi}->{_tag_enable});}' unless defined(&mpt_tag_enable);
    eval 'sub mpt_disc_enable () { ($cfg->{spi}->{_disc_enable});}' unless defined(&mpt_disc_enable);
    eval 'sub mpt_update_params0 () { ($cfg->{spi}->{_update_params0});}' unless defined(&mpt_update_params0);
    eval 'sub mpt_update_params1 () { ($cfg->{spi}->{_update_params1});}' unless defined(&mpt_update_params1);
    eval 'sub mpt_report_xfer_mode () { ($cfg->{spi}->{_report_xfer_mode});}' unless defined(&mpt_report_xfer_mode);
    eval 'sub MPT_SYNC_REQ {
        local($mpt, $req, $ops) = @_;
	    eval q( &bus_dmamap_sync(($mpt)-> &sc_dmat, ($mpt)-> &request_dmap, ($req)-> &req_pbuf - ($mpt)-> &request_phys,  &MPT_REQUEST_AREA, ($ops)));
    }' unless defined(&MPT_SYNC_REQ);
    eval 'sub mpt_read {
        local($mpt, $reg) = @_;
	    eval q( &bus_space_read_4(($mpt)-> &sc_st, ($mpt)-> &sc_sh, ($reg)));
    }' unless defined(&mpt_read);
    eval 'sub mpt_write {
        local($mpt, $reg, $val) = @_;
	    eval q( &bus_space_write_4(($mpt)-> &sc_st, ($mpt)-> &sc_sh, ($reg), ($val)));
    }' unless defined(&mpt_write);
    eval 'sub mpt_set_config_regs {
        local($mpt) = @_;
	    eval q( &do {  &if (($mpt)-> &sc_set_config_regs !=  &NULL) (*($mpt)-> &sc_set_config_regs)(($mpt)); }  &while ( 0));
    }' unless defined(&mpt_set_config_regs);
}
1;
