#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10049);
 script_version ("$Revision: 1.16 $");
 script_bugtraq_id(128);
 script_cve_id("CVE-1999-0021");
 name["english"] = "Count.cgi";
 name["francais"] = "Count.cgi";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
The 'Count.cgi' cgi is installed. Some versions of this CGI 
have a well known security flaw that lets anyone execute arbitrary
commands with the privileges of the http daemon (root or nobody).

** Note that Nessus neither checked the version number nor tested
** the bug, so this might be a false positive

Solution : remove it from /cgi-bin.

Risk factor : Serious";


 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of /cgi-bin/Count.cgi";
 summary["francais"] = "Vrifie la prsence de /cgi-bin/Count.cgi";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

port = is_cgi_installed("Count.cgi");
if(port)security_hole(port);

