"""SNMP GET test"""
from pysnmp.proto.api import alpha
import base

class GetSetAppMixIn:
    def agentCbFun(self, reqPdu):
        varBinds = map(lambda x: x.apiAlphaGetOidVal(), \
                       reqPdu.apiAlphaGetVarBindList())
        assert map(lambda (o, v): o, varBinds) == \
               map(lambda (o, v): o, self.oidVals)
        rspPdu = reqPdu.apiAlphaReply()
        apply(rspPdu.apiAlphaSetVarBindList, self.oidVals)
        return rspPdu
    
    def __testGetAndSet(self, reqPdu):
        def cbFun(rspPdu):
            if reqPdu.match(rspPdu):
                varBinds = map(lambda x: x.apiAlphaGetOidVal(), \
                               rspPdu.apiAlphaGetVarBindList())
                assert varBinds == self.oidVals
                self.__gotReply = 1
                return 1

        self.__gotReply = 0
        self.managerSendAndReceive(reqPdu, cbFun)
        assert self.__gotReply

    def testGet(self):
        reqPdu = self.snmpProto.GetRequestPdu()
        apply(reqPdu.apiAlphaSetVarBindList, \
              map(lambda (o, v): (o, None), self.oidVals))        
        self.__testGetAndSet(reqPdu)

    def testSet(self):
        reqPdu = self.snmpProto.SetRequestPdu()
        apply(reqPdu.apiAlphaSetVarBindList, self.oidVals)
        self.__testGetAndSet(reqPdu)

class GetSetV1AppTestCase(base.SnmpEntityTestCase, GetSetAppMixIn):
    snmpProto = alpha.protoVersions[alpha.protoVersionId1]
    oidVals = [
        ('.1.3.6.1.2.1.1.1.0', snmpProto.OctetString('testing')),
        ('.1.3.6.1.2.1.1.2.0', snmpProto.Integer(12345)),
        ('.1.3.6.1.2.1.1.3.0', snmpProto.IpAddress('127.0.0.1')) ]
    
class GetSetV2cAppTestCase(base.SnmpEntityTestCase, GetSetAppMixIn):
    snmpProto = alpha.protoVersions[alpha.protoVersionId2c]
    oidVals = [
        ('.1.3.6.1.2.1.1.1.0', snmpProto.Counter64(0x7fffffffffffffffl)),
        ('.1.3.6.1.2.1.1.2.0', snmpProto.Unsigned32(12345)),
        ('.1.3.6.1.2.1.1.3.0', snmpProto.IpAddress('127.0.0.1')) ]

if __name__ == "__main__":
    base.unittest.main()
