#
# Copyright (C) 2004 Tenable Network Security 
#
#

if(description)
{
 script_id(12003);
 
 script_version("$Revision: 1.2 $");

 name["english"] = "TIMESINK detection";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using the TIMESINK program.  
You should ensure that:
- the user intended to install TIMESINK (it is sometimes silently installed)
- the use of TIMESINK matches your corporate mandates and security policies.

To remove this sort of software, you may wish to check out ad-aware or spybot. 

See also : http://www.safersite.com/PestInfo/t/timesink.asp 

Solution : Uninstall this software
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "TIMESINK detection";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("smb_registry_full_access.nasl");
 script_require_keys("SMB/registry_full_access");

 script_require_ports(139, 445);
 exit(0);
}


# start the script

if ( ! get_kb_item("SMB/registry_full_access") ) exit(0);

path[0] = "software\conducent";
path[1] = "software\microsoft\windows\currentversion\uninstall\flexpak";
path[2] = "software\timesink  inc.";



include("smb_nt.inc");

for (i=0; path[i]; i++) {
    if (key[i]) {
        rootfile = registry_get_sz(key:path[i], item:key[i]);
        if(rootfile) {
           mypattern = string(".*", regx[i], ".*");
           if (egrep(string:rootfile, pattern:mypattern)) {security_hole(kb_smb_transport()); exit(0);}
       }
    } else {
       val = registry_get_acl(key:path[i]);
       if(val != NULL) {security_hole(kb_smb_transport()); exit(0); } 
    } 
}


