#
# This script was written by Xue Yong Zhi<xueyong@udel.edu>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(11340);
 script_version ("$Revision: 1.2 $");
 script_bugtraq_id(2222);
 script_cve_id("CVE-2001-0259");
 
 name["english"] = "SSH Secure-RPC Weak Encrypted Authentication";
 script_name(english:name["english"]);
 
 desc["english"] = "
You are running SSH Communications Security SSH 1.2.27 - 1.2.30.
 
With Secure-RPC, this version can allow local attackers to recover a 
SUN-DES-1 magic phrase generated by another user, which the attacker 
can use to decrypt that user's private key file.

Solution :
Patch and New version are available from SSH.

Risk factor : Low";
	
 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the remote SSH version";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2003 Xue Yong Zhi",
		francais:"Ce script est Copyright (C) 2003 Xue Yong Zhi");
 family["english"] = "Gain a shell remotely";
 script_family(english:family["english"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/ssh", 22);
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/ssh");
if(!port)port = 22;

key = string("ssh/banner/", port);
banner = get_kb_item(key);

if(!banner)exit(0);

#Looking for SSH product version number  < 1.2.30
if(ereg(string:banner,
  	pattern:"SSH-.*-1\.2\.([1-2][0-9]|30)[^0-9]*$", icase:TRUE))security_warning(port);

