#
# (C) Tenable Network Security
#
if(description)
{
 script_id(11990);
 script_version("$Revision: 1.4 $");
 script_cve_id("CVE-2003-0903");
 script_bugtraq_id(9407);
 name["english"] = "MDAC Buffer Overflow (832483)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote Microsoft Data Access Component (MDAC) server is vulnerable to a 
flaw which could allow an attacker to execute arbitrary code on this host, 
provided he can simulate responses from a SQL server.

To exploit this flaw, an attacker would need to wait for a host running
a vulnerable MDAC implementation to send a broadcast query. He would then
need to send a malicious packet pretending to come from a SQL server.

Solution : http://www.microsoft.com/technet/security/bulletin/ms04-003.asp
Risk factor : Serious";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks the version of MDAC";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2003 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl","smb_registry_full_access.nasl",
		     "smb_reg_service_pack_W2K.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
		     "SMB/registry_full_access","SMB/WindowsVersion");


 script_require_ports(139, 445);
 exit(0);
}

include("smb_nt.inc");
port = get_kb_item("SMB/transport");
if(!port)port = 139;


access = get_kb_item("SMB/registry_full_access");
if(!access)exit(0);

version = get_kb_item("SMB/WindowsVersion");

key = "SOFTWARE\Microsoft\DataAccess";
item = "Version";
version = registry_get_sz(key:key, item:item);
if(!version)exit(0);



if(ereg(pattern:"2\.8.*", string:version))
{
  key = "SOFTWARE\Microsoft\Windows NT\CurrentVersion\HotFix\KB832483";
  item = "Description";
  hf = registry_get_sz(key:key, item:item);
  if(!hf){ 
  key = "SOFTWARE\Microsoft\Updates\DataAccess\Q832483";
  item = "Description";
  hf = registry_get_sz(key:key, item:item);
  if ( !hf ) { security_warning(port); exit(0); }
  }
}
else if(ereg(pattern:"2\.7.*", string:version))
{
  key = "SOFTWARE\Microsoft\Updates\DataAccess\Q832483";
  item = "Description";
  hf = registry_get_sz(key:key, item:item);
  if(!hf){ security_warning(port); exit(0); }
}
else if(ereg(pattern:"2\.6.*", string:version))
{
 if(ereg(pattern:"2\.6[3-9].*", string:version))exit(0); # SP3 applied
 key = "SOFTWARE\Microsoft\Updates\DataAccess\Q832483";
 item = "Description";
 hf = registry_get_sz(key:key, item:item);
 if(!hf){ security_warning(port); exit(0); }
}
else if(ereg(pattern:"2\.5.*", string:version))
{
 key = "SOFTWARE\Microsoft\Updates\DataAccess\Q832483";
 item = "Description";
 hf = registry_get_sz(key:key, item:item);
 if(!hf) { security_warning(port); exit(0); }
}

set_kb_item(name:"SMB/Q832483", value:1);
