<?php
// $Horde: kronolith/lib/Notification/kronolith.php,v 1.3.2.1 2003/01/03 13:23:36 jan Exp $

require_once HORDE_BASE . '/lib/Notification/status.php';

/**
 * The Notification_status_Kronolith:: class extends the Notification_status::
 * class to display the messages for Kronolith's special message types
 * 'kronolith.alarm' and 'kronolith.event'.
 *
 * @author  Jan Schneider <jan@horde.org>
 * @version $Revision: 1.3.2.1 $
 * @since   Kronolith 1.0
 * @package horde.notification
 */
class Notification_status_kronolith extends Notification_status {

    /**
     * Outputs one message if it's a Kronolith message or calls the
     * parent method otherwise.
     *
     * @param array $message    One message hash from the stack.
     */
    function getMessage($message)
    {
        switch ($message['type']) {
        case 'kronolith.alarm':
            echo '<tr><td class="control">' . Horde::img('alarm.gif') . '&nbsp;&nbsp;<b>' . $message['message'] . '</b></td></tr>';
            break;

        case 'kronolith.event':
            echo '<tr><td class="control">' . Horde::img('event.gif') . '&nbsp;&nbsp;<b>' . $message['message'] . '</b></td></tr>';
            break;

        default:
            parent::getMessage($message);
            break;

        }
    }

}
?>
