%% ``The contents of this file are subject to the Erlang Public License,
%% Version 1.0, (the "License"); you may not use this file except in
%% compliance with the License. You may obtain a copy of the License at
%% http://www.erlang.org/EPL1_0.txt
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% The Original Code is Erlang-4.7.3, December, 1998.
%% 
%% The Initial Developer of the Original Code is Ericsson Telecom
%% AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
%% Telecom AB. All Rights Reserved.
%% 
%% Contributor(s): ______________________________________.''
%%
-module(erl_distribution).
-copyright('Copyright (c) 1991-97 Ericsson Telecom AB').
-vsn('$Revision: /main/release/free/1').
-author('magnus@erix.ericsson.se').

-behaviour(supervisor).

-export([start_link/0,start_link/1,init/1,start/1,stop/0]).

start_link() ->
    case catch start_p() of
	{ok,Args} ->
	    start_link(Args);
	_ ->
	    ignore
    end.

start_link(Args) ->
    supervisor:start_link({local,net_sup},erl_distribution,Args).

init(NetArgs) ->
    Epmd = {erl_epmd,{erl_epmd,start_link,[]},
	    permanent,2000,worker,[erl_epmd]},
    Kernel = {net_kernel,{net_kernel,start_link,[NetArgs]},
	      permanent,2000,worker,[net_kernel]},
    {ok,{{one_for_all,0,1},[Epmd,Kernel]}}.

start_p() ->
    sname(),
    lname(),
    false.

sname() ->
    case init:get_argument(sname) of
	{ok,[[Name]]} ->
	    throw({ok,[list_to_atom(Name),shortnames|ticktime()]});
	_ ->
	    false
    end.

lname() ->
    case init:get_argument(name) of
	{ok,[[Name]]} ->
	    throw({ok,[list_to_atom(Name),longnames|ticktime()]});
	_ ->
	    false
    end.

ticktime() ->
    %% catch, in case the system was started with boot file start_old,
    %% i.e. running without the application_controller.
    %% Time is given in seconds. The net_kernel tick time is
    %% Time/4 milliseconds.
    case catch application:get_env(net_ticktime) of
	{ok, Value} when integer(Value), Value > 0 ->
	    [Value * 250]; %% i.e. 1000 / 4 = 250 ms.
	_ ->
	    []
    end.

start(Args) ->
    C = {net_sup_dynamic, {erl_distribution, start_link, [Args]}, permanent,
	 1000, supervisor, [erl_distribution]},
    supervisor:start_child(kernel_sup, C).

stop() ->
    case supervisor:terminate_child(kernel_sup, net_sup_dynamic) of
	ok ->
	    supervisor:delete_child(kernel_sup, net_sup_dynamic);
	Error ->
	    case whereis(net_sup) of
		Pid when pid(Pid) ->
		    %% Dist. started through -sname | -name flags
		    {error, not_allowed};
		_ ->
		    Error
	    end
    end.

