
######################################################################
#
#  XMMS.PL - xmms-specific code file for wmtheme
#

$wm_executable = 'xmms';
$tosite = '';
$dont_extract = 1;
my $xext_match = 'tgz|tar\.gz|zip|tar\.bz2|wsz';

  ###
  #
  #  WM_GETDEFAULTDIRS
  #
  ###

sub wm_getdefaultdirs {
  my @dirs = ();

  if (exists $ENV{SKINSDIR}) {
    foreach (split /:/, $ENV{SKINSDIR}) {
      push @dirs, $_ if $_;
    }
  }

  verify_themedirs(1, ("$home/.xmms/Skins", "/usr/local/share/xmms/Skins",
    "/usr/share/xmms/Skins", @dirs));
}

  ###
  #
  #  WM_SCANDIR
  #
  ###

sub wm_scandir {
  my $dir = shift;
  my ($entry, $owner, $mtime);

  $owner = (stat $dir)[4];
  $mtime = (stat _)[9];
  opendir DH, $dir or choke("Can't opendir $dir: $!");
  while (defined ($entry = readdir DH)) {
    next if $entry =~ /^\.\.?$/;
    if (-d "$dir/$entry") {
      createthemerec($entry, "$dir/$entry", $owner);
    } elsif (-f "$dir/$entry" and $entry =~ m!([^/]+)\.(?:$xext_match)$!i) {
      createthemerec($1, "$dir/$entry", $owner);
    }
  }
  closedir DH;
  ($dir, $mtime);
}

  ###
  #
  #  WM_INSTALLTHEME
  #
  ###

sub wm_installtheme {
  my ($location, $filename, $defname) = @_;
  my ($themename, $name);

  if (-f $location and $location =~ m!/([^/]+)\.($xext_match)$!i) {
    $name = $defname || $1;
    $ext = $2;
  } else {
    choke("Can't use $location as an xmms skin");
  }

  if ($> == 0) {
    if (!$globalthemedir) {
      choke("No global xmms skin directory could be found.");
    }
    $destdir = $globalthemedir;
  } elsif (!$localthemedir) {
    $localthemedir = "$home/.xmms/Skins";
    print "$localthemedir doesn't exist.  Make it? [Y/n] ";
    if (<STDIN> =~ /^(?:[Yy]|\s*$)/) {
      print "Creating $localthemedir\n";
      syscmd('mkdir', '-p', $localthemedir);
    } else {
      finish("Installation cancelled.");
    }
    $destdir = $localthemedir;
  } else {
    $destdir = $localthemedir;
  }

  $themename = checkname($name);
  syscmd('mv', $location, "$destdir/$themename.$ext");
  createthemerec($themename, "$destdir/$themename.$ext", $>);
  $themename;
}

  ###
  #
  #  WM_ACTIVATETHEME
  #
  ###

sub wm_activatetheme {
  my ($theme, $explicit) = @_;

  eval { require Xmms::Remote };

  if ($@) {
    choke("Can't activate xmms skins without the Xmms::Remote module")
      if $explicit;
    return;
  }

  my $remote = Xmms::Remote->new();
  choke("Couldn't get an xmms remote control!") unless $remote;
  $remote->set_skin($themes{$theme}{path});
}

  ###
  #
  #  WM_UNINSTALLTHEME
  #
  ###

sub wm_uninstalltheme {
  my $theme = shift;

  dirwipe($themes{$theme}{path}, 1);
}

  ###
  #
  #  WM_RENAME
  #
  ###

sub wm_rename {
  my ($old, $new) = @_;
  my $oldpath = $themes{$old}{path};
  my $newpath = $oldpath;

  if (-d $oldpath) {
    $newpath =~ s!/[^/]+$!/$new! or
      choke("Couldn't find old name \"$old\" in theme path \"$newpath\"");
   } elsif ($newpath =~ s!/[^/]+\.($xext_match)$!/$new.$1!) {
   } else {
     choke("Can't rename archive \"$oldpath\" -- unknown extension");
   }
  syscmd('mv', $oldpath, $newpath);
  $newpath;
}

  ###
  #
  #  WM_VERSIONOK
  #
  ###

sub wm_versionok {
  1;
}

1;

