
######################################################################
#
#  OROBORUS.PL - WM-specific code for oroborus
#  
#  Last updated at:
#
#    Oroborus 2.0.3
#    August 9, 2001

#$tosite = 'oroborus.themes.org';
$wm_executable = 'oroborus';
$unsupported{renaming} = 1;
$localrcfile = "$home/.oroborusrc";
my @globaldirs = qw(
    /usr/local/share/oroborus
    /usr/share/oroborus
    /usr/X11R6/share/oroborus
  );

  ###
  #
  #  WM_GETDEFAULTDIRS
  #
  ###

sub wm_getdefaultdirs {
  verify_themedirs(0,
    "$home/.oroborus/themes",
    map { "$_/themes" } @globaldirs
    );
}

  ###
  #
  #  WM_SCANDIR
  #
  ###

sub wm_scandir {
  my $dir = shift;
  my (%scanned, $owner, $entry);

  unless (opendir DH, $dir) {
    complain("can't read directory $dir: $!");
    return;
  }

  $owner = (stat $dir)[4];
  $scanned{$dir} = (stat _)[9];
  while (defined($entry = readdir DH)) {
    next if $entry =~ /^\.\.?$/;
    if (-d "$dir/$entry" and -f "$dir/$entry/themerc") {
      createthemerec($entry, "$dir/$entry", $owner);
    }
  }
  closedir DH;
  %scanned;
}

  ###
  #
  #  WM_INSTALLTHEME
  #
  ###

sub wm_installtheme {
  my ($location, $filename, $defname) = @_;
  my ($destdir, $fromdir, $name);

  unless (-d $location) {
    choke("installation source must be a directory (internal error?)");
  }

  if ($> == 0) {
    if (!$globalthemedir) {
      choke("no global theme directory could be identified");
    }
    $destdir = $globalthemedir;
  } else {
    localsetup_oroborus();
    $destdir = $localthemedir;
  }

  $fromdir = findsubdirwithfile($location, 'themerc')
    or choke("can't find a file named 'themerc' anywhere in",
      "this theme: it's probably bogus.  not installing.");

  if ($defname) {
    $name = $defname;
  } elsif ($fromdir =~ m!([^/]+)$!) {
    $name = $1;
  } else {
    choke("can't get a name from $fromdir (internal error?)");
  }
  $name = checkname($name);
  $destdir .= "/$name";
  syscmd('mv', $fromdir, $destdir);
  createthemerec($name, $destdir, $>);
  $name;
}

  ###
  #
  #  WM_ACTIVATETHEME
  #
  ###

sub wm_activatetheme {
  my ($theme, $explicit) = @_;
  my $rctext;

  localsetup_oroborus();
  $rctext = slurpfile($localrcfile);
  unless ($rctext =~ s/^\s*theme\s*=.*$/theme=$themes{$theme}{path}/m) {
    $rctext = "theme=$themes{$theme}{path}\n$rctext";
  }
  stowfile($localrcfile, $rctext);
  sigbyname(HUP, 'oroborus');
}

  ###
  #
  #  WM_UNINSTALLTHEME
  #
  ###

sub wm_uninstalltheme {
  my $theme = shift;

  dirwipe($themes{$theme}{path}, 1);
}

  ###
  #
  #  WM_RENAME
  #
  ###

sub wm_rename {
  my ($old, $new) = @_;

  my $oldpath = $themes{$old}{path};
  my $newpath = $oldpath;

  if (-d $oldpath) {
    $newpath =~ s!/\Q$old\E$!$new! or
      choke("couldn't rename $old to $new: internal error?");
    rename $oldpath, $newpath or
      choke("can't rename $oldpath to $newpath: $!");
  } else {
    choke("no such directory $oldpath: internal error?");
  }

  $newpath;
}

  ###
  #
  #  WM_VERSIONOK
  #
  ###

sub wm_versionok {
  1;
}

sub localsetup_oroborus {
  $localthemedir = "$home/.oroborus/themes";
  return if -e $localrcfile and -d $localthemedir;

  print "The file ~/.oroborusrc and directory ~/.oroborus/themes are required.\n";
  print "Ok to create these? [Y/n] ";
  choke("Cancelled.") unless <STDIN> =~ /^(?:[Yy]|\s*$)/;

  unless (-e $localrcfile) {
    for (@globaldirs) {
      if (-e "$_/defaults") {
        $globalrcfile = "$_/defaults";
        last;
      }
    }

    unless ($globalrcfile) {
      choke("can't find a local or global rcfile",
        "your oroborus kit seems to be incomplete!");
    }
    copyfile($globalrcfile, $localrcfile);
  }

  unless (-d "$home/.oroborus") {
    mkdir "$home/.oroborus", 0755 or
      choke("can't mkdir $home/.oroborus: $!");
  }
  unless (-d "$home/.oroborus/themes") {
    mkdir "$home/.oroborus/themes", 0755 or
      choke("can't mkdir $home/.oroborus/themes: $!");
  }
}

1;

