/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
 
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
 
    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
    Alexander Pipelka
    pipelka@teleweb.at
 
    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/05/11 13:45:17 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/include/Attic/pggradientwidget.h,v $
    CVS/RCS Revision: $Revision: 1.1.2.3 $
    Status:           $State: Exp $
*/

#ifndef PG_GRADIENTWIDGET_H
#define PG_GRADIENTWIDGET_H

#ifdef SWIG
%include "swigcommon.h"
%module pggradientwidget
%{
#include "pggradientwidget.h"
%}
#endif

#include "pgwidgetdnd.h"

/**
	@author Alexander Pipelka

	@short Base class for widgets with gradients.

	This class is the base class for all themed widgets.<br>
	It handles various combinations of gradients and background images.

	\anchor theme_PG_GradientWidget

	<h2>Theme support</h2><p>

	<b>widget type:</b>		GradientWidget (default)<br>
	<b>object name:</b>		GradientWidget<br>

	<h3>Parent theme:</h3>

	\ref theme_PG_Widget "PG_Widget" theme<br>

	<h3>Theme sample:</h3>

	\code
	<widget>
		<type value="GradientWidget"/>
			<object>
			<name value="GradientWidget"/>
			<filename name="background" value="default/back.bmp"/>
			<property name="backmode" value="TILE"/>
			<gradient name="gradient"
				color0="0x00B0B1B6"
				color1="0x0083838D"
				color2="0x007B7B83"
				color3="0x00585765"/>
			<property name="blend" value="200"/>
			<property name="transparency" value="0"/>
			<property name="bordersize" value="1"/>
		</object>
	</widget>
	\endcode
	<p>
	<h2>Code:</h2><p>
*/

class DECLSPEC PG_GradientWidget : public PG_WidgetDnD  {
public:

	PG_GradientWidget(PG_Widget* parent, const PG_Rect& r, bool bCreateSurface, const char* style="GradientWidget");
	PG_GradientWidget(PG_Widget* parent, const PG_Rect& r, const char* style="GradientWidget");
	~PG_GradientWidget();

	/**
	Load a specific themestyle
	@param	widgettype		name of widget type to load
	*/
	void LoadThemeStyle(const char* widgettype);

	void LoadThemeStyle(const char* widgettype, const char* objectname);
	
	/**
	Load the background image from a file
	@param	filename		path to background image file
	@param	mode			BKMODE_TILE | BKMODE_STRETCH
	*/
	bool SetBackground(const char* filename, int mode=BKMODE_TILE);

	/**
	Define a surface as background image (will not be freed)
	@param	surface		pointer to background surface
	@param	mode			BKMODE_TILE | BKMODE_STRETCH
	@return						true on success
	*/
#ifdef SWIG
	%name(SetBackground2) bool SetBackground(SDL_Surface* surface, int mode=BKMODE_TILE);
#else
	bool SetBackground(SDL_Surface* surface, int mode=BKMODE_TILE);
#endif

	/**
	Defines the "blend-level" of gradient & background
	@param	backblend	0 - background image fully visible / 255 - gradient fully visible
	*/
	void SetBackgroundBlend(Uint8 backblend);

	/**
	Set the background gradient
	@param grad				a PG_Gradient structure describing the gradient
	*/
	void SetGradient(PG_Gradient& grad);

protected:

	/**  */
	void eventDraw(SDL_Surface* surface, const PG_Rect& rect);

	PG_Gradient my_gradient;
	SDL_Surface* my_background;

	Uint8 my_blendLevel;
	bool my_backgroundFree;
	int my_backgroundMode;
	int my_bordersize;

private:

	void Init(const char* style);

#ifdef SWIG
	PG_GradientWidget(const PG_GradientWidget&);
	PG_GradientWidget& operator=(const PG_GradientWidget&);
#endif

	/**
	This function frees background surface if possible
	*/
	void FreeSurface();

	bool bThemeLoaded;
};

#endif // PG_GRADIENTWIDGET_H
