<?php
/**
 * $Horde: kronolith/delevent.php,v 1.25.2.4 2003/04/17 16:37:12 chuck Exp $
 *
 * Copyright 1999-2003 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';

$event = $calendar->getEventObject(Horde::getFormData('eventID'));
if (!$event) {
    if (($url = Horde::getFormData('url')) === null) {
        $url = $prefs->getValue('defaultview') . '.php';
        if ($url == '.php') {
            $url = 'month.php';
        }
        $url = Horde::applicationUrl($url, true);
    }
    header('Location: ' . $url);
} elseif ($event->hasRecurType(KRONOLITH_RECUR_NONE) &&
    !$prefs->getValue('confirm_delete')) {
    header('Location: ' . Horde::applicationUrl('deleventaction.php?' . $_SERVER['QUERY_STRING'], 1));
    exit;
}

if ($timestamp = Horde::getFormData('timestamp')) {
	$month = date('n', $timestamp);
	$year = date('Y', $timestamp);
    $day = date('j', $timestamp);
} else {
	$month = Horde::getFormData('month', date('n'));
    $day = Horde::getFormData('mday', date('j'));
	$year = Horde::getFormData('year', date('Y'));
}

$url = Horde::getFormData('url');

$title = sprintf(_("Delete %s"), $event->getTitle());
$js_onLoad = null;

require KRONOLITH_TEMPLATES . '/common-header.inc';
require KRONOLITH_BASE . '/menu.php';
if ($event->hasRecurType(KRONOLITH_RECUR_NONE)) {
    include KRONOLITH_TEMPLATES . '/delete/one.inc';
} else {
    include KRONOLITH_TEMPLATES . '/delete/delete.inc';
}
require KRONOLITH_TEMPLATES . '/common-footer.inc';
