# -*- coding: iso-8859-1 -*-
# Author: David Goodger
# Contact: goodger@users.sourceforge.net
# Revision: $Revision: 1.1.4.1 $
# Date: $Date: 2004/05/13 16:19:59 $
# Copyright: This module has been placed in the public domain.

# New language mappings are welcome.  Before doing a new translation, please
# read <http://docutils.sf.net/spec/howto/i18n.html>.  Two files must be
# translated for each language: one in docutils/languages, the other in
# docutils/parsers/rst/languages.

"""
Brazilian Portuguese-language mappings for language-dependent features of
reStructuredText.
"""

__docformat__ = 'reStructuredText'


directives = {
      # language-dependent: fixed
      u'ateno': 'attention',
      'cuidado': 'caution',
      'perigo': 'danger',
      'erro': 'error',
      u'sugesto': 'hint',
      'importante': 'important',
      'nota': 'note',
      'dica': 'tip',
      'aviso': 'warning',
      u'exortao': 'admonition',
      'barra-lateral': 'sidebar',
      u'tpico': 'topic',
      'bloco-de-linhas': 'line-block',
      'literal-interpretado': 'parsed-literal',
      'rubrica': 'rubric',
      u'epgrafo': 'epigraph',
      'destaques': 'highlights',
      u'citao-destacada': 'pull-quote',
      u'table (translation required)': 'table',
      #'perguntas': 'questions',
      #'qa': 'questions',
      #'faq': 'questions',
      'meta': 'meta',
      #'imagemap': 'imagemap',
      'imagem': 'image',
      'figura': 'figure',
      u'incluso': 'include',
      'cru': 'raw',
      u'substituio': 'replace',
      'unicode': 'unicode',
      'classe': 'class',
      'role (translation required)': 'role',
      u'ndice': 'contents',
      'numsec': 'sectnum',
      u'numerao-de-sees': 'sectnum',
      #u'notas-de-rorap': 'footnotes',
      #u'citaes': 'citations',
      u'links-no-rodap': 'target-notes',
      'restructuredtext-test-directive': 'restructuredtext-test-directive'}
"""English name to registered (in directives/__init__.py) directive name
mapping."""

roles = {
    # language-dependent: fixed
    u'abbreviao': 'abbreviation',
    'ab': 'abbreviation',
    u'acrnimo': 'acronym',
    'ac': 'acronym',
    u'ndice-remissivo': 'index',
    'i': 'index',
    'subscrito': 'subscript',
    'sub': 'subscript',
    'sobrescrito': 'superscript',
    'sob': 'superscript',
    u'referncia-a-ttulo': 'title-reference',
    u'ttulo': 'title-reference',
    't': 'title-reference',
    u'referncia-a-pep': 'pep-reference',
    'pep': 'pep-reference',
    u'referncia-a-rfc': 'rfc-reference',
    'rfc': 'rfc-reference',
    u'nfase': 'emphasis',
    'forte': 'strong',
    'literal': 'literal',
    u'referncia-por-nome': 'named-reference',
    u'referncia-annima': 'anonymous-reference',
    u'referncia-a-nota-de-rodap': 'footnote-reference',
    u'referncia-a-citao': 'citation-reference',
    u'referncia-a-substituio': 'substitution-reference',
    'alvo': 'target',
    u'referncia-a-uri': 'uri-reference',
    'uri': 'uri-reference',
    'url': 'uri-reference',}
"""Mapping of English role names to canonical role names for interpreted text.
"""
