#
# written by K-Otik.com <ReYn0@k-otik.com>
#
# DCP-Portal Cross Site Scripting Bugs
#
#  Message-ID: <1642444765.20030319015935@olympos.org>
#  From: Ertan Kurt <mailto:ertank@olympos.org>
#  To: <bugtraq@securityfocus.com>
#  Subject: Some XSS vulns
#

if (description)
{
 script_id(11446);
 script_version ("$Revision: 1.9 $");
 script_bugtraq_id(7144, 7141);

 script_name(english:"DCP-Portal Cross Site Scripting Bugs");
 desc["english"] = "
DCP-Portal v5.3.1  has a cross site scripting bug. An attacker may use it to 
perform a cross site scripting attack on this host.

Solution : Upgrade to a newer version.
Risk factor : Medium";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if DCP-Portal is vulnerable to xss attack");
 script_category(ACT_GATHER_INFO);
 script_family(english:"CGI abuses", francais:"Abus de CGI");
 script_copyright(english:"This script is Copyright (C) 2003 k-otik.com");
 script_dependencie("find_service.nes", "http_version.nasl", "cross_site_scripting.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_kb_item("Services/www");
if (!port) port = 80;
if(!get_port_state(port))exit(0);
if(!can_host_php(port:port)) exit(0);
if(get_kb_item(string("www/", port, "/generic_xss"))) exit(0);

foreach d (cgi_dirs())
{
 url = string(d, "/calendar.php?year=<script>foo</script>&month=03&day=05");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:1);
 if( buf == NULL ) exit(0);
 
 if( "<script>foo</script>" >< buf )
   {
    security_warning(port);
    exit(0);
   }
}

