<?php
/**
 * Kronolith_Driver:: defines an API for implementing storage backends
 * for Kronolith.
 *
 * $Horde: kronolith/lib/Driver.php,v 1.8.2.2 2003/04/04 19:23:59 chuck Exp $
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @version $Revision: 1.8.2.2 $
 * @since   Kronolith 0.1
 * @package kronolith
 */
class Kronolith_Driver {

    /**
     * A hash containing any parameters for the current driver.
     *
     * @var array $_params
     */
    var $_params = array();

    /**
     * The current calendar.
     *
     * @var string $_calendar
     */
    var $_calendar;

    /**
     * Constructor - just store the $params in our newly-created
     * object. All other work is done by open().
     *
     * @param optional array $params  Any parameters needed for this driver.
     */
    function Kronolith_Driver($params = array())
    {
        $this->_params = $params;
    }

    /**
     * Get the currently open calendar.
     *
     * @return string  The current calendar name.
     */
    function getCalendar()
    {
        return $this->_calendar;
    }

    /**
     * Attempts to return a concrete Kronolith_Driver instance based
     * on $driver.
     * 
     * @param $driver   The type of concrete Kronolith_Driver subclass to return.
     *                  This is based on the calendar driver ($driver). The
     *                  code is dynamically included.
     *
     * @param $params   (optional) A hash containing any additional
     *                  configuration or connection parameters a subclass
     *                  might need.
     *
     * @return          The newly created concrete Kronolith_Driver instance, or false
     *                  on error.
     */
    function &factory($driver, $params = array())
    {
        $driver = strtolower(basename($driver));
        include_once dirname(__FILE__) . '/Driver/' . $driver . '.php';
        $class = 'Kronolith_Driver_' . $driver;
        if (class_exists($class)) {
            return new $class($params);
        } else {
            Horde::fatal(new PEAR_Error(sprintf(_("Unable to load the definition of %s."), $class)), __FILE__, __LINE__);
        }
    }
    
}
