# iso_to_html.py
# (C) 2000 Pablo De Napoli
# This python script translates iso-8859-1 characters 
# to html characters
# Based on Bluefish Copyright (C) 2000 Olivier Sessink
#
#  This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU Library General Public License for more details.
#
#  You should have received a copy of the GNU Library General Public License
#   along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#

import glimmer

html_char_table = {34:"&quot;",	38:"&amp;"   ,     60:"&lt;",          62: "&gt;",
	              160: "&nbsp;",	161:"&iexcl;" ,    162: "&cent;",   163:"&pound;",
		         164:"&curren;" , 165:"&yen;" ,     166:"&brvbar;", 167:"&sect;",
		         168:"&uml;",      169:"&copy;",     170:"&ordf;",    171:"&laquo;",
		         172:"&not;",       173: "&shy;",      174:"&reg;",     175:"&macr;",
		         176:"&deg;",      177: "&plusmn;", 178:"&sup2;",   179:"&sup3;",
		         180: "&acute;",   181: "&micro;",   182:"&para;",    183:"&middot;",
			    184: "&cedil;",    185: "&sup1;",    186: "&ordm;",  187:"&raquo;",
		         188: "&frac14;",  189: "&frac12;",  190:"&frac34;", 191:"&iquest;",
			    192:"&Agrave;",  193:"&Aacute;",  194:"&Acirc;",  195:"&Atilde;",
		         196: "&Auml;",    197:"&Aring;",     198: "&AElig;",  199:"&Ccedil;",
		   	 200:"&Egrave;",  201: "&Eacute;",   202:"&Ecirc;", 203:"&Euml;",
		         204:"&Igrave;",   205: "&Iacute;" ,    206: "&Icirc;" , 207:"&Iuml;",
		         208:"&ETH;",      209: "&Ntilde;",     210:"&Ograve;" , 211:"&Oacute;",
		         212:"&Ocirc;",    213: "&Otilde;",     214:"&Ouml;",     215:"&times;",
		         216: "&Oslash;", 217:"&Ugrave;",    218:"&Uacute;", 219:"&Ucirc;",
		         220: "&Uuml;",    221:"&Yacute;",    222: "&THORN;", 223:"&szlig;",
		         224: "&agrave;", 225:"&aacute;",    226:"&acirc;",  227:"&atilde;",
		         228:"&auml;" ,    229:"&aring;",       230: "&aelig;", 231:"&ccedil;",
		         232:"&egrave;", 233: "&eacute;",    234: "&ecirc;", 235:"&euml;",
		         236:"&igrave;",  237: "&iacute;",     238:"&icirc;",   239:"&iuml;",
		         240:"&eth;",       241:"&ntilde;" ,     242:"&ograve;", 243:"&oacute;",
                   244:"&ocirc;",    245:"&otilde;",      246: "&ouml;" ,  247:"&divide;",
		         248:"&oslash;",  249: "&ugrave;",  250: "&uacute;", 251:"&ucirc;",
		         252:"&uuml;",     253:"&yacute;",   254:"&thorn;",  255:"&yuml;" }

def iso_to_html():
	import struct
	glimmer.move_to(0)
	end_of_text = 0
   glimmer.freeze()
	while not(end_of_text):
		c=glimmer.get_next_char()
		char_code=struct.unpack("B",c)[0]
		if html_char_table.has_key(char_code):
			glimmer.backward_delete(1)
			glimmer.insert(html_char_table[char_code])
		end_of_text =  glimmer.current_position() == glimmer.buffer_size()
   glimmer.thaw()
