require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_M68K_DB_MACHDEP_H_)) {
    eval 'sub _M68K_DB_MACHDEP_H_ () {1;}' unless defined(&_M68K_DB_MACHDEP_H_);
    require 'sys/types.ph';
    require 'uvm/uvm_param.ph';
    require 'machine/frame.ph';
    require 'machine/psl.ph';
    require 'machine/trap.ph';
    eval 'sub DDB_REGS () {( &ddb_regs);}' unless defined(&DDB_REGS);
    eval 'sub PC_REGS {
        local($regs) = @_;
	    eval q((( &db_addr_t)($regs)-> &tf_pc));
    }' unless defined(&PC_REGS);
    eval 'sub BKPT_INST () {0x4e4f;}' unless defined(&BKPT_INST);
    eval 'sub BKPT_SIZE () {(2);}' unless defined(&BKPT_SIZE);
    eval 'sub BKPT_SET {
        local($inst) = @_;
	    eval q(( &BKPT_INST));
    }' unless defined(&BKPT_SET);
    eval 'sub FIXUP_PC_AFTER_BREAK {
        local($regs) = @_;
	    eval q((($regs)-> &tf_pc -=  &BKPT_SIZE));
    }' unless defined(&FIXUP_PC_AFTER_BREAK);
    eval 'sub db_clear_single_step {
        local($regs) = @_;
	    eval q((($regs)-> &tf_sr &= ~ &PSL_T));
    }' unless defined(&db_clear_single_step);
    eval 'sub db_set_single_step {
        local($regs) = @_;
	    eval q((($regs)-> &tf_sr |=  &PSL_T));
    }' unless defined(&db_set_single_step);
    eval 'sub IS_BREAKPOINT_TRAP {
        local($type, $code) = @_;
	    eval q((($type) ==  &T_BREAKPOINT));
    }' unless defined(&IS_BREAKPOINT_TRAP);
    if(defined(&T_WATCHPOINT)) {
	eval 'sub IS_WATCHPOINT_TRAP {
	    local($type, $code) = @_;
    	    eval q((($type) ==  &T_WATCHPOINT));
	}' unless defined(&IS_WATCHPOINT_TRAP);
    } else {
	eval 'sub IS_WATCHPOINT_TRAP {
	    local($type, $code) = @_;
    	    eval q(0);
	}' unless defined(&IS_WATCHPOINT_TRAP);
    }
    eval 'sub M_RTS () {0xffff0000;}' unless defined(&M_RTS);
    eval 'sub I_RTS () {0x4e750000;}' unless defined(&I_RTS);
    eval 'sub M_JSR () {0xffc00000;}' unless defined(&M_JSR);
    eval 'sub I_JSR () {0x4e800000;}' unless defined(&I_JSR);
    eval 'sub M_BSR () {0xff000000;}' unless defined(&M_BSR);
    eval 'sub I_BSR () {0x61000000;}' unless defined(&I_BSR);
    eval 'sub M_RTE () {0xffff0000;}' unless defined(&M_RTE);
    eval 'sub I_RTE () {0x4e730000;}' unless defined(&I_RTE);
    eval 'sub inst_trap_return {
        local($ins) = @_;
	    eval q(((($ins) &M_RTE) ==  &I_RTE));
    }' unless defined(&inst_trap_return);
    eval 'sub inst_return {
        local($ins) = @_;
	    eval q(((($ins) &M_RTS) ==  &I_RTS));
    }' unless defined(&inst_return);
    eval 'sub inst_call {
        local($ins) = @_;
	    eval q(((($ins) &M_JSR) ==  &I_JSR || (($ins) &M_BSR) ==  &I_BSR));
    }' unless defined(&inst_call);
    eval 'sub inst_load {
        local($ins) = @_;
	    eval q(0);
    }' unless defined(&inst_load);
    eval 'sub inst_store {
        local($ins) = @_;
	    eval q(0);
    }' unless defined(&inst_store);
    eval 'sub KGDB_NUMREGS () {(16+2);}' unless defined(&KGDB_NUMREGS);
    eval 'sub KGDB_BUFLEN () {512;}' unless defined(&KGDB_BUFLEN);
    if(defined(&_KERNEL)) {
    }
    eval 'sub DB_AOUT_SYMBOLS () {1;}' unless defined(&DB_AOUT_SYMBOLS);
}
1;
