require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&LMC_MTU)) {
    sub LMC_MTU () {	1500;}
}
unless(defined(&PPP_HEADER_LEN)) {
    sub PPP_HEADER_LEN () {	4;}
}
unless(defined(&BIG_PACKET)) {
    sub BIG_PACKET () {	1;}
}
if(0) {
    eval 'sub LMC_DEBUG () {1;}' unless defined(&LMC_DEBUG);
    eval 'sub DP {
        local($x) = @_;
	    eval q( &printf $x);
    }' unless defined(&DP);
} else {
    eval 'sub DP {
        local($x) = @_;
	    eval q();
    }' unless defined(&DP);
}
unless(defined(&TULIP_DSTS_RxMIIERR)) {
    eval 'sub TULIP_DSTS_RxMIIERR () {0x8;}' unless defined(&TULIP_DSTS_RxMIIERR);
}
unless(defined(&LMC_DSTS_ERRSUM)) {
    sub LMC_DSTS_ERRSUM () {	( &TULIP_DSTS_RxMIIERR);}
}
unless(defined(&PCI_CFID)) {
    sub PCI_CFID () {	0x;}
}
unless(defined(&PCI_CFCS)) {
    sub PCI_CFCS () {	0x4;}
}
unless(defined(&PCI_CFRV)) {
    sub PCI_CFRV () {	0x8;}
}
unless(defined(&PCI_CFLT)) {
    sub PCI_CFLT () {	0xc;}
}
unless(defined(&PCI_CBIO)) {
    sub PCI_CBIO () {	0x10;}
}
unless(defined(&PCI_CBMA)) {
    sub PCI_CBMA () {	0x14;}
}
unless(defined(&PCI_SSID)) {
    sub PCI_SSID () {	0x2c;}
}
unless(defined(&PCI_CFIT)) {
    sub PCI_CFIT () {	0x3c;}
}
unless(defined(&PCI_CFDA)) {
    sub PCI_CFDA () {	0x40;}
}
unless(defined(&LMC_HZ)) {
    sub LMC_HZ () {	10;}
}
unless(defined(&TULIP_GP_PINSET)) {
    eval 'sub TULIP_GP_PINSET () {0x100;}' unless defined(&TULIP_GP_PINSET);
}
unless(defined(&TULIP_BUSMODE_READMULTIPLE)) {
    eval 'sub TULIP_BUSMODE_READMULTIPLE () {0x200000;}' unless defined(&TULIP_BUSMODE_READMULTIPLE);
}
if(defined( &__NetBSD__)) {
    require 'rnd.ph';
    if((defined(&NRND) ? &NRND : 0) > 0) {
	require 'sys/rnd.ph';
    }
}
if(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
    eval 'sub LMC_CSR_READ {
        local($sc, $csr) = @_;
	    eval q( &bus_space_read_4(($sc)-> &lmc_bustag, ($sc)-> &lmc_bushandle, ($sc)-> ($lmc_csrs->{csr})));
    }' unless defined(&LMC_CSR_READ);
    eval 'sub LMC_CSR_WRITE {
        local($sc, $csr, $val) = @_;
	    eval q( &bus_space_write_4(($sc)-> &lmc_bustag, ($sc)-> &lmc_bushandle, ($sc)-> ($lmc_csrs->{csr}), ($val)));
    }' unless defined(&LMC_CSR_WRITE);
    eval 'sub LMC_CSR_READBYTE {
        local($sc, $csr) = @_;
	    eval q( &bus_space_read_1(($sc)-> &lmc_bustag, ($sc)-> &lmc_bushandle, ($sc)-> ($lmc_csrs->{csr})));
    }' unless defined(&LMC_CSR_READBYTE);
    eval 'sub LMC_CSR_WRITEBYTE {
        local($sc, $csr, $val) = @_;
	    eval q( &bus_space_write_1(($sc)-> &lmc_bustag, ($sc)-> &lmc_bushandle, ($sc)-> ($lmc_csrs->{csr}), ($val)));
    }' unless defined(&LMC_CSR_WRITEBYTE);
}
if(!defined( &__NetBSD__)  && !defined( &__OpenBSD__)) {
    eval 'sub LMC_CSR_READ {
        local($sc, $csr) = @_;
	    eval q(( &inl(($sc)-> ($lmc_csrs->{csr}))));
    }' unless defined(&LMC_CSR_READ);
    eval 'sub LMC_CSR_WRITE {
        local($sc, $csr, $val) = @_;
	    eval q( &outl(($sc)-> ($lmc_csrs->{csr}), $val));
    }' unless defined(&LMC_CSR_WRITE);
    eval 'sub LMC_CSR_READBYTE {
        local($sc, $csr) = @_;
	    eval q(( &inb(($sc)-> ($lmc_csrs->{csr}))));
    }' unless defined(&LMC_CSR_READBYTE);
    eval 'sub LMC_CSR_WRITEBYTE {
        local($sc, $csr, $val) = @_;
	    eval q( &outb(($sc)-> ($lmc_csrs->{csr}), $val));
    }' unless defined(&LMC_CSR_WRITEBYTE);
}
unless(defined(&LMC_PCI_CSRSIZE)) {
    sub LMC_PCI_CSRSIZE () {	8;}
}
unless(defined(&LMC_PCI_CSROFFSET)) {
    sub LMC_PCI_CSROFFSET () {	0;}
}
if(!defined( &__NetBSD__)  && !defined( &__OpenBSD__)) {
    eval 'sub LMC_CSR_READ {
        local($sc, $csr) = @_;
	    eval q((0+ *($sc)-> ($lmc_csrs->{csr})));
    }' unless defined(&LMC_CSR_READ);
    eval 'sub LMC_CSR_WRITE {
        local($sc, $csr, $val) = @_;
	    eval q((( &void)(*($sc)-> ($lmc_csrs->{csr}) = ($val))));
    }' unless defined(&LMC_CSR_WRITE);
}
unless(defined(&csr_enetrom)) {
    sub csr_enetrom () {	 &csr_9;}
}
unless(defined(&csr_reserved)) {
    sub csr_reserved () {	 &csr_10;}
}
unless(defined(&csr_full_duplex)) {
    sub csr_full_duplex () {	 &csr_11;}
}
unless(defined(&csr_bootrom)) {
    sub csr_bootrom () {	 &csr_10;}
}
unless(defined(&csr_gp)) {
    sub csr_gp () {	 &csr_12;}
}
unless(defined(&csr_watchdog)) {
    sub csr_watchdog () {	 &csr_15;}
}
unless(defined(&csr_gp_timer)) {
    sub csr_gp_timer () {	 &csr_11;}
}
unless(defined(&csr_srom_mii)) {
    sub csr_srom_mii () {	 &csr_9;}
}
unless(defined(&csr_sia_status)) {
    sub csr_sia_status () {	 &csr_12;}
}
unless(defined(&csr_sia_connectivity)) {
    sub csr_sia_connectivity () {	 &csr_13;}
}
unless(defined(&csr_sia_tx_rx)) {
    sub csr_sia_tx_rx () {	 &csr_14;}
}
unless(defined(&csr_sia_general)) {
    sub csr_sia_general () {	 &csr_15;}
}
unless(defined(&LMC_RXDESCS)) {
    sub LMC_RXDESCS () {	48;}
}
unless(defined(&LMC_TXDESCS)) {
    sub LMC_TXDESCS () {	128;}
}
unless(defined(&LMC_RXQ_TARGET)) {
    sub LMC_RXQ_TARGET () {	32;}
}
if((defined(&LMC_RXQ_TARGET) ? &LMC_RXQ_TARGET : 0) >= (defined(&LMC_RXDESCS) ? &LMC_RXDESCS : 0)) {
    die("LMC_RXQ_TARGET\ must\ be\ less\ than\ LMC_RXDESCS");
}
unless(defined(&LMC_RX_BUFLEN)) {
    sub LMC_RX_BUFLEN () {	(( &MCLBYTES < 2048?  &MCLBYTES : 2048) - 16);}
}
unless(defined(&LMC_LINK_UP)) {
    sub LMC_LINK_UP () {	1;}
}
unless(defined(&LMC_LINK_DOWN)) {
    sub LMC_LINK_DOWN () {	0;}
}
eval("sub LMC_21140 () { 0; }") unless defined(&LMC_21140);
eval("sub LMC_21140A () { 1; }") unless defined(&LMC_21140A);
eval("sub LMC_CHIPID_UNKNOWN () { 2; }") unless defined(&LMC_CHIPID_UNKNOWN);
unless(defined(&LMC_BIT)) {
    sub LMC_BIT {
	local($b) = @_;
	eval q((1 << (($b))));
    }
}
if(defined( &__bsdi__)) {
    eval 'sub lmc_if () { ($lmc_p2pcom->{p2p_if});}' unless defined(&lmc_if);
}
if(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
}
if(defined( &__NetBSD__) || defined( &__FreeBSD__) || defined( &__OpenBSD__)) {
    eval 'sub lmc_if () { ($lmc_sppp->{pp_if});}' unless defined(&lmc_if);
}
if(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
} else {
}
if(defined( &__FreeBSD__)) {
} else {
}
if(defined( &__NetBSD__)  && (defined(&NRND) ? &NRND : 0) > 0) {
}
unless(defined(&LMC_IFUP)) {
    sub LMC_IFUP () {	0x1;}
}
unless(defined(&LMC_00000002)) {
    sub LMC_00000002 () {	0x2;}
}
unless(defined(&LMC_00000004)) {
    sub LMC_00000004 () {	0x4;}
}
unless(defined(&LMC_00000008)) {
    sub LMC_00000008 () {	0x8;}
}
unless(defined(&LMC_00000010)) {
    sub LMC_00000010 () {	0x10;}
}
unless(defined(&LMC_MODEMOK)) {
    sub LMC_MODEMOK () {	0x20;}
}
unless(defined(&LMC_00000040)) {
    sub LMC_00000040 () {	0x40;}
}
unless(defined(&LMC_00000080)) {
    sub LMC_00000080 () {	0x80;}
}
unless(defined(&LMC_RXACT)) {
    sub LMC_RXACT () {	0x100;}
}
unless(defined(&LMC_INRESET)) {
    sub LMC_INRESET () {	0x200;}
}
unless(defined(&LMC_NEEDRESET)) {
    sub LMC_NEEDRESET () {	0x400;}
}
unless(defined(&LMC_00000800)) {
    sub LMC_00000800 () {	0x800;}
}
unless(defined(&LMC_00001000)) {
    sub LMC_00001000 () {	0x1000;}
}
unless(defined(&LMC_00002000)) {
    sub LMC_00002000 () {	0x2000;}
}
unless(defined(&LMC_WANTTXSTART)) {
    sub LMC_WANTTXSTART () {	0x4000;}
}
unless(defined(&LMC_NEWTXTHRESH)) {
    sub LMC_NEWTXTHRESH () {	0x8000;}
}
unless(defined(&LMC_NOAUTOSENSE)) {
    sub LMC_NOAUTOSENSE () {	0x10000;}
}
unless(defined(&LMC_PRINTLINKUP)) {
    sub LMC_PRINTLINKUP () {	0x20000;}
}
unless(defined(&LMC_LINKUP)) {
    sub LMC_LINKUP () {	0x40000;}
}
unless(defined(&LMC_RXBUFSLOW)) {
    sub LMC_RXBUFSLOW () {	0x80000;}
}
unless(defined(&LMC_NOMESSAGES)) {
    sub LMC_NOMESSAGES () {	0x100000;}
}
unless(defined(&LMC_SYSTEMERROR)) {
    sub LMC_SYSTEMERROR () {	0x200000;}
}
unless(defined(&LMC_TIMEOUTPENDING)) {
    sub LMC_TIMEOUTPENDING () {	0x400000;}
}
unless(defined(&LMC_00800000)) {
    sub LMC_00800000 () {	0x800000;}
}
unless(defined(&LMC_01000000)) {
    sub LMC_01000000 () {	0x1000000;}
}
unless(defined(&LMC_02000000)) {
    sub LMC_02000000 () {	0x2000000;}
}
unless(defined(&LMC_RXIGNORE)) {
    sub LMC_RXIGNORE () {	0x4000000;}
}
unless(defined(&LMC_08000000)) {
    sub LMC_08000000 () {	0x8000000;}
}
unless(defined(&LMC_10000000)) {
    sub LMC_10000000 () {	0x10000000;}
}
unless(defined(&LMC_20000000)) {
    sub LMC_20000000 () {	0x20000000;}
}
unless(defined(&LMC_40000000)) {
    sub LMC_40000000 () {	0x40000000;}
}
unless(defined(&LMC_80000000)) {
    sub LMC_80000000 () {	0x80000000;}
}
unless(defined(&LMC_HAVE_GPR)) {
    sub LMC_HAVE_GPR () {	0x1;}
}
unless(defined(&LMC_HAVE_RXBADOVRFLW)) {
    sub LMC_HAVE_RXBADOVRFLW () {	0x2;}
}
unless(defined(&LMC_HAVE_POWERMGMT)) {
    sub LMC_HAVE_POWERMGMT () {	0x4;}
}
unless(defined(&LMC_HAVE_MII)) {
    sub LMC_HAVE_MII () {	0x8;}
}
unless(defined(&LMC_HAVE_SIANWAY)) {
    sub LMC_HAVE_SIANWAY () {	0x10;}
}
unless(defined(&LMC_HAVE_DUALSENSE)) {
    sub LMC_HAVE_DUALSENSE () {	0x20;}
}
unless(defined(&LMC_HAVE_SIAGP)) {
    sub LMC_HAVE_SIAGP () {	0x40;}
}
unless(defined(&LMC_HAVE_BROKEN_HASH)) {
    sub LMC_HAVE_BROKEN_HASH () {	0x80;}
}
unless(defined(&LMC_HAVE_ISVSROM)) {
    sub LMC_HAVE_ISVSROM () {	0x100;}
}
unless(defined(&LMC_HAVE_BASEROM)) {
    sub LMC_HAVE_BASEROM () {	0x200;}
}
unless(defined(&LMC_HAVE_SLAVEDROM)) {
    sub LMC_HAVE_SLAVEDROM () {	0x400;}
}
unless(defined(&LMC_HAVE_SLAVEDINTR)) {
    sub LMC_HAVE_SLAVEDINTR () {	0x800;}
}
unless(defined(&LMC_HAVE_SHAREDINTR)) {
    sub LMC_HAVE_SHAREDINTR () {	0x1000;}
}
unless(defined(&LMC_HAVE_OKROM)) {
    sub LMC_HAVE_OKROM () {	0x2000;}
}
unless(defined(&LMC_HAVE_NOMEDIA)) {
    sub LMC_HAVE_NOMEDIA () {	0x4000;}
}
unless(defined(&LMC_HAVE_STOREFWD)) {
    sub LMC_HAVE_STOREFWD () {	0x8000;}
}
unless(defined(&LMC_HAVE_SIA100)) {
    sub LMC_HAVE_SIA100 () {	0x10000;}
}
unless(defined(&LMC_MAX_DEVICES)) {
    sub LMC_MAX_DEVICES () {	32;}
}
if(defined( &__FreeBSD__)) {
    if((defined(&BSD) ? &BSD : 0) >= 199506) {
	eval 'sub LMC_IFP_TO_SOFTC {
	    local($ifp) = @_;
    	    eval q((( &lmc_softc_t *)(($ifp)-> &if_softc)));
	}' unless defined(&LMC_IFP_TO_SOFTC);
	if((defined(&NBPFILTER) ? &NBPFILTER : 0) > 0) {
	    eval 'sub LMC_BPF_MTAP {
	        local($sc, $m) = @_;
    		eval q( &bpf_mtap(($sc)-> ($l$mc_sppp->{pp_if}), $m));
	    }' unless defined(&LMC_BPF_MTAP);
	    eval 'sub LMC_BPF_TAP {
	        local($sc, $p, $l) = @_;
    		eval q( &bpf_tap(($sc)-> ($lmc_sppp->{p$p_if}), $p, $l));
	    }' unless defined(&LMC_BPF_TAP);
	    eval 'sub LMC_BPF_ATTACH {
	        local($sc) = @_;
    		eval q( &bpfattach(($sc)-> ($lmc_sppp->{pp_if}),  &DLT_PPP,  &PPP_HEADER_LEN));
	    }' unless defined(&LMC_BPF_ATTACH);
	}
	eval 'sub LMC_VOID_INTRFUNC () {1;}' unless defined(&LMC_VOID_INTRFUNC);
	eval 'sub IFF_NOTRAILERS () {0;}' unless defined(&IFF_NOTRAILERS);
	eval 'sub LMC_EADDR_FMT () {"%6D";}' unless defined(&LMC_EADDR_FMT);
	eval 'sub LMC_EADDR_ARGS {
	    local($addr) = @_;
    	    eval q($addr, \\":\\");
	}' unless defined(&LMC_EADDR_ARGS);
    } else {
	eval 'sub LMC_IFP_TO_SOFTC {
	    local($ifp) = @_;
    	    eval q(( &LMC_UNIT_TO_SOFTC(($ifp)-> &if_unit)));
	}' unless defined(&LMC_IFP_TO_SOFTC);
	require 'sys/devconf.ph';
	eval 'sub LMC_DEVCONF () {1;}' unless defined(&LMC_DEVCONF);
    }
    eval 'sub LMC_UNIT_TO_SOFTC {
        local($unit) = @_;
	    eval q(( $tulips[$unit]));
    }' unless defined(&LMC_UNIT_TO_SOFTC);
    eval 'sub LMC_BURSTSIZE {
        local($unit) = @_;
	    eval q( &pci_max_burst_len);
    }' unless defined(&LMC_BURSTSIZE);
    eval 'sub loudprintf () { &if ( &bootverbose)  &printf;}' unless defined(&loudprintf);
}
if(defined( &__bsdi__)) {
    eval 'sub LMC_UNIT_TO_SOFTC {
        local($unit) = @_;
	    eval q((( &lmc_softc_t *) ($lmccd->{cd_devs[$unit]})));
    }' unless defined(&LMC_UNIT_TO_SOFTC);
    eval 'sub LMC_IFP_TO_SOFTC {
        local($ifp) = @_;
	    eval q(( &LMC_UNIT_TO_SOFTC(($ifp)-> &if_unit)));
    }' unless defined(&LMC_IFP_TO_SOFTC);
    eval 'sub loudprintf () { &aprint_verbose;}' unless defined(&loudprintf);
    eval 'sub MCNT {
        local($x) = @_;
	    eval q(($sizeof{$x} / $sizeof{\'struct ifmedia_entry\'}));
    }' unless defined(&MCNT);
    eval 'sub lmc_unit () { ($lmc_dev->{dv_unit});}' unless defined(&lmc_unit);
    eval 'sub lmc_name () { ($lmc_p2pcom->{p2p_if}->{if_name});}' unless defined(&lmc_name);
    eval 'sub LMC_BPF_MTAP {
        local($sc, $m) = @_;
	    eval q();
    }' unless defined(&LMC_BPF_MTAP);
    eval 'sub LMC_BPF_TAP {
        local($sc, $p, $l) = @_;
	    eval q();
    }' unless defined(&LMC_BPF_TAP);
    eval 'sub LMC_BPF_ATTACH {
        local($sc) = @_;
	    eval q();
    }' unless defined(&LMC_BPF_ATTACH);
}
if(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
    eval 'sub LMC_UNIT_TO_SOFTC {
        local($unit) = @_;
	    eval q((( &lmc_softc_t *)  ($lmc_cd->{cd_devs[$unit]})));
    }' unless defined(&LMC_UNIT_TO_SOFTC);
    eval 'sub LMC_IFP_TO_SOFTC {
        local($ifp) = @_;
	    eval q((( &lmc_softc_t *)(($ifp)-> &if_softc)));
    }' unless defined(&LMC_IFP_TO_SOFTC);
    eval 'sub lmc_unit () { ($lmc_dev->{dv_unit});}' unless defined(&lmc_unit);
    eval 'sub lmc_xname () { ($lmc_if->{if_xname});}' unless defined(&lmc_xname);
    eval 'sub LMC_RAISESPL () {
        eval q( &splnet());
    }' unless defined(&LMC_RAISESPL);
    eval 'sub LMC_RAISESOFTSPL () {
        eval q( &splsoftnet());
    }' unless defined(&LMC_RAISESOFTSPL);
    eval 'sub LMC_RESTORESPL {
        local($s) = @_;
	    eval q( &splx($s));
    }' unless defined(&LMC_RESTORESPL);
    eval 'sub loudprintf () { &printf;}' unless defined(&loudprintf);
    eval 'sub LMC_PRINTF_FMT () {"%s";}' unless defined(&LMC_PRINTF_FMT);
    eval 'sub LMC_PRINTF_ARGS () { ($sc->{lmc_xname});}' unless defined(&LMC_PRINTF_ARGS);
    if(defined( &__alpha__)) {
	eval 'sub LMC_KVATOPHYS {
	    local($sc, $va) = @_;
    	    eval q( &alpha_XXX_dmamap(( &vm_offset_t)($va)));
	}' unless defined(&LMC_KVATOPHYS);
    }
}
unless(defined(&LMC_PRINTF_FMT)) {
    eval 'sub LMC_PRINTF_FMT () {"%s%d";}' unless defined(&LMC_PRINTF_FMT);
}
unless(defined(&LMC_PRINTF_ARGS)) {
    eval 'sub LMC_PRINTF_ARGS () { ($sc->{lmc_name}),  ($sc->{lmc_unit});}' unless defined(&LMC_PRINTF_ARGS);
}
unless(defined(&LMC_BURSTSIZE)) {
    eval 'sub LMC_BURSTSIZE {
        local($unit) = @_;
	    eval q(3);
    }' unless defined(&LMC_BURSTSIZE);
}
unless(defined(&lmc_unit)) {
    eval 'sub lmc_unit () { ($lmc_sppp->{pp_if}->{if_unit});}' unless defined(&lmc_unit);
}
unless(defined(&lmc_name)) {
    eval 'sub lmc_name () { ($lmc_sppp->{pp_if}->{if_name});}' unless defined(&lmc_name);
}
if(!defined( &lmc_bpf)) {
    if(defined( &__NetBSD__) || defined( &__FreeBSD__) | defined( &__OpenBSD__)) {
	eval 'sub lmc_bpf () { ($lmc_sppp->{pp_if}->{if_bpf});}' unless defined(&lmc_bpf);
    }
    if(defined( &__bsdi__)) {
	eval 'sub lmc_bpf () { ($lmc_if->{if_bpf});}' unless defined(&lmc_bpf);
    }
}
if(!defined( &LMC_KVATOPHYS)) {
    eval 'sub LMC_KVATOPHYS {
        local($sc, $va) = @_;
	    eval q( &vtophys($va));
    }' unless defined(&LMC_KVATOPHYS);
}
unless(defined(&LMC_RAISESPL)) {
    eval 'sub LMC_RAISESPL () {
        eval q( &splimp());
    }' unless defined(&LMC_RAISESPL);
}
unless(defined(&LMC_RAISESOFTSPL)) {
    eval 'sub LMC_RAISESOFTSPL () {
        eval q( &splnet());
    }' unless defined(&LMC_RAISESOFTSPL);
}
unless(defined(&TULUP_RESTORESPL)) {
    eval 'sub LMC_RESTORESPL {
        local($s) = @_;
	    eval q( &splx($s));
    }' unless defined(&LMC_RESTORESPL);
}
if(!defined( &LMC_BPF_MTAP)  && (defined(&NBPFILTER) ? &NBPFILTER : 0) > 0) {
    eval 'sub LMC_BPF_MTAP {
        local($sc, $m) = @_;
	    eval q( &bpf_mtap(($sc)-> &lmc_bpf, $m));
    }' unless defined(&LMC_BPF_MTAP);
    eval 'sub LMC_BPF_TAP {
        local($sc, $p, $l) = @_;
	    eval q( &bpf_tap(($sc)-> &lmc_bpf, $p, $l));
    }' unless defined(&LMC_BPF_TAP);
    eval 'sub LMC_BPF_ATTACH {
        local($sc) = @_;
	    eval q( &bpfattach(($sc)-> &lmc_bpf, ($sc)-> ($lmc_sppp->{pp_if}),  &DLT_PPP,  &PPP_HEADER_LEN));
    }' unless defined(&LMC_BPF_ATTACH);
}
if(!defined( &LMC_EADDR_FMT)) {
    eval 'sub LMC_EADDR_FMT () {"%s";}' unless defined(&LMC_EADDR_FMT);
    eval 'sub LMC_EADDR_ARGS {
        local($addr) = @_;
	    eval q( &ether_sprintf($addr));
    }' unless defined(&LMC_EADDR_ARGS);
}
unless(defined(&LMC_CRC32_POLY)) {
    sub LMC_CRC32_POLY () {	0xedb88320;}
}
unless(defined(&LMC_MAX_TXSEG)) {
    sub LMC_MAX_TXSEG () {	30;}
}
unless(defined(&LMC_ADDREQUAL)) {
    sub LMC_ADDREQUAL {
	local($a1, $a2) = @_;
	eval q(((( &u_int16_t *)$a1)[0] == (( &u_int16_t *)$a2)[0]  && (( &u_int16_t *)$a1)[1] == (( &u_int16_t *)$a2)[1]  && (( &u_int16_t *)$a1)[2] == (( &u_int16_t *)$a2)[2]));
    }
}
unless(defined(&LMC_ADDRBRDCST)) {
    sub LMC_ADDRBRDCST {
	local($a1) = @_;
	eval q(((( &u_int16_t *)$a1)[0] == 0xffff  && (( &u_int16_t *)$a1)[1] == 0xffff  && (( &u_int16_t *)$a1)[2] == 0xffff));
    }
}
1;
