require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_I386_CPUFUNC_H_)) {
    eval 'sub _I386_CPUFUNC_H_ () {1;}' unless defined(&_I386_CPUFUNC_H_);
    if(defined(&_KERNEL)) {
	require 'sys/cdefs.ph';
	require 'sys/types.ph';
	require 'machine/specialreg.ph';
	eval 'sub invlpg {
	    local($addr) = @_;
    	    eval q({  &__asm  &__volatile(\\"invlpg (%0)\\" : : \\"r\\" ($addr) : \\"memory\\"); } );
	}' unless defined(&invlpg);
	eval 'sub lidt {
	    local($p) = @_;
    	    eval q({  &__asm  &__volatile(\\"lidt (%0)\\" : : \\"r\\" ($p)); });
	}' unless defined(&lidt);
	eval 'sub lldt {
	    local($sel) = @_;
    	    eval q({  &__asm  &__volatile(\\"lldt %0\\" : : \\"r\\" ($sel)); });
	}' unless defined(&lldt);
	eval 'sub ltr {
	    local($sel) = @_;
    	    eval q({  &__asm  &__volatile(\\"ltr %0\\" : : \\"r\\" ($sel)); });
	}' unless defined(&ltr);
	eval 'sub lcr0 {
	    local($val) = @_;
    	    eval q({  &__asm  &__volatile(\\"movl %0,%%cr0\\" : : \\"r\\" ($val)); });
	}' unless defined(&lcr0);
	eval 'sub rcr0 {
	    local($void) = @_;
    	    eval q({ \'u_int\'  &val;  &__asm  &__volatile(\\"movl %%cr0,%0\\" : \\"=r\\" ( &val));  &val; });
	}' unless defined(&rcr0);
	eval 'sub rcr2 {
	    local($void) = @_;
    	    eval q({ \'u_int\'  &val;  &__asm  &__volatile(\\"movl %%cr2,%0\\" : \\"=r\\" ( &val));  &val; });
	}' unless defined(&rcr2);
	eval 'sub lcr3 {
	    local($val) = @_;
    	    eval q({  &__asm  &__volatile(\\"movl %0,%%cr3\\" : : \\"r\\" ($val)); });
	}' unless defined(&lcr3);
	eval 'sub rcr3 {
	    local($void) = @_;
    	    eval q({ \'u_int\'  &val;  &__asm  &__volatile(\\"movl %%cr3,%0\\" : \\"=r\\" ( &val));  &val; });
	}' unless defined(&rcr3);
	eval 'sub lcr4 {
	    local($val) = @_;
    	    eval q({  &__asm  &__volatile(\\"movl %0,%%cr4\\" : : \\"r\\" ($val)); });
	}' unless defined(&lcr4);
	eval 'sub rcr4 {
	    local($void) = @_;
    	    eval q({ \'u_int\'  &val;  &__asm  &__volatile(\\"movl %%cr4,%0\\" : \\"=r\\" ( &val));  &val; });
	}' unless defined(&rcr4);
	eval 'sub tlbflush {
	    local($void) = @_;
    	    eval q({ \'u_int\'  &val;  &__asm  &__volatile(\\"movl %%cr3,%0\\" : \\"=r\\" ( &val));  &__asm  &__volatile(\\"movl %0,%%cr3\\" : : \\"r\\" ( &val)); });
	}' unless defined(&tlbflush);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub tlbflushg {
	    local($void) = @_;
    	    eval q({  &tlbflush(); });
	}' unless defined(&tlbflushg);
	if(defined(&notyet)) {
	}
	eval 'sub enable_intr {
	    local($void) = @_;
    	    eval q({  &__asm  &__volatile(\\"sti\\"); });
	}' unless defined(&enable_intr);
	eval 'sub read_eflags {
	    local($void) = @_;
    	    eval q({ \'u_int\'  &ef;  &__asm  &__volatile(\\"pushfl; popl %0\\" : \\"=r\\" ( &ef)); ( &ef); });
	}' unless defined(&read_eflags);
	eval 'sub write_eflags {
	    local($ef) = @_;
    	    eval q({  &__asm  &__volatile(\\"pushl %0; popfl\\" : : \\"r\\" ($ef)); });
	}' unless defined(&write_eflags);
	eval 'sub wbinvd {
	    local($void) = @_;
    	    eval q({  &__asm  &__volatile(\\"wbinvd\\"); });
	}' unless defined(&wbinvd);
	eval 'sub wrmsr {
	    local($msr,$newval) = @_;
    	    eval q({  &__asm  &__volatile(\\"wrmsr\\" : : \\"A\\" ($newval), \\"c\\" ($msr)); });
	}' unless defined(&wrmsr);
	eval 'sub rdmsr {
	    local($msr) = @_;
    	    eval q({  &u_int64_t  &rv;  &__asm  &__volatile(\\"rdmsr\\" : \\"=A\\" ( &rv) : \\"c\\" ($msr)); ( &rv); });
	}' unless defined(&rdmsr);
    }
}
1;
