require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_MACHINE_CPU_H_)) {
    eval 'sub _MACHINE_CPU_H_ () {1;}' unless defined(&_MACHINE_CPU_H_);
    require 'machine/trap.ph';
    require 'machine/frame.ph';
    eval 'sub HPPA_FTRS_TLBU () {0x1;}' unless defined(&HPPA_FTRS_TLBU);
    eval 'sub HPPA_FTRS_BTLBU () {0x2;}' unless defined(&HPPA_FTRS_BTLBU);
    eval 'sub HPPA_FTRS_HVT () {0x4;}' unless defined(&HPPA_FTRS_HVT);
    eval 'sub HPPA_FTRS_W32B () {0x8;}' unless defined(&HPPA_FTRS_W32B);
    unless(defined(&_LOCORE)) {
	eval("sub hpcxs () { 0; }") unless defined(&hpcxs);
	eval("sub hpcxt () { 1; }") unless defined(&hpcxt);
	eval("sub hpcxta () { 2; }") unless defined(&hpcxta);
	eval("sub hpcxl () { 3; }") unless defined(&hpcxl);
	eval("sub hpcxl2 () { 4; }") unless defined(&hpcxl2);
	eval("sub hpcxu () { 5; }") unless defined(&hpcxu);
	eval("sub hpcxu2 () { 6; }") unless defined(&hpcxu2);
	eval("sub hpcxw () { 7; }") unless defined(&hpcxw);
    }
    eval 'sub HPPA_FPUS () {0xc0;}' unless defined(&HPPA_FPUS);
    eval 'sub HPPA_FPUVER {
        local($w) = @_;
	    eval q(((($w) & 0x3ff800) >> 11));
    }' unless defined(&HPPA_FPUVER);
    eval 'sub HPPA_FPU_OP {
        local($w) = @_;
	    eval q((($w) >> 26));
    }' unless defined(&HPPA_FPU_OP);
    eval 'sub HPPA_FPU_UNMPL () {0x1;}' unless defined(&HPPA_FPU_UNMPL);
    eval 'sub HPPA_FPU_ILL () {0x80;}' unless defined(&HPPA_FPU_ILL);
    eval 'sub HPPA_FPU_I () {0x1;}' unless defined(&HPPA_FPU_I);
    eval 'sub HPPA_FPU_U () {0x2;}' unless defined(&HPPA_FPU_U);
    eval 'sub HPPA_FPU_O () {0x4;}' unless defined(&HPPA_FPU_O);
    eval 'sub HPPA_FPU_Z () {0x8;}' unless defined(&HPPA_FPU_Z);
    eval 'sub HPPA_FPU_V () {0x10;}' unless defined(&HPPA_FPU_V);
    eval 'sub HPPA_FPU_D () {0x20;}' unless defined(&HPPA_FPU_D);
    eval 'sub HPPA_FPU_T () {0x40;}' unless defined(&HPPA_FPU_T);
    eval 'sub HPPA_FPU_XMASK () {0x7f;}' unless defined(&HPPA_FPU_XMASK);
    eval 'sub HPPA_FPU_T_POS () {25;}' unless defined(&HPPA_FPU_T_POS);
    eval 'sub HPPA_FPU_RM () {0x600;}' unless defined(&HPPA_FPU_RM);
    eval 'sub HPPA_FPU_CQ () {0xfff800;}' unless defined(&HPPA_FPU_CQ);
    eval 'sub HPPA_FPU_C () {0x4000000;}' unless defined(&HPPA_FPU_C);
    eval 'sub HPPA_FPU_FLSH () {27;}' unless defined(&HPPA_FPU_FLSH);
    eval 'sub HPPA_FPU_INIT () {(0);}' unless defined(&HPPA_FPU_INIT);
    eval 'sub HPPA_FPU_FORK {
        local($s) = @_;
	    eval q((($s) & ~(( &u_int64_t)( &HPPA_FPU_XMASK)<<32)));
    }' unless defined(&HPPA_FPU_FORK);
    eval 'sub HPPA_PMSFUS () {0x20;}' unless defined(&HPPA_PMSFUS);
    eval 'sub HPPA_PGALIAS () {0x100000;}' unless defined(&HPPA_PGALIAS);
    eval 'sub HPPA_PGAMASK () {0xfff00000;}' unless defined(&HPPA_PGAMASK);
    eval 'sub HPPA_PGAOFF () {0xfffff;}' unless defined(&HPPA_PGAOFF);
    eval 'sub HPPA_IOSPACE () {0xf0000000;}' unless defined(&HPPA_IOSPACE);
    eval 'sub HPPA_IOBCAST () {0xfffc0000;}' unless defined(&HPPA_IOBCAST);
    eval 'sub HPPA_PDC_LOW () {0xef000000;}' unless defined(&HPPA_PDC_LOW);
    eval 'sub HPPA_PDC_HIGH () {0xf1000000;}' unless defined(&HPPA_PDC_HIGH);
    eval 'sub HPPA_FPA () {0xfff80000;}' unless defined(&HPPA_FPA);
    eval 'sub HPPA_FLEX_DATA () {0xfff80001;}' unless defined(&HPPA_FLEX_DATA);
    eval 'sub HPPA_DMA_ENABLE () {0x1;}' unless defined(&HPPA_DMA_ENABLE);
    eval 'sub HPPA_FLEX_MASK () {0xfffc0000;}' unless defined(&HPPA_FLEX_MASK);
    eval 'sub HPPA_FLEX {
        local($a) = @_;
	    eval q(((($a) &  &HPPA_FLEX_MASK) >> 18));
    }' unless defined(&HPPA_FLEX);
    eval 'sub HPPA_SPA_ENABLE () {0x20;}' unless defined(&HPPA_SPA_ENABLE);
    eval 'sub HPPA_NMODSPBUS () {64;}' unless defined(&HPPA_NMODSPBUS);
    eval 'sub clockframe () { &trapframe;}' unless defined(&clockframe);
    eval 'sub CLKF_PC {
        local($framep) = @_;
	    eval q((($framep)-> &tf_iioq_head));
    }' unless defined(&CLKF_PC);
    eval 'sub CLKF_INTR {
        local($framep) = @_;
	    eval q((($framep)-> &tf_flags &  &TFF_INTR));
    }' unless defined(&CLKF_INTR);
    eval 'sub CLKF_USERMODE {
        local($framep) = @_;
	    eval q((($framep)-> &tf_flags &  &T_USER));
    }' unless defined(&CLKF_USERMODE);
    eval 'sub CLKF_SYSCALL {
        local($framep) = @_;
	    eval q((($framep)-> &tf_flags &  &TFF_SYS));
    }' unless defined(&CLKF_SYSCALL);
    eval 'sub signotify {
        local($p) = @_;
	    eval q(( &setsoftast()));
    }' unless defined(&signotify);
    eval 'sub need_resched {
        local($ci) = @_;
	    eval q(( &want_resched = 1,  &setsoftast()));
    }' unless defined(&need_resched);
    eval 'sub need_proftick {
        local($p) = @_;
	    eval q((($p)-> &p_flag |=  &P_OWEUPC,  &setsoftast()));
    }' unless defined(&need_proftick);
    unless(defined(&_LOCORE)) {
	if(defined(&_KERNEL)) {
	    eval 'sub MD_CACHE_FLUSH () {0;}' unless defined(&MD_CACHE_FLUSH);
	    eval 'sub MD_CACHE_PURGE () {1;}' unless defined(&MD_CACHE_PURGE);
	    eval 'sub MD_CACHE_CTL {
	        local($a,$s,$t) = @_;
    		eval q(((($t)?  &pdcache :  &fdcache) ( &HPPA_SID_KERNEL,( &vaddr_t)($a),($s))));
	    }' unless defined(&MD_CACHE_CTL);
	    eval 'sub DELAY {
	        local($x) = @_;
    		eval q( &delay($x));
	    }' unless defined(&DELAY);
	}
	eval 'sub BOOTARG_LEN () {( &NBPG);}' unless defined(&BOOTARG_LEN);
	eval 'sub BOOTARG_OFF () {(0x10000);}' unless defined(&BOOTARG_OFF);
	eval 'sub CPU_CONSDEV () {1;}' unless defined(&CPU_CONSDEV);
	eval 'sub CPU_FPU () {2;}' unless defined(&CPU_FPU);
	eval 'sub CPU_MAXID () {3;}' unless defined(&CPU_MAXID);
	eval 'sub CTL_MACHDEP_NAMES () {{ { 0, 0}, { "console_device",  &CTLTYPE_STRUCT }, { "fpu",  &CTLTYPE_INT }, };}' unless defined(&CTL_MACHDEP_NAMES);
    }
}
1;
