require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_DEV_IEEE1394_IEEE1394REG_H_)) {
    eval 'sub _DEV_IEEE1394_IEEE1394REG_H_ () {1;}' unless defined(&_DEV_IEEE1394_IEEE1394REG_H_);
    require 'dev/std/ieee1212reg.ph';
    eval 'sub IEEE1394_TCODE_WRITE_REQUEST_QUADLET () {0;}' unless defined(&IEEE1394_TCODE_WRITE_REQUEST_QUADLET);
    eval 'sub IEEE1394_TCODE_WRITE_REQUEST_DATABLOCK () {1;}' unless defined(&IEEE1394_TCODE_WRITE_REQUEST_DATABLOCK);
    eval 'sub IEEE1394_TCODE_WRITE_RESPONSE () {2;}' unless defined(&IEEE1394_TCODE_WRITE_RESPONSE);
    eval 'sub IEEE1394_TCODE_RESERVED_3 () {3;}' unless defined(&IEEE1394_TCODE_RESERVED_3);
    eval 'sub IEEE1394_TCODE_READ_REQUEST_QUADLET () {4;}' unless defined(&IEEE1394_TCODE_READ_REQUEST_QUADLET);
    eval 'sub IEEE1394_TCODE_READ_REQUEST_DATABLOCK () {5;}' unless defined(&IEEE1394_TCODE_READ_REQUEST_DATABLOCK);
    eval 'sub IEEE1394_TCODE_READ_RESPONSE_QUADLET () {6;}' unless defined(&IEEE1394_TCODE_READ_RESPONSE_QUADLET);
    eval 'sub IEEE1394_TCODE_READ_RESPONSE_DATABLOCK () {7;}' unless defined(&IEEE1394_TCODE_READ_RESPONSE_DATABLOCK);
    eval 'sub IEEE1394_TCODE_CYCLE_START () {8;}' unless defined(&IEEE1394_TCODE_CYCLE_START);
    eval 'sub IEEE1394_TCODE_LOCK_REQUEST () {9;}' unless defined(&IEEE1394_TCODE_LOCK_REQUEST);
    eval 'sub IEEE1394_TCODE_ISOCHRONOUS_DATABLOCK () {10;}' unless defined(&IEEE1394_TCODE_ISOCHRONOUS_DATABLOCK);
    eval 'sub IEEE1394_TCODE_LOCK_RESPONSE () {11;}' unless defined(&IEEE1394_TCODE_LOCK_RESPONSE);
    eval 'sub IEEE1394_TCODE_RESERVED_12 () {12;}' unless defined(&IEEE1394_TCODE_RESERVED_12);
    eval 'sub IEEE1394_TCODE_RESERVED_13 () {13;}' unless defined(&IEEE1394_TCODE_RESERVED_13);
    eval 'sub IEEE1394_TCODE_RESERVED_14 () {14;}' unless defined(&IEEE1394_TCODE_RESERVED_14);
    eval 'sub IEEE1394_TCODE_RESERVED_15 () {15;}' unless defined(&IEEE1394_TCODE_RESERVED_15);
    eval 'sub IEEE1394_XTCODE_RESERVED_0 () { &P1212_LOCK_RESERVED_0;}' unless defined(&IEEE1394_XTCODE_RESERVED_0);
    eval 'sub IEEE1394_XTCODE_MASK_SWAP () { &P1212_LOCK_MASK_SWAP;}' unless defined(&IEEE1394_XTCODE_MASK_SWAP);
    eval 'sub IEEE1394_XTCODE_COMPARE_SWAP () { &P1212_LOCK_COMPARE_SWAP;}' unless defined(&IEEE1394_XTCODE_COMPARE_SWAP);
    eval 'sub IEEE1394_XTCODE_FETCH_ADD () { &P1212_LOCK_FETCH_ADD;}' unless defined(&IEEE1394_XTCODE_FETCH_ADD);
    eval 'sub IEEE1394_XTCODE_LITTLE_ADD () { &P1212_LOCK_LITTLE_ADD;}' unless defined(&IEEE1394_XTCODE_LITTLE_ADD);
    eval 'sub IEEE1394_XTCODE_BOUNDED_ADD () { &P1212_LOCK_BOUNDED_ADD;}' unless defined(&IEEE1394_XTCODE_BOUNDED_ADD);
    eval 'sub IEEE1394_XTCODE_WRAP_ADD () { &P1212_LOCK_WRAP_ADD;}' unless defined(&IEEE1394_XTCODE_WRAP_ADD);
    eval 'sub IEEE1394_XTCODE_VENDOR_DEPENDENT () { &P1212_LOCK_VENDOR_DEPENDENT;}' unless defined(&IEEE1394_XTCODE_VENDOR_DEPENDENT);
    eval 'sub IEEE1394_RCODE_COMPLETE () {0;}' unless defined(&IEEE1394_RCODE_COMPLETE);
    eval 'sub IEEE1394_RCODE_RESERVED_1 () {1;}' unless defined(&IEEE1394_RCODE_RESERVED_1);
    eval 'sub IEEE1394_RCODE_RESERVED_2 () {2;}' unless defined(&IEEE1394_RCODE_RESERVED_2);
    eval 'sub IEEE1394_RCODE_RESERVED_3 () {3;}' unless defined(&IEEE1394_RCODE_RESERVED_3);
    eval 'sub IEEE1394_RCODE_CONFLICT_ERROR () {4;}' unless defined(&IEEE1394_RCODE_CONFLICT_ERROR);
    eval 'sub IEEE1394_RCODE_DATA_ERROR () {5;}' unless defined(&IEEE1394_RCODE_DATA_ERROR);
    eval 'sub IEEE1394_RCODE_TYPE_ERROR () {6;}' unless defined(&IEEE1394_RCODE_TYPE_ERROR);
    eval 'sub IEEE1394_RCODE_ADDRESS_ERROR () {7;}' unless defined(&IEEE1394_RCODE_ADDRESS_ERROR);
    eval 'sub IEEE1394_RCODE_RESERVED_8 () {8;}' unless defined(&IEEE1394_RCODE_RESERVED_8);
    eval 'sub IEEE1394_RCODE_RESERVED_9 () {9;}' unless defined(&IEEE1394_RCODE_RESERVED_9);
    eval 'sub IEEE1394_RCODE_RESERVED_10 () {10;}' unless defined(&IEEE1394_RCODE_RESERVED_10);
    eval 'sub IEEE1394_RCODE_RESERVED_11 () {11;}' unless defined(&IEEE1394_RCODE_RESERVED_11);
    eval 'sub IEEE1394_RCODE_RESERVED_12 () {12;}' unless defined(&IEEE1394_RCODE_RESERVED_12);
    eval 'sub IEEE1394_RCODE_RESERVED_13 () {13;}' unless defined(&IEEE1394_RCODE_RESERVED_13);
    eval 'sub IEEE1394_RCODE_RESERVED_14 () {14;}' unless defined(&IEEE1394_RCODE_RESERVED_14);
    eval 'sub IEEE1394_RCODE_RESERVED_15 () {15;}' unless defined(&IEEE1394_RCODE_RESERVED_15);
    eval 'sub IEEE1394_TAG_UNFORMATTED () {0;}' unless defined(&IEEE1394_TAG_UNFORMATTED);
    eval 'sub IEEE1394_TAG_RESERVED_1 () {1;}' unless defined(&IEEE1394_TAG_RESERVED_1);
    eval 'sub IEEE1394_TAG_RESERVED_2 () {2;}' unless defined(&IEEE1394_TAG_RESERVED_2);
    eval 'sub IEEE1394_TAG_RESERVED_3 () {3;}' unless defined(&IEEE1394_TAG_RESERVED_3);
    eval 'sub IEEE1394_ACK_RESERVED_0 () {0;}' unless defined(&IEEE1394_ACK_RESERVED_0);
    eval 'sub IEEE1394_ACK_COMPLETE () {1;}' unless defined(&IEEE1394_ACK_COMPLETE);
    eval 'sub IEEE1394_ACK_PENDING () {2;}' unless defined(&IEEE1394_ACK_PENDING);
    eval 'sub IEEE1394_ACK_RESERVED_3 () {3;}' unless defined(&IEEE1394_ACK_RESERVED_3);
    eval 'sub IEEE1394_ACK_BUSY_X () {4;}' unless defined(&IEEE1394_ACK_BUSY_X);
    eval 'sub IEEE1394_ACK_BUSY_A () {5;}' unless defined(&IEEE1394_ACK_BUSY_A);
    eval 'sub IEEE1394_ACK_BUSY_B () {6;}' unless defined(&IEEE1394_ACK_BUSY_B);
    eval 'sub IEEE1394_ACK_RESERVED_7 () {7;}' unless defined(&IEEE1394_ACK_RESERVED_7);
    eval 'sub IEEE1394_ACK_RESERVED_8 () {8;}' unless defined(&IEEE1394_ACK_RESERVED_8);
    eval 'sub IEEE1394_ACK_RESERVED_9 () {9;}' unless defined(&IEEE1394_ACK_RESERVED_9);
    eval 'sub IEEE1394_ACK_RESERVED_10 () {10;}' unless defined(&IEEE1394_ACK_RESERVED_10);
    eval 'sub IEEE1394_ACK_RESERVED_11 () {11;}' unless defined(&IEEE1394_ACK_RESERVED_11);
    eval 'sub IEEE1394_ACK_RESERVED_12 () {12;}' unless defined(&IEEE1394_ACK_RESERVED_12);
    eval 'sub IEEE1394_ACK_DATA_ERROR () {13;}' unless defined(&IEEE1394_ACK_DATA_ERROR);
    eval 'sub IEEE1394_ACK_TYPE_ERROR () {14;}' unless defined(&IEEE1394_ACK_TYPE_ERROR);
    eval 'sub IEEE1394_ACK_RESERVED_15 () {15;}' unless defined(&IEEE1394_ACK_RESERVED_15);
    eval 'sub IEEE1394_PHY_TYPE_MASK () {0xc0000000;}' unless defined(&IEEE1394_PHY_TYPE_MASK);
    eval 'sub IEEE1394_PHY_TYPE_BITPOS () {30;}' unless defined(&IEEE1394_PHY_TYPE_BITPOS);
    eval 'sub IEEE1394_PHY_SELF_ID () {0x80000000;}' unless defined(&IEEE1394_PHY_SELF_ID);
    eval 'sub IEEE1394_PHY_LINK_ON () {0x40000000;}' unless defined(&IEEE1394_PHY_LINK_ON);
    eval 'sub IEEE1394_PHY_CONFIG () {0x;}' unless defined(&IEEE1394_PHY_CONFIG);
    eval 'sub IEEE1394_PHY_ID_MASK () {0x3f000000;}' unless defined(&IEEE1394_PHY_ID_MASK);
    eval 'sub IEEE1394_PHY_ID_BITPOS () {24;}' unless defined(&IEEE1394_PHY_ID_BITPOS);
    eval 'sub IEEE1394_CONFIG_FORCE_ROOT () {0x800000;}' unless defined(&IEEE1394_CONFIG_FORCE_ROOT);
    eval 'sub IEEE1394_CONFIG_SET_GAPCNT () {0x400000;}' unless defined(&IEEE1394_CONFIG_SET_GAPCNT);
    eval 'sub IEEE1394_CONFIG_GAPCNT_MASK () {0x3f0000;}' unless defined(&IEEE1394_CONFIG_GAPCNT_MASK);
    eval 'sub IEEE1394_CONFIG_GAPCNT_BITPOS () {16;}' unless defined(&IEEE1394_CONFIG_GAPCNT_BITPOS);
    eval 'sub IEEE1394_SELFID_EXTENDED () {0x800000;}' unless defined(&IEEE1394_SELFID_EXTENDED);
    eval 'sub IEEE1394_SELFID_LINK_ACTIVE () {0x400000;}' unless defined(&IEEE1394_SELFID_LINK_ACTIVE);
    eval 'sub IEEE1394_SELFID_CONTENDER () {0x800;}' unless defined(&IEEE1394_SELFID_CONTENDER);
    eval 'sub IEEE1394_SELFID_INITIATED_RESET () {0x2;}' unless defined(&IEEE1394_SELFID_INITIATED_RESET);
    eval 'sub IEEE1394_SELFID_MORE_PACKETS () {0x1;}' unless defined(&IEEE1394_SELFID_MORE_PACKETS);
    eval 'sub IEEE1394_SELFID_GAPCNT_MASK () {0x3f0000;}' unless defined(&IEEE1394_SELFID_GAPCNT_MASK);
    eval 'sub IEEE1394_SELFID_GAPCNT_BITPOS () {16;}' unless defined(&IEEE1394_SELFID_GAPCNT_BITPOS);
    eval 'sub IEEE1394_SELFID_SPEED_MASK () {0xc000;}' unless defined(&IEEE1394_SELFID_SPEED_MASK);
    eval 'sub IEEE1394_SELFID_SPEED_BITPOS () {14;}' unless defined(&IEEE1394_SELFID_SPEED_BITPOS);
    eval 'sub IEEE1394_SELFID_DELAY_MASK () {0x3000;}' unless defined(&IEEE1394_SELFID_DELAY_MASK);
    eval 'sub IEEE1394_SELFID_DELAY_BITPOS () {12;}' unless defined(&IEEE1394_SELFID_DELAY_BITPOS);
    eval 'sub IEEE1394_SELFID_POWER_MASK () {0x700;}' unless defined(&IEEE1394_SELFID_POWER_MASK);
    eval 'sub IEEE1394_SELFID_POWER_BITPOS () {8;}' unless defined(&IEEE1394_SELFID_POWER_BITPOS);
    eval 'sub IEEE1394_SELFID_EXT_SEQ_MASK () {0x700000;}' unless defined(&IEEE1394_SELFID_EXT_SEQ_MASK);
    eval 'sub IEEE1394_SELFID_EXT_SEQ_BITPOS () {20;}' unless defined(&IEEE1394_SELFID_EXT_SEQ_BITPOS);
    eval 'sub IEEE1394_SELFID_PORT_STATUS {
        local($packet,$port) = @_;
	    eval q(((($packet) >> (16- 2* ($port))) & 0x3));
    }' unless defined(&IEEE1394_SELFID_PORT_STATUS);
    eval 'sub IEEE1394_PORT_NOT_PRESENT () {0;}' unless defined(&IEEE1394_PORT_NOT_PRESENT);
    eval 'sub IEEE1394_PORT_NOT_CONNECTED () {1;}' unless defined(&IEEE1394_PORT_NOT_CONNECTED);
    eval 'sub IEEE1394_PORT_CONNECT_PARENT () {2;}' unless defined(&IEEE1394_PORT_CONNECT_PARENT);
    eval 'sub IEEE1394_PORT_CONNECT_CHILD () {3;}' unless defined(&IEEE1394_PORT_CONNECT_CHILD);
    eval 'sub IEEE1394_POW_NONE () {0;}' unless defined(&IEEE1394_POW_NONE);
    eval 'sub IEEE1394_POW_SELF_15W () {1;}' unless defined(&IEEE1394_POW_SELF_15W);
    eval 'sub IEEE1394_POW_SELF_30W () {2;}' unless defined(&IEEE1394_POW_SELF_30W);
    eval 'sub IEEE1394_POW_SELF_45W () {3;}' unless defined(&IEEE1394_POW_SELF_45W);
    eval 'sub IEEE1394_POW_USES_1W () {4;}' unless defined(&IEEE1394_POW_USES_1W);
    eval 'sub IEEE1394_POW_USES_2W () {5;}' unless defined(&IEEE1394_POW_USES_2W);
    eval 'sub IEEE1394_POW_USES_5W () {6;}' unless defined(&IEEE1394_POW_USES_5W);
    eval 'sub IEEE1394_POW_USES_9W () {7;}' unless defined(&IEEE1394_POW_USES_9W);
    eval 'sub IEEE1394_POW_STRINGS () {"None", "15W_Src", "30W_Src", "45W_Src", "1W_Sink", "2W_Sink", "5W_Sink", "9W_Sink";}' unless defined(&IEEE1394_POW_STRINGS);
    eval 'sub IEEE1394_SPD_S100 () {0;}' unless defined(&IEEE1394_SPD_S100);
    eval 'sub IEEE1394_SPD_S200 () {1;}' unless defined(&IEEE1394_SPD_S200);
    eval 'sub IEEE1394_SPD_S400 () {2;}' unless defined(&IEEE1394_SPD_S400);
    eval 'sub IEEE1394_SPD_S800 () {3;}' unless defined(&IEEE1394_SPD_S800);
    eval 'sub IEEE1394_SPD_S1600 () {4;}' unless defined(&IEEE1394_SPD_S1600);
    eval 'sub IEEE1394_SPD_S3200 () {5;}' unless defined(&IEEE1394_SPD_S3200);
    eval 'sub IEEE1394_SPD_MAX () {6;}' unless defined(&IEEE1394_SPD_MAX);
    eval 'sub IEEE1394_SPD_STRINGS () {"100Mb/s", "200Mb/s", "400Mb/s", "800Mb/s", "1.6Gb/s", "3.2Gb/s";}' unless defined(&IEEE1394_SPD_STRINGS);
    if(0) {
    }
    eval 'sub IEEE1394_BCAST_PHY_ID () {0x3f;}' unless defined(&IEEE1394_BCAST_PHY_ID);
    eval 'sub IEEE1394_ISOCH_MASK () {0x3f;}' unless defined(&IEEE1394_ISOCH_MASK);
    eval 'sub IEEE1394_SIGNATURE () {0x31333934;}' unless defined(&IEEE1394_SIGNATURE);
    eval 'sub IEEE1394_TAG_GASP () {0x3;}' unless defined(&IEEE1394_TAG_GASP);
    eval 'sub CSR_BASE_HI () {0xffff;}' unless defined(&CSR_BASE_HI);
    eval 'sub CSR_BASE_LO () {0xf0000000;}' unless defined(&CSR_BASE_LO);
    eval 'sub CSR_BASE () {0xfffff0000000;}' unless defined(&CSR_BASE);
    eval 'sub CSR_STATE_CLEAR () {0x;}' unless defined(&CSR_STATE_CLEAR);
    eval 'sub CSR_STATE_SET () {0x4;}' unless defined(&CSR_STATE_SET);
    eval 'sub CSR_NODE_IDS () {0x8;}' unless defined(&CSR_NODE_IDS);
    eval 'sub CSR_RESET_START () {0xc;}' unless defined(&CSR_RESET_START);
    eval 'sub CSR_INDIRECT_ADDRESS () {0x10;}' unless defined(&CSR_INDIRECT_ADDRESS);
    eval 'sub CSR_INDIRECT_DATA () {0x14;}' unless defined(&CSR_INDIRECT_DATA);
    eval 'sub CSR_SPLIT_TIMEOUT_HI () {0x18;}' unless defined(&CSR_SPLIT_TIMEOUT_HI);
    eval 'sub CSR_SPLIT_TIMEOUT_LO () {0x1c;}' unless defined(&CSR_SPLIT_TIMEOUT_LO);
    eval 'sub CSR_ARGUMENT_HI () {0x20;}' unless defined(&CSR_ARGUMENT_HI);
    eval 'sub CSR_ARGUMENT_LO () {0x24;}' unless defined(&CSR_ARGUMENT_LO);
    eval 'sub CSR_TEST_START () {0x28;}' unless defined(&CSR_TEST_START);
    eval 'sub CSR_TEST_STATUS () {0x2c;}' unless defined(&CSR_TEST_STATUS);
    eval 'sub CSR_INTERRUPT_TARGET () {0x50;}' unless defined(&CSR_INTERRUPT_TARGET);
    eval 'sub CSR_INTERRUPT_MASK () {0x54;}' unless defined(&CSR_INTERRUPT_MASK);
    eval 'sub CSR_CLOCK_VALUE () {0x58;}' unless defined(&CSR_CLOCK_VALUE);
    eval 'sub CSR_CLOCK_PERIOD () {0x5c;}' unless defined(&CSR_CLOCK_PERIOD);
    eval 'sub CSR_CLOCK_STROBE_ARRIVED () {0x60;}' unless defined(&CSR_CLOCK_STROBE_ARRIVED);
    eval 'sub CSR_CLOCK_INFO () {0x64;}' unless defined(&CSR_CLOCK_INFO);
    eval 'sub CSR_MESSAGE_REQUEST () {0x80;}' unless defined(&CSR_MESSAGE_REQUEST);
    eval 'sub CSR_MESSAGE_RESPONSE () {0xc0;}' unless defined(&CSR_MESSAGE_RESPONSE);
    eval 'sub CSR_SB_CYCLE_TIME () {0x200;}' unless defined(&CSR_SB_CYCLE_TIME);
    eval 'sub CSR_SB_BUS_TIME () {0x204;}' unless defined(&CSR_SB_BUS_TIME);
    eval 'sub CSR_SB_POWER_FAIL_IMMINENT () {0x208;}' unless defined(&CSR_SB_POWER_FAIL_IMMINENT);
    eval 'sub CSR_SB_POWER_SOURCE () {0x20c;}' unless defined(&CSR_SB_POWER_SOURCE);
    eval 'sub CSR_SB_BUSY_TIMEOUT () {0x210;}' unless defined(&CSR_SB_BUSY_TIMEOUT);
    eval 'sub CSR_SB_PRIORITY_BUDGET_HI () {0x214;}' unless defined(&CSR_SB_PRIORITY_BUDGET_HI);
    eval 'sub CSR_SB_PRIORITY_BUDGET_LO () {0x218;}' unless defined(&CSR_SB_PRIORITY_BUDGET_LO);
    eval 'sub CSR_SB_BUS_MANAGER_ID () {0x21c;}' unless defined(&CSR_SB_BUS_MANAGER_ID);
    eval 'sub CSR_SB_BANDWIDTH_AVAILABLE () {0x220;}' unless defined(&CSR_SB_BANDWIDTH_AVAILABLE);
    eval 'sub CSR_SB_CHANNEL_AVAILABLE_HI () {0x224;}' unless defined(&CSR_SB_CHANNEL_AVAILABLE_HI);
    eval 'sub CSR_SB_CHANNEL_AVAILABLE_LO () {0x228;}' unless defined(&CSR_SB_CHANNEL_AVAILABLE_LO);
    eval 'sub CSR_SB_MAINT_CONTROL () {0x22c;}' unless defined(&CSR_SB_MAINT_CONTROL);
    eval 'sub CSR_SB_MAINT_UTILITY () {0x230;}' unless defined(&CSR_SB_MAINT_UTILITY);
    eval 'sub CSR_SB_BROADCAST_CHANNEL () {0x234;}' unless defined(&CSR_SB_BROADCAST_CHANNEL);
    eval 'sub CSR_CONFIG_ROM () {0x400;}' unless defined(&CSR_CONFIG_ROM);
    eval 'sub CSR_SB_OUTPUT_MASTER_PLUG () {0x900;}' unless defined(&CSR_SB_OUTPUT_MASTER_PLUG);
    eval 'sub CSR_SB_OUTPUT_PLUG () {0x904;}' unless defined(&CSR_SB_OUTPUT_PLUG);
    eval 'sub CSR_SB_INPUT_MASTER_PLUG () {0x980;}' unless defined(&CSR_SB_INPUT_MASTER_PLUG);
    eval 'sub CSR_SB_INPUT_PLUG () {0x984;}' unless defined(&CSR_SB_INPUT_PLUG);
    eval 'sub CSR_SB_FCP_COMMAND_FRAME () {0xb00;}' unless defined(&CSR_SB_FCP_COMMAND_FRAME);
    eval 'sub CSR_SB_FCP_RESPONSE_FRAME () {0xd00;}' unless defined(&CSR_SB_FCP_RESPONSE_FRAME);
    eval 'sub CSR_SB_TOPOLOGY_MAP () {0x1000;}' unless defined(&CSR_SB_TOPOLOGY_MAP);
    eval 'sub CSR_SB_END () {0x1400;}' unless defined(&CSR_SB_END);
    eval 'sub IEEE1394_MAX_REC {
        local($i) = @_;
	    eval q((0x1 << (($i) + 1)));
    }' unless defined(&IEEE1394_MAX_REC);
    eval 'sub IEEE1394_MAX_ASYNC {
        local($i) = @_;
	    eval q((0x200 << ($i)));
    }' unless defined(&IEEE1394_MAX_ASYNC);
    eval 'sub IEEE1394_BUSINFO_LEN () {3;}' unless defined(&IEEE1394_BUSINFO_LEN);
    eval 'sub IEEE1394_GET_MAX_REC {
        local($i) = @_;
	    eval q(((($i) & 0xf000) >> 12));
    }' unless defined(&IEEE1394_GET_MAX_REC);
    eval 'sub IEEE1394_GET_LINK_SPD {
        local($i) = @_;
	    eval q((($i) & 0x7));
    }' unless defined(&IEEE1394_GET_LINK_SPD);
    eval 'sub FW_FIFO_HI () {0x2000;}' unless defined(&FW_FIFO_HI);
    eval 'sub FW_FIFO_LO () {0x;}' unless defined(&FW_FIFO_LO);
}
1;
