require '_h2ph_pre.ph';

no warnings 'redefine';

if(defined( &__sparc__) || defined( &__FreeBSD__)) {
    eval 'sub bus_space_read_4 {
        local($t, $h, $o) = @_;
	    eval q(( $t, (*(($h) + ($o)))));
    }' unless defined(&bus_space_read_4);
    eval 'sub bus_space_write_4 {
        local($t, $h, $o, $v) = @_;
	    eval q(( $t, ((*(($h) + ($o)) = ($v)))));
    }' unless defined(&bus_space_write_4);
    if(defined( &__sparc__)) {
	eval 'sub vtophys {
	    local($x) = @_;
    	    eval q((($x)));
	}' unless defined(&vtophys);
    }
}
unless(defined(&MID_SZTOB)) {
    sub MID_SZTOB {
	local($X) = @_;
	eval q((($X) * 256* 4));
    }
}
unless(defined(&MID_BTOSZ)) {
    sub MID_BTOSZ {
	local($X) = @_;
	eval q((($X) / 256/ 4));
    }
}
unless(defined(&MID_N_VC)) {
    sub MID_N_VC () {	1024;}
}
unless(defined(&MID_NTX_CH)) {
    sub MID_NTX_CH () {	8;}
}
unless(defined(&MID_ATMDATASZ)) {
    sub MID_ATMDATASZ () {	48;}
}
unless(defined(&MID_PHYOFF)) {
    sub MID_PHYOFF () {	0x30000;}
}
unless(defined(&MID_MIDOFF)) {
    sub MID_MIDOFF () {	0x40000;}
}
unless(defined(&MID_RAMOFF)) {
    sub MID_RAMOFF () {	0x200000;}
}
unless(defined(&MID_DRQOFF)) {
    sub MID_DRQOFF () {	0x204000;}
}
unless(defined(&MID_DRQEND)) {
    sub MID_DRQEND () {	 &MID_DTQOFF;}
}
unless(defined(&MID_DTQOFF)) {
    sub MID_DTQOFF () {	0x205000;}
}
unless(defined(&MID_DTQEND)) {
    sub MID_DTQEND () {	 &MID_SLOFF;}
}
unless(defined(&MID_SLOFF)) {
    sub MID_SLOFF () {	0x206000;}
}
unless(defined(&MID_SLEND)) {
    sub MID_SLEND () {	 &MID_BUFOFF;}
}
unless(defined(&MID_BUFOFF)) {
    sub MID_BUFOFF () {	0x207000;}
}
unless(defined(&MID_PROBEOFF)) {
    sub MID_PROBEOFF () {	0x21fffc;}
}
unless(defined(&MID_PROBSIZE)) {
    sub MID_PROBSIZE () {	0x20000;}
}
unless(defined(&MID_MAXOFF)) {
    sub MID_MAXOFF () {	0x3ffffc;}
}
unless(defined(&MID_RESID)) {
    sub MID_RESID () {	0x40000;}
}
unless(defined(&MID_VER)) {
    sub MID_VER {
	local($X) = @_;
	eval q(((($X) & 0xf0000000) >> 28));
    }
}
unless(defined(&MID_MID)) {
    sub MID_MID {
	local($X) = @_;
	eval q(((($X) & 0x700) >> 8));
    }
}
unless(defined(&MID_IS_SABRE)) {
    sub MID_IS_SABRE {
	local($X) = @_;
	eval q((($X) & 0x80));
    }
}
unless(defined(&MID_IS_SUNI)) {
    sub MID_IS_SUNI {
	local($X) = @_;
	eval q((($X) & 0x40));
    }
}
unless(defined(&MID_IS_UPIPE)) {
    sub MID_IS_UPIPE {
	local($X) = @_;
	eval q((($X) & 0x20));
    }
}
unless(defined(&MID_DID)) {
    sub MID_DID {
	local($X) = @_;
	eval q((($X) & 0x1f));
    }
}
unless(defined(&MID_INTACK)) {
    sub MID_INTACK () {	0x40004;}
}
unless(defined(&MID_INTSTAT)) {
    sub MID_INTSTAT () {	0x40008;}
}
unless(defined(&MID_INTENA)) {
    sub MID_INTENA () {	0x4000c;}
}
unless(defined(&MID_TXCHAN)) {
    sub MID_TXCHAN {
	local($N) = @_;
	eval q((1<< (($N) + 9)));
    }
}
unless(defined(&MID_INT_TX)) {
    sub MID_INT_TX () {	0x1fe00;}
}
unless(defined(&MID_INT_DMA_OVR)) {
    sub MID_INT_DMA_OVR () {	0x100;}
}
unless(defined(&MID_INT_IDENT)) {
    sub MID_INT_IDENT () {	0x80;}
}
unless(defined(&MID_INT_LERR)) {
    sub MID_INT_LERR () {	0x40;}
}
unless(defined(&MID_INT_DMA_ERR)) {
    sub MID_INT_DMA_ERR () {	0x20;}
}
unless(defined(&MID_INT_DMA_RX)) {
    sub MID_INT_DMA_RX () {	0x10;}
}
unless(defined(&MID_INT_DMA_TX)) {
    sub MID_INT_DMA_TX () {	0x8;}
}
unless(defined(&MID_INT_SERVICE)) {
    sub MID_INT_SERVICE () {	0x4;}
}
unless(defined(&MID_INT_SUNI)) {
    sub MID_INT_SUNI () {	0x2;}
}
unless(defined(&MID_INT_STATS)) {
    sub MID_INT_STATS () {	0x1;}
}
unless(defined(&MID_INT_ANY)) {
    sub MID_INT_ANY () {	0x1ffff;}
}
unless(defined(&MID_INTBITS)) {
    sub MID_INTBITS () {	"\20\21T7\20T6\17T5\16T4\15T3\14T2\13T1\12T0\11DMAOVR\10ID\7LERR\6DMAERR\5RXDMA\4TXDMA\3SERV\2SUNI\1STAT";}
}
unless(defined(&MID_MAST_CSR)) {
    sub MID_MAST_CSR () {	0x40010;}
}
unless(defined(&MID_IPL)) {
    sub MID_IPL {
	local($X) = @_;
	eval q(((($X) & 0x1c0) >> 6));
    }
}
unless(defined(&MID_SETIPL)) {
    sub MID_SETIPL {
	local($I) = @_;
	eval q((($I) << 6));
    }
}
unless(defined(&MID_MCSR_TXLOCK)) {
    sub MID_MCSR_TXLOCK () {	0x20;}
}
unless(defined(&MID_MCSR_ENDMA)) {
    sub MID_MCSR_ENDMA () {	0x10;}
}
unless(defined(&MID_MCSR_ENTX)) {
    sub MID_MCSR_ENTX () {	0x8;}
}
unless(defined(&MID_MCSR_ENRX)) {
    sub MID_MCSR_ENRX () {	0x4;}
}
unless(defined(&MID_MCSR_W1MS)) {
    sub MID_MCSR_W1MS () {	0x2;}
}
unless(defined(&MID_MCSR_W500US)) {
    sub MID_MCSR_W500US () {	0x1;}
}
unless(defined(&MID_MCSRBITS)) {
    sub MID_MCSRBITS () {	"\20\6LCK\5DMAON\4TXON\3RXON\2W1MS\1W500US";}
}
unless(defined(&MID_STAT)) {
    sub MID_STAT () {	0x40014;}
}
unless(defined(&MID_VTRASH)) {
    sub MID_VTRASH {
	local($X) = @_;
	eval q(((($X) >> 16) & 0xffff));
    }
}
unless(defined(&MID_OTRASH)) {
    sub MID_OTRASH {
	local($X) = @_;
	eval q((($X) & 0xffff));
    }
}
unless(defined(&MID_SERV_WRITE)) {
    sub MID_SERV_WRITE () {	0x40018;}
}
unless(defined(&MID_DMA_ADDR)) {
    sub MID_DMA_ADDR () {	0x4001c;}
}
unless(defined(&MID_DMA_WRRX)) {
    sub MID_DMA_WRRX () {	0x40020;}
}
unless(defined(&MID_DMA_RDRX)) {
    sub MID_DMA_RDRX () {	0x40024;}
}
unless(defined(&MID_DMA_WRTX)) {
    sub MID_DMA_WRTX () {	0x40028;}
}
unless(defined(&MID_DMA_RDTX)) {
    sub MID_DMA_RDTX () {	0x4002c;}
}
unless(defined(&MIDX_PLACE)) {
    sub MIDX_PLACE {
	local($N) = @_;
	eval q((0x40040+(($N)*0x10)));
    }
}
unless(defined(&MIDX_MKPLACE)) {
    sub MIDX_MKPLACE {
	local($SZ,$LOC) = @_;
	eval q(( (($SZ) << 11) | ($LOC) ));
    }
}
unless(defined(&MIDX_LOC)) {
    sub MIDX_LOC {
	local($X) = @_;
	eval q((($X) & 0x7ff));
    }
}
unless(defined(&MIDX_SZ)) {
    sub MIDX_SZ {
	local($X) = @_;
	eval q((($X) >> 11));
    }
}
unless(defined(&MIDX_BASE)) {
    sub MIDX_BASE {
	local($X) = @_;
	eval q(((( &MIDX_LOC($X) <<  &MIDV_LOCTOPSHFT) * $sizeof{ &u_int32_t}) +  &MID_RAMOFF));
    }
}
unless(defined(&MIDX_READPTR)) {
    sub MIDX_READPTR {
	local($N) = @_;
	eval q((0x40044+(($N)*0x10)));
    }
}
unless(defined(&MIDX_DESCSTART)) {
    sub MIDX_DESCSTART {
	local($N) = @_;
	eval q((0x40048+(($N)*0x10)));
    }
}
unless(defined(&MID_VC)) {
    sub MID_VC {
	local($N) = @_;
	eval q(( &MID_RAMOFF+(($N)*0x10)));
    }
}
unless(defined(&MIDV_TRASH)) {
    sub MIDV_TRASH () {	0x;}
}
unless(defined(&MIDV_AAL5)) {
    sub MIDV_AAL5 () {	0x80000000;}
}
unless(defined(&MIDV_NOAAL)) {
    sub MIDV_NOAAL () {	0x40000000;}
}
unless(defined(&MIDV_MASK)) {
    sub MIDV_MASK () {	0xc0000000;}
}
unless(defined(&MIDV_SETMODE)) {
    sub MIDV_SETMODE {
	local($VC,$M) = @_;
	eval q(((($VC) & ~( &MIDV_MASK)) | ($M)));
    }
}
unless(defined(&MIDV_PTI)) {
    sub MIDV_PTI () {	0x20000000;}
}
unless(defined(&MIDV_LOCTOPSHFT)) {
    sub MIDV_LOCTOPSHFT () {	8;}
}
unless(defined(&MIDV_LOCSHIFT)) {
    sub MIDV_LOCSHIFT () {	18;}
}
unless(defined(&MIDV_LOCMASK)) {
    sub MIDV_LOCMASK () {	0x7ff;}
}
unless(defined(&MIDV_LOC)) {
    sub MIDV_LOC {
	local($X) = @_;
	eval q(((($X) >>  &MIDV_LOCSHIFT) &  &MIDV_LOCMASK));
    }
}
unless(defined(&MIDV_SZSHIFT)) {
    sub MIDV_SZSHIFT () {	15;}
}
unless(defined(&MIDV_SZ)) {
    sub MIDV_SZ {
	local($X) = @_;
	eval q(((($X) >>  &MIDV_SZSHIFT) & 7));
    }
}
unless(defined(&MIDV_INSERVICE)) {
    sub MIDV_INSERVICE () {	0x1;}
}
unless(defined(&MID_DST_RP)) {
    sub MID_DST_RP {
	local($N) = @_;
	eval q(( &MID_VC($N)|0x4));
    }
}
unless(defined(&MIDV_DSTART_SHIFT)) {
    sub MIDV_DSTART_SHIFT () {	16;}
}
unless(defined(&MIDV_DSTART)) {
    sub MIDV_DSTART {
	local($X) = @_;
	eval q(((($X) >>  &MIDV_DSTART_SHIFT) & 0x7fff));
    }
}
unless(defined(&MIDV_READP_MASK)) {
    sub MIDV_READP_MASK () {	0x7fff;}
}
unless(defined(&MID_WP_ST_CNT)) {
    sub MID_WP_ST_CNT {
	local($N) = @_;
	eval q(( &MID_VC($N)|0x8));
    }
}
unless(defined(&MIDV_WRITEP_MASK)) {
    sub MIDV_WRITEP_MASK () {	0x7fff0000;}
}
unless(defined(&MIDV_WRITEP_SHIFT)) {
    sub MIDV_WRITEP_SHIFT () {	16;}
}
unless(defined(&MIDV_ST_IDLE)) {
    sub MIDV_ST_IDLE () {	0x;}
}
unless(defined(&MIDV_ST_TRASH)) {
    sub MIDV_ST_TRASH () {	0xc000;}
}
unless(defined(&MIDV_ST_REASS)) {
    sub MIDV_ST_REASS () {	0x4000;}
}
unless(defined(&MIDV_CCOUNT)) {
    sub MIDV_CCOUNT () {	0x7ff;}
}
unless(defined(&MID_CRC)) {
    sub MID_CRC {
	local($N) = @_;
	eval q(( &MID_VC($N)|0xc));
    }
}
unless(defined(&MID_DMA_END)) {
    sub MID_DMA_END () {	(1<< 5);}
}
unless(defined(&MID_DMA_CNT)) {
    sub MID_DMA_CNT {
	local($X) = @_;
	eval q(((($X) >> 16) & 0xffff));
    }
}
unless(defined(&MID_DMA_TXCHAN)) {
    sub MID_DMA_TXCHAN {
	local($X) = @_;
	eval q(((($X) >> 6) & 0x7));
    }
}
unless(defined(&MID_DMA_RXVCI)) {
    sub MID_DMA_RXVCI {
	local($X) = @_;
	eval q(((($X) >> 6) & 0x3ff));
    }
}
unless(defined(&MID_DMA_TYPE)) {
    sub MID_DMA_TYPE {
	local($X) = @_;
	eval q((($X) & 0xf));
    }
}
unless(defined(&MID_DRQ_N)) {
    sub MID_DRQ_N () {	512;}
}
unless(defined(&MID_DRQ_A2REG)) {
    sub MID_DRQ_A2REG {
	local($N) = @_;
	eval q(((($N) -  &MID_DRQOFF) >> 3));
    }
}
unless(defined(&MID_DRQ_REG2A)) {
    sub MID_DRQ_REG2A {
	local($N) = @_;
	eval q(((($N) << 3) +  &MID_DRQOFF));
    }
}
unless(defined(&MID_MK_RXQ_ENI)) {
    sub MID_MK_RXQ_ENI {
	local($CNT,$VC,$END,$TYPE) = @_;
	eval q(( (($CNT) << 16)|(($VC) << 6)|($END)|($TYPE) ));
    }
}
unless(defined(&MID_MK_RXQ_ADP)) {
    sub MID_MK_RXQ_ADP {
	local($CNT,$VC,$END,$JK) = @_;
	eval q(( (($CNT) << 12)|(($VC) << 2)|(($END) >> 4)|((($JK) != 0) ? 1: 0)));
    }
}
unless(defined(&MID_DTQ_N)) {
    sub MID_DTQ_N () {	512;}
}
unless(defined(&MID_DTQ_A2REG)) {
    sub MID_DTQ_A2REG {
	local($N) = @_;
	eval q(((($N) -  &MID_DTQOFF) >> 3));
    }
}
unless(defined(&MID_DTQ_REG2A)) {
    sub MID_DTQ_REG2A {
	local($N) = @_;
	eval q(((($N) << 3) +  &MID_DTQOFF));
    }
}
unless(defined(&MID_MK_TXQ_ENI)) {
    sub MID_MK_TXQ_ENI {
	local($CNT,$CHN,$END,$TYPE) = @_;
	eval q(( (($CNT) << 16)|(($CHN) << 6)|($END)|($TYPE) ));
    }
}
unless(defined(&MID_MK_TXQ_ADP)) {
    sub MID_MK_TXQ_ADP {
	local($CNT,$CHN,$END,$JK) = @_;
	eval q(( (($CNT) << 12)|(($CHN) << 2)|(($END) >> 4)|((($JK) != 0) ? 1: 0) ));
    }
}
unless(defined(&MIDDMA_JK)) {
    sub MIDDMA_JK () {	0x3;}
}
unless(defined(&MIDDMA_BYTE)) {
    sub MIDDMA_BYTE () {	0x1;}
}
unless(defined(&MIDDMA_2BYTE)) {
    sub MIDDMA_2BYTE () {	0x2;}
}
unless(defined(&MIDDMA_WORD)) {
    sub MIDDMA_WORD () {	0x;}
}
unless(defined(&MIDDMA_2WORD)) {
    sub MIDDMA_2WORD () {	0x7;}
}
unless(defined(&MIDDMA_4WORD)) {
    sub MIDDMA_4WORD () {	0x4;}
}
unless(defined(&MIDDMA_8WORD)) {
    sub MIDDMA_8WORD () {	0x5;}
}
unless(defined(&MIDDMA_16WORD)) {
    sub MIDDMA_16WORD () {	0x6;}
}
unless(defined(&MIDDMA_2WMAYBE)) {
    sub MIDDMA_2WMAYBE () {	0xf;}
}
unless(defined(&MIDDMA_4WMAYBE)) {
    sub MIDDMA_4WMAYBE () {	0xc;}
}
unless(defined(&MIDDMA_8WMAYBE)) {
    sub MIDDMA_8WMAYBE () {	0xd;}
}
unless(defined(&MIDDMA_16WMAYBE)) {
    sub MIDDMA_16WMAYBE () {	0xe;}
}
unless(defined(&MIDDMA_MAYBE)) {
    sub MIDDMA_MAYBE () {	0xc;}
}
unless(defined(&MIDDMA_MAXBURST)) {
    sub MIDDMA_MAXBURST () {	(16* $sizeof{ &u_int32_t});}
}
unless(defined(&MID_SL_N)) {
    sub MID_SL_N () {	1024;}
}
unless(defined(&MID_SL_A2REG)) {
    sub MID_SL_A2REG {
	local($N) = @_;
	eval q(((($N) -  &MID_SLOFF) >> 2));
    }
}
unless(defined(&MID_SL_REG2A)) {
    sub MID_SL_REG2A {
	local($N) = @_;
	eval q(((($N) << 2) +  &MID_SLOFF));
    }
}
unless(defined(&MID_RBD_SIZE)) {
    sub MID_RBD_SIZE () {	4;}
}
unless(defined(&MID_CHDR_SIZE)) {
    sub MID_CHDR_SIZE () {	4;}
}
unless(defined(&MID_RBD_ID)) {
    sub MID_RBD_ID {
	local($X) = @_;
	eval q((($X) & 0xfe000000));
    }
}
unless(defined(&MID_RBD_STDID)) {
    sub MID_RBD_STDID () {	0x36000000;}
}
unless(defined(&MID_RBD_CLP)) {
    sub MID_RBD_CLP () {	0x1000000;}
}
unless(defined(&MID_RBD_CE)) {
    sub MID_RBD_CE () {	0x10000;}
}
unless(defined(&MID_RBD_T)) {
    sub MID_RBD_T () {	0x1000;}
}
unless(defined(&MID_RBD_CRCERR)) {
    sub MID_RBD_CRCERR () {	0x800;}
}
unless(defined(&MID_RBD_CNT)) {
    sub MID_RBD_CNT {
	local($X) = @_;
	eval q((($X) & 0x7ff));
    }
}
unless(defined(&MID_TBD_SIZE)) {
    sub MID_TBD_SIZE () {	8;}
}
unless(defined(&MID_TBD_MK1)) {
    sub MID_TBD_MK1 {
	local($AAL,$PR_RATE,$CNT) = @_;
	eval q(( &MID_TBD_STDID|($AAL)|(($PR_RATE) << 19)|($CNT)));
    }
}
unless(defined(&MID_TBD_STDID)) {
    sub MID_TBD_STDID () {	0xb0000000;}
}
unless(defined(&MID_TBD_AAL5)) {
    sub MID_TBD_AAL5 () {	0x8000000;}
}
unless(defined(&MID_TBD_NOAAL5)) {
    sub MID_TBD_NOAAL5 () {	0x;}
}
unless(defined(&MID_TBD_MK2)) {
    sub MID_TBD_MK2 {
	local($VCI,$PTI,$CLP) = @_;
	eval q(((($VCI) << 4)|(($PTI) << 1)|($CLP)));
    }
}
unless(defined(&MID_PDU_SIZE)) {
    sub MID_PDU_SIZE () {	8;}
}
unless(defined(&MID_PDU_MK1)) {
    sub MID_PDU_MK1 {
	local($UU,$CPI,$LEN) = @_;
	eval q(((($UU) << 24)|(($CPI) << 16)|($LEN)));
    }
}
unless(defined(&MID_PDU_LEN)) {
    sub MID_PDU_LEN {
	local($X) = @_;
	eval q((($X) & 0xffff));
    }
}
1;
