require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&GDT_CMD_RESERVE)) {
    sub GDT_CMD_RESERVE () {	4;}
}
unless(defined(&GDT_IOCTL_DUMMY)) {
    sub GDT_IOCTL_DUMMY () {	 &_IOWR(ord('B'), 32, 'struct gdt_dummy');}
}
unless(defined(&GDT_SCRATCH_SZ)) {
    sub GDT_SCRATCH_SZ () {	4096;}
}
unless(defined(&GDT_IOCTL_GENERAL)) {
    sub GDT_IOCTL_GENERAL () {	 &_IOWR(ord('B'), 33,  &gdt_ucmd_t);}
}
unless(defined(&GDT_IOCTL_DRVERS)) {
    sub GDT_IOCTL_DRVERS () {	 &_IOWR(ord('B'), 34, 'int');}
}
unless(defined(&GDT_IOCTL_CTRTYPE)) {
    sub GDT_IOCTL_CTRTYPE () {	 &_IOR(ord('B'), 35,  &gdt_ctrt_t);}
}
unless(defined(&GDT_IOCTL_OSVERS)) {
    sub GDT_IOCTL_OSVERS () {	 &_IOR(ord('B'), 36,  &gdt_osv_t);}
}
unless(defined(&GDT_IOCTL_CTRCNT)) {
    sub GDT_IOCTL_CTRCNT () {	 &_IOR(ord('B'), 37, 'int');}
}
unless(defined(&GDT_IOCTL_EVENT)) {
    sub GDT_IOCTL_EVENT () {	 &_IOWR(ord('B'), 38,  &gdt_event_t);}
}
unless(defined(&GDT_ES_ASYNC)) {
    sub GDT_ES_ASYNC () {	1;}
}
unless(defined(&GDT_ES_DRIVER)) {
    sub GDT_ES_DRIVER () {	2;}
}
unless(defined(&GDT_ES_TEST)) {
    sub GDT_ES_TEST () {	3;}
}
unless(defined(&GDT_ES_SYNC)) {
    sub GDT_ES_SYNC () {	4;}
}
unless(defined(&GDT_IOCTL_STATIST)) {
    sub GDT_IOCTL_STATIST () {	 &_IOR(ord('B'), 39,  &gdt_statist_t);}
}
if(defined(&_KERNEL)) {
    if(defined(&GDT_DEBUG)) {
	eval 'sub GDT_DPRINTF {
	    local($mask, $args) = @_;
    	    eval q( &if ( &gdt_debug & ($mask))  &printf $args);
	}' unless defined(&GDT_DPRINTF);
	eval 'sub GDT_D_INTR () {0x1;}' unless defined(&GDT_D_INTR);
	eval 'sub GDT_D_MISC () {0x2;}' unless defined(&GDT_D_MISC);
	eval 'sub GDT_D_CMD () {0x4;}' unless defined(&GDT_D_CMD);
	eval 'sub GDT_D_QUEUE () {0x8;}' unless defined(&GDT_D_QUEUE);
	eval 'sub GDT_D_IO () {0x10;}' unless defined(&GDT_D_IO);
    } else {
	eval 'sub GDT_DPRINTF {
	    local($mask, $args) = @_;
    	    eval q();
	}' unless defined(&GDT_DPRINTF);
    }
    eval 'sub GDT_RETRIES () {100000000;}' unless defined(&GDT_RETRIES);
    eval 'sub GDT_TIMEOUT () {100000000;}' unless defined(&GDT_TIMEOUT);
    eval 'sub GDT_POLL_TIMEOUT () {10000000;}' unless defined(&GDT_POLL_TIMEOUT);
    eval 'sub GDT_WATCH_TIMEOUT () {10000;}' unless defined(&GDT_WATCH_TIMEOUT);
    eval 'sub GDT_GCF_CMD_MASK () {0x3;}' unless defined(&GDT_GCF_CMD_MASK);
    eval 'sub GDT_GCF_UNUSED () {0;}' unless defined(&GDT_GCF_UNUSED);
    eval 'sub GDT_GCF_INTERNAL () {1;}' unless defined(&GDT_GCF_INTERNAL);
    eval 'sub GDT_GCF_SCREEN () {2;}' unless defined(&GDT_GCF_SCREEN);
    eval 'sub GDT_GCF_SCSI () {3;}' unless defined(&GDT_GCF_SCSI);
    eval 'sub GDT_GCF_WATCHDOG () {0x4;}' unless defined(&GDT_GCF_WATCHDOG);
    eval 'sub GDT_ISA () {0x1;}' unless defined(&GDT_ISA);
    eval 'sub GDT_EISA () {0x2;}' unless defined(&GDT_EISA);
    eval 'sub GDT_PCI () {0x3;}' unless defined(&GDT_PCI);
    eval 'sub GDT_PCINEW () {0x4;}' unless defined(&GDT_PCINEW);
    eval 'sub GDT_MPR () {0x5;}' unless defined(&GDT_MPR);
    eval 'sub GDT_CLASS_MASK () {0x7;}' unless defined(&GDT_CLASS_MASK);
    eval 'sub GDT_FC () {0x10;}' unless defined(&GDT_FC);
    eval 'sub GDT_CLASS {
        local($gdt) = @_;
	    eval q((($gdt)-> &sc_class &  &GDT_CLASS_MASK));
    }' unless defined(&GDT_CLASS);
    eval 'sub GDT_LOCK_GDT {
        local($gdt) = @_;
	    eval q( &splbio());
    }' unless defined(&GDT_LOCK_GDT);
    eval 'sub GDT_UNLOCK_GDT {
        local($gdt, $lock) = @_;
	    eval q( &splx($lock));
    }' unless defined(&GDT_UNLOCK_GDT);
    if(defined(&__GNUC__)) {
    }
    if(defined( &__alpha__)) {
	undef(&vtophys) if defined(&vtophys);
	eval 'sub vtophys {
	    local($va) = @_;
    	    eval q( &alpha_XXX_dmamap(($va)));
	}' unless defined(&vtophys);
    }
}
1;
