/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.pp4;

import de.tu_darmstadt.sp.pp4.PP4Exception;
import de.tu_darmstadt.sp.pp4.PP4Handler;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.Locale;

public class PP4hdMonoBg
extends PP4Handler {
    private DecimalFormatSymbols usdecforms = new DecimalFormatSymbols(Locale.US);
    private DecimalFormat positionformat = new DecimalFormat("0.0##", this.usdecforms);
    private DecimalFormat colorformat = new DecimalFormat("0.0##", this.usdecforms);

    private String convertVTeXColor(String t) throws PP4Exception {
        long color;
        float[] args = new float[4];
        int len = 1;
        if (t.charAt(1) == '\"') {
            len = 3;
        } else if (t.charAt(1) == ':') {
            len = 4;
        } else {
            throw new PP4Exception("Bad VTeX color specification in " + this.pattern() + " " + t);
        }
        try {
            color = Integer.parseInt(t.substring(2), 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PP4Exception("Invalid hex value in " + this.pattern() + ": " + t);
        }
        int i = len;
        while (i > 0) {
            args[--i] = (float)((double)(color % 256L) / 255.0);
            color /= 256L;
        }
        if (len == 4) {
            return this.colorformat.format(args[0]) + " " + this.colorformat.format(args[1]) + " " + this.colorformat.format(args[2]) + " " + this.colorformat.format(args[3]) + " k " + this.colorformat.format(args[0]) + " " + this.colorformat.format(args[1]) + " " + this.colorformat.format(args[2]) + " " + this.colorformat.format(args[3]) + " K";
        }
        return args[0] + " " + args[1] + " " + args[2] + " rg " + args[0] + " " + args[1] + " " + args[2] + " RG";
    }

    public void doit(String command, String arguments) throws PP4Exception {
        Object resultid;
        if (arguments == null || arguments.equals("")) {
            throw new PP4Exception(String.valueOf(command) + ": missing arguments");
        }
        float[] bounds = this.getPagesRef().getPageBounds();
        if (PP4Handler.resulthash == null) {
            PP4Handler.resulthash = new Hashtable();
        }
        if ((resultid = PP4Handler.resulthash.get(String.valueOf(command) + " " + arguments + " " + bounds)) == null) {
            StringBuffer workarea = new StringBuffer(512);
            workarea.append("q ");
            workarea.append("W ");
            workarea.append(bounds[0]);
            workarea.append(" ");
            workarea.append(bounds[1]);
            workarea.append(" m ");
            workarea.append(bounds[0]);
            workarea.append(" ");
            workarea.append(bounds[3]);
            workarea.append(" l ");
            workarea.append(bounds[2]);
            workarea.append(" ");
            workarea.append(bounds[3]);
            workarea.append(" l ");
            workarea.append(bounds[2]);
            workarea.append(" ");
            workarea.append(bounds[1]);
            workarea.append(" l h n ");
            if (arguments.startsWith("c")) {
                workarea.append(this.convertVTeXColor(arguments));
            } else {
                workarea.append(arguments);
            }
            workarea.append(" 1 i ");
            workarea.append(bounds[0]);
            workarea.append(" ");
            workarea.append(bounds[1]);
            workarea.append(" ");
            workarea.append(bounds[2]);
            workarea.append(" ");
            workarea.append(bounds[3]);
            workarea.append(" re f Q ");
            resultid = this.getPagesRef().makeStream(workarea.toString());
            PP4Handler.resulthash.put(String.valueOf(command) + " " + arguments + " " + bounds, resultid);
        }
        this.getPagesRef().addBgStream(resultid);
    }

    public String pattern() {
        return "%mbackground";
    }
}

