/*

Sound audio library

Copyright (c) 1999 Pascal Hofstee & Alain Kalker
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

$Id: wsound.h,v 1.25 2000/01/19 14:24:19 dalroi Exp $

*/

#ifndef _WSOUND_H_
#define _WSOUND_H_


/* version of the header for the library: 0.01 */
#define WSOUND_HEADER_VERSION	1


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#if !defined(__FreeBSD__) && !defined(__OpenBSD__)
#include <malloc.h>
#endif

#include <sys/stat.h>
#include <sys/types.h>
#include <sys/fcntl.h>

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <proplist.h>
#include <audiofile.h>

#if defined (DRIVER_VOXWARE)
#   define DRIVER	"Voxware"
#elif defined (DRIVER_HPUX)
#   define DRIVER	"HPUX"
#elif defined (DRIVER_SOLARIS)
#   define DRIVER	"Solaris"
#else
#   define DRIVER	"Unknown"
#endif
typedef struct SAudioFileInfo {
	AFfilehandle	FileHandle;
	char	*Path;
	int	FileFormat;
	int	Version;
	int	SampleFormat;
	int	SampleWidth;
	double	SampleRate;
	int	ByteOrder;
	int	Channels;
	long	FrameCount;
	long	TrackBytes;
	long	DataOffset;
	int	Compression;

} SAudioFileInfo;


/* error codes */
#define SERR_NONE		0
#define SERR_OPEN		1	/* can't open file */
#define	SERR_READ		2	/* error reading from file */
#define SERR_WRITE		3	/* error writing to file */
#define	SERR_NOMEMORY		4	/* out of memory */
#define SERR_BADAUDIOFILE	5	/* audio file is corrupted or invalid */
#define	SERR_BADFORMAT		6	/* audio file format is unknown */
#define SERR_DEVOPEN		7	/* error opening audio device */
#define SERR_DEVCLOSE		8	/* error closing audio device */
#define SERR_DEVSUPPORT		9	/* audio device doesn't support format */
#define SERR_DEVSTEREO		10	/* error setting audio device to stereo/mono */
#define SERR_DEVSPEED		11	/* error setting sample rate on audio device */
#define SERR_DEVWRITE		12	/* error while writing data to audio device */
#define SERR_DEVRESET		13	/* error while resetting audio device */
#define SERR_NOSERVER		14	/* sound server is not currently active */
#define SERR_NODISPLAY		15	/* error opening display */
#define SERR_LOADLCONFIG	16	/* error loading local configuration */
#define SERR_LOADGCONFIG	17	/* error loading global configuration */
#define SERR_NOGCONFIG		18	/* could not locate global configuration */
#define SERR_NOKEY		19	/* specified plkey is not in config file */
#define SERR_NOFILE		20	/* could not locate requested file */
#define SERR_AFOPEN		21	/* unable to open file / file format unknown */

#define SERR_BADPLATFORM	127	/* platform is not supported */
#define	SERR_INTERNAL		128	/* should not happen */

/* Endianness */
#define BIGENDIAN		0
#define LITTLEENDIAN		1

/* WSoundServer domain file keywords */
#define S_DEVICE            "Device"
#define S_STARTUP           "Startup"
#define S_SHUTDOWN	    "Shutdown"
#define S_APPSTART          "AppStart"
#define S_APPEXIT           "AppExit"
#define S_MAXIMIZE          "Maximize"
#define S_UNMAXIMIZE        "UnMaximize"
#define S_ICONIFY           "Iconify"
#define S_DEICONIFY         "DeIconify"
#define S_HIDE              "Hide"
#define S_UNHIDE            "UnHide"
#define S_SHADE             "Shade"
#define S_UNSHADE           "UnShade"
#define S_DOCK              "Dock"
#define S_UNDOCK            "UnDock"
#define S_KABOOM            "Kaboom"
#define S_USERDEF           "UserDefined"

/* Sound Event IDs */
#define SEVNT_SHADE		1001
#define SEVNT_UNSHADE		1002
#define SEVNT_MAXIMIZE		1003
#define SEVNT_UNMAXIMIZE	1004
#define SEVNT_ICONIFY		1005
#define SEVNT_DEICONIFY		1006
#define SEVNT_HIDE		1007
#define SEVNT_UNHIDE		1008
#define SEVNT_APPSTART		1009
#define SEVNT_APPEXIT		1010
#define SEVNT_DOCK              1011
#define SEVNT_UNDOCK            1012
#define SEVNT_KABOOM            1013

#define SEVNT_USERDEF		1100
#define SEVNT_STARTUP		1101
#define SEVNT_SHUTDOWN		1102

/* what do you call these ? */
#define GSTEP_DIR               "/GNUstep"
#define WMSOUND_DOMAIN          "WMSound"
#define WMAKER_DOMAIN           "WindowMaker"

int SGetEndianness(void);


/*
 * Audio device interaction
 */
int SPerformAudio(SAudioFileInfo *afInfo);

/*
 * Application initialization/shutdown functions
 */
Bool SApplicationInitialized(void);
void SInitializeApplication(char *applicationName);
void SShutdownApplication(void);

/*
 * Aquire audiofile information
 */
SAudioFileInfo *SGetAudioFileInfo(char *file);
void SPrintAudioFileInfo(SAudioFileInfo *afInfo);
void SDestroyAudioFileInfo(SAudioFileInfo *afInfo);

/*
 * Error functions
 */
void sfatal(const char* msg, ...);
void swarning(const char* msg, ...);

/*
 * Path related functions
 */
char *sexpandpath(char *path);
char *sgethomedir(void);
char *sgetuserhomedir(char *username);
char *susergnusteppath(void);

/*
 * Sound playing
 */
int SPlayEvent(long wsEventID);	/* play soundevent */
int SPlaySound(char *file);	/* play through the sound server */
int SCoreSound(char *file);	/* play using core sound functions */
void SSendSound(void);		/* send UserDefined sound event */
void SSetVolume(float vol);	/* set the volume to play event audio */
float SGetVolume();		/* get the volume to play event audio */

/*
 * misc functions
 */
const char *SMessageForError(int errorCode);	/* do not free the returned string! */
int SFindSoundServer(void);	/* check if sound server is active */
void SLoadConfig(void);		/* load WMSound Domain file */
void SSyncConfig(void);		/* Synchronize WMSound Domain file */
char *SMapEventID(int wsEventID);
char *SGetSoundFileFromKey(char *plKey);
char *SGetSoundFile(char *file);
char *SGetSoundSetFile(char *sndsetfile);


/* Global variables */
extern int		SErrorCode;
extern proplist_t	WMSoundDB;
extern Bool		WMSoundDBLoaded;
extern Display		*dpy;
extern Window		wsoundserver;
extern Atom		_XA_WINDOWMAKER_EVENT;

/* TODO HIDE THESE FUNCTIONS ... DO NOT use Outside of API */
extern proplist_t	SGetObjectForKey (char *defaultName);
extern void		SSetObjectForKey (proplist_t object, char *defaultName);
extern void		SRemoveObjectForKey (char *defaultName);
extern char		*SGetStringForKey (char *defaultName);
extern proplist_t	SGetArrayForKey (char *defaultName);
extern proplist_t	SGetDictionaryForKey (char *defaultName);
extern void		SSetStringForKey (char *value, char *defaultName);


#endif
