/* ``The contents of this file are subject to the Erlang Public License,
 * Version 1.0, (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.erlang.org/EPL1_0.txt
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 * 
 * The Original Code is Erlang-4.7.3, December, 1998.
 * 
 * The Initial Developer of the Original Code is Ericsson Telecom
 * AB. Portions created by Ericsson are Copyright (C), 1998, Ericsson
 * Telecom AB. All Rights Reserved.
 * 
 * Contributor(s): ______________________________________.''
 */
#ifndef _ERL_INTERFACE_H
#define _ERL_INTERFACE_H
/* Copyright (C) 1993,1994 Ellemtel Telecommunications Systems Laboratories
 * Copyright (C) 1995, 1996 Ericsson Telecom
 * 
 * Author: Claes Wikstrom  klacke@erix.ericsson.se
 * 
 * Purpose:  Erlang types in C
 * 
 * Mod: 9 May 1996 by tobbe@erix.ericsson.se 
 *      Major rewrite. New data representation.
 */
#include "erl_eterm.h"
#include "erl_format.h"
#include "erl_marshal.h"
#include "erl_fix_alloc.h"
#include "erl_malloc.h"
#include "erl_rport.h"
#include "erl_connect.h"
#include "erl_start.h"
#include "erl_error.h"
#include "erl_resolve.h"
#include "erl_locking.h"
#include "erl_global.h"
#include "erl_epmd.h"

#ifdef __WIN32__
#define MAXPATHLEN 256
#define writesocket(sock,buf,nbyte) send(sock,buf,nbyte,0)
#define  readsocket(sock,buf,nbyte) recv(sock,buf,nbyte,0)
#else /* not __WIN32__ */
#define writesocket write
#define readsocket  read
#define closesocket close
#define ioctlsocket ioctl
#endif

#endif

