# NOTE: Derived from blib/lib/Class/MethodMaker.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package Class::MethodMaker;

#line 1911 "blib/lib/Class/MethodMaker.pm (autosplit into blib/lib/auto/Class/MethodMaker/list.al)"
# ----------------------------------------------------------------------


sub list {
  my ($class, @args) = @_;
  my %methods;

  foreach (@args) {
    my $field = $_;

    $methods{$field} =
      sub {
        my ($self, @list) = @_;
        defined $self->{$field} or $self->{$field} = [];

        # Maintain any existing reference (avoid replacing)
        @{$self->{$field}} = map { ref $_ eq 'ARRAY' ? @$_ : ($_) } @list
          if @list;

        return wantarray ? @{$self->{$field}} : $self->{$field};
      };

    $class->_add_list_methods(\%methods, $field);

    #
    # Deprecated. v0.95 1.vi.00
    #
    $methods{"${field}_ref"} =
      sub {
        my ($self) = @_;
        $self->{$field};
      };

  }
  $class->install_methods(%methods);
}

# end of Class::MethodMaker::list
1;
