# NOTE: Derived from blib/lib/Class/MethodMaker.pm.
# Changes made here will be lost when autosplit is run again.
# See AutoSplit.pm.
package Class::MethodMaker;

#line 2251 "blib/lib/Class/MethodMaker.pm (autosplit into blib/lib/auto/Class/MethodMaker/hash.al)"
# ----------------------------------------------------------------------


sub hash {
  my ($class, @args) = @_;
  my %methods;

  foreach (@args) {
    my $field = $_;

    $methods{$field} =
      sub {
        my ($self, @list) = @_;
        defined $self->{$field} or $self->{$field} = {};
        if (scalar @list == 1) {
          my ($key) = @list;

          if ( my $type = ref $key ) {
            if ( $type eq 'ARRAY' ) {
              return @{$self->{$field}}{@$key};
            } elsif ( $type eq 'HASH' ) {
              while (my ($subkey, $value) = each %$key ) {
                $self->{$field}->{$subkey} = $value;
              }
              return wantarray ? %{$self->{$field}} : $self->{$field};
            } else {
              cluck "Not a recognized ref type for hash method: $type.";
            }
          } else { # $key is simple scalar
              return $self->{$field}->{$key};
          }
        } else {
          while (1) {
            my $key = shift @list;
            defined $key or last;
            my $value = shift @list;
            defined $value or carp "No value for key $key.";
            $self->{$field}->{$key} = $value;
          }
          return wantarray ? %{$self->{$field}} : $self->{$field};
        }
      };

    $class->_add_hash_methods(\%methods, $field) ;

    $methods{$field . "_clear"} =
      sub {
	my $self = shift;
	$self->{$field} = {};
      };
  }
  $class->install_methods(%methods);
}

# end of Class::MethodMaker::hash
1;
