/*  
  This file is part of KBabel
  Copyright (C) 2002 Stefan Asserhll <stefan.asserhall@telia.com>
		2003 Stanislav Visnovsky <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
*/

#ifndef POINFO_H
#define POINFO_H


#include "catalogfileplugin.h"

#include <kdebug.h>

#include <qstring.h>

/*
 * File cache version number.
 * If the existing file is outdated, it will not get read,
 * instead we'll overwrite it with a new file...
 */
#define POINFOCACHE_VERSION 1

class GettextFlexLexer;

namespace KBabel {

class FindOptions;

/**
 * PO-file information class, with transparent caching of information.
 */
class PoInfo
{
public:
   int total;
   int fuzzy;
   int untranslated;

   QString project;
   QString creation;
   QString revision;
   QString lastTranslator;
   QString languageTeam;
   QString mimeVersion;
   QString contentType;
   QString encoding;
   QString others;

   QString headerComment;

   /**
    * Find PO-file information in the cache.
    *
    * @param url The URL of the PO-file.
    * @param info Returned cached information.
    * @return true if found, false otherwise.
    */
   static bool cacheFind(const QString url, PoInfo& info);

   /**
    * Save PO-file information in the cache.
    *
    * @param url The URL of the PO-file.
    * @param info Information to save.
    */
   static void cacheSave(const QString url, PoInfo& info);

   static ConversionStatus info(const QString url,PoInfo& info, QStringList &wordList, bool updateWordList, bool interactive=true);
   static PoInfo headerInfo(const CatalogItem);
   static bool findInFile(const QString url, FindOptions options );
   
   static bool stopStaticRead;

   /**
   * reads header information from the file and searches for charset
   * information.
   * @param gettextHeader text containing gettext headers
   *
   * @return Codec for found charset or 0, if no information has been found
   */
   static QTextCodec* codecForFile(QString gettextHeader);

   static void cacheWrite();
private:
   /**
    * Read the entire cache.
    */
   static void cacheRead();

   /**
    * Write the entire cache.
    */
   
   static ConversionStatus fastRead( CatalogItem& item, GettextFlexLexer* lexer, bool storeText );
   
   static bool _gettextPluralForm;
};

}

#endif // POINFO_H
