require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_NET_IF_IEEE80211_H_)) {
    eval 'sub _NET_IF_IEEE80211_H_ () {1;}' unless defined(&_NET_IF_IEEE80211_H_);
    eval 'sub IEEE80211_ADDR_LEN () { &ETHER_ADDR_LEN;}' unless defined(&IEEE80211_ADDR_LEN);
    eval 'sub IEEE80211_PLCP_SFD () {0xf3a0;}' unless defined(&IEEE80211_PLCP_SFD);
    eval 'sub IEEE80211_PLCP_SERVICE () {0x;}' unless defined(&IEEE80211_PLCP_SERVICE);
    eval 'sub IEEE80211_FC0_VERSION_MASK () {0x3;}' unless defined(&IEEE80211_FC0_VERSION_MASK);
    eval 'sub IEEE80211_FC0_VERSION_SHIFT () {0;}' unless defined(&IEEE80211_FC0_VERSION_SHIFT);
    eval 'sub IEEE80211_FC0_VERSION_0 () {0x;}' unless defined(&IEEE80211_FC0_VERSION_0);
    eval 'sub IEEE80211_FC0_TYPE_MASK () {0xc;}' unless defined(&IEEE80211_FC0_TYPE_MASK);
    eval 'sub IEEE80211_FC0_TYPE_SHIFT () {2;}' unless defined(&IEEE80211_FC0_TYPE_SHIFT);
    eval 'sub IEEE80211_FC0_TYPE_MGT () {0x;}' unless defined(&IEEE80211_FC0_TYPE_MGT);
    eval 'sub IEEE80211_FC0_TYPE_CTL () {0x4;}' unless defined(&IEEE80211_FC0_TYPE_CTL);
    eval 'sub IEEE80211_FC0_TYPE_DATA () {0x8;}' unless defined(&IEEE80211_FC0_TYPE_DATA);
    eval 'sub IEEE80211_FC0_SUBTYPE_MASK () {0xf0;}' unless defined(&IEEE80211_FC0_SUBTYPE_MASK);
    eval 'sub IEEE80211_FC0_SUBTYPE_SHIFT () {4;}' unless defined(&IEEE80211_FC0_SUBTYPE_SHIFT);
    eval 'sub IEEE80211_FC0_SUBTYPE_ASSOC_REQ () {0x;}' unless defined(&IEEE80211_FC0_SUBTYPE_ASSOC_REQ);
    eval 'sub IEEE80211_FC0_SUBTYPE_ASSOC_RESP () {0x10;}' unless defined(&IEEE80211_FC0_SUBTYPE_ASSOC_RESP);
    eval 'sub IEEE80211_FC0_SUBTYPE_REASSOC_REQ () {0x20;}' unless defined(&IEEE80211_FC0_SUBTYPE_REASSOC_REQ);
    eval 'sub IEEE80211_FC0_SUBTYPE_REASSOC_RESP () {0x30;}' unless defined(&IEEE80211_FC0_SUBTYPE_REASSOC_RESP);
    eval 'sub IEEE80211_FC0_SUBTYPE_PROBE_REQ () {0x40;}' unless defined(&IEEE80211_FC0_SUBTYPE_PROBE_REQ);
    eval 'sub IEEE80211_FC0_SUBTYPE_PROBE_RESP () {0x50;}' unless defined(&IEEE80211_FC0_SUBTYPE_PROBE_RESP);
    eval 'sub IEEE80211_FC0_SUBTYPE_BEACON () {0x80;}' unless defined(&IEEE80211_FC0_SUBTYPE_BEACON);
    eval 'sub IEEE80211_FC0_SUBTYPE_ATIM () {0x90;}' unless defined(&IEEE80211_FC0_SUBTYPE_ATIM);
    eval 'sub IEEE80211_FC0_SUBTYPE_DISASSOC () {0xa0;}' unless defined(&IEEE80211_FC0_SUBTYPE_DISASSOC);
    eval 'sub IEEE80211_FC0_SUBTYPE_AUTH () {0xb0;}' unless defined(&IEEE80211_FC0_SUBTYPE_AUTH);
    eval 'sub IEEE80211_FC0_SUBTYPE_DEAUTH () {0xc0;}' unless defined(&IEEE80211_FC0_SUBTYPE_DEAUTH);
    eval 'sub IEEE80211_FC0_SUBTYPE_PS_POLL () {0xa0;}' unless defined(&IEEE80211_FC0_SUBTYPE_PS_POLL);
    eval 'sub IEEE80211_FC0_SUBTYPE_RTS () {0xb0;}' unless defined(&IEEE80211_FC0_SUBTYPE_RTS);
    eval 'sub IEEE80211_FC0_SUBTYPE_CTS () {0xc0;}' unless defined(&IEEE80211_FC0_SUBTYPE_CTS);
    eval 'sub IEEE80211_FC0_SUBTYPE_ACK () {0xd0;}' unless defined(&IEEE80211_FC0_SUBTYPE_ACK);
    eval 'sub IEEE80211_FC0_SUBTYPE_CF_END () {0xe0;}' unless defined(&IEEE80211_FC0_SUBTYPE_CF_END);
    eval 'sub IEEE80211_FC0_SUBTYPE_CF_END_ACK () {0xf0;}' unless defined(&IEEE80211_FC0_SUBTYPE_CF_END_ACK);
    eval 'sub IEEE80211_FC0_SUBTYPE_DATA () {0x;}' unless defined(&IEEE80211_FC0_SUBTYPE_DATA);
    eval 'sub IEEE80211_FC0_SUBTYPE_CF_ACK () {0x10;}' unless defined(&IEEE80211_FC0_SUBTYPE_CF_ACK);
    eval 'sub IEEE80211_FC0_SUBTYPE_CF_POLL () {0x20;}' unless defined(&IEEE80211_FC0_SUBTYPE_CF_POLL);
    eval 'sub IEEE80211_FC0_SUBTYPE_CF_ACPL () {0x30;}' unless defined(&IEEE80211_FC0_SUBTYPE_CF_ACPL);
    eval 'sub IEEE80211_FC0_SUBTYPE_NODATA () {0x40;}' unless defined(&IEEE80211_FC0_SUBTYPE_NODATA);
    eval 'sub IEEE80211_FC0_SUBTYPE_CFACK () {0x50;}' unless defined(&IEEE80211_FC0_SUBTYPE_CFACK);
    eval 'sub IEEE80211_FC0_SUBTYPE_CFPOLL () {0x60;}' unless defined(&IEEE80211_FC0_SUBTYPE_CFPOLL);
    eval 'sub IEEE80211_FC0_SUBTYPE_CF_ACK_CF_POLL () {0x70;}' unless defined(&IEEE80211_FC0_SUBTYPE_CF_ACK_CF_POLL);
    eval 'sub IEEE80211_FC1_DIR_MASK () {0x3;}' unless defined(&IEEE80211_FC1_DIR_MASK);
    eval 'sub IEEE80211_FC1_DIR_NODS () {0x;}' unless defined(&IEEE80211_FC1_DIR_NODS);
    eval 'sub IEEE80211_FC1_DIR_TODS () {0x1;}' unless defined(&IEEE80211_FC1_DIR_TODS);
    eval 'sub IEEE80211_FC1_DIR_FROMDS () {0x2;}' unless defined(&IEEE80211_FC1_DIR_FROMDS);
    eval 'sub IEEE80211_FC1_DIR_DSTODS () {0x3;}' unless defined(&IEEE80211_FC1_DIR_DSTODS);
    eval 'sub IEEE80211_FC1_MORE_FRAG () {0x4;}' unless defined(&IEEE80211_FC1_MORE_FRAG);
    eval 'sub IEEE80211_FC1_RETRY () {0x8;}' unless defined(&IEEE80211_FC1_RETRY);
    eval 'sub IEEE80211_FC1_PWR_MGT () {0x10;}' unless defined(&IEEE80211_FC1_PWR_MGT);
    eval 'sub IEEE80211_FC1_MORE_DATA () {0x20;}' unless defined(&IEEE80211_FC1_MORE_DATA);
    eval 'sub IEEE80211_FC1_WEP () {0x40;}' unless defined(&IEEE80211_FC1_WEP);
    eval 'sub IEEE80211_FC1_ORDER () {0x80;}' unless defined(&IEEE80211_FC1_ORDER);
    eval 'sub IEEE80211_SEQ_FRAG_MASK () {0xf;}' unless defined(&IEEE80211_SEQ_FRAG_MASK);
    eval 'sub IEEE80211_SEQ_FRAG_SHIFT () {0;}' unless defined(&IEEE80211_SEQ_FRAG_SHIFT);
    eval 'sub IEEE80211_SEQ_SEQ_MASK () {0xfff0;}' unless defined(&IEEE80211_SEQ_SEQ_MASK);
    eval 'sub IEEE80211_SEQ_SEQ_SHIFT () {4;}' unless defined(&IEEE80211_SEQ_SEQ_SHIFT);
    eval 'sub IEEE80211_NWID_LEN () {32;}' unless defined(&IEEE80211_NWID_LEN);
    eval 'sub IEEE80211_BEACON_INTERVAL {
        local($beacon) = @_;
	    eval q((($beacon)[8] | (($beacon)[9] << 8)));
    }' unless defined(&IEEE80211_BEACON_INTERVAL);
    eval 'sub IEEE80211_BEACON_CAPABILITY {
        local($beacon) = @_;
	    eval q((($beacon)[10] | (($beacon)[11] << 8)));
    }' unless defined(&IEEE80211_BEACON_CAPABILITY);
    eval 'sub IEEE80211_CAPINFO_ESS () {0x1;}' unless defined(&IEEE80211_CAPINFO_ESS);
    eval 'sub IEEE80211_CAPINFO_IBSS () {0x2;}' unless defined(&IEEE80211_CAPINFO_IBSS);
    eval 'sub IEEE80211_CAPINFO_CF_POLLABLE () {0x4;}' unless defined(&IEEE80211_CAPINFO_CF_POLLABLE);
    eval 'sub IEEE80211_CAPINFO_CF_POLLREQ () {0x8;}' unless defined(&IEEE80211_CAPINFO_CF_POLLREQ);
    eval 'sub IEEE80211_CAPINFO_PRIVACY () {0x10;}' unless defined(&IEEE80211_CAPINFO_PRIVACY);
    eval 'sub IEEE80211_CAPINFO_SHORT_PREAMBLE () {0x20;}' unless defined(&IEEE80211_CAPINFO_SHORT_PREAMBLE);
    eval 'sub IEEE80211_CAPINFO_PBCC () {0x40;}' unless defined(&IEEE80211_CAPINFO_PBCC);
    eval 'sub IEEE80211_CAPINFO_CHNL_AGILITY () {0x80;}' unless defined(&IEEE80211_CAPINFO_CHNL_AGILITY);
    eval 'sub IEEE80211_CAPINFO_BITS () {"\\20\\01ESS\\02IBSS\\03POLLABLE\\04POLLREQ\\05PRIVACY\\06SHORT_PREAMBLE\\07PBCC\\08CHNL_AGILITY";}' unless defined(&IEEE80211_CAPINFO_BITS);
    eval 'sub IEEE80211_RATE_BASIC () {0x80;}' unless defined(&IEEE80211_RATE_BASIC);
    eval 'sub IEEE80211_RATE_VAL () {0x7f;}' unless defined(&IEEE80211_RATE_VAL);
    eval 'sub IEEE80211_DUR_TU () {1024;}' unless defined(&IEEE80211_DUR_TU);
    eval 'sub IEEE80211_DUR_DS_LONG_PREAMBLE () {144;}' unless defined(&IEEE80211_DUR_DS_LONG_PREAMBLE);
    eval 'sub IEEE80211_DUR_DS_SHORT_PREAMBLE () {72;}' unless defined(&IEEE80211_DUR_DS_SHORT_PREAMBLE);
    eval 'sub IEEE80211_DUR_DS_FAST_PLCPHDR () {24;}' unless defined(&IEEE80211_DUR_DS_FAST_PLCPHDR);
    eval 'sub IEEE80211_DUR_DS_SLOW_PLCPHDR () {48;}' unless defined(&IEEE80211_DUR_DS_SLOW_PLCPHDR);
    eval 'sub IEEE80211_DUR_DS_SLOW_ACK () {112;}' unless defined(&IEEE80211_DUR_DS_SLOW_ACK);
    eval 'sub IEEE80211_DUR_DS_FAST_ACK () {56;}' unless defined(&IEEE80211_DUR_DS_FAST_ACK);
    eval 'sub IEEE80211_DUR_DS_SLOW_CTS () {112;}' unless defined(&IEEE80211_DUR_DS_SLOW_CTS);
    eval 'sub IEEE80211_DUR_DS_FAST_CTS () {56;}' unless defined(&IEEE80211_DUR_DS_FAST_CTS);
    eval 'sub IEEE80211_DUR_DS_SLOT () {20;}' unless defined(&IEEE80211_DUR_DS_SLOT);
    eval 'sub IEEE80211_DUR_DS_SIFS () {10;}' unless defined(&IEEE80211_DUR_DS_SIFS);
    eval 'sub IEEE80211_DUR_DS_PIFS () {( &IEEE80211_DUR_DS_SIFS +  &IEEE80211_DUR_DS_SLOT);}' unless defined(&IEEE80211_DUR_DS_PIFS);
    eval 'sub IEEE80211_DUR_DS_DIFS () {( &IEEE80211_DUR_DS_SIFS + 2*  &IEEE80211_DUR_DS_SLOT);}' unless defined(&IEEE80211_DUR_DS_DIFS);
    eval 'sub IEEE80211_DUR_DS_EIFS () {( &IEEE80211_DUR_DS_SIFS +  &IEEE80211_DUR_DS_SLOW_ACK +  &IEEE80211_DUR_DS_LONG_PREAMBLE +  &IEEE80211_DUR_DS_SLOW_PLCPHDR +  &IEEE80211_DUR_DIFS);}' unless defined(&IEEE80211_DUR_DS_EIFS);
    eval 'sub IEEE80211_ELEMID_SSID () {0;}' unless defined(&IEEE80211_ELEMID_SSID);
    eval 'sub IEEE80211_ELEMID_RATES () {1;}' unless defined(&IEEE80211_ELEMID_RATES);
    eval 'sub IEEE80211_ELEMID_FHPARMS () {2;}' unless defined(&IEEE80211_ELEMID_FHPARMS);
    eval 'sub IEEE80211_ELEMID_DSPARMS () {3;}' unless defined(&IEEE80211_ELEMID_DSPARMS);
    eval 'sub IEEE80211_ELEMID_CFPARMS () {4;}' unless defined(&IEEE80211_ELEMID_CFPARMS);
    eval 'sub IEEE80211_ELEMID_TIM () {5;}' unless defined(&IEEE80211_ELEMID_TIM);
    eval 'sub IEEE80211_ELEMID_IBSSPARMS () {6;}' unless defined(&IEEE80211_ELEMID_IBSSPARMS);
    eval 'sub IEEE80211_ELEMID_CHALLENGE () {16;}' unless defined(&IEEE80211_ELEMID_CHALLENGE);
    eval 'sub IEEE80211_AUTH_ALGORITHM {
        local($auth) = @_;
	    eval q((($auth)[0] | (($auth)[1] << 8)));
    }' unless defined(&IEEE80211_AUTH_ALGORITHM);
    eval 'sub IEEE80211_AUTH_TRANSACTION {
        local($auth) = @_;
	    eval q((($auth)[2] | (($auth)[3] << 8)));
    }' unless defined(&IEEE80211_AUTH_TRANSACTION);
    eval 'sub IEEE80211_AUTH_STATUS {
        local($auth) = @_;
	    eval q((($auth)[4] | (($auth)[5] << 8)));
    }' unless defined(&IEEE80211_AUTH_STATUS);
    eval 'sub IEEE80211_AUTH_ALG_OPEN () {0x;}' unless defined(&IEEE80211_AUTH_ALG_OPEN);
    eval 'sub IEEE80211_AUTH_ALG_SHARED () {0x1;}' unless defined(&IEEE80211_AUTH_ALG_SHARED);
    eval 'sub IEEE80211_AUTH_OPEN_REQUEST () {1;}' unless defined(&IEEE80211_AUTH_OPEN_REQUEST);
    eval 'sub IEEE80211_AUTH_OPEN_RESPONSE () {2;}' unless defined(&IEEE80211_AUTH_OPEN_RESPONSE);
    eval 'sub IEEE80211_AUTH_SHARED_REQUEST () {1;}' unless defined(&IEEE80211_AUTH_SHARED_REQUEST);
    eval 'sub IEEE80211_AUTH_SHARED_CHALLENGE () {2;}' unless defined(&IEEE80211_AUTH_SHARED_CHALLENGE);
    eval 'sub IEEE80211_AUTH_SHARED_RESPONSE () {3;}' unless defined(&IEEE80211_AUTH_SHARED_RESPONSE);
    eval 'sub IEEE80211_AUTH_SHARED_PASS () {4;}' unless defined(&IEEE80211_AUTH_SHARED_PASS);
    eval 'sub IEEE80211_REASON_UNSPECIFIED () {1;}' unless defined(&IEEE80211_REASON_UNSPECIFIED);
    eval 'sub IEEE80211_REASON_AUTH_EXPIRE () {2;}' unless defined(&IEEE80211_REASON_AUTH_EXPIRE);
    eval 'sub IEEE80211_REASON_AUTH_LEAVE () {3;}' unless defined(&IEEE80211_REASON_AUTH_LEAVE);
    eval 'sub IEEE80211_REASON_ASSOC_EXPIRE () {4;}' unless defined(&IEEE80211_REASON_ASSOC_EXPIRE);
    eval 'sub IEEE80211_REASON_ASSOC_TOOMANY () {5;}' unless defined(&IEEE80211_REASON_ASSOC_TOOMANY);
    eval 'sub IEEE80211_REASON_NOT_AUTHED () {6;}' unless defined(&IEEE80211_REASON_NOT_AUTHED);
    eval 'sub IEEE80211_REASON_NOT_ASSOCED () {7;}' unless defined(&IEEE80211_REASON_NOT_ASSOCED);
    eval 'sub IEEE80211_REASON_ASSOC_LEAVE () {8;}' unless defined(&IEEE80211_REASON_ASSOC_LEAVE);
    eval 'sub IEEE80211_REASON_ASSOC_NOT_AUTHED () {9;}' unless defined(&IEEE80211_REASON_ASSOC_NOT_AUTHED);
    eval 'sub IEEE80211_STATUS_SUCCESS () {0;}' unless defined(&IEEE80211_STATUS_SUCCESS);
    eval 'sub IEEE80211_STATUS_UNSPECIFIED () {1;}' unless defined(&IEEE80211_STATUS_UNSPECIFIED);
    eval 'sub IEEE80211_STATUS_CAPINFO () {10;}' unless defined(&IEEE80211_STATUS_CAPINFO);
    eval 'sub IEEE80211_STATUS_NOT_ASSOCED () {11;}' unless defined(&IEEE80211_STATUS_NOT_ASSOCED);
    eval 'sub IEEE80211_STATUS_OTHER () {12;}' unless defined(&IEEE80211_STATUS_OTHER);
    eval 'sub IEEE80211_STATUS_ALG () {13;}' unless defined(&IEEE80211_STATUS_ALG);
    eval 'sub IEEE80211_STATUS_SEQUENCE () {14;}' unless defined(&IEEE80211_STATUS_SEQUENCE);
    eval 'sub IEEE80211_STATUS_CHALLENGE () {15;}' unless defined(&IEEE80211_STATUS_CHALLENGE);
    eval 'sub IEEE80211_STATUS_TIMEOUT () {16;}' unless defined(&IEEE80211_STATUS_TIMEOUT);
    eval 'sub IEEE80211_STATUS_TOOMANY () {17;}' unless defined(&IEEE80211_STATUS_TOOMANY);
    eval 'sub IEEE80211_STATUS_BASIC_RATE () {18;}' unless defined(&IEEE80211_STATUS_BASIC_RATE);
    eval 'sub IEEE80211_STATUS_SP_REQUIRED () {19;}' unless defined(&IEEE80211_STATUS_SP_REQUIRED);
    eval 'sub IEEE80211_STATUS_PBCC_REQUIRED () {20;}' unless defined(&IEEE80211_STATUS_PBCC_REQUIRED);
    eval 'sub IEEE80211_STATUS_CA_REQUIRED () {21;}' unless defined(&IEEE80211_STATUS_CA_REQUIRED);
    eval 'sub IEEE80211_STATUS_TOO_MANY_STATIONS () {22;}' unless defined(&IEEE80211_STATUS_TOO_MANY_STATIONS);
    eval 'sub IEEE80211_STATUS_RATES () {23;}' unless defined(&IEEE80211_STATUS_RATES);
    eval 'sub IEEE80211_WEP_KEYLEN () {5;}' unless defined(&IEEE80211_WEP_KEYLEN);
    eval 'sub IEEE80211_WEP_IVLEN () {3;}' unless defined(&IEEE80211_WEP_IVLEN);
    eval 'sub IEEE80211_WEP_KIDLEN () {1;}' unless defined(&IEEE80211_WEP_KIDLEN);
    eval 'sub IEEE80211_WEP_CRCLEN () {4;}' unless defined(&IEEE80211_WEP_CRCLEN);
    eval 'sub IEEE80211_WEP_NKID () {4;}' unless defined(&IEEE80211_WEP_NKID);
    eval 'sub IEEE80211_CRC_LEN () {4;}' unless defined(&IEEE80211_CRC_LEN);
    eval 'sub IEEE80211_MTU () {1500;}' unless defined(&IEEE80211_MTU);
    eval 'sub IEEE80211_MAX_LEN () {(2300+  &IEEE80211_CRC_LEN + ( &IEEE80211_WEP_IVLEN +  &IEEE80211_WEP_KIDLEN +  &IEEE80211_WEP_CRCLEN));}' unless defined(&IEEE80211_MAX_LEN);
    eval 'sub IEEE80211_MAX_AID () {2007;}' unless defined(&IEEE80211_MAX_AID);
    eval 'sub IEEE80211_AID_SET {
        local($b, $w) = @_;
	    eval q((($w)[(($b) & ~0xc000) / 32] |= (1<< ((($b) & ~0xc000) % 32))));
    }' unless defined(&IEEE80211_AID_SET);
    eval 'sub IEEE80211_AID_CLR {
        local($b, $w) = @_;
	    eval q((($w)[(($b) & ~0xc000) / 32] &= ~(1<< ((($b) & ~0xc000) % 32))));
    }' unless defined(&IEEE80211_AID_CLR);
    eval 'sub IEEE80211_AID_ISSET {
        local($b, $w) = @_;
	    eval q((($w)[(($b) & ~0xc000) / 32] & (1<< ((($b) & ~0xc000) % 32))));
    }' unless defined(&IEEE80211_AID_ISSET);
    eval 'sub SIOCS80211NWID () { &_IOWR(ord(\'i\'), 230, \'struct ifreq\');}' unless defined(&SIOCS80211NWID);
    eval 'sub SIOCG80211NWID () { &_IOWR(ord(\'i\'), 231, \'struct ifreq\');}' unless defined(&SIOCG80211NWID);
    eval 'sub SIOCS80211NWKEY () { &_IOW(ord(\'i\'), 232, \'struct ieee80211_nwkey\');}' unless defined(&SIOCS80211NWKEY);
    eval 'sub SIOCG80211NWKEY () { &_IOWR(ord(\'i\'), 233, \'struct ieee80211_nwkey\');}' unless defined(&SIOCG80211NWKEY);
    eval 'sub IEEE80211_NWKEY_OPEN () {0;}' unless defined(&IEEE80211_NWKEY_OPEN);
    eval 'sub IEEE80211_NWKEY_WEP () {1;}' unless defined(&IEEE80211_NWKEY_WEP);
    eval 'sub IEEE80211_NWKEY_EAP () {2;}' unless defined(&IEEE80211_NWKEY_EAP);
    eval 'sub IEEE80211_NWKEY_PERSIST () {0x100;}' unless defined(&IEEE80211_NWKEY_PERSIST);
    eval 'sub SIOCS80211POWER () { &_IOW(ord(\'i\'), 234, \'struct ieee80211_power\');}' unless defined(&SIOCS80211POWER);
    eval 'sub SIOCG80211POWER () { &_IOWR(ord(\'i\'), 235, \'struct ieee80211_power\');}' unless defined(&SIOCG80211POWER);
    eval 'sub IEEE80211_AUTH_NONE () {0;}' unless defined(&IEEE80211_AUTH_NONE);
    eval 'sub IEEE80211_AUTH_OPEN () {1;}' unless defined(&IEEE80211_AUTH_OPEN);
    eval 'sub IEEE80211_AUTH_SHARED () {2;}' unless defined(&IEEE80211_AUTH_SHARED);
    eval 'sub SIOCS80211AUTH () { &_IOW(ord(\'i\'), 236, \'struct ieee80211_auth\');}' unless defined(&SIOCS80211AUTH);
    eval 'sub SIOCG80211AUTH () { &_IOWR(ord(\'i\'), 237, \'struct ieee80211_auth\');}' unless defined(&SIOCG80211AUTH);
    eval 'sub IEEE80211_CHAN_ANY () {0xffff;}' unless defined(&IEEE80211_CHAN_ANY);
    eval 'sub SIOCS80211CHANNEL () { &_IOW(ord(\'i\'), 238, \'struct ieee80211_channel\');}' unless defined(&SIOCS80211CHANNEL);
    eval 'sub SIOCG80211CHANNEL () { &_IOWR(ord(\'i\'), 239, \'struct ieee80211_channel\');}' unless defined(&SIOCG80211CHANNEL);
    eval 'sub SIOCS80211BSSID () { &_IOW(ord(\'i\'), 240, \'struct ieee80211_bssid\');}' unless defined(&SIOCS80211BSSID);
    eval 'sub SIOCG80211BSSID () { &_IOWR(ord(\'i\'), 241, \'struct ieee80211_bssid\');}' unless defined(&SIOCG80211BSSID);
    if(defined(&_KERNEL)) {
	eval 'sub IEEE80211_ASCAN_WAIT () {2;}' unless defined(&IEEE80211_ASCAN_WAIT);
	eval 'sub IEEE80211_PSCAN_WAIT () {5;}' unless defined(&IEEE80211_PSCAN_WAIT);
	eval 'sub IEEE80211_TRANS_WAIT () {5;}' unless defined(&IEEE80211_TRANS_WAIT);
	eval 'sub IEEE80211_INACT_WAIT () {5;}' unless defined(&IEEE80211_INACT_WAIT);
	eval 'sub IEEE80211_INACT_MAX () {(300/ &IEEE80211_INACT_WAIT);}' unless defined(&IEEE80211_INACT_MAX);
	eval 'sub IEEE80211_CHAN_MAX () {255;}' unless defined(&IEEE80211_CHAN_MAX);
	eval 'sub IEEE80211_RATE_SIZE () {12;}' unless defined(&IEEE80211_RATE_SIZE);
	eval 'sub IEEE80211_KEYBUF_SIZE () {16;}' unless defined(&IEEE80211_KEYBUF_SIZE);
	eval 'sub IEEE80211_NODE_HASHSIZE () {32;}' unless defined(&IEEE80211_NODE_HASHSIZE);
	eval 'sub IEEE80211_NODE_HASH {
	    local($addr) = @_;
    	    eval q(((($addr))[ &IEEE80211_ADDR_LEN - 1] %  &IEEE80211_NODE_HASHSIZE));
	}' unless defined(&IEEE80211_NODE_HASH);
	eval("sub IEEE80211_T_DS () { 0; }") unless defined(&IEEE80211_T_DS);
	eval("sub IEEE80211_T_FH () { 1; }") unless defined(&IEEE80211_T_FH);
	eval("sub IEEE80211_T_OFDM () { 2; }") unless defined(&IEEE80211_T_OFDM);
	eval("sub IEEE80211_M_STA () { 1; }") unless defined(&IEEE80211_M_STA);
	eval("sub IEEE80211_M_IBSS () { 0; }") unless defined(&IEEE80211_M_IBSS);
	eval("sub IEEE80211_M_AHDEMO () { 3; }") unless defined(&IEEE80211_M_AHDEMO);
	eval("sub IEEE80211_M_HOSTAP () { 6; }") unless defined(&IEEE80211_M_HOSTAP);
	eval("sub IEEE80211_M_MONITOR () { 8; }") unless defined(&IEEE80211_M_MONITOR);
	eval("sub IEEE80211_S_INIT () { 0; }") unless defined(&IEEE80211_S_INIT);
	eval("sub IEEE80211_S_SCAN () { 1; }") unless defined(&IEEE80211_S_SCAN);
	eval("sub IEEE80211_S_AUTH () { 2; }") unless defined(&IEEE80211_S_AUTH);
	eval("sub IEEE80211_S_ASSOC () { 3; }") unless defined(&IEEE80211_S_ASSOC);
	eval("sub IEEE80211_S_RUN () { 4; }") unless defined(&IEEE80211_S_RUN);
	eval 'sub IEEE80211_FH_CHANMOD () {80;}' unless defined(&IEEE80211_FH_CHANMOD);
	eval 'sub IEEE80211_FH_CHAN {
	    local($set,$pat) = @_;
    	    eval q(((($set)-1)* &IEEE80211_FH_CHANMOD+($pat)));
	}' unless defined(&IEEE80211_FH_CHAN);
	eval 'sub IEEE80211_FH_CHANSET {
	    local($chan) = @_;
    	    eval q((($chan)/ &IEEE80211_FH_CHANMOD+1));
	}' unless defined(&IEEE80211_FH_CHANSET);
	eval 'sub IEEE80211_FH_CHANPAT {
	    local($chan) = @_;
    	    eval q((($chan)% &IEEE80211_FH_CHANMOD));
	}' unless defined(&IEEE80211_FH_CHANPAT);
	eval 'sub IEEE80211_PS_SLEEP () {0x1;}' unless defined(&IEEE80211_PS_SLEEP);
	eval 'sub IEEE80211_PS_MAX_QUEUE () {50;}' unless defined(&IEEE80211_PS_MAX_QUEUE);
	if(defined(&__NetBSD__)) {
	}
	if(defined(&__FreeBSD__)) {
	}
	if(defined(&__OpenBSD__)) {
	}
	if(defined(&__NetBSD__)) {
	    eval 'sub ic_if () { ($ic_ec->{ec_if});}' unless defined(&ic_if);
	}
	if(defined( &__FreeBSD__) || defined( &__OpenBSD__)) {
	    eval 'sub ic_if () { ($ic_ac->{ac_if});}' unless defined(&ic_if);
	}
	eval 'sub ic_softc () { ($ic_if->{if_softc});}' unless defined(&ic_softc);
	eval 'sub IEEE80211_HEADER_LEN {
	    local($ic) = @_;
    	    eval q(((($ic)-> &ic_hdrlen > 0) ? ($ic)-> &ic_hdrlen : $sizeof{\'struct ieee80211_frame\'}));
	}' unless defined(&IEEE80211_HEADER_LEN);
	eval 'sub IEEE80211_SEND_MGMT {
	    local($ic,$ni,$type,$arg) = @_;
    	    eval q( &do {  &if (($ic)-> $ic_send_mgmt[($type)>> &IEEE80211_FC0_SUBTYPE_SHIFT] !=  &NULL) (*($ic)-> $ic_send_mgmt[($type)>> &IEEE80211_FC0_SUBTYPE_SHIFT]) ($ic,$ni,$type,$arg); }  &while ( 0));
	}' unless defined(&IEEE80211_SEND_MGMT);
	eval 'sub IEEE80211_ADDR_EQ {
	    local($a1,$a2) = @_;
    	    eval q(( &memcmp($a1,$a2, &IEEE80211_ADDR_LEN) == 0));
	}' unless defined(&IEEE80211_ADDR_EQ);
	eval 'sub IEEE80211_ADDR_COPY {
	    local($dst,$src) = @_;
    	    eval q( &memcpy($dst,$src, &IEEE80211_ADDR_LEN));
	}' unless defined(&IEEE80211_ADDR_COPY);
	eval 'sub IEEE80211_IS_MULTICAST {
	    local($a) = @_;
    	    eval q( &ETHER_IS_MULTICAST($a));
	}' unless defined(&IEEE80211_IS_MULTICAST);
	eval 'sub IEEE80211_F_ASCAN () {0x1;}' unless defined(&IEEE80211_F_ASCAN);
	eval 'sub IEEE80211_F_SIBSS () {0x2;}' unless defined(&IEEE80211_F_SIBSS);
	eval 'sub IEEE80211_F_WEPON () {0x100;}' unless defined(&IEEE80211_F_WEPON);
	eval 'sub IEEE80211_F_IBSSON () {0x200;}' unless defined(&IEEE80211_F_IBSSON);
	eval 'sub IEEE80211_F_PMGTON () {0x400;}' unless defined(&IEEE80211_F_PMGTON);
	eval 'sub IEEE80211_F_DESBSSID () {0x800;}' unless defined(&IEEE80211_F_DESBSSID);
	eval 'sub IEEE80211_F_SCANAP () {0x1000;}' unless defined(&IEEE80211_F_SCANAP);
	eval 'sub IEEE80211_F_HASWEP () {0x10000;}' unless defined(&IEEE80211_F_HASWEP);
	eval 'sub IEEE80211_F_HASIBSS () {0x20000;}' unless defined(&IEEE80211_F_HASIBSS);
	eval 'sub IEEE80211_F_HASPMGT () {0x40000;}' unless defined(&IEEE80211_F_HASPMGT);
	eval 'sub IEEE80211_F_HASHOSTAP () {0x80000;}' unless defined(&IEEE80211_F_HASHOSTAP);
	eval 'sub IEEE80211_F_HASAHDEMO () {0x100000;}' unless defined(&IEEE80211_F_HASAHDEMO);
	eval 'sub IEEE80211_F_HASMONITOR () {0x200000;}' unless defined(&IEEE80211_F_HASMONITOR);
	eval 'sub IEEE80211_F_DOSORT () {0x1;}' unless defined(&IEEE80211_F_DOSORT);
	eval 'sub IEEE80211_F_DOFRATE () {0x2;}' unless defined(&IEEE80211_F_DOFRATE);
	eval 'sub IEEE80211_F_DONEGO () {0x4;}' unless defined(&IEEE80211_F_DONEGO);
	eval 'sub IEEE80211_F_DODEL () {0x8;}' unless defined(&IEEE80211_F_DODEL);
    }
}
1;
