require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&ST_VENDORID)) {
    sub ST_VENDORID () {	0x13f0;}
}
unless(defined(&ST_DEVICEID_ST201)) {
    sub ST_DEVICEID_ST201 () {	0x201;}
}
unless(defined(&DL_VENDORID)) {
    sub DL_VENDORID () {	0x1186;}
}
unless(defined(&DL_DEVICEID_550TX)) {
    sub DL_DEVICEID_550TX () {	0x1002;}
}
unless(defined(&STE_DMACTL)) {
    sub STE_DMACTL () {	0x;}
}
unless(defined(&STE_TX_DMALIST_PTR)) {
    sub STE_TX_DMALIST_PTR () {	0x4;}
}
unless(defined(&STE_TX_DMABURST_THRESH)) {
    sub STE_TX_DMABURST_THRESH () {	0x8;}
}
unless(defined(&STE_TX_DMAURG_THRESH)) {
    sub STE_TX_DMAURG_THRESH () {	0x9;}
}
unless(defined(&STE_TX_DMAPOLL_PERIOD)) {
    sub STE_TX_DMAPOLL_PERIOD () {	0xa;}
}
unless(defined(&STE_RX_DMASTATUS)) {
    sub STE_RX_DMASTATUS () {	0xc;}
}
unless(defined(&STE_RX_DMALIST_PTR)) {
    sub STE_RX_DMALIST_PTR () {	0x10;}
}
unless(defined(&STE_RX_DMABURST_THRESH)) {
    sub STE_RX_DMABURST_THRESH () {	0x14;}
}
unless(defined(&STE_RX_DMAURG_THRESH)) {
    sub STE_RX_DMAURG_THRESH () {	0x15;}
}
unless(defined(&STE_RX_DMAPOLL_PERIOD)) {
    sub STE_RX_DMAPOLL_PERIOD () {	0x16;}
}
unless(defined(&STE_DEBUGCTL)) {
    sub STE_DEBUGCTL () {	0x1a;}
}
unless(defined(&STE_ASICCTL)) {
    sub STE_ASICCTL () {	0x30;}
}
unless(defined(&STE_EEPROM_DATA)) {
    sub STE_EEPROM_DATA () {	0x34;}
}
unless(defined(&STE_EEPROM_CTL)) {
    sub STE_EEPROM_CTL () {	0x36;}
}
unless(defined(&STE_FIFOCTL)) {
    sub STE_FIFOCTL () {	0x3a;}
}
unless(defined(&STE_TX_STARTTHRESH)) {
    sub STE_TX_STARTTHRESH () {	0x3c;}
}
unless(defined(&STE_RX_EARLYTHRESH)) {
    sub STE_RX_EARLYTHRESH () {	0x3e;}
}
unless(defined(&STE_EXT_ROMADDR)) {
    sub STE_EXT_ROMADDR () {	0x40;}
}
unless(defined(&STE_EXT_ROMDATA)) {
    sub STE_EXT_ROMDATA () {	0x44;}
}
unless(defined(&STE_WAKE_EVENT)) {
    sub STE_WAKE_EVENT () {	0x45;}
}
unless(defined(&STE_TX_STATUS)) {
    sub STE_TX_STATUS () {	0x46;}
}
unless(defined(&STE_TX_FRAMEID)) {
    sub STE_TX_FRAMEID () {	0x47;}
}
unless(defined(&STE_COUNTDOWN)) {
    sub STE_COUNTDOWN () {	0x48;}
}
unless(defined(&STE_ISR_ACK)) {
    sub STE_ISR_ACK () {	0x4a;}
}
unless(defined(&STE_IMR)) {
    sub STE_IMR () {	0x4c;}
}
unless(defined(&STE_ISR)) {
    sub STE_ISR () {	0x4e;}
}
unless(defined(&STE_MACCTL0)) {
    sub STE_MACCTL0 () {	0x50;}
}
unless(defined(&STE_MACCTL1)) {
    sub STE_MACCTL1 () {	0x52;}
}
unless(defined(&STE_PAR0)) {
    sub STE_PAR0 () {	0x54;}
}
unless(defined(&STE_PAR1)) {
    sub STE_PAR1 () {	0x56;}
}
unless(defined(&STE_PAR2)) {
    sub STE_PAR2 () {	0x58;}
}
unless(defined(&STE_MAX_FRAMELEN)) {
    sub STE_MAX_FRAMELEN () {	0x5a;}
}
unless(defined(&STE_RX_MODE)) {
    sub STE_RX_MODE () {	0x5c;}
}
unless(defined(&STE_TX_RECLAIM_THRESH)) {
    sub STE_TX_RECLAIM_THRESH () {	0x5d;}
}
unless(defined(&STE_PHYCTL)) {
    sub STE_PHYCTL () {	0x5e;}
}
unless(defined(&STE_MAR0)) {
    sub STE_MAR0 () {	0x60;}
}
unless(defined(&STE_MAR1)) {
    sub STE_MAR1 () {	0x64;}
}
unless(defined(&STE_STATS)) {
    sub STE_STATS () {	0x68;}
}
unless(defined(&STE_DMACTL_RXDMA_STOPPED)) {
    sub STE_DMACTL_RXDMA_STOPPED () {	0x1;}
}
unless(defined(&STE_DMACTL_TXDMA_CMPREQ)) {
    sub STE_DMACTL_TXDMA_CMPREQ () {	0x2;}
}
unless(defined(&STE_DMACTL_TXDMA_STOPPED)) {
    sub STE_DMACTL_TXDMA_STOPPED () {	0x4;}
}
unless(defined(&STE_DMACTL_RXDMA_COMPLETE)) {
    sub STE_DMACTL_RXDMA_COMPLETE () {	0x8;}
}
unless(defined(&STE_DMACTL_TXDMA_COMPLETE)) {
    sub STE_DMACTL_TXDMA_COMPLETE () {	0x10;}
}
unless(defined(&STE_DMACTL_RXDMA_STALL)) {
    sub STE_DMACTL_RXDMA_STALL () {	0x100;}
}
unless(defined(&STE_DMACTL_RXDMA_UNSTALL)) {
    sub STE_DMACTL_RXDMA_UNSTALL () {	0x200;}
}
unless(defined(&STE_DMACTL_TXDMA_STALL)) {
    sub STE_DMACTL_TXDMA_STALL () {	0x400;}
}
unless(defined(&STE_DMACTL_TXDMA_UNSTALL)) {
    sub STE_DMACTL_TXDMA_UNSTALL () {	0x800;}
}
unless(defined(&STE_DMACTL_TXDMA_INPROG)) {
    sub STE_DMACTL_TXDMA_INPROG () {	0x4000;}
}
unless(defined(&STE_DMACTL_DMA_HALTINPROG)) {
    sub STE_DMACTL_DMA_HALTINPROG () {	0x8000;}
}
unless(defined(&STE_DMACTL_RXEARLY_ENABLE)) {
    sub STE_DMACTL_RXEARLY_ENABLE () {	0x20000;}
}
unless(defined(&STE_DMACTL_COUNTDOWN_SPEED)) {
    sub STE_DMACTL_COUNTDOWN_SPEED () {	0x40000;}
}
unless(defined(&STE_DMACTL_COUNTDOWN_MODE)) {
    sub STE_DMACTL_COUNTDOWN_MODE () {	0x80000;}
}
unless(defined(&STE_DMACTL_MWI_DISABLE)) {
    sub STE_DMACTL_MWI_DISABLE () {	0x100000;}
}
unless(defined(&STE_DMACTL_RX_DISCARD_OFLOWS)) {
    sub STE_DMACTL_RX_DISCARD_OFLOWS () {	0x400000;}
}
unless(defined(&STE_DMACTL_COUNTDOWN_ENABLE)) {
    sub STE_DMACTL_COUNTDOWN_ENABLE () {	0x800000;}
}
unless(defined(&STE_DMACTL_TARGET_ABORT)) {
    sub STE_DMACTL_TARGET_ABORT () {	0x40000000;}
}
unless(defined(&STE_DMACTL_MASTER_ABORT)) {
    sub STE_DMACTL_MASTER_ABORT () {	0x80000000;}
}
unless(defined(&STE_TXDMABURST_THRESH)) {
    sub STE_TXDMABURST_THRESH () {	0x1f;}
}
unless(defined(&STE_TXDMAURG_THRESH)) {
    sub STE_TXDMAURG_THRESH () {	0x3f;}
}
unless(defined(&STE_TXDMA_POLL_PERIOD)) {
    sub STE_TXDMA_POLL_PERIOD () {	0x7f;}
}
unless(defined(&STE_RX_DMASTATUS_FRAMELEN)) {
    sub STE_RX_DMASTATUS_FRAMELEN () {	0x1fff;}
}
unless(defined(&STE_RX_DMASTATUS_RXERR)) {
    sub STE_RX_DMASTATUS_RXERR () {	0x4000;}
}
unless(defined(&STE_RX_DMASTATUS_DMADONE)) {
    sub STE_RX_DMASTATUS_DMADONE () {	0x8000;}
}
unless(defined(&STE_RX_DMASTATUS_FIFO_OFLOW)) {
    sub STE_RX_DMASTATUS_FIFO_OFLOW () {	0x10000;}
}
unless(defined(&STE_RX_DMASTATUS_RUNT)) {
    sub STE_RX_DMASTATUS_RUNT () {	0x20000;}
}
unless(defined(&STE_RX_DMASTATUS_ALIGNERR)) {
    sub STE_RX_DMASTATUS_ALIGNERR () {	0x40000;}
}
unless(defined(&STE_RX_DMASTATUS_CRCERR)) {
    sub STE_RX_DMASTATUS_CRCERR () {	0x80000;}
}
unless(defined(&STE_RX_DMASTATUS_GIANT)) {
    sub STE_RX_DMASTATUS_GIANT () {	0x100000;}
}
unless(defined(&STE_RX_DMASTATUS_DRIBBLE)) {
    sub STE_RX_DMASTATUS_DRIBBLE () {	0x800000;}
}
unless(defined(&STE_RX_DMASTATUS_DMA_OFLOW)) {
    sub STE_RX_DMASTATUS_DMA_OFLOW () {	0x1000000;}
}
unless(defined(&STE_RXDMABURST_THRESH)) {
    sub STE_RXDMABURST_THRESH () {	0xff;}
}
unless(defined(&STE_RXDMAURG_THRESH)) {
    sub STE_RXDMAURG_THRESH () {	0x1f;}
}
unless(defined(&STE_RXDMA_POLL_PERIOD)) {
    sub STE_RXDMA_POLL_PERIOD () {	0x7f;}
}
unless(defined(&STE_DEBUGCTL_GPIO0_CTL)) {
    sub STE_DEBUGCTL_GPIO0_CTL () {	0x1;}
}
unless(defined(&STE_DEBUGCTL_GPIO1_CTL)) {
    sub STE_DEBUGCTL_GPIO1_CTL () {	0x2;}
}
unless(defined(&STE_DEBUGCTL_GPIO0_DATA)) {
    sub STE_DEBUGCTL_GPIO0_DATA () {	0x4;}
}
unless(defined(&STE_DEBUGCTL_GPIO1_DATA)) {
    sub STE_DEBUGCTL_GPIO1_DATA () {	0x8;}
}
unless(defined(&STE_ASICCTL_ROMSIZE)) {
    sub STE_ASICCTL_ROMSIZE () {	0x2;}
}
unless(defined(&STE_ASICCTL_TX_LARGEPKTS)) {
    sub STE_ASICCTL_TX_LARGEPKTS () {	0x4;}
}
unless(defined(&STE_ASICCTL_RX_LARGEPKTS)) {
    sub STE_ASICCTL_RX_LARGEPKTS () {	0x8;}
}
unless(defined(&STE_ASICCTL_EXTROM_DISABLE)) {
    sub STE_ASICCTL_EXTROM_DISABLE () {	0x10;}
}
unless(defined(&STE_ASICCTL_PHYSPEED_10)) {
    sub STE_ASICCTL_PHYSPEED_10 () {	0x20;}
}
unless(defined(&STE_ASICCTL_PHYSPEED_100)) {
    sub STE_ASICCTL_PHYSPEED_100 () {	0x40;}
}
unless(defined(&STE_ASICCTL_PHYMEDIA)) {
    sub STE_ASICCTL_PHYMEDIA () {	0x80;}
}
unless(defined(&STE_ASICCTL_FORCEDCONFIG)) {
    sub STE_ASICCTL_FORCEDCONFIG () {	0x700;}
}
unless(defined(&STE_ASICCTL_D3RESET_DISABLE)) {
    sub STE_ASICCTL_D3RESET_DISABLE () {	0x800;}
}
unless(defined(&STE_ASICCTL_SPEEDUPMODE)) {
    sub STE_ASICCTL_SPEEDUPMODE () {	0x2000;}
}
unless(defined(&STE_ASICCTL_LEDMODE)) {
    sub STE_ASICCTL_LEDMODE () {	0x4000;}
}
unless(defined(&STE_ASICCTL_RSTOUT_POLARITY)) {
    sub STE_ASICCTL_RSTOUT_POLARITY () {	0x8000;}
}
unless(defined(&STE_ASICCTL_GLOBAL_RESET)) {
    sub STE_ASICCTL_GLOBAL_RESET () {	0x10000;}
}
unless(defined(&STE_ASICCTL_RX_RESET)) {
    sub STE_ASICCTL_RX_RESET () {	0x20000;}
}
unless(defined(&STE_ASICCTL_TX_RESET)) {
    sub STE_ASICCTL_TX_RESET () {	0x40000;}
}
unless(defined(&STE_ASICCTL_DMA_RESET)) {
    sub STE_ASICCTL_DMA_RESET () {	0x80000;}
}
unless(defined(&STE_ASICCTL_FIFO_RESET)) {
    sub STE_ASICCTL_FIFO_RESET () {	0x100000;}
}
unless(defined(&STE_ASICCTL_NETWORK_RESET)) {
    sub STE_ASICCTL_NETWORK_RESET () {	0x200000;}
}
unless(defined(&STE_ASICCTL_HOST_RESET)) {
    sub STE_ASICCTL_HOST_RESET () {	0x400000;}
}
unless(defined(&STE_ASICCTL_AUTOINIT_RESET)) {
    sub STE_ASICCTL_AUTOINIT_RESET () {	0x800000;}
}
unless(defined(&STE_ASICCTL_EXTRESET_RESET)) {
    sub STE_ASICCTL_EXTRESET_RESET () {	0x1000000;}
}
unless(defined(&STE_ASICCTL_SOFTINTR)) {
    sub STE_ASICCTL_SOFTINTR () {	0x2000000;}
}
unless(defined(&STE_ASICCTL_RESET_BUSY)) {
    sub STE_ASICCTL_RESET_BUSY () {	0x4000000;}
}
unless(defined(&STE_ASICCTL1_GLOBAL_RESET)) {
    sub STE_ASICCTL1_GLOBAL_RESET () {	0x1;}
}
unless(defined(&STE_ASICCTL1_RX_RESET)) {
    sub STE_ASICCTL1_RX_RESET () {	0x2;}
}
unless(defined(&STE_ASICCTL1_TX_RESET)) {
    sub STE_ASICCTL1_TX_RESET () {	0x4;}
}
unless(defined(&STE_ASICCTL1_DMA_RESET)) {
    sub STE_ASICCTL1_DMA_RESET () {	0x8;}
}
unless(defined(&STE_ASICCTL1_FIFO_RESET)) {
    sub STE_ASICCTL1_FIFO_RESET () {	0x10;}
}
unless(defined(&STE_ASICCTL1_NETWORK_RESET)) {
    sub STE_ASICCTL1_NETWORK_RESET () {	0x20;}
}
unless(defined(&STE_ASICCTL1_HOST_RESET)) {
    sub STE_ASICCTL1_HOST_RESET () {	0x40;}
}
unless(defined(&STE_ASICCTL1_AUTOINIT_RESET)) {
    sub STE_ASICCTL1_AUTOINIT_RESET () {	0x80;}
}
unless(defined(&STE_ASICCTL1_EXTRESET_RESET)) {
    sub STE_ASICCTL1_EXTRESET_RESET () {	0x100;}
}
unless(defined(&STE_ASICCTL1_SOFTINTR)) {
    sub STE_ASICCTL1_SOFTINTR () {	0x200;}
}
unless(defined(&STE_ASICCTL1_RESET_BUSY)) {
    sub STE_ASICCTL1_RESET_BUSY () {	0x400;}
}
unless(defined(&STE_EECTL_ADDR)) {
    sub STE_EECTL_ADDR () {	0xff;}
}
unless(defined(&STE_EECTL_OPCODE)) {
    sub STE_EECTL_OPCODE () {	0x300;}
}
unless(defined(&STE_EECTL_BUSY)) {
    sub STE_EECTL_BUSY () {	0x1000;}
}
unless(defined(&STE_EEOPCODE_WRITE)) {
    sub STE_EEOPCODE_WRITE () {	0x100;}
}
unless(defined(&STE_EEOPCODE_READ)) {
    sub STE_EEOPCODE_READ () {	0x200;}
}
unless(defined(&STE_EEOPCODE_ERASE)) {
    sub STE_EEOPCODE_ERASE () {	0x300;}
}
unless(defined(&STE_FIFOCTL_RAMTESTMODE)) {
    sub STE_FIFOCTL_RAMTESTMODE () {	0x1;}
}
unless(defined(&STE_FIFOCTL_OVERRUNMODE)) {
    sub STE_FIFOCTL_OVERRUNMODE () {	0x200;}
}
unless(defined(&STE_FIFOCTL_RXFIFOFULL)) {
    sub STE_FIFOCTL_RXFIFOFULL () {	0x800;}
}
unless(defined(&STE_FIFOCTL_TX_BUSY)) {
    sub STE_FIFOCTL_TX_BUSY () {	0x4000;}
}
unless(defined(&STE_FIFOCTL_RX_BUSY)) {
    sub STE_FIFOCTL_RX_BUSY () {	0x8000;}
}
unless(defined(&STE_TXSTART_THRESH)) {
    sub STE_TXSTART_THRESH () {	0x1fff;}
}
unless(defined(&STE_RXEARLY_THRESH)) {
    sub STE_RXEARLY_THRESH () {	0x1fff;}
}
unless(defined(&STE_WAKEEVENT_WAKEPKT_ENB)) {
    sub STE_WAKEEVENT_WAKEPKT_ENB () {	0x1;}
}
unless(defined(&STE_WAKEEVENT_MAGICPKT_ENB)) {
    sub STE_WAKEEVENT_MAGICPKT_ENB () {	0x2;}
}
unless(defined(&STE_WAKEEVENT_LINKEVT_ENB)) {
    sub STE_WAKEEVENT_LINKEVT_ENB () {	0x4;}
}
unless(defined(&STE_WAKEEVENT_WAKEPOLARITY)) {
    sub STE_WAKEEVENT_WAKEPOLARITY () {	0x8;}
}
unless(defined(&STE_WAKEEVENT_WAKEPKTEVENT)) {
    sub STE_WAKEEVENT_WAKEPKTEVENT () {	0x10;}
}
unless(defined(&STE_WAKEEVENT_MAGICPKTEVENT)) {
    sub STE_WAKEEVENT_MAGICPKTEVENT () {	0x20;}
}
unless(defined(&STE_WAKEEVENT_LINKEVENT)) {
    sub STE_WAKEEVENT_LINKEVENT () {	0x40;}
}
unless(defined(&STE_WAKEEVENT_WAKEONLAN_ENB)) {
    sub STE_WAKEEVENT_WAKEONLAN_ENB () {	0x80;}
}
unless(defined(&STE_TXSTATUS_RECLAIMERR)) {
    sub STE_TXSTATUS_RECLAIMERR () {	0x2;}
}
unless(defined(&STE_TXSTATUS_STATSOFLOW)) {
    sub STE_TXSTATUS_STATSOFLOW () {	0x4;}
}
unless(defined(&STE_TXSTATUS_EXCESSCOLLS)) {
    sub STE_TXSTATUS_EXCESSCOLLS () {	0x8;}
}
unless(defined(&STE_TXSTATUS_UNDERRUN)) {
    sub STE_TXSTATUS_UNDERRUN () {	0x10;}
}
unless(defined(&STE_TXSTATUS_TXINTR_REQ)) {
    sub STE_TXSTATUS_TXINTR_REQ () {	0x40;}
}
unless(defined(&STE_TXSTATUS_TXDONE)) {
    sub STE_TXSTATUS_TXDONE () {	0x80;}
}
unless(defined(&STE_ISRACK_INTLATCH)) {
    sub STE_ISRACK_INTLATCH () {	0x1;}
}
unless(defined(&STE_ISRACK_HOSTERR)) {
    sub STE_ISRACK_HOSTERR () {	0x2;}
}
unless(defined(&STE_ISRACK_TX_DONE)) {
    sub STE_ISRACK_TX_DONE () {	0x4;}
}
unless(defined(&STE_ISRACK_MACCTL_FRAME)) {
    sub STE_ISRACK_MACCTL_FRAME () {	0x8;}
}
unless(defined(&STE_ISRACK_RX_DONE)) {
    sub STE_ISRACK_RX_DONE () {	0x10;}
}
unless(defined(&STE_ISRACK_RX_EARLY)) {
    sub STE_ISRACK_RX_EARLY () {	0x20;}
}
unless(defined(&STE_ISRACK_SOFTINTR)) {
    sub STE_ISRACK_SOFTINTR () {	0x40;}
}
unless(defined(&STE_ISRACK_STATS_OFLOW)) {
    sub STE_ISRACK_STATS_OFLOW () {	0x80;}
}
unless(defined(&STE_ISRACK_LINKEVENT)) {
    sub STE_ISRACK_LINKEVENT () {	0x100;}
}
unless(defined(&STE_ISRACK_TX_DMADONE)) {
    sub STE_ISRACK_TX_DMADONE () {	0x200;}
}
unless(defined(&STE_ISRACK_RX_DMADONE)) {
    sub STE_ISRACK_RX_DMADONE () {	0x400;}
}
unless(defined(&STE_IMR_HOSTERR)) {
    sub STE_IMR_HOSTERR () {	0x2;}
}
unless(defined(&STE_IMR_TX_DONE)) {
    sub STE_IMR_TX_DONE () {	0x4;}
}
unless(defined(&STE_IMR_MACCTL_FRAME)) {
    sub STE_IMR_MACCTL_FRAME () {	0x8;}
}
unless(defined(&STE_IMR_RX_DONE)) {
    sub STE_IMR_RX_DONE () {	0x10;}
}
unless(defined(&STE_IMR_RX_EARLY)) {
    sub STE_IMR_RX_EARLY () {	0x20;}
}
unless(defined(&STE_IMR_SOFTINTR)) {
    sub STE_IMR_SOFTINTR () {	0x40;}
}
unless(defined(&STE_IMR_STATS_OFLOW)) {
    sub STE_IMR_STATS_OFLOW () {	0x80;}
}
unless(defined(&STE_IMR_LINKEVENT)) {
    sub STE_IMR_LINKEVENT () {	0x100;}
}
unless(defined(&STE_IMR_TX_DMADONE)) {
    sub STE_IMR_TX_DMADONE () {	0x200;}
}
unless(defined(&STE_IMR_RX_DMADONE)) {
    sub STE_IMR_RX_DMADONE () {	0x400;}
}
unless(defined(&STE_INTRS)) {
    sub STE_INTRS () {	( &STE_IMR_RX_DMADONE| &STE_IMR_TX_DMADONE| &STE_IMR_STATS_OFLOW|  &STE_IMR_TX_DONE| &STE_IMR_HOSTERR| &STE_IMR_RX_EARLY);}
}
unless(defined(&STE_ISR_INTLATCH)) {
    sub STE_ISR_INTLATCH () {	0x1;}
}
unless(defined(&STE_ISR_HOSTERR)) {
    sub STE_ISR_HOSTERR () {	0x2;}
}
unless(defined(&STE_ISR_TX_DONE)) {
    sub STE_ISR_TX_DONE () {	0x4;}
}
unless(defined(&STE_ISR_MACCTL_FRAME)) {
    sub STE_ISR_MACCTL_FRAME () {	0x8;}
}
unless(defined(&STE_ISR_RX_DONE)) {
    sub STE_ISR_RX_DONE () {	0x10;}
}
unless(defined(&STE_ISR_RX_EARLY)) {
    sub STE_ISR_RX_EARLY () {	0x20;}
}
unless(defined(&STE_ISR_SOFTINTR)) {
    sub STE_ISR_SOFTINTR () {	0x40;}
}
unless(defined(&STE_ISR_STATS_OFLOW)) {
    sub STE_ISR_STATS_OFLOW () {	0x80;}
}
unless(defined(&STE_ISR_LINKEVENT)) {
    sub STE_ISR_LINKEVENT () {	0x100;}
}
unless(defined(&STE_ISR_TX_DMADONE)) {
    sub STE_ISR_TX_DMADONE () {	0x200;}
}
unless(defined(&STE_ISR_RX_DMADONE)) {
    sub STE_ISR_RX_DMADONE () {	0x400;}
}
unless(defined(&STE_MACCTL0_IPG)) {
    sub STE_MACCTL0_IPG () {	0x3;}
}
unless(defined(&STE_MACCTL0_FULLDUPLEX)) {
    sub STE_MACCTL0_FULLDUPLEX () {	0x20;}
}
unless(defined(&STE_MACCTL0_RX_GIANTS)) {
    sub STE_MACCTL0_RX_GIANTS () {	0x40;}
}
unless(defined(&STE_MACCTL0_FLOWCTL_ENABLE)) {
    sub STE_MACCTL0_FLOWCTL_ENABLE () {	0x100;}
}
unless(defined(&STE_MACCTL0_RX_FCS)) {
    sub STE_MACCTL0_RX_FCS () {	0x200;}
}
unless(defined(&STE_MACCTL0_FIFOLOOPBK)) {
    sub STE_MACCTL0_FIFOLOOPBK () {	0x400;}
}
unless(defined(&STE_MACCTL0_MACLOOPBK)) {
    sub STE_MACCTL0_MACLOOPBK () {	0x800;}
}
unless(defined(&STE_MACCTL1_COLLDETECT)) {
    sub STE_MACCTL1_COLLDETECT () {	0x1;}
}
unless(defined(&STE_MACCTL1_CARRSENSE)) {
    sub STE_MACCTL1_CARRSENSE () {	0x2;}
}
unless(defined(&STE_MACCTL1_TX_BUSY)) {
    sub STE_MACCTL1_TX_BUSY () {	0x4;}
}
unless(defined(&STE_MACCTL1_TX_ERROR)) {
    sub STE_MACCTL1_TX_ERROR () {	0x8;}
}
unless(defined(&STE_MACCTL1_STATS_ENABLE)) {
    sub STE_MACCTL1_STATS_ENABLE () {	0x20;}
}
unless(defined(&STE_MACCTL1_STATS_DISABLE)) {
    sub STE_MACCTL1_STATS_DISABLE () {	0x40;}
}
unless(defined(&STE_MACCTL1_STATS_ENABLED)) {
    sub STE_MACCTL1_STATS_ENABLED () {	0x80;}
}
unless(defined(&STE_MACCTL1_TX_ENABLE)) {
    sub STE_MACCTL1_TX_ENABLE () {	0x100;}
}
unless(defined(&STE_MACCTL1_TX_DISABLE)) {
    sub STE_MACCTL1_TX_DISABLE () {	0x200;}
}
unless(defined(&STE_MACCTL1_TX_ENABLED)) {
    sub STE_MACCTL1_TX_ENABLED () {	0x400;}
}
unless(defined(&STE_MACCTL1_RX_ENABLE)) {
    sub STE_MACCTL1_RX_ENABLE () {	0x800;}
}
unless(defined(&STE_MACCTL1_RX_DISABLE)) {
    sub STE_MACCTL1_RX_DISABLE () {	0x1000;}
}
unless(defined(&STE_MACCTL1_RX_ENABLED)) {
    sub STE_MACCTL1_RX_ENABLED () {	0x2000;}
}
unless(defined(&STE_MACCTL1_PAUSED)) {
    sub STE_MACCTL1_PAUSED () {	0x4000;}
}
unless(defined(&STE_IPG_96BT)) {
    sub STE_IPG_96BT () {	0x;}
}
unless(defined(&STE_IPG_128BT)) {
    sub STE_IPG_128BT () {	0x1;}
}
unless(defined(&STE_IPG_224BT)) {
    sub STE_IPG_224BT () {	0x2;}
}
unless(defined(&STE_IPG_544BT)) {
    sub STE_IPG_544BT () {	0x3;}
}
unless(defined(&STE_RXMODE_UNICAST)) {
    sub STE_RXMODE_UNICAST () {	0x1;}
}
unless(defined(&STE_RXMODE_ALLMULTI)) {
    sub STE_RXMODE_ALLMULTI () {	0x2;}
}
unless(defined(&STE_RXMODE_BROADCAST)) {
    sub STE_RXMODE_BROADCAST () {	0x4;}
}
unless(defined(&STE_RXMODE_PROMISC)) {
    sub STE_RXMODE_PROMISC () {	0x8;}
}
unless(defined(&STE_RXMODE_MULTIHASH)) {
    sub STE_RXMODE_MULTIHASH () {	0x10;}
}
unless(defined(&STE_RXMODE_ALLIPMULTI)) {
    sub STE_RXMODE_ALLIPMULTI () {	0x20;}
}
unless(defined(&STE_PHYCTL_MCLK)) {
    sub STE_PHYCTL_MCLK () {	0x1;}
}
unless(defined(&STE_PHYCTL_MDATA)) {
    sub STE_PHYCTL_MDATA () {	0x2;}
}
unless(defined(&STE_PHYCTL_MDIR)) {
    sub STE_PHYCTL_MDIR () {	0x4;}
}
unless(defined(&STE_PHYCTL_CLK25_DISABLE)) {
    sub STE_PHYCTL_CLK25_DISABLE () {	0x8;}
}
unless(defined(&STE_PHYCTL_DUPLEXPOLARITY)) {
    sub STE_PHYCTL_DUPLEXPOLARITY () {	0x10;}
}
unless(defined(&STE_PHYCTL_DUPLEXSTAT)) {
    sub STE_PHYCTL_DUPLEXSTAT () {	0x20;}
}
unless(defined(&STE_PHYCTL_SPEEDSTAT)) {
    sub STE_PHYCTL_SPEEDSTAT () {	0x40;}
}
unless(defined(&STE_PHYCTL_LINKSTAT)) {
    sub STE_PHYCTL_LINKSTAT () {	0x80;}
}
unless(defined(&STE_EEADDR_CONFIGPARM)) {
    sub STE_EEADDR_CONFIGPARM () {	0x;}
}
unless(defined(&STE_EEADDR_ASICCTL)) {
    sub STE_EEADDR_ASICCTL () {	0x2;}
}
unless(defined(&STE_EEADDR_SUBSYS_ID)) {
    sub STE_EEADDR_SUBSYS_ID () {	0x4;}
}
unless(defined(&STE_EEADDR_SUBVEN_ID)) {
    sub STE_EEADDR_SUBVEN_ID () {	0x8;}
}
unless(defined(&STE_EEADDR_NODE0)) {
    sub STE_EEADDR_NODE0 () {	0x10;}
}
unless(defined(&STE_EEADDR_NODE1)) {
    sub STE_EEADDR_NODE1 () {	0x12;}
}
unless(defined(&STE_EEADDR_NODE2)) {
    sub STE_EEADDR_NODE2 () {	0x14;}
}
unless(defined(&STE_PCI_VENDOR_ID)) {
    sub STE_PCI_VENDOR_ID () {	0x;}
}
unless(defined(&STE_PCI_DEVICE_ID)) {
    sub STE_PCI_DEVICE_ID () {	0x2;}
}
unless(defined(&STE_PCI_COMMAND)) {
    sub STE_PCI_COMMAND () {	0x4;}
}
unless(defined(&STE_PCI_STATUS)) {
    sub STE_PCI_STATUS () {	0x6;}
}
unless(defined(&STE_PCI_CLASSCODE)) {
    sub STE_PCI_CLASSCODE () {	0x9;}
}
unless(defined(&STE_PCI_LATENCY_TIMER)) {
    sub STE_PCI_LATENCY_TIMER () {	0xd;}
}
unless(defined(&STE_PCI_HEADER_TYPE)) {
    sub STE_PCI_HEADER_TYPE () {	0xe;}
}
unless(defined(&STE_PCI_LOIO)) {
    sub STE_PCI_LOIO () {	0x10;}
}
unless(defined(&STE_PCI_LOMEM)) {
    sub STE_PCI_LOMEM () {	0x14;}
}
unless(defined(&STE_PCI_BIOSROM)) {
    sub STE_PCI_BIOSROM () {	0x30;}
}
unless(defined(&STE_PCI_INTLINE)) {
    sub STE_PCI_INTLINE () {	0x3c;}
}
unless(defined(&STE_PCI_INTPIN)) {
    sub STE_PCI_INTPIN () {	0x3d;}
}
unless(defined(&STE_PCI_MINGNT)) {
    sub STE_PCI_MINGNT () {	0x3e;}
}
unless(defined(&STE_PCI_MINLAT)) {
    sub STE_PCI_MINLAT () {	0xf;}
}
unless(defined(&STE_PCI_CAPID)) {
    sub STE_PCI_CAPID () {	0x50;}
}
unless(defined(&STE_PCI_NEXTPTR)) {
    sub STE_PCI_NEXTPTR () {	0x51;}
}
unless(defined(&STE_PCI_PWRMGMTCAP)) {
    sub STE_PCI_PWRMGMTCAP () {	0x52;}
}
unless(defined(&STE_PCI_PWRMGMTCTRL)) {
    sub STE_PCI_PWRMGMTCTRL () {	0x54;}
}
unless(defined(&STE_PSTATE_MASK)) {
    sub STE_PSTATE_MASK () {	0x3;}
}
unless(defined(&STE_PSTATE_D0)) {
    sub STE_PSTATE_D0 () {	0x;}
}
unless(defined(&STE_PSTATE_D1)) {
    sub STE_PSTATE_D1 () {	0x2;}
}
unless(defined(&STE_PSTATE_D2)) {
    sub STE_PSTATE_D2 () {	0x2;}
}
unless(defined(&STE_PSTATE_D3)) {
    sub STE_PSTATE_D3 () {	0x3;}
}
unless(defined(&STE_PME_EN)) {
    sub STE_PME_EN () {	0x10;}
}
unless(defined(&STE_PME_STATUS)) {
    sub STE_PME_STATUS () {	0x8000;}
}
unless(defined(&STE_FRAG_LAST)) {
    sub STE_FRAG_LAST () {	0x80000000;}
}
unless(defined(&STE_FRAG_LEN)) {
    sub STE_FRAG_LEN () {	0x1fff;}
}
unless(defined(&STE_MAXFRAGS)) {
    sub STE_MAXFRAGS () {	63;}
}
unless(defined(&STE_TXCTL_WORDALIGN)) {
    sub STE_TXCTL_WORDALIGN () {	0x3;}
}
unless(defined(&STE_TXCTL_FRAMEID)) {
    sub STE_TXCTL_FRAMEID () {	0x3fc;}
}
unless(defined(&STE_TXCTL_NOCRC)) {
    sub STE_TXCTL_NOCRC () {	0x2000;}
}
unless(defined(&STE_TXCTL_TXINTR)) {
    sub STE_TXCTL_TXINTR () {	0x8000;}
}
unless(defined(&STE_TXCTL_DMADONE)) {
    sub STE_TXCTL_DMADONE () {	0x10000;}
}
unless(defined(&STE_TXCTL_DMAINTR)) {
    sub STE_TXCTL_DMAINTR () {	0x80000000;}
}
unless(defined(&STE_RXSTAT_FRAMELEN)) {
    sub STE_RXSTAT_FRAMELEN () {	0x1fff;}
}
unless(defined(&STE_RXSTAT_FRAME_ERR)) {
    sub STE_RXSTAT_FRAME_ERR () {	0x4000;}
}
unless(defined(&STE_RXSTAT_DMADONE)) {
    sub STE_RXSTAT_DMADONE () {	0x8000;}
}
unless(defined(&STE_RXSTAT_FIFO_OFLOW)) {
    sub STE_RXSTAT_FIFO_OFLOW () {	0x10000;}
}
unless(defined(&STE_RXSTAT_RUNT)) {
    sub STE_RXSTAT_RUNT () {	0x20000;}
}
unless(defined(&STE_RXSTAT_ALIGNERR)) {
    sub STE_RXSTAT_ALIGNERR () {	0x40000;}
}
unless(defined(&STE_RXSTAT_CRCERR)) {
    sub STE_RXSTAT_CRCERR () {	0x80000;}
}
unless(defined(&STE_RXSTAT_GIANT)) {
    sub STE_RXSTAT_GIANT () {	0x100000;}
}
unless(defined(&STE_RXSTAT_DRIBBLEBITS)) {
    sub STE_RXSTAT_DRIBBLEBITS () {	0x800000;}
}
unless(defined(&STE_RXSTAT_DMA_OFLOW)) {
    sub STE_RXSTAT_DMA_OFLOW () {	0x1000000;}
}
unless(defined(&STE_RXATAT_ONEBUF)) {
    sub STE_RXATAT_ONEBUF () {	0x10000000;}
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{ste_btag}),  ($sc->{ste_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2( ($sc->{ste_btag}),  ($sc->{ste_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1( ($sc->{ste_btag}),  ($sc->{ste_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_4( ($sc->{ste_btag}),  ($sc->{ste_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_2( ($sc->{ste_btag}),  ($sc->{ste_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_1( ($sc->{ste_btag}),  ($sc->{ste_bhandle}), $reg));
    }
}
unless(defined(&STE_TIMEOUT)) {
    sub STE_TIMEOUT () {	1000;}
}
unless(defined(&STE_MIN_FRAMELEN)) {
    sub STE_MIN_FRAMELEN () {	60;}
}
unless(defined(&STE_PACKET_SIZE)) {
    sub STE_PACKET_SIZE () {	1536;}
}
unless(defined(&ETHER_ALIGN)) {
    sub ETHER_ALIGN () {	2;}
}
unless(defined(&STE_RX_LIST_CNT)) {
    sub STE_RX_LIST_CNT () {	128;}
}
unless(defined(&STE_TX_LIST_CNT)) {
    sub STE_TX_LIST_CNT () {	256;}
}
unless(defined(&STE_INC)) {
    sub STE_INC {
	local($x, $y) = @_;
	eval q(($x) = ($x + 1) % $y);
    }
}
unless(defined(&STE_MII_STARTDELIM)) {
    sub STE_MII_STARTDELIM () {	0x1;}
}
unless(defined(&STE_MII_READOP)) {
    sub STE_MII_READOP () {	0x2;}
}
unless(defined(&STE_MII_WRITEOP)) {
    sub STE_MII_WRITEOP () {	0x1;}
}
unless(defined(&STE_MII_TURNAROUND)) {
    sub STE_MII_TURNAROUND () {	0x2;}
}
if(defined(&__alpha__)) {
    undef(&vtophys) if defined(&vtophys);
    eval 'sub vtophys {
        local($va) = @_;
	    eval q( &alpha_XXX_dmamap($va));
    }' unless defined(&vtophys);
}
1;
