require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&LFS_LABELPAD)) {
    sub LFS_LABELPAD () {	8192;}
}
unless(defined(&LFS_SBPAD)) {
    sub LFS_SBPAD () {	8192;}
}
unless(defined(&LFS_SYNC)) {
    sub LFS_SYNC () {	0x2;}
}
unless(defined(&SEGUSE_ACTIVE)) {
    sub SEGUSE_ACTIVE () {	0x1;}
}
unless(defined(&SEGUSE_DIRTY)) {
    sub SEGUSE_DIRTY () {	0x2;}
}
unless(defined(&SEGUSE_SUPERBLOCK)) {
    sub SEGUSE_SUPERBLOCK () {	0x4;}
}
unless(defined(&SEGUPB)) {
    sub SEGUPB {
	local($fs) = @_;
	eval q((1<< ($fs)-> &lfs_sushift));
    }
}
unless(defined(&SEGTABSIZE_SU)) {
    sub SEGTABSIZE_SU {
	local($fs) = @_;
	eval q(((($fs)-> &lfs_nseg +  &SEGUPB($fs) - 1) >> ($fs)-> &lfs_sushift));
    }
}
unless(defined(&LFS_MAGIC)) {
    sub LFS_MAGIC () {	0x70162;}
}
unless(defined(&LFS_VERSION)) {
    sub LFS_VERSION () {	1;}
}
unless(defined(&LFS_MIN_SBINTERVAL)) {
    sub LFS_MIN_SBINTERVAL () {	5;}
}
unless(defined(&LFS_MAXNUMSB)) {
    sub LFS_MAXNUMSB () {	10;}
}
unless(defined(&LFS_UNUSED_INUM)) {
    sub LFS_UNUSED_INUM () {	0;}
}
unless(defined(&LFS_IFILE_INUM)) {
    sub LFS_IFILE_INUM () {	1;}
}
unless(defined(&LOSTFOUNDINO)) {
    sub LOSTFOUNDINO () {	3;}
}
unless(defined(&LFS_FIRST_INUM)) {
    sub LFS_FIRST_INUM () {	4;}
}
unless(defined(&S_INDIR)) {
    sub S_INDIR {
	local($fs) = @_;
	eval q(- &NDADDR);
    }
}
unless(defined(&D_INDIR)) {
    sub D_INDIR {
	local($fs) = @_;
	eval q(( &S_INDIR($fs) -  &NINDIR($fs) - 1));
    }
}
unless(defined(&T_INDIR)) {
    sub T_INDIR {
	local($fs) = @_;
	eval q(( &D_INDIR($fs) -  &NINDIR($fs) *  &NINDIR($fs) - 1));
    }
}
unless(defined(&UNASSIGNED)) {
    sub UNASSIGNED () {	-1;}
}
unless(defined(&LFS_UNUSED_LBN)) {
    sub LFS_UNUSED_LBN () {	-1;}
}
unless(defined(&LFS_UNUSED_DADDR)) {
    sub LFS_UNUSED_DADDR () {	0;}
}
unless(defined(&CLEANSIZE_SU)) {
    sub CLEANSIZE_SU {
	local($fs) = @_;
	eval q((($sizeof{ &CLEANERINFO} + ($fs)-> &lfs_bsize - 1) >> ($fs)-> &lfs_bshift));
    }
}
unless(defined(&LFS_SUMMARY_SIZE)) {
    sub LFS_SUMMARY_SIZE () {	512;}
}
unless(defined(&SS_MAGIC)) {
    sub SS_MAGIC () {	0x61561;}
}
unless(defined(&SS_DIROP)) {
    sub SS_DIROP () {	0x1;}
}
unless(defined(&SS_CONT)) {
    sub SS_CONT () {	0x2;}
}
unless(defined(&NINDIR)) {
    sub NINDIR {
	local($fs) = @_;
	eval q((($fs)-> &lfs_nindir));
    }
}
unless(defined(&INOPB)) {
    sub INOPB {
	local($fs) = @_;
	eval q((($fs)-> &lfs_inopb));
    }
}
unless(defined(&blksize)) {
    sub blksize {
	local($fs, $ip, $lbn) = @_;
	eval q(((($lbn) >=  &NDADDR || ($ip)-> &i_size >= (($lbn) + 1) << ($fs)-> &lfs_bshift) ? ($fs)-> &lfs_bsize : ( &fragroundup($fs,  &blkoff($fs, ($ip)-> &i_size)))));
    }
}
unless(defined(&blkoff)) {
    sub blkoff {
	local($fs, $loc) = @_;
	eval q(((($loc) & ($fs)-> &lfs_bmask)));
    }
}
unless(defined(&fragoff)) {
    sub fragoff {
	local($fs, $loc) = @_;
	eval q(((($loc) & ($fs)-> &lfs_ffmask)));
    }
}
unless(defined(&fsbtodb)) {
    sub fsbtodb {
	local($fs, $b) = @_;
	eval q((($b) << ($fs)-> &lfs_fsbtodb));
    }
}
unless(defined(&dbtofsb)) {
    sub dbtofsb {
	local($fs, $b) = @_;
	eval q((($b) >> ($fs)-> &lfs_fsbtodb));
    }
}
unless(defined(&fragstodb)) {
    sub fragstodb {
	local($fs, $b) = @_;
	eval q((($b) << (($fs)-> &lfs_fsbtodb - ($fs)-> &lfs_fbshift)));
    }
}
unless(defined(&dbtofrags)) {
    sub dbtofrags {
	local($fs, $b) = @_;
	eval q((($b) >> (($fs)-> &lfs_fsbtodb - ($fs)-> &lfs_fbshift)));
    }
}
unless(defined(&lblkno)) {
    sub lblkno {
	local($fs, $loc) = @_;
	eval q((($loc) >> ($fs)-> &lfs_bshift));
    }
}
unless(defined(&lblktosize)) {
    sub lblktosize {
	local($fs, $blk) = @_;
	eval q((($blk) << ($fs)-> &lfs_bshift));
    }
}
unless(defined(&numfrags)) {
    sub numfrags {
	local($fs, $loc) = @_;
	eval q((($loc) >> ($fs)-> &lfs_ffshift));
    }
}
unless(defined(&blkroundup)) {
    sub blkroundup {
	local($fs, $size) = @_;
	eval q((((($size) + ($fs)-> &lfs_bmask) & (~($fs)-> &lfs_bmask))));
    }
}
unless(defined(&fragroundup)) {
    sub fragroundup {
	local($fs, $size) = @_;
	eval q((((($size) + ($fs)-> &lfs_ffmask) & (~($fs)-> &lfs_ffmask))));
    }
}
unless(defined(&fragstoblks)) {
    sub fragstoblks {
	local($fs, $frags) = @_;
	eval q((($frags) >> ($fs)-> &lfs_fbshift));
    }
}
unless(defined(&blkstofrags)) {
    sub blkstofrags {
	local($fs, $blks) = @_;
	eval q((($blks) << ($fs)-> &lfs_fbshift));
    }
}
unless(defined(&fragnum)) {
    sub fragnum {
	local($fs, $fsb) = @_;
	eval q((($fsb) & (($fs)-> &lfs_frag - 1)));
    }
}
unless(defined(&blknum)) {
    sub blknum {
	local($fs, $fsb) = @_;
	eval q((($fsb) &~ (($fs)-> &lfs_frag - 1)));
    }
}
unless(defined(&dblksize)) {
    sub dblksize {
	local($fs, $dip, $lbn) = @_;
	eval q(((($lbn) >=  &NDADDR || ($dip)-> &di_size >= (($lbn) + 1) << ($fs)-> &lfs_bshift) ? ($fs)-> &lfs_bsize : ( &fragroundup($fs,  &blkoff($fs, ($dip)-> &di_size)))));
    }
}
unless(defined(&datosn)) {
    sub datosn {
	local($fs, $daddr) = @_;
	eval q(((($daddr) - ($fs)-> $lfs_sboffs[0]) /  &fsbtodb(($fs), ($fs)-> &lfs_ssize)));
    }
}
unless(defined(&sntoda)) {
    sub sntoda {
	local($fs, $sn) = @_;
	eval q(((($sn) * (($fs)-> &lfs_ssize << ($fs)-> &lfs_fsbtodb) + ($fs)-> $lfs_sboffs[0])));
    }
}
unless(defined(&LFS_CLEANERINFO)) {
    sub LFS_CLEANERINFO {
	local($CP, $F, $BP) = @_;
	eval q({  &VTOI(-> &lfs_ivnode)-> &i_flag |=  &IN_ACCESS;  &if ( &bread(-> &lfs_ivnode, 0, -> &lfs_bsize,  &NOCRED, ))  &panic(\"lfs: ifile read\"); = ($BP)-> &b_data; });
    }
}
unless(defined(&LFS_IENTRY)) {
    sub LFS_IENTRY {
	local($IP, $F, $IN, $BP) = @_;
	eval q({ 'int'  &_e;  &VTOI(-> &lfs_ivnode)-> &i_flag |=  &IN_ACCESS;  &if (( &_e =  &bread(-> &lfs_ivnode, / -> &lfs_ifpb + -> &lfs_cleansz + -> &lfs_segtabsz, -> &lfs_bsize,  &NOCRED, )) != 0)  &panic(\"lfs: ifile read %d\",  &_e); = ($BP)-> &b_data + ($IN) % ($F)-> &lfs_ifpb; });
    }
}
unless(defined(&LFS_SEGENTRY)) {
    sub LFS_SEGENTRY {
	local($SP, $F, $IN, $BP) = @_;
	eval q({ 'int'  &_e;  &VTOI(-> &lfs_ivnode)-> &i_flag |=  &IN_ACCESS;  &if (( &_e =  &bread(-> &lfs_ivnode, ( >> -> &lfs_sushift) + -> &lfs_cleansz, -> &lfs_bsize,  &NOCRED, )) != 0)  &panic(\"lfs: ifile read: %d\",  &_e); = ($BP)-> &b_data + (($IN) & (($F)-> &lfs_sepb - 1)); });
    }
}
unless(defined(&LFS_FITS)) {
    sub LFS_FITS {
	local($fs, $db) = @_;
	eval q(((($db + (($fs)-> &lfs_uinodes +  &INOPB(($fs))) /  &INOPB(($fs)) +  &fsbtodb($fs, 1) +  &LFS_SUMMARY_SIZE /  &DEV_BSIZE + ($fs)-> &lfs_segtabsz)) < ($fs)-> &lfs_avail));
    }
}
unless(defined(&IS_IFILE)) {
    sub IS_IFILE {
	local($bp) = @_;
	eval q(( &VTOI( ($bp->{b_vp}))-> &i_number ==  &LFS_IFILE_INUM));
    }
}
unless(defined(&SEGM_CKP)) {
    sub SEGM_CKP () {	0x1;}
}
unless(defined(&SEGM_CLEAN)) {
    sub SEGM_CLEAN () {	0x2;}
}
unless(defined(&SEGM_SYNC)) {
    sub SEGM_SYNC () {	0x4;}
}
unless(defined(&ISSPACE)) {
    sub ISSPACE {
	local($F, $BB, $C) = @_;
	eval q(((($C)-> &cr_uid == 0 && ($F)-> &lfs_bfree >= ($BB)) || (($C)-> &cr_uid != 0 &&  &IS_FREESPACE($F, $BB))));
    }
}
unless(defined(&IS_FREESPACE)) {
    sub IS_FREESPACE {
	local($F, $BB) = @_;
	eval q((($F)-> &lfs_bfree > (($F)-> &lfs_dsize * ($F)-> &lfs_minfree / 100+ ($BB))));
    }
}
unless(defined(&ISSPACE_XXX)) {
    sub ISSPACE_XXX {
	local($F, $BB) = @_;
	eval q((($F)-> &lfs_bfree >= ($BB)));
    }
}
unless(defined(&DOSTATS)) {
    sub DOSTATS () {	1;}
}
if(defined(&DOSTATS)) {
}
1;
