require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_AIC7XXX_OPENBSD_H_)) {
    eval 'sub _AIC7XXX_OPENBSD_H_ () {1;}' unless defined(&_AIC7XXX_OPENBSD_H_);
    require 'pci.ph';
    require 'sys/param.ph';
    require 'sys/kernel.ph';
    require 'sys/systm.ph';
    require 'sys/device.ph';
    require 'sys/malloc.ph';
    require 'sys/buf.ph';
    require 'sys/proc.ph';
    require 'sys/queue.ph';
    require 'dev/pci/pcireg.ph';
    require 'dev/pci/pcivar.ph';
    require 'machine/bus.ph';
    require 'machine/intr.ph';
    require 'scsi/scsi_all.ph';
    require 'scsi/scsi_message.ph';
    require 'scsi/scsi_debug.ph';
    require 'scsi/scsiconf.ph';
    require 'uvm/uvm_extern.ph';
    if(defined(&CAM_NEW_TRAN_CODE)) {
	eval 'sub AHC_NEW_TRAN_SETTINGS () {1;}' unless defined(&AHC_NEW_TRAN_SETTINGS);
    }
    if((defined(&NPCI) ? &NPCI : 0) > 0) {
	eval 'sub AHC_PCI_CONFIG () {1;}' unless defined(&AHC_PCI_CONFIG);
    }
    eval 'sub AHC_DEBUG () { &AHC_SHOW_SENSE |  &AHC_SHOW_MISC |  &AHC_SHOW_CMDS;}' unless defined(&AHC_DEBUG);
    if(defined(&DEBUG)) {
	eval 'sub bootverbose () {1;}' unless defined(&bootverbose);
    } else {
	eval 'sub bootverbose () {0;}' unless defined(&bootverbose);
    }
    eval 'sub SCSI_IS_SCSIBUS_B {
        local($ahc, $sc_link) = @_;
	    eval q((($sc_link)-> &scsibus == ($ahc)-> ($sc_channel_b->{scsibus})));
    }' unless defined(&SCSI_IS_SCSIBUS_B);
    eval 'sub SCSI_SCSI_ID {
        local($ahc, $sc_link) = @_;
	    eval q(( &SCSI_IS_SCSIBUS_B($ahc, $sc_link) ?  ($ahc->{our_id_b}) :  ($ahc->{our_id})));
    }' unless defined(&SCSI_SCSI_ID);
    eval 'sub SCSI_CHANNEL {
        local($ahc, $sc_link) = @_;
	    eval q(( &SCSI_IS_SCSIBUS_B($ahc, $sc_link) ? ord(\'B\' : \'A\')));
    }' unless defined(&SCSI_CHANNEL);
    eval 'sub BUILD_SCSIID {
        local($ahc, $sc_link, $target_id, $our_id) = @_;
	    eval q((((($target_id) <<  &TID_SHIFT) &  &TID) | ($our_id)));
    }' unless defined(&BUILD_SCSIID);
    unless(defined(&offsetof)) {
	eval 'sub offsetof {
	    local($type, $member) = @_;
    	    eval q((((0)->$member)));
	}' unless defined(&offsetof);
    }
    eval 'sub ahc_dmamap_sync {
        local($ahc, $dma_tag, $dmamap, $offset, $len, $op) = @_;
	    eval q( &bus_dmamap_sync($dma_tag, $dmamap, $offset, $len, $op));
    }' unless defined(&ahc_dmamap_sync);
    eval 'sub AHC_NSEG () {( &roundup( &btoc( &MAXPHYS) + 1, 16));}' unless defined(&AHC_NSEG);
    require 'dev/ic/aic7xxxvar.ph';
    unless(defined(&ISABUS_DMA_32BIT)) {
	eval 'sub ISABUS_DMA_32BIT () { &BUS_DMA_BUS1;}' unless defined(&ISABUS_DMA_32BIT);
    }
    eval 'sub ahc_htobe16 {
        local($x) = @_;
	    eval q( &htobe16($x));
    }' unless defined(&ahc_htobe16);
    eval 'sub ahc_htobe32 {
        local($x) = @_;
	    eval q( &htobe32($x));
    }' unless defined(&ahc_htobe32);
    eval 'sub ahc_htobe64 {
        local($x) = @_;
	    eval q( &htobe64($x));
    }' unless defined(&ahc_htobe64);
    eval 'sub ahc_htole16 {
        local($x) = @_;
	    eval q( &htole16($x));
    }' unless defined(&ahc_htole16);
    eval 'sub ahc_htole32 {
        local($x) = @_;
	    eval q( &htole32($x));
    }' unless defined(&ahc_htole32);
    eval 'sub ahc_htole64 {
        local($x) = @_;
	    eval q( &htole64($x));
    }' unless defined(&ahc_htole64);
    eval 'sub ahc_be16toh {
        local($x) = @_;
	    eval q( &betoh16($x));
    }' unless defined(&ahc_be16toh);
    eval 'sub ahc_be32toh {
        local($x) = @_;
	    eval q( &betoh32($x));
    }' unless defined(&ahc_be32toh);
    eval 'sub ahc_be64toh {
        local($x) = @_;
	    eval q( &betoh64($x));
    }' unless defined(&ahc_be64toh);
    eval 'sub ahc_le16toh {
        local($x) = @_;
	    eval q( &letoh16($x));
    }' unless defined(&ahc_le16toh);
    eval 'sub ahc_le32toh {
        local($x) = @_;
	    eval q( &letoh32($x));
    }' unless defined(&ahc_le32toh);
    eval 'sub ahc_le64toh {
        local($x) = @_;
	    eval q( &letoh64($x));
    }' unless defined(&ahc_le64toh);
    if((defined(&AHC_REG_PRETTY_PRINT) ? &AHC_REG_PRETTY_PRINT : 0)) {
	eval 'sub AIC_DEBUG_REGISTERS () {1;}' unless defined(&AIC_DEBUG_REGISTERS);
    } else {
	eval 'sub AIC_DEBUG_REGISTERS () {0;}' unless defined(&AIC_DEBUG_REGISTERS);
    }
    eval 'sub ahc_timer_init () { &callout_init;}' unless defined(&ahc_timer_init);
    eval 'sub ahc_timer_stop () { &callout_stop;}' unless defined(&ahc_timer_stop);
    eval 'sub ahc_inb {
        local($ahc, $port) = @_;
	    eval q( &bus_space_read_1(($ahc)-> &tag, ($ahc)-> &bsh, $port));
    }' unless defined(&ahc_inb);
    eval 'sub ahc_outb {
        local($ahc, $port, $value) = @_;
	    eval q( &bus_space_write_1(($ahc)-> &tag, ($ahc)-> &bsh, $port, $value));
    }' unless defined(&ahc_outb);
    eval 'sub ahc_outsb {
        local($ahc, $port, $valp, $count) = @_;
	    eval q( &bus_space_write_multi_1(($ahc)-> &tag, ($ahc)-> &bsh, $port, $valp, $count));
    }' unless defined(&ahc_outsb);
    eval 'sub ahc_insb {
        local($ahc, $port, $valp, $count) = @_;
	    eval q( &bus_space_read_multi_1(($ahc)-> &tag, ($ahc)-> &bsh, $port, $valp, $count));
    }' unless defined(&ahc_insb);
    eval 'sub ahc_delay () { &DELAY;}' unless defined(&ahc_delay);
    if(defined(&AHC_PCI_CONFIG)) {
	eval("sub AHC_POWER_STATE_D0 () { 0; }") unless defined(&AHC_POWER_STATE_D0);
	eval("sub AHC_POWER_STATE_D1 () { 1; }") unless defined(&AHC_POWER_STATE_D1);
	eval("sub AHC_POWER_STATE_D2 () { 2; }") unless defined(&AHC_POWER_STATE_D2);
	eval("sub AHC_POWER_STATE_D3 () { 3; }") unless defined(&AHC_POWER_STATE_D3);
    }
}
1;
