require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_RF__RF_FREELIST_H_)) {
    eval 'sub _RF__RF_FREELIST_H_ () {1;}' unless defined(&_RF__RF_FREELIST_H_);
    require 'rf_types.ph';
    require 'rf_debugMem.ph';
    require 'rf_general.ph';
    require 'rf_threadstuff.ph';
    eval 'sub RF_FREELIST_STATS () {0;}' unless defined(&RF_FREELIST_STATS);
    if((defined(&RF_FREELIST_STATS) ? &RF_FREELIST_STATS : 0) > 0) {
	eval 'sub RF_FREELIST_STAT_INIT {
	    local($_fl_) = @_;
    	    eval q( &do {  &bzero((($_fl_)-> &stats), $sizeof{ &RF_FreeListStats_t}); ($_fl_)-> ($stats->{file}) =  &__FILE__; ($_fl_)-> ($stats->{line}) =  &__LINE__; }  &while (0));
	}' unless defined(&RF_FREELIST_STAT_INIT);
	eval 'sub RF_FREELIST_STAT_ALLOC {
	    local($_fl_) = @_;
    	    eval q( &do { ($_fl_)-> ($stats->{allocations})++; ($_fl_)-> ($stats->{outstanding})++;  &if (($_fl_)-> ($stats->{outstanding}) > ($_fl_)-> ($stats->{max_outstanding})) ($_fl_)-> ($stats->{max_outstanding}) = ($_fl_)-> ($stats->{outstanding}); }  &while (0));
	}' unless defined(&RF_FREELIST_STAT_ALLOC);
	eval 'sub RF_FREELIST_STAT_FREE_UPDATE {
	    local($_fl_) = @_;
    	    eval q( &do {  &if (($_fl_)-> &free_cnt > ($_fl_)-> ($stats->{max_free})) ($_fl_)-> ($stats->{max_free}) = ($_fl_)-> &free_cnt; }  &while (0));
	}' unless defined(&RF_FREELIST_STAT_FREE_UPDATE);
	eval 'sub RF_FREELIST_STAT_FREE {
	    local($_fl_) = @_;
    	    eval q( &do { ($_fl_)-> ($stats->{frees})++; ($_fl_)-> ($stats->{outstanding})--;  &RF_FREELIST_STAT_FREE_UPDATE($_fl_); }  &while (0));
	}' unless defined(&RF_FREELIST_STAT_FREE);
	eval 'sub RF_FREELIST_STAT_GROW {
	    local($_fl_) = @_;
    	    eval q( &do { ($_fl_)-> ($stats->{grows})++;  &RF_FREELIST_STAT_FREE_UPDATE($_fl_); }  &while (0));
	}' unless defined(&RF_FREELIST_STAT_GROW);
	eval 'sub RF_FREELIST_STAT_REPORT {
	    local($_fl_) = @_;
    	    eval q( &do {  &printf(\\"Freelist at %s %d (%s)\\\\n\\", ($_fl_)-> ($stats->{file}), ($_fl_)-> ($stats->{line}),  &RF_STRING($_fl_));  &printf(\\"  %d allocations, %d frees\\\\n\\", ($_fl_)-> ($stats->{allocations}), ($_fl_)-> ($stats->{frees}));  &printf(\\"  %d grows\\\\n\\", ($_fl_)-> ($stats->{grows}));  &printf(\\"  %d outstanding\\\\n\\", ($_fl_)-> ($stats->{outstanding}));  &printf(\\"  %d free (max)\\\\n\\", ($_fl_)-> ($stats->{max_free}));  &printf(\\"  %d outstanding (max)\\\\n\\", ($_fl_)-> ($stats->{max_outstanding})); }  &while (0));
	}' unless defined(&RF_FREELIST_STAT_REPORT);
    } else {
	eval 'sub RF_FREELIST_STAT_INIT {
	    local($_fl_) = @_;
    	    eval q();
	}' unless defined(&RF_FREELIST_STAT_INIT);
	eval 'sub RF_FREELIST_STAT_ALLOC {
	    local($_fl_) = @_;
    	    eval q();
	}' unless defined(&RF_FREELIST_STAT_ALLOC);
	eval 'sub RF_FREELIST_STAT_FREE_UPDATE {
	    local($_fl_) = @_;
    	    eval q();
	}' unless defined(&RF_FREELIST_STAT_FREE_UPDATE);
	eval 'sub RF_FREELIST_STAT_FREE {
	    local($_fl_) = @_;
    	    eval q();
	}' unless defined(&RF_FREELIST_STAT_FREE);
	eval 'sub RF_FREELIST_STAT_GROW {
	    local($_fl_) = @_;
    	    eval q();
	}' unless defined(&RF_FREELIST_STAT_GROW);
	eval 'sub RF_FREELIST_STAT_REPORT {
	    local($_fl_) = @_;
    	    eval q();
	}' unless defined(&RF_FREELIST_STAT_REPORT);
    }
    if((defined(&RF_FREELIST_STATS) ? &RF_FREELIST_STATS : 0) > 0) {
    }
    eval 'sub RF_FREELIST_CREATE {
        local($_fl_,$_maxcnt_,$_inc_,$_size_) = @_;
	    eval q( &do { \'int\'  &rc;  &RF_ASSERT(($_inc_) > 0);  &RF_Malloc($_fl_, $sizeof{ &RF_FreeList_t}, ( &RF_FreeList_t *)); ($_fl_)-> &objlist =  &NULL; ($_fl_)-> &free_cnt = 0; ($_fl_)-> &max_free_cnt = $_maxcnt_; ($_fl_)-> &obj_inc = $_inc_; ($_fl_)-> &obj_size = $_size_;  &rc =  &rf_mutex_init(($_fl_)-> &lock);  &if ( &rc) {  &RF_Free($_fl_, $sizeof{ &RF_FreeList_t}); $_fl_ =  &NULL; }  &RF_FREELIST_STAT_INIT($_fl_); }  &while (0));
    }' unless defined(&RF_FREELIST_CREATE);
    eval 'sub RF_FREELIST_PRIME {
        local($_fl_,$_cnt_,$_nextp_,$_cast_) = @_;
	    eval q( &do {  &void * &_p; \'int\'  &_i;  &RF_LOCK_MUTEX(($_fl_)-> &lock);  &for ( &_i = 0;  &_i < ($_cnt_);  &_i++) {  &RF_Calloc( &_p, 1, ($_fl_)-> &obj_size, ( &void *));  &if ( &_p) { ($_cast_( &_p))->$_nextp_ = ($_fl_)-> &objlist; ($_fl_)-> &objlist =  &_p; ($_fl_)-> &free_cnt++; }  &else {  &break; } }  &RF_FREELIST_STAT_FREE_UPDATE($_fl_);  &RF_UNLOCK_MUTEX(($_fl_)-> &lock); }  &while (0));
    }' unless defined(&RF_FREELIST_PRIME);
    eval 'sub RF_FREELIST_MUTEX_OF {
        local($_fl_) = @_;
	    eval q((($_fl_)-> &lock));
    }' unless defined(&RF_FREELIST_MUTEX_OF);
    eval 'sub RF_FREELIST_DO_UNLOCK {
        local($_fl_) = @_;
	    eval q( &RF_UNLOCK_MUTEX(($_fl_)-> &lock));
    }' unless defined(&RF_FREELIST_DO_UNLOCK);
    eval 'sub RF_FREELIST_DO_LOCK {
        local($_fl_) = @_;
	    eval q( &RF_LOCK_MUTEX(($_fl_)-> &lock));
    }' unless defined(&RF_FREELIST_DO_LOCK);
    eval 'sub RF_FREELIST_PRIME_INIT {
        local($_fl_,$_cnt_,$_nextp_,$_cast_,$_init_) = @_;
	    eval q( &do {  &void * &_p; \'int\'  &_i;  &RF_LOCK_MUTEX(($_fl_)-> &lock);  &for ( &_i = 0;  &_i < ($_cnt_);  &_i++) {  &RF_Calloc( &_p, 1, ($_fl_)-> &obj_size, ( &void *));  &if ($_init_($_cast_  &_p)) {  &RF_Free( &_p, ($_fl_)-> &obj_size);  &_p =  &NULL; }  &if ( &_p) { ($_cast_( &_p))->$_nextp_ = ($_fl_)-> &objlist; ($_fl_)-> &objlist =  &_p; ($_fl_)-> &free_cnt++; }  &else {  &break; } }  &RF_FREELIST_STAT_FREE_UPDATE($_fl_);  &RF_UNLOCK_MUTEX(($_fl_)-> &lock); }  &while (0));
    }' unless defined(&RF_FREELIST_PRIME_INIT);
    eval 'sub RF_FREELIST_PRIME_INIT_ARG {
        local($_fl_,$_cnt_,$_nextp_,$_cast_,$_init_,$_arg_) = @_;
	    eval q( &do {  &void * &_p; \'int\'  &_i;  &RF_LOCK_MUTEX(($_fl_)-> &lock);  &for ( &_i = 0;  &_i < ($_cnt_);  &_i++) {  &RF_Calloc( &_p, 1, ($_fl_)-> &obj_size, ( &void *));  &if ($_init_($_cast_  &_p, $_arg_)) {  &RF_Free( &_p, ($_fl_)-> &obj_size);  &_p =  &NULL; }  &if ( &_p) { ($_cast_( &_p))->$_nextp_ = ($_fl_)-> &objlist; ($_fl_)-> &objlist =  &_p; ($_fl_)-> &free_cnt++; }  &else {  &break; } }  &RF_FREELIST_STAT_FREE_UPDATE($_fl_);  &RF_UNLOCK_MUTEX(($_fl_)-> &lock); }  &while (0));
    }' unless defined(&RF_FREELIST_PRIME_INIT_ARG);
    eval 'sub RF_FREELIST_GET_INIT {
        local($_fl_,$_obj_,$_nextp_,$_cast_,$_init_) = @_;
	    eval q( &do {  &void * &_p; \'int\'  &_i;  &RF_LOCK_MUTEX(-> &lock);  &RF_ASSERT($sizeof{} == (-> &obj_size));  &if ( ($_fl_->{objlist})) { $_obj_ = $_cast_(-> &objlist); -> &objlist = (($_obj_)->$_nextp_); ($_fl_)-> &free_cnt--; }  &else {  &RF_Calloc($_obj_, 1, ($_fl_)-> &obj_size, $_cast_);  &if ($_obj_) {  &if ($_init_($_obj_)) {  &RF_Free($_obj_, ($_fl_)-> &obj_size); $_obj_ =  &NULL; }  &else {  &for ( &_i = 1;  &_i < ($_fl_)-> &obj_inc;  &_i++) {  &RF_Calloc( &_p, 1, ($_fl_)-> &obj_size, ( &void *));  &if ( &_p) {  &if ($_init_( &_p)) {  &RF_Free( &_p, ($_fl_)-> &obj_size);  &_p =  &NULL;  &break; } ($_cast_( &_p))->$_nextp_ = ($_fl_)-> &objlist; ($_fl_)-> &objlist =  &_p; }  &else {  &break; } } } }  &RF_FREELIST_STAT_GROW($_fl_); }  &RF_FREELIST_STAT_ALLOC($_fl_);  &RF_UNLOCK_MUTEX(($_fl_)-> &lock); }  &while (0));
    }' unless defined(&RF_FREELIST_GET_INIT);
    eval 'sub RF_FREELIST_GET_INIT_ARG {
        local($_fl_,$_obj_,$_nextp_,$_cast_,$_init_,$_arg_) = @_;
	    eval q( &do {  &void * &_p; \'int\'  &_i;  &RF_LOCK_MUTEX(-> &lock);  &RF_ASSERT($sizeof{} == (-> &obj_size));  &if ( ($_fl_->{objlist})) { $_obj_ = $_cast_(-> &objlist); -> &objlist = (($_obj_)->$_nextp_); ($_fl_)-> &free_cnt--; }  &else {  &RF_Calloc($_obj_, 1, ($_fl_)-> &obj_size, $_cast_);  &if ($_obj_) {  &if ($_init_($_obj_, $_arg_)) {  &RF_Free($_obj_, ($_fl_)-> &obj_size); $_obj_ =  &NULL; }  &else {  &for ( &_i = 1;  &_i < ($_fl_)-> &obj_inc;  &_i++) {  &RF_Calloc( &_p, 1, ($_fl_)-> &obj_size, ( &void *));  &if ( &_p) {  &if ($_init_( &_p, $_arg_)) {  &RF_Free( &_p, ($_fl_)-> &obj_size);  &_p =  &NULL;  &break; } ($_cast_( &_p))->$_nextp_ = ($_fl_)-> &objlist; ($_fl_)-> &objlist =  &_p; }  &else {  &break; } } } }  &RF_FREELIST_STAT_GROW($_fl_); }  &RF_FREELIST_STAT_ALLOC($_fl_);  &RF_UNLOCK_MUTEX(($_fl_)-> &lock); }  &while (0));
    }' unless defined(&RF_FREELIST_GET_INIT_ARG);
    eval 'sub RF_FREELIST_GET_INIT_NOUNLOCK {
        local($_fl_,$_obj_,$_nextp_,$_cast_,$_init_) = @_;
	    eval q( &do {  &void * &_p; \'int\'  &_i;  &RF_LOCK_MUTEX(-> &lock);  &RF_ASSERT($sizeof{} == (-> &obj_size));  &if ( ($_fl_->{objlist})) { $_obj_ = $_cast_(-> &objlist); -> &objlist = (($_obj_)->$_nextp_); ($_fl_)-> &free_cnt--; }  &else {  &RF_Calloc($_obj_, 1, ($_fl_)-> &obj_size, $_cast_);  &if ($_obj_) {  &if ($_init_($_obj_)) {  &RF_Free($_obj_, ($_fl_)-> &obj_size); $_obj_ =  &NULL; }  &else {  &for ( &_i = 1;  &_i < ($_fl_)-> &obj_inc;  &_i++) {  &RF_Calloc( &_p, 1, ($_fl_)-> &obj_size, ( &void *));  &if ( &_p) {  &if ($_init_( &_p)) {  &RF_Free( &_p, ($_fl_)-> &obj_size);  &_p =  &NULL;  &break; } ($_cast_( &_p))->$_nextp_ = ($_fl_)-> &objlist; ($_fl_)-> &objlist =  &_p; }  &else {  &break; } } } }  &RF_FREELIST_STAT_GROW($_fl_); }  &RF_FREELIST_STAT_ALLOC($_fl_); }  &while (0));
    }' unless defined(&RF_FREELIST_GET_INIT_NOUNLOCK);
    eval 'sub RF_FREELIST_GET {
        local($_fl_,$_obj_,$_nextp_,$_cast_) = @_;
	    eval q( &do {  &void * &_p; \'int\'  &_i;  &RF_LOCK_MUTEX(-> &lock);  &RF_ASSERT($sizeof{} == (-> &obj_size));  &if ( ($_fl_->{objlist})) { $_obj_ = $_cast_(-> &objlist); -> &objlist = (($_obj_)->$_nextp_); ($_fl_)-> &free_cnt--; }  &else {  &RF_Calloc($_obj_, 1, ($_fl_)-> &obj_size, $_cast_);  &if ($_obj_) {  &for ( &_i = 1;  &_i < ($_fl_)-> &obj_inc;  &_i++) {  &RF_Calloc( &_p, 1, ($_fl_)-> &obj_size, ( &void *));  &if ( &_p) { ($_cast_( &_p))->$_nextp_ = ($_fl_)-> &objlist; ($_fl_)-> &objlist =  &_p; }  &else {  &break; } } }  &RF_FREELIST_STAT_GROW($_fl_); }  &RF_FREELIST_STAT_ALLOC($_fl_);  &RF_UNLOCK_MUTEX(($_fl_)-> &lock); }  &while (0));
    }' unless defined(&RF_FREELIST_GET);
    eval 'sub RF_FREELIST_GET_N {
        local($_fl_,$_obj_,$_nextp_,$_cast_,$_num_) = @_;
	    eval q( &do {  &void * &_p, * &_l, * &_f; \'int\'  &_i,  &_n;  &_l =  &_f =  &NULL;  &_n = 0;  &RF_LOCK_MUTEX(-> &lock);  &RF_ASSERT($sizeof{} == (-> &obj_size));  &for ( &_n = 0;  &_n < $_num_;  &_n++) {  &if ( ($_fl_->{objlist})) { $_obj_ = $_cast_(-> &objlist); -> &objlist = (($_obj_)->$_nextp_); ($_fl_)-> &free_cnt--; }  &else {  &RF_Calloc($_obj_, 1, ($_fl_)-> &obj_size, $_cast_);  &if ($_obj_) {  &for ( &_i = 1;  &_i < ($_fl_)-> &obj_inc;  &_i++) {  &RF_Calloc( &_p, 1, ($_fl_)-> &obj_size, ( &void *));  &if ( &_p) { ($_cast_( &_p))->$_nextp_ = ($_fl_)-> &objlist; ($_fl_)-> &objlist =  &_p; }  &else {  &break; } } }  &RF_FREELIST_STAT_GROW($_fl_); }  &if ( &_f ==  &NULL)  &_f = $_obj_;  &if ($_obj_) { ($_cast_($_obj_))->$_nextp_ =  &_l;  &_l = $_obj_;  &RF_FREELIST_STAT_ALLOC($_fl_); }  &else { ($_cast_( &_f))->$_nextp_ = ($_fl_)-> &objlist; ($_fl_)-> &objlist =  &_l;  &_n = $_num_; } }  &RF_UNLOCK_MUTEX(($_fl_)-> &lock); }  &while (0));
    }' unless defined(&RF_FREELIST_GET_N);
    eval 'sub RF_FREELIST_FREE {
        local($_fl_,$_obj_,$_nextp_) = @_;
	    eval q( &do {  &RF_LOCK_MUTEX(-> &lock);  &if (-> &free_cnt == -> &max_free_cnt) {  &RF_Free($_obj_, -> &obj_size); }  &else {  &RF_ASSERT(-> &free_cnt < -> &max_free_cnt); ->$_nextp_ = -> &objlist; -> &objlist = ($_obj_); ($_fl_)-> &free_cnt++; }  &RF_FREELIST_STAT_FREE($_fl_);  &RF_UNLOCK_MUTEX(($_fl_)-> &lock); }  &while (0));
    }' unless defined(&RF_FREELIST_FREE);
    eval 'sub RF_FREELIST_FREE_N {
        local($_fl_,$_obj_,$_nextp_,$_cast_,$_num_) = @_;
	    eval q( &do {  &void * &_no; \'int\'  &_n;  &_n = 0;  &RF_LOCK_MUTEX(-> &lock);  &while {  &_no = ->$_nextp_;  &if (-> &free_cnt == -> &max_free_cnt) {  &RF_Free($_obj_, -> &obj_size); }  &else {  &RF_ASSERT(-> &free_cnt < -> &max_free_cnt); ->$_nextp_ = -> &objlist; -> &objlist = ($_obj_); ($_fl_)-> &free_cnt++; }  &_n++; $_obj_ =  &_no;  &RF_FREELIST_STAT_FREE($_fl_); }  &RF_ASSERT( &_n==($_num_));  &RF_UNLOCK_MUTEX(($_fl_)-> &lock); }  &while (0));
    }' unless defined(&RF_FREELIST_FREE_N);
    eval 'sub RF_FREELIST_FREE_CLEAN {
        local($_fl_,$_obj_,$_nextp_,$_clean_) = @_;
	    eval q( &do {  &RF_LOCK_MUTEX(-> &lock);  &if (-> &free_cnt == -> &max_free_cnt) { $_clean_;  &RF_Free($_obj_, -> &obj_size); }  &else {  &RF_ASSERT(-> &free_cnt < -> &max_free_cnt); ->$_nextp_ = -> &objlist; -> &objlist = ($_obj_); ($_fl_)-> &free_cnt++; }  &RF_FREELIST_STAT_FREE($_fl_);  &RF_UNLOCK_MUTEX(($_fl_)-> &lock); }  &while (0));
    }' unless defined(&RF_FREELIST_FREE_CLEAN);
    eval 'sub RF_FREELIST_FREE_CLEAN_ARG {
        local($_fl_,$_obj_,$_nextp_,$_clean_,$_arg_) = @_;
	    eval q( &do {  &RF_LOCK_MUTEX(-> &lock);  &if (-> &free_cnt == -> &max_free_cnt) { $_clean_($_obj_, $_arg_);  &RF_Free($_obj_, -> &obj_size); }  &else {  &RF_ASSERT(-> &free_cnt < -> &max_free_cnt); ->$_nextp_ = -> &objlist; -> &objlist = ($_obj_); ($_fl_)-> &free_cnt++; }  &RF_FREELIST_STAT_FREE($_fl_);  &RF_UNLOCK_MUTEX(($_fl_)-> &lock); }  &while (0));
    }' unless defined(&RF_FREELIST_FREE_CLEAN_ARG);
    eval 'sub RF_FREELIST_FREE_CLEAN_NOUNLOCK {
        local($_fl_,$_obj_,$_nextp_,$_clean_) = @_;
	    eval q( &do {  &RF_LOCK_MUTEX(-> &lock);  &if (-> &free_cnt == -> &max_free_cnt) { $_clean_;  &RF_Free($_obj_, -> &obj_size); }  &else {  &RF_ASSERT(-> &free_cnt < -> &max_free_cnt); ->$_nextp_ = -> &objlist; -> &objlist = ($_obj_); ($_fl_)-> &free_cnt++; }  &RF_FREELIST_STAT_FREE($_fl_); }  &while (0));
    }' unless defined(&RF_FREELIST_FREE_CLEAN_NOUNLOCK);
    eval 'sub RF_FREELIST_DESTROY {
        local($_fl_,$_nextp_,$_cast_) = @_;
	    eval q( &do {  &void * &_cur, * &_next;  &RF_FREELIST_STAT_REPORT($_fl_);  &rf_mutex_destroy((($_fl_)-> &lock));  &for ( &_cur = ($_fl_)-> &objlist;  &_cur;  &_cur =  &_next) {  &_next = ($_cast_  &_cur)->$_nextp_;  &RF_Free( &_cur, ($_fl_)-> &obj_size); }  &RF_Free($_fl_, $sizeof{ &RF_FreeList_t}); }  &while (0));
    }' unless defined(&RF_FREELIST_DESTROY);
    eval 'sub RF_FREELIST_DESTROY_CLEAN {
        local($_fl_,$_nextp_,$_cast_,$_clean_) = @_;
	    eval q( &do {  &void * &_cur, * &_next;  &RF_FREELIST_STAT_REPORT($_fl_);  &rf_mutex_destroy((($_fl_)-> &lock));  &for ( &_cur = ($_fl_)-> &objlist;  &_cur;  &_cur =  &_next) {  &_next = ($_cast_  &_cur)->$_nextp_; $_clean_( &_cur);  &RF_Free( &_cur, ($_fl_)-> &obj_size); }  &RF_Free($_fl_, $sizeof{ &RF_FreeList_t}); }  &while (0));
    }' unless defined(&RF_FREELIST_DESTROY_CLEAN);
    eval 'sub RF_FREELIST_DESTROY_CLEAN_ARG {
        local($_fl_,$_nextp_,$_cast_,$_clean_,$_arg_) = @_;
	    eval q( &do {  &void * &_cur, * &_next;  &RF_FREELIST_STAT_REPORT($_fl_);  &rf_mutex_destroy((($_fl_)-> &lock));  &for ( &_cur = ($_fl_)-> &objlist;  &_cur;  &_cur =  &_next) {  &_next = ($_cast_  &_cur)->$_nextp_; $_clean_( &_cur, $_arg_);  &RF_Free( &_cur, ($_fl_)-> &obj_size); }  &RF_Free($_fl_, $sizeof{ &RF_FreeList_t}); }  &while (0));
    }' unless defined(&RF_FREELIST_DESTROY_CLEAN_ARG);
}
1;
