require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&SIS_CSR)) {
    sub SIS_CSR () {	0x;}
}
unless(defined(&SIS_CFG)) {
    sub SIS_CFG () {	0x4;}
}
unless(defined(&SIS_EECTL)) {
    sub SIS_EECTL () {	0x8;}
}
unless(defined(&SIS_PCICTL)) {
    sub SIS_PCICTL () {	0xc;}
}
unless(defined(&SIS_ISR)) {
    sub SIS_ISR () {	0x10;}
}
unless(defined(&SIS_IMR)) {
    sub SIS_IMR () {	0x14;}
}
unless(defined(&SIS_IER)) {
    sub SIS_IER () {	0x18;}
}
unless(defined(&SIS_PHYCTL)) {
    sub SIS_PHYCTL () {	0x1c;}
}
unless(defined(&SIS_TX_LISTPTR)) {
    sub SIS_TX_LISTPTR () {	0x20;}
}
unless(defined(&SIS_TX_CFG)) {
    sub SIS_TX_CFG () {	0x24;}
}
unless(defined(&SIS_RX_LISTPTR)) {
    sub SIS_RX_LISTPTR () {	0x30;}
}
unless(defined(&SIS_RX_CFG)) {
    sub SIS_RX_CFG () {	0x34;}
}
unless(defined(&SIS_FLOWCTL)) {
    sub SIS_FLOWCTL () {	0x38;}
}
unless(defined(&SIS_RXFILT_CTL)) {
    sub SIS_RXFILT_CTL () {	0x48;}
}
unless(defined(&SIS_RXFILT_DATA)) {
    sub SIS_RXFILT_DATA () {	0x4c;}
}
unless(defined(&SIS_PWRMAN_CTL)) {
    sub SIS_PWRMAN_CTL () {	0xb0;}
}
unless(defined(&SIS_PWERMAN_WKUP_EVENT)) {
    sub SIS_PWERMAN_WKUP_EVENT () {	0xb4;}
}
unless(defined(&SIS_WKUP_FRAME_CRC)) {
    sub SIS_WKUP_FRAME_CRC () {	0xbc;}
}
unless(defined(&SIS_WKUP_FRAME_MASK0)) {
    sub SIS_WKUP_FRAME_MASK0 () {	0xc0;}
}
unless(defined(&SIS_WKUP_FRAME_MASKXX)) {
    sub SIS_WKUP_FRAME_MASKXX () {	0xec;}
}
unless(defined(&SIS_SILICON_REV)) {
    sub SIS_SILICON_REV () {	0x5c;}
}
unless(defined(&SIS_MIB_CTL0)) {
    sub SIS_MIB_CTL0 () {	0x60;}
}
unless(defined(&SIS_MIB_CTL1)) {
    sub SIS_MIB_CTL1 () {	0x64;}
}
unless(defined(&SIS_MIB_CTL2)) {
    sub SIS_MIB_CTL2 () {	0x68;}
}
unless(defined(&SIS_MIB_CTL3)) {
    sub SIS_MIB_CTL3 () {	0x6c;}
}
unless(defined(&SIS_MIB)) {
    sub SIS_MIB () {	0x80;}
}
unless(defined(&SIS_LINKSTS)) {
    sub SIS_LINKSTS () {	0xa0;}
}
unless(defined(&SIS_TIMEUNIT)) {
    sub SIS_TIMEUNIT () {	0xa4;}
}
unless(defined(&SIS_GPIO)) {
    sub SIS_GPIO () {	0xb8;}
}
unless(defined(&NS_IHR)) {
    sub NS_IHR () {	0x1c;}
}
unless(defined(&NS_CLKRUN)) {
    sub NS_CLKRUN () {	0x3c;}
}
unless(defined(&NS_SRR)) {
    sub NS_SRR () {	0x58;}
}
unless(defined(&NS_BMCR)) {
    sub NS_BMCR () {	0x80;}
}
unless(defined(&NS_BMSR)) {
    sub NS_BMSR () {	0x84;}
}
unless(defined(&NS_PHYIDR1)) {
    sub NS_PHYIDR1 () {	0x88;}
}
unless(defined(&NS_PHYIDR2)) {
    sub NS_PHYIDR2 () {	0x8c;}
}
unless(defined(&NS_ANAR)) {
    sub NS_ANAR () {	0x90;}
}
unless(defined(&NS_ANLPAR)) {
    sub NS_ANLPAR () {	0x94;}
}
unless(defined(&NS_ANER)) {
    sub NS_ANER () {	0x98;}
}
unless(defined(&NS_ANNPTR)) {
    sub NS_ANNPTR () {	0x9c;}
}
unless(defined(&NS_PHY_CR)) {
    sub NS_PHY_CR () {	0xe4;}
}
unless(defined(&NS_PHY_10BTSCR)) {
    sub NS_PHY_10BTSCR () {	0xe8;}
}
unless(defined(&NS_PHY_PAGE)) {
    sub NS_PHY_PAGE () {	0xcc;}
}
unless(defined(&NS_PHY_EXTCFG)) {
    sub NS_PHY_EXTCFG () {	0xf0;}
}
unless(defined(&NS_PHY_DSPCFG)) {
    sub NS_PHY_DSPCFG () {	0xf4;}
}
unless(defined(&NS_PHY_SDCFG)) {
    sub NS_PHY_SDCFG () {	0xf8;}
}
unless(defined(&NS_PHY_TDATA)) {
    sub NS_PHY_TDATA () {	0xfc;}
}
unless(defined(&NS_CLKRUN_PMESTS)) {
    sub NS_CLKRUN_PMESTS () {	0x8000;}
}
unless(defined(&NS_CLKRUN_PMEENB)) {
    sub NS_CLKRUN_PMEENB () {	0x100;}
}
unless(defined(&NS_CLNRUN_CLKRUN_ENB)) {
    sub NS_CLNRUN_CLKRUN_ENB () {	0x1;}
}
unless(defined(&NS_SRR_15C)) {
    sub NS_SRR_15C () {	0x302;}
}
unless(defined(&NS_SRR_15D)) {
    sub NS_SRR_15D () {	0x403;}
}
unless(defined(&NS_SRR_16A)) {
    sub NS_SRR_16A () {	0x505;}
}
unless(defined(&SIS_CSR_TX_ENABLE)) {
    sub SIS_CSR_TX_ENABLE () {	0x1;}
}
unless(defined(&SIS_CSR_TX_DISABLE)) {
    sub SIS_CSR_TX_DISABLE () {	0x2;}
}
unless(defined(&SIS_CSR_RX_ENABLE)) {
    sub SIS_CSR_RX_ENABLE () {	0x4;}
}
unless(defined(&SIS_CSR_RX_DISABLE)) {
    sub SIS_CSR_RX_DISABLE () {	0x8;}
}
unless(defined(&SIS_CSR_TX_RESET)) {
    sub SIS_CSR_TX_RESET () {	0x10;}
}
unless(defined(&SIS_CSR_RX_RESET)) {
    sub SIS_CSR_RX_RESET () {	0x20;}
}
unless(defined(&SIS_CSR_SOFTINTR)) {
    sub SIS_CSR_SOFTINTR () {	0x80;}
}
unless(defined(&SIS_CSR_RESET)) {
    sub SIS_CSR_RESET () {	0x100;}
}
unless(defined(&SIS_CSR_RELOAD)) {
    sub SIS_CSR_RELOAD () {	0x400;}
}
unless(defined(&SIS_CFG_BIGENDIAN)) {
    sub SIS_CFG_BIGENDIAN () {	0x1;}
}
unless(defined(&SIS_CFG_PERR_DETECT)) {
    sub SIS_CFG_PERR_DETECT () {	0x8;}
}
unless(defined(&SIS_CFG_DEFER_DISABLE)) {
    sub SIS_CFG_DEFER_DISABLE () {	0x10;}
}
unless(defined(&SIS_CFG_OUTOFWIN_TIMER)) {
    sub SIS_CFG_OUTOFWIN_TIMER () {	0x20;}
}
unless(defined(&SIS_CFG_SINGLE_BACKOFF)) {
    sub SIS_CFG_SINGLE_BACKOFF () {	0x40;}
}
unless(defined(&SIS_CFG_PCIREQ_ALG)) {
    sub SIS_CFG_PCIREQ_ALG () {	0x80;}
}
unless(defined(&SIS_EECTL_DIN)) {
    sub SIS_EECTL_DIN () {	0x1;}
}
unless(defined(&SIS_EECTL_DOUT)) {
    sub SIS_EECTL_DOUT () {	0x2;}
}
unless(defined(&SIS_EECTL_CLK)) {
    sub SIS_EECTL_CLK () {	0x4;}
}
unless(defined(&SIS_EECTL_CSEL)) {
    sub SIS_EECTL_CSEL () {	0x8;}
}
unless(defined(&SIS_MII_CLK)) {
    sub SIS_MII_CLK () {	0x40;}
}
unless(defined(&SIS_MII_DIR)) {
    sub SIS_MII_DIR () {	0x20;}
}
unless(defined(&SIS_MII_DATA)) {
    sub SIS_MII_DATA () {	0x10;}
}
unless(defined(&SIS_EECMD_WRITE)) {
    sub SIS_EECMD_WRITE () {	0x140;}
}
unless(defined(&SIS_EECMD_READ)) {
    sub SIS_EECMD_READ () {	0x180;}
}
unless(defined(&SIS_EECMD_ERASE)) {
    sub SIS_EECMD_ERASE () {	0x1c0;}
}
unless(defined(&SIS_EE_NODEADDR)) {
    sub SIS_EE_NODEADDR () {	0x8;}
}
unless(defined(&NS_EE_NODEADDR)) {
    sub NS_EE_NODEADDR () {	0x6;}
}
unless(defined(&SIS_PCICTL_SRAMADDR)) {
    sub SIS_PCICTL_SRAMADDR () {	0x1f;}
}
unless(defined(&SIS_PCICTL_RAMTSTENB)) {
    sub SIS_PCICTL_RAMTSTENB () {	0x20;}
}
unless(defined(&SIS_PCICTL_TXTSTENB)) {
    sub SIS_PCICTL_TXTSTENB () {	0x40;}
}
unless(defined(&SIS_PCICTL_RXTSTENB)) {
    sub SIS_PCICTL_RXTSTENB () {	0x80;}
}
unless(defined(&SIS_PCICTL_BMTSTENB)) {
    sub SIS_PCICTL_BMTSTENB () {	0x200;}
}
unless(defined(&SIS_PCICTL_RAMADDR)) {
    sub SIS_PCICTL_RAMADDR () {	0x1f0000;}
}
unless(defined(&SIS_PCICTL_ROMTIME)) {
    sub SIS_PCICTL_ROMTIME () {	0xf000000;}
}
unless(defined(&SIS_PCICTL_DISCTEST)) {
    sub SIS_PCICTL_DISCTEST () {	0x40000000;}
}
unless(defined(&SIS_ISR_RX_OK)) {
    sub SIS_ISR_RX_OK () {	0x1;}
}
unless(defined(&SIS_ISR_RX_DESC_OK)) {
    sub SIS_ISR_RX_DESC_OK () {	0x2;}
}
unless(defined(&SIS_ISR_RX_ERR)) {
    sub SIS_ISR_RX_ERR () {	0x4;}
}
unless(defined(&SIS_ISR_RX_EARLY)) {
    sub SIS_ISR_RX_EARLY () {	0x8;}
}
unless(defined(&SIS_ISR_RX_IDLE)) {
    sub SIS_ISR_RX_IDLE () {	0x10;}
}
unless(defined(&SIS_ISR_RX_OFLOW)) {
    sub SIS_ISR_RX_OFLOW () {	0x20;}
}
unless(defined(&SIS_ISR_TX_OK)) {
    sub SIS_ISR_TX_OK () {	0x40;}
}
unless(defined(&SIS_ISR_TX_DESC_OK)) {
    sub SIS_ISR_TX_DESC_OK () {	0x80;}
}
unless(defined(&SIS_ISR_TX_ERR)) {
    sub SIS_ISR_TX_ERR () {	0x100;}
}
unless(defined(&SIS_ISR_TX_IDLE)) {
    sub SIS_ISR_TX_IDLE () {	0x200;}
}
unless(defined(&SIS_ISR_TX_UFLOW)) {
    sub SIS_ISR_TX_UFLOW () {	0x400;}
}
unless(defined(&SIS_ISR_SOFTINTR)) {
    sub SIS_ISR_SOFTINTR () {	0x800;}
}
unless(defined(&SIS_ISR_HIBITS)) {
    sub SIS_ISR_HIBITS () {	0x8000;}
}
unless(defined(&SIS_ISR_RX_FIFO_OFLOW)) {
    sub SIS_ISR_RX_FIFO_OFLOW () {	0x10000;}
}
unless(defined(&SIS_ISR_TGT_ABRT)) {
    sub SIS_ISR_TGT_ABRT () {	0x100000;}
}
unless(defined(&SIS_ISR_BM_ABRT)) {
    sub SIS_ISR_BM_ABRT () {	0x200000;}
}
unless(defined(&SIS_ISR_SYSERR)) {
    sub SIS_ISR_SYSERR () {	0x400000;}
}
unless(defined(&SIS_ISR_PARITY_ERR)) {
    sub SIS_ISR_PARITY_ERR () {	0x800000;}
}
unless(defined(&SIS_ISR_RX_RESET_DONE)) {
    sub SIS_ISR_RX_RESET_DONE () {	0x1000000;}
}
unless(defined(&SIS_ISR_TX_RESET_DONE)) {
    sub SIS_ISR_TX_RESET_DONE () {	0x2000000;}
}
unless(defined(&SIS_ISR_TX_PAUSE_START)) {
    sub SIS_ISR_TX_PAUSE_START () {	0x4000000;}
}
unless(defined(&SIS_ISR_TX_PAUSE_DONE)) {
    sub SIS_ISR_TX_PAUSE_DONE () {	0x8000000;}
}
unless(defined(&SIS_ISR_WAKE_EVENT)) {
    sub SIS_ISR_WAKE_EVENT () {	0x10000000;}
}
unless(defined(&SIS_IMR_RX_OK)) {
    sub SIS_IMR_RX_OK () {	0x1;}
}
unless(defined(&SIS_IMR_RX_DESC_OK)) {
    sub SIS_IMR_RX_DESC_OK () {	0x2;}
}
unless(defined(&SIS_IMR_RX_ERR)) {
    sub SIS_IMR_RX_ERR () {	0x4;}
}
unless(defined(&SIS_IMR_RX_EARLY)) {
    sub SIS_IMR_RX_EARLY () {	0x8;}
}
unless(defined(&SIS_IMR_RX_IDLE)) {
    sub SIS_IMR_RX_IDLE () {	0x10;}
}
unless(defined(&SIS_IMR_RX_OFLOW)) {
    sub SIS_IMR_RX_OFLOW () {	0x20;}
}
unless(defined(&SIS_IMR_TX_OK)) {
    sub SIS_IMR_TX_OK () {	0x40;}
}
unless(defined(&SIS_IMR_TX_DESC_OK)) {
    sub SIS_IMR_TX_DESC_OK () {	0x80;}
}
unless(defined(&SIS_IMR_TX_ERR)) {
    sub SIS_IMR_TX_ERR () {	0x100;}
}
unless(defined(&SIS_IMR_TX_IDLE)) {
    sub SIS_IMR_TX_IDLE () {	0x200;}
}
unless(defined(&SIS_IMR_TX_UFLOW)) {
    sub SIS_IMR_TX_UFLOW () {	0x400;}
}
unless(defined(&SIS_IMR_SOFTINTR)) {
    sub SIS_IMR_SOFTINTR () {	0x800;}
}
unless(defined(&SIS_IMR_HIBITS)) {
    sub SIS_IMR_HIBITS () {	0x8000;}
}
unless(defined(&SIS_IMR_RX_FIFO_OFLOW)) {
    sub SIS_IMR_RX_FIFO_OFLOW () {	0x10000;}
}
unless(defined(&SIS_IMR_TGT_ABRT)) {
    sub SIS_IMR_TGT_ABRT () {	0x100000;}
}
unless(defined(&SIS_IMR_BM_ABRT)) {
    sub SIS_IMR_BM_ABRT () {	0x200000;}
}
unless(defined(&SIS_IMR_SYSERR)) {
    sub SIS_IMR_SYSERR () {	0x400000;}
}
unless(defined(&SIS_IMR_PARITY_ERR)) {
    sub SIS_IMR_PARITY_ERR () {	0x800000;}
}
unless(defined(&SIS_IMR_RX_RESET_DONE)) {
    sub SIS_IMR_RX_RESET_DONE () {	0x1000000;}
}
unless(defined(&SIS_IMR_TX_RESET_DONE)) {
    sub SIS_IMR_TX_RESET_DONE () {	0x2000000;}
}
unless(defined(&SIS_IMR_TX_PAUSE_START)) {
    sub SIS_IMR_TX_PAUSE_START () {	0x4000000;}
}
unless(defined(&SIS_IMR_TX_PAUSE_DONE)) {
    sub SIS_IMR_TX_PAUSE_DONE () {	0x8000000;}
}
unless(defined(&SIS_IMR_WAKE_EVENT)) {
    sub SIS_IMR_WAKE_EVENT () {	0x10000000;}
}
unless(defined(&SIS_INTRS)) {
    sub SIS_INTRS () {	( &SIS_IMR_RX_OFLOW| &SIS_IMR_TX_UFLOW| &SIS_IMR_TX_OK|  &SIS_IMR_TX_IDLE| &SIS_IMR_RX_OK| &SIS_IMR_RX_ERR|  &SIS_IMR_RX_IDLE|  &SIS_IMR_SYSERR);}
}
unless(defined(&SIS_IER_INTRENB)) {
    sub SIS_IER_INTRENB () {	0x1;}
}
unless(defined(&SIS_PHYCTL_ACCESS)) {
    sub SIS_PHYCTL_ACCESS () {	0x10;}
}
unless(defined(&SIS_PHYCTL_OP)) {
    sub SIS_PHYCTL_OP () {	0x20;}
}
unless(defined(&SIS_PHYCTL_REGADDR)) {
    sub SIS_PHYCTL_REGADDR () {	0x7c0;}
}
unless(defined(&SIS_PHYCTL_PHYADDR)) {
    sub SIS_PHYCTL_PHYADDR () {	0xf800;}
}
unless(defined(&SIS_PHYCTL_PHYDATA)) {
    sub SIS_PHYCTL_PHYDATA () {	0xffff0000;}
}
unless(defined(&SIS_PHYOP_READ)) {
    sub SIS_PHYOP_READ () {	0x20;}
}
unless(defined(&SIS_PHYOP_WRITE)) {
    sub SIS_PHYOP_WRITE () {	0x;}
}
unless(defined(&SIS_TXCFG_DRAIN_THRESH)) {
    sub SIS_TXCFG_DRAIN_THRESH () {	0x3f;}
}
unless(defined(&SIS_TXCFG_FILL_THRESH)) {
    sub SIS_TXCFG_FILL_THRESH () {	0x3f00;}
}
unless(defined(&SIS_TXCFG_DMABURST)) {
    sub SIS_TXCFG_DMABURST () {	0x700000;}
}
unless(defined(&SIS_TXCFG_AUTOPAD)) {
    sub SIS_TXCFG_AUTOPAD () {	0x10000000;}
}
unless(defined(&SIS_TXCFG_LOOPBK)) {
    sub SIS_TXCFG_LOOPBK () {	0x20000000;}
}
unless(defined(&SIS_TXCFG_IGN_HBEAT)) {
    sub SIS_TXCFG_IGN_HBEAT () {	0x40000000;}
}
unless(defined(&SIS_TXCFG_IGN_CARR)) {
    sub SIS_TXCFG_IGN_CARR () {	0x80000000;}
}
unless(defined(&SIS_TXCFG_DRAIN)) {
    sub SIS_TXCFG_DRAIN {
	local($x) = @_;
	eval q(((($x) >> 5) &  &SIS_TXCFG_DRAIN_THRESH));
    }
}
unless(defined(&SIS_TXCFG_FILL)) {
    sub SIS_TXCFG_FILL {
	local($x) = @_;
	eval q((((($x) >> 5) << 8) &  &SIS_TXCFG_FILL_THRESH));
    }
}
unless(defined(&SIS_TXDMA_512BYTES)) {
    sub SIS_TXDMA_512BYTES () {	0x;}
}
unless(defined(&SIS_TXDMA_4BYTES)) {
    sub SIS_TXDMA_4BYTES () {	0x100000;}
}
unless(defined(&SIS_TXDMA_8BYTES)) {
    sub SIS_TXDMA_8BYTES () {	0x200000;}
}
unless(defined(&SIS_TXDMA_16BYTES)) {
    sub SIS_TXDMA_16BYTES () {	0x300000;}
}
unless(defined(&SIS_TXDMA_32BYTES)) {
    sub SIS_TXDMA_32BYTES () {	0x400000;}
}
unless(defined(&SIS_TXDMA_64BYTES)) {
    sub SIS_TXDMA_64BYTES () {	0x500000;}
}
unless(defined(&SIS_TXDMA_128BYTES)) {
    sub SIS_TXDMA_128BYTES () {	0x600000;}
}
unless(defined(&SIS_TXDMA_256BYTES)) {
    sub SIS_TXDMA_256BYTES () {	0x700000;}
}
unless(defined(&SIS_TXCFG_100)) {
    sub SIS_TXCFG_100 () {	( &SIS_TXDMA_64BYTES| &SIS_TXCFG_AUTOPAD|  &SIS_TXCFG_FILL(64)| &SIS_TXCFG_DRAIN(1536));}
}
unless(defined(&SIS_TXCFG_10)) {
    sub SIS_TXCFG_10 () {	( &SIS_TXDMA_32BYTES| &SIS_TXCFG_AUTOPAD|  &SIS_TXCFG_FILL(64)| &SIS_TXCFG_DRAIN(1536));}
}
unless(defined(&SIS_RXCFG_DRAIN_THRESH)) {
    sub SIS_RXCFG_DRAIN_THRESH () {	0x3e;}
}
unless(defined(&SIS_RXCFG_DMABURST)) {
    sub SIS_RXCFG_DMABURST () {	0x700000;}
}
unless(defined(&SIS_RXCFG_RX_JABBER)) {
    sub SIS_RXCFG_RX_JABBER () {	0x8000000;}
}
unless(defined(&SIS_RXCFG_RX_TXPKTS)) {
    sub SIS_RXCFG_RX_TXPKTS () {	0x10000000;}
}
unless(defined(&SIS_RXCFG_RX_RUNTS)) {
    sub SIS_RXCFG_RX_RUNTS () {	0x40000000;}
}
unless(defined(&SIS_RXCFG_RX_GIANTS)) {
    sub SIS_RXCFG_RX_GIANTS () {	0x80000000;}
}
unless(defined(&SIS_RXCFG_DRAIN)) {
    sub SIS_RXCFG_DRAIN {
	local($x) = @_;
	eval q((((($x) >> 3) << 1) &  &SIS_RXCFG_DRAIN_THRESH));
    }
}
unless(defined(&SIS_RXDMA_512BYTES)) {
    sub SIS_RXDMA_512BYTES () {	0x;}
}
unless(defined(&SIS_RXDMA_4BYTES)) {
    sub SIS_RXDMA_4BYTES () {	0x100000;}
}
unless(defined(&SIS_RXDMA_8BYTES)) {
    sub SIS_RXDMA_8BYTES () {	0x200000;}
}
unless(defined(&SIS_RXDMA_16BYTES)) {
    sub SIS_RXDMA_16BYTES () {	0x300000;}
}
unless(defined(&SIS_RXDMA_32BYTES)) {
    sub SIS_RXDMA_32BYTES () {	0x400000;}
}
unless(defined(&SIS_RXDMA_64BYTES)) {
    sub SIS_RXDMA_64BYTES () {	0x500000;}
}
unless(defined(&SIS_RXDMA_128BYTES)) {
    sub SIS_RXDMA_128BYTES () {	0x600000;}
}
unless(defined(&SIS_RXDMA_256BYTES)) {
    sub SIS_RXDMA_256BYTES () {	0x700000;}
}
unless(defined(&SIS_RXCFG)) {
    sub SIS_RXCFG () {	( &SIS_RXCFG_DRAIN(64)| &SIS_RXDMA_256BYTES);}
}
unless(defined(&SIS_RXFILTCTL_ADDR)) {
    sub SIS_RXFILTCTL_ADDR () {	0xf0000;}
}
unless(defined(&NS_RXFILTCTL_MCHASH)) {
    sub NS_RXFILTCTL_MCHASH () {	0x200000;}
}
unless(defined(&NS_RXFILTCTL_ARP)) {
    sub NS_RXFILTCTL_ARP () {	0x400000;}
}
unless(defined(&NS_RXFILTCTL_PERFECT)) {
    sub NS_RXFILTCTL_PERFECT () {	0x8000000;}
}
unless(defined(&SIS_RXFILTCTL_ALLPHYS)) {
    sub SIS_RXFILTCTL_ALLPHYS () {	0x10000000;}
}
unless(defined(&SIS_RXFILTCTL_ALLMULTI)) {
    sub SIS_RXFILTCTL_ALLMULTI () {	0x20000000;}
}
unless(defined(&SIS_RXFILTCTL_BROAD)) {
    sub SIS_RXFILTCTL_BROAD () {	0x40000000;}
}
unless(defined(&SIS_RXFILTCTL_ENABLE)) {
    sub SIS_RXFILTCTL_ENABLE () {	0x80000000;}
}
unless(defined(&SIS_FILTADDR_PAR0)) {
    sub SIS_FILTADDR_PAR0 () {	0x;}
}
unless(defined(&SIS_FILTADDR_PAR1)) {
    sub SIS_FILTADDR_PAR1 () {	0x10000;}
}
unless(defined(&SIS_FILTADDR_PAR2)) {
    sub SIS_FILTADDR_PAR2 () {	0x20000;}
}
unless(defined(&SIS_FILTADDR_MAR0)) {
    sub SIS_FILTADDR_MAR0 () {	0x40000;}
}
unless(defined(&SIS_FILTADDR_MAR1)) {
    sub SIS_FILTADDR_MAR1 () {	0x50000;}
}
unless(defined(&SIS_FILTADDR_MAR2)) {
    sub SIS_FILTADDR_MAR2 () {	0x60000;}
}
unless(defined(&SIS_FILTADDR_MAR3)) {
    sub SIS_FILTADDR_MAR3 () {	0x70000;}
}
unless(defined(&SIS_FILTADDR_MAR4)) {
    sub SIS_FILTADDR_MAR4 () {	0x80000;}
}
unless(defined(&SIS_FILTADDR_MAR5)) {
    sub SIS_FILTADDR_MAR5 () {	0x90000;}
}
unless(defined(&SIS_FILTADDR_MAR6)) {
    sub SIS_FILTADDR_MAR6 () {	0xa0000;}
}
unless(defined(&SIS_FILTADDR_MAR7)) {
    sub SIS_FILTADDR_MAR7 () {	0xb0000;}
}
unless(defined(&NS_FILTADDR_PAR0)) {
    sub NS_FILTADDR_PAR0 () {	0x;}
}
unless(defined(&NS_FILTADDR_PAR1)) {
    sub NS_FILTADDR_PAR1 () {	0x2;}
}
unless(defined(&NS_FILTADDR_PAR2)) {
    sub NS_FILTADDR_PAR2 () {	0x4;}
}
unless(defined(&NS_FILTADDR_FMEM_LO)) {
    sub NS_FILTADDR_FMEM_LO () {	0x200;}
}
unless(defined(&NS_FILTADDR_FMEM_HI)) {
    sub NS_FILTADDR_FMEM_HI () {	0x3fe;}
}
unless(defined(&sis_rxstat)) {
    sub sis_rxstat () {	 &sis_cmdsts;}
}
unless(defined(&sis_txstat)) {
    sub sis_txstat () {	 &sis_cmdsts;}
}
unless(defined(&sis_ctl)) {
    sub sis_ctl () {	 &sis_cmdsts;}
}
unless(defined(&SIS_CMDSTS_BUFLEN)) {
    sub SIS_CMDSTS_BUFLEN () {	0xfff;}
}
unless(defined(&SIS_CMDSTS_PKT_OK)) {
    sub SIS_CMDSTS_PKT_OK () {	0x8000000;}
}
unless(defined(&SIS_CMDSTS_CRC)) {
    sub SIS_CMDSTS_CRC () {	0x10000000;}
}
unless(defined(&SIS_CMDSTS_INTR)) {
    sub SIS_CMDSTS_INTR () {	0x20000000;}
}
unless(defined(&SIS_CMDSTS_MORE)) {
    sub SIS_CMDSTS_MORE () {	0x40000000;}
}
unless(defined(&SIS_CMDSTS_OWN)) {
    sub SIS_CMDSTS_OWN () {	0x80000000;}
}
unless(defined(&SIS_LASTDESC)) {
    sub SIS_LASTDESC {
	local($x) = @_;
	eval q((!(($x)-> &sis_ctl &  &SIS_CMDSTS_MORE))));
    }
}
unless(defined(&SIS_OWNDESC)) {
    sub SIS_OWNDESC {
	local($x) = @_;
	eval q((($x)-> &sis_ctl &  &SIS_CMDSTS_OWN));
    }
}
unless(defined(&SIS_INC)) {
    sub SIS_INC {
	local($x, $y) = @_;
	eval q({  &if (++($x) == $y) $x=0; });
    }
}
unless(defined(&SIS_RXBYTES)) {
    sub SIS_RXBYTES {
	local($x) = @_;
	eval q((($x)-> &sis_ctl &  &SIS_CMDSTS_BUFLEN));
    }
}
unless(defined(&SIS_RXSTAT_COLL)) {
    sub SIS_RXSTAT_COLL () {	0x10000;}
}
unless(defined(&SIS_RXSTAT_LOOPBK)) {
    sub SIS_RXSTAT_LOOPBK () {	0x20000;}
}
unless(defined(&SIS_RXSTAT_ALIGNERR)) {
    sub SIS_RXSTAT_ALIGNERR () {	0x40000;}
}
unless(defined(&SIS_RXSTAT_CRCERR)) {
    sub SIS_RXSTAT_CRCERR () {	0x80000;}
}
unless(defined(&SIS_RXSTAT_SYMBOLERR)) {
    sub SIS_RXSTAT_SYMBOLERR () {	0x100000;}
}
unless(defined(&SIS_RXSTAT_RUNT)) {
    sub SIS_RXSTAT_RUNT () {	0x200000;}
}
unless(defined(&SIS_RXSTAT_GIANT)) {
    sub SIS_RXSTAT_GIANT () {	0x400000;}
}
unless(defined(&SIS_RXSTAT_DSTCLASS)) {
    sub SIS_RXSTAT_DSTCLASS () {	0x1800000;}
}
unless(defined(&SIS_RXSTAT_OVERRUN)) {
    sub SIS_RXSTAT_OVERRUN () {	0x2000000;}
}
unless(defined(&SIS_RXSTAT_RX_ABORT)) {
    sub SIS_RXSTAT_RX_ABORT () {	0x4000000;}
}
unless(defined(&SIS_DSTCLASS_REJECT)) {
    sub SIS_DSTCLASS_REJECT () {	0x;}
}
unless(defined(&SIS_DSTCLASS_UNICAST)) {
    sub SIS_DSTCLASS_UNICAST () {	0x800000;}
}
unless(defined(&SIS_DSTCLASS_MULTICAST)) {
    sub SIS_DSTCLASS_MULTICAST () {	0x1000000;}
}
unless(defined(&SIS_DSTCLASS_BROADCAST)) {
    sub SIS_DSTCLASS_BROADCAST () {	0x2000000;}
}
unless(defined(&SIS_TXSTAT_COLLCNT)) {
    sub SIS_TXSTAT_COLLCNT () {	0xf0000;}
}
unless(defined(&SIS_TXSTAT_EXCESSCOLLS)) {
    sub SIS_TXSTAT_EXCESSCOLLS () {	0x100000;}
}
unless(defined(&SIS_TXSTAT_OUTOFWINCOLL)) {
    sub SIS_TXSTAT_OUTOFWINCOLL () {	0x200000;}
}
unless(defined(&SIS_TXSTAT_EXCESS_DEFER)) {
    sub SIS_TXSTAT_EXCESS_DEFER () {	0x400000;}
}
unless(defined(&SIS_TXSTAT_DEFERED)) {
    sub SIS_TXSTAT_DEFERED () {	0x800000;}
}
unless(defined(&SIS_TXSTAT_CARR_LOST)) {
    sub SIS_TXSTAT_CARR_LOST () {	0x1000000;}
}
unless(defined(&SIS_TXSTAT_UNDERRUN)) {
    sub SIS_TXSTAT_UNDERRUN () {	0x2000000;}
}
unless(defined(&SIS_TXSTAT_TX_ABORT)) {
    sub SIS_TXSTAT_TX_ABORT () {	0x4000000;}
}
unless(defined(&SIS_RX_LIST_CNT)) {
    sub SIS_RX_LIST_CNT () {	64;}
}
unless(defined(&SIS_TX_LIST_CNT)) {
    sub SIS_TX_LIST_CNT () {	128;}
}
unless(defined(&SIS_VENDORID)) {
    sub SIS_VENDORID () {	0x1039;}
}
unless(defined(&SIS_DEVICEID_900)) {
    sub SIS_DEVICEID_900 () {	0x900;}
}
unless(defined(&SIS_DEVICEID_7016)) {
    sub SIS_DEVICEID_7016 () {	0x7016;}
}
unless(defined(&SIS_REV_630E)) {
    sub SIS_REV_630E () {	0x81;}
}
unless(defined(&SIS_REV_630S)) {
    sub SIS_REV_630S () {	0x82;}
}
unless(defined(&SIS_REV_630EA1)) {
    sub SIS_REV_630EA1 () {	0x83;}
}
unless(defined(&SIS_REV_630ET)) {
    sub SIS_REV_630ET () {	0x84;}
}
unless(defined(&SIS_REV_635)) {
    sub SIS_REV_635 () {	0x90;}
}
unless(defined(&SIS_MII_STARTDELIM)) {
    sub SIS_MII_STARTDELIM () {	0x1;}
}
unless(defined(&SIS_MII_READOP)) {
    sub SIS_MII_READOP () {	0x2;}
}
unless(defined(&SIS_MII_WRITEOP)) {
    sub SIS_MII_WRITEOP () {	0x1;}
}
unless(defined(&SIS_MII_TURNAROUND)) {
    sub SIS_MII_TURNAROUND () {	0x2;}
}
unless(defined(&SIS_TYPE_900)) {
    sub SIS_TYPE_900 () {	1;}
}
unless(defined(&SIS_TYPE_7016)) {
    sub SIS_TYPE_7016 () {	2;}
}
unless(defined(&SIS_TYPE_83815)) {
    sub SIS_TYPE_83815 () {	3;}
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{sis_btag}),  ($sc->{sis_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_4( ($sc->{sis_btag}),  ($sc->{sis_bhandle}), $reg));
    }
}
unless(defined(&SIS_TIMEOUT)) {
    sub SIS_TIMEOUT () {	1000;}
}
unless(defined(&ETHER_ALIGN)) {
    sub ETHER_ALIGN () {	2;}
}
unless(defined(&SIS_RXLEN)) {
    sub SIS_RXLEN () {	1536;}
}
unless(defined(&SIS_MIN_FRAMELEN)) {
    sub SIS_MIN_FRAMELEN () {	60;}
}
unless(defined(&SIS_PCI_VENDOR_ID)) {
    sub SIS_PCI_VENDOR_ID () {	0x;}
}
unless(defined(&SIS_PCI_DEVICE_ID)) {
    sub SIS_PCI_DEVICE_ID () {	0x2;}
}
unless(defined(&SIS_PCI_COMMAND)) {
    sub SIS_PCI_COMMAND () {	0x4;}
}
unless(defined(&SIS_PCI_STATUS)) {
    sub SIS_PCI_STATUS () {	0x6;}
}
unless(defined(&SIS_PCI_REVID)) {
    sub SIS_PCI_REVID () {	0x8;}
}
unless(defined(&SIS_PCI_CLASSCODE)) {
    sub SIS_PCI_CLASSCODE () {	0x9;}
}
unless(defined(&SIS_PCI_CACHELEN)) {
    sub SIS_PCI_CACHELEN () {	0xc;}
}
unless(defined(&SIS_PCI_LATENCY_TIMER)) {
    sub SIS_PCI_LATENCY_TIMER () {	0xd;}
}
unless(defined(&SIS_PCI_HEADER_TYPE)) {
    sub SIS_PCI_HEADER_TYPE () {	0xe;}
}
unless(defined(&SIS_PCI_LOIO)) {
    sub SIS_PCI_LOIO () {	0x10;}
}
unless(defined(&SIS_PCI_LOMEM)) {
    sub SIS_PCI_LOMEM () {	0x14;}
}
unless(defined(&SIS_PCI_BIOSROM)) {
    sub SIS_PCI_BIOSROM () {	0x30;}
}
unless(defined(&SIS_PCI_INTLINE)) {
    sub SIS_PCI_INTLINE () {	0x3c;}
}
unless(defined(&SIS_PCI_INTPIN)) {
    sub SIS_PCI_INTPIN () {	0x3d;}
}
unless(defined(&SIS_PCI_MINGNT)) {
    sub SIS_PCI_MINGNT () {	0x3e;}
}
unless(defined(&SIS_PCI_MINLAT)) {
    sub SIS_PCI_MINLAT () {	0xf;}
}
unless(defined(&SIS_PCI_RESETOPT)) {
    sub SIS_PCI_RESETOPT () {	0x48;}
}
unless(defined(&SIS_PCI_EEPROM_DATA)) {
    sub SIS_PCI_EEPROM_DATA () {	0x4c;}
}
unless(defined(&SIS_PCI_CAPID)) {
    sub SIS_PCI_CAPID () {	0x50;}
}
unless(defined(&SIS_PCI_NEXTPTR)) {
    sub SIS_PCI_NEXTPTR () {	0x51;}
}
unless(defined(&SIS_PCI_PWRMGMTCAP)) {
    sub SIS_PCI_PWRMGMTCAP () {	0x52;}
}
unless(defined(&SIS_PCI_PWRMGMTCTRL)) {
    sub SIS_PCI_PWRMGMTCTRL () {	0x54;}
}
unless(defined(&SIS_PSTATE_MASK)) {
    sub SIS_PSTATE_MASK () {	0x3;}
}
unless(defined(&SIS_PSTATE_D0)) {
    sub SIS_PSTATE_D0 () {	0x;}
}
unless(defined(&SIS_PSTATE_D1)) {
    sub SIS_PSTATE_D1 () {	0x1;}
}
unless(defined(&SIS_PSTATE_D2)) {
    sub SIS_PSTATE_D2 () {	0x2;}
}
unless(defined(&SIS_PSTATE_D3)) {
    sub SIS_PSTATE_D3 () {	0x3;}
}
unless(defined(&SIS_PME_EN)) {
    sub SIS_PME_EN () {	0x10;}
}
unless(defined(&SIS_PME_STATUS)) {
    sub SIS_PME_STATUS () {	0x8000;}
}
1;
