require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__NCR_REG_H__)) {
    eval 'sub __NCR_REG_H__ () {1;}' unless defined(&__NCR_REG_H__);
    if(defined(&__OpenBSD__)) {
	eval 'sub ISSCRIPTRAMMAPPED {
	    local($np) = @_;
    	    eval q(( ($np->{scriptmapped})));
	}' unless defined(&ISSCRIPTRAMMAPPED);
    } else {
	eval 'sub ISSCRIPTRAMMAPPED {
	    local($np) = @_;
    	    eval q(( ($np->{vaddr2})));
	}' unless defined(&ISSCRIPTRAMMAPPED);
    }
    eval 'sub ISCON () {0x10;}' unless defined(&ISCON);
    eval 'sub CRST () {0x8;}' unless defined(&CRST);
    eval 'sub SDU () {0x80;}' unless defined(&SDU);
    eval 'sub CHM () {0x40;}' unless defined(&CHM);
    eval 'sub WSS () {0x8;}' unless defined(&WSS);
    eval 'sub WSR () {0x1;}' unless defined(&WSR);
    eval 'sub EWS () {0x8;}' unless defined(&EWS);
    eval 'sub RRE () {0x40;}' unless defined(&RRE);
    eval 'sub SRE () {0x20;}' unless defined(&SRE);
    eval 'sub CREQ () {0x80;}' unless defined(&CREQ);
    eval 'sub CACK () {0x40;}' unless defined(&CACK);
    eval 'sub CBSY () {0x20;}' unless defined(&CBSY);
    eval 'sub CSEL () {0x10;}' unless defined(&CSEL);
    eval 'sub CATN () {0x8;}' unless defined(&CATN);
    eval 'sub CMSG () {0x4;}' unless defined(&CMSG);
    eval 'sub CC_D () {0x2;}' unless defined(&CC_D);
    eval 'sub CI_O () {0x1;}' unless defined(&CI_O);
    eval 'sub DFE () {0x80;}' unless defined(&DFE);
    eval 'sub MDPE () {0x40;}' unless defined(&MDPE);
    eval 'sub BF () {0x20;}' unless defined(&BF);
    eval 'sub ABRT () {0x10;}' unless defined(&ABRT);
    eval 'sub SSI () {0x8;}' unless defined(&SSI);
    eval 'sub SIR () {0x4;}' unless defined(&SIR);
    eval 'sub IID () {0x1;}' unless defined(&IID);
    eval 'sub ILF () {0x80;}' unless defined(&ILF);
    eval 'sub ORF () {0x40;}' unless defined(&ORF);
    eval 'sub OLF () {0x20;}' unless defined(&OLF);
    eval 'sub AIP () {0x10;}' unless defined(&AIP);
    eval 'sub LOA () {0x8;}' unless defined(&LOA);
    eval 'sub WOA () {0x4;}' unless defined(&WOA);
    eval 'sub IRST () {0x2;}' unless defined(&IRST);
    eval 'sub SDP () {0x1;}' unless defined(&SDP);
    eval 'sub FF3210 () {0xf0;}' unless defined(&FF3210);
    eval 'sub ILF1 () {0x80;}' unless defined(&ILF1);
    eval 'sub ORF1 () {0x40;}' unless defined(&ORF1);
    eval 'sub OLF1 () {0x20;}' unless defined(&OLF1);
    eval 'sub LDSC () {0x2;}' unless defined(&LDSC);
    eval 'sub CABRT () {0x80;}' unless defined(&CABRT);
    eval 'sub SRST () {0x40;}' unless defined(&SRST);
    eval 'sub SIGP () {0x20;}' unless defined(&SIGP);
    eval 'sub SEM () {0x10;}' unless defined(&SEM);
    eval 'sub CON () {0x8;}' unless defined(&CON);
    eval 'sub INTF () {0x4;}' unless defined(&INTF);
    eval 'sub SIP () {0x2;}' unless defined(&SIP);
    eval 'sub DIP () {0x1;}' unless defined(&DIP);
    eval 'sub CSIGP () {0x40;}' unless defined(&CSIGP);
    eval 'sub FLF () {0x8;}' unless defined(&FLF);
    eval 'sub CLF () {0x4;}' unless defined(&CLF);
    eval 'sub FM () {0x2;}' unless defined(&FM);
    eval 'sub WRIE () {0x1;}' unless defined(&WRIE);
    eval 'sub BDIS () {0x80;}' unless defined(&BDIS);
    eval 'sub MPEE () {0x8;}' unless defined(&MPEE);
    eval 'sub DFS () {0x20;}' unless defined(&DFS);
    eval 'sub BL_2 () {0x80;}' unless defined(&BL_2);
    eval 'sub BL_1 () {0x40;}' unless defined(&BL_1);
    eval 'sub ERL () {0x8;}' unless defined(&ERL);
    eval 'sub ERMP () {0x4;}' unless defined(&ERMP);
    eval 'sub BOF () {0x2;}' unless defined(&BOF);
    eval 'sub CLSE () {0x80;}' unless defined(&CLSE);
    eval 'sub PFF () {0x40;}' unless defined(&PFF);
    eval 'sub PFEN () {0x20;}' unless defined(&PFEN);
    eval 'sub SSM () {0x10;}' unless defined(&SSM);
    eval 'sub IRQM () {0x8;}' unless defined(&IRQM);
    eval 'sub STD () {0x4;}' unless defined(&STD);
    eval 'sub IRQD () {0x2;}' unless defined(&IRQD);
    eval 'sub NOCOM () {0x1;}' unless defined(&NOCOM);
    eval 'sub STO () {0x400;}' unless defined(&STO);
    eval 'sub GEN () {0x200;}' unless defined(&GEN);
    eval 'sub HTH () {0x100;}' unless defined(&HTH);
    eval 'sub MA () {0x80;}' unless defined(&MA);
    eval 'sub CMP () {0x40;}' unless defined(&CMP);
    eval 'sub SEL () {0x20;}' unless defined(&SEL);
    eval 'sub RSL () {0x10;}' unless defined(&RSL);
    eval 'sub SGE () {0x8;}' unless defined(&SGE);
    eval 'sub UDC () {0x4;}' unless defined(&UDC);
    eval 'sub RST () {0x2;}' unless defined(&RST);
    eval 'sub PAR () {0x1;}' unless defined(&PAR);
    eval 'sub DBLEN () {0x8;}' unless defined(&DBLEN);
    eval 'sub DBLSEL () {0x4;}' unless defined(&DBLSEL);
    eval 'sub ROF () {0x40;}' unless defined(&ROF);
    eval 'sub EXT () {0x2;}' unless defined(&EXT);
    eval 'sub TE () {0x80;}' unless defined(&TE);
    eval 'sub HSC () {0x20;}' unless defined(&HSC);
    eval 'sub CSF () {0x2;}' unless defined(&CSF);
    eval 'sub SMODE () {0xc0;}' unless defined(&SMODE);
    eval 'sub SMODE_HVD () {0x40;}' unless defined(&SMODE_HVD);
    eval 'sub SMODE_SE () {0x80;}' unless defined(&SMODE_SE);
    eval 'sub SMODE_LVD () {0xc0;}' unless defined(&SMODE_LVD);
    eval 'sub LCKFRQ () {0x20;}' unless defined(&LCKFRQ);
    eval 'sub REGJ {
        local($p,$r) = @_;
	    eval q(( &offsetof(\'struct ncr_reg\', $p  $r)));
    }' unless defined(&REGJ);
    eval 'sub REG {
        local($r) = @_;
	    eval q( &REGJ ( &nc_, $r));
    }' unless defined(&REG);
    unless(defined(&TARGET_MODE)) {
	eval 'sub TARGET_MODE () {0;}' unless defined(&TARGET_MODE);
    }
    if((defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
	eval 'sub SCR_BO {
	    local($x) = @_;
    	    eval q(((($x) >> 24) | ((($x) >> 8) & 0xff00) | (($x) << 24) | ((($x) & 0xff00) << 8)));
	}' unless defined(&SCR_BO);
    } else {
	eval 'sub SCR_BO {
	    local($x) = @_;
    	    eval q(($x));
	}' unless defined(&SCR_BO);
    }
    eval 'sub SCR_DATA_OUT () {0x;}' unless defined(&SCR_DATA_OUT);
    eval 'sub SCR_DATA_IN () {0x1000000;}' unless defined(&SCR_DATA_IN);
    eval 'sub SCR_COMMAND () {0x2000000;}' unless defined(&SCR_COMMAND);
    eval 'sub SCR_STATUS () {0x3000000;}' unless defined(&SCR_STATUS);
    eval 'sub SCR_ILG_OUT () {0x4000000;}' unless defined(&SCR_ILG_OUT);
    eval 'sub SCR_ILG_IN () {0x5000000;}' unless defined(&SCR_ILG_IN);
    eval 'sub SCR_MSG_OUT () {0x6000000;}' unless defined(&SCR_MSG_OUT);
    eval 'sub SCR_MSG_IN () {0x7000000;}' unless defined(&SCR_MSG_IN);
    eval 'sub SCR_MOVE_ABS {
        local($l) = @_;
	    eval q(((0x8000000 ^ ( &TARGET_MODE << 1)) | ($l)));
    }' unless defined(&SCR_MOVE_ABS);
    eval 'sub SCR_MOVE_IND {
        local($l) = @_;
	    eval q(((0x28000000 ^ ( &TARGET_MODE << 1)) | ($l)));
    }' unless defined(&SCR_MOVE_IND);
    eval 'sub SCR_MOVE_TBL () {(0x18000000 ^ ( &TARGET_MODE << 1));}' unless defined(&SCR_MOVE_TBL);
    eval 'sub SCR_SEL_ABS () {0x40000000;}' unless defined(&SCR_SEL_ABS);
    eval 'sub SCR_SEL_ABS_ATN () {0x41000000;}' unless defined(&SCR_SEL_ABS_ATN);
    eval 'sub SCR_SEL_TBL () {0x42000000;}' unless defined(&SCR_SEL_TBL);
    eval 'sub SCR_SEL_TBL_ATN () {0x43000000;}' unless defined(&SCR_SEL_TBL_ATN);
    eval 'sub SCR_JMP_REL () {0x4000000;}' unless defined(&SCR_JMP_REL);
    eval 'sub SCR_ID {
        local($id) = @_;
	    eval q(((($id)) << 16));
    }' unless defined(&SCR_ID);
    eval 'sub SCR_WAIT_DISC () {0x48000000;}' unless defined(&SCR_WAIT_DISC);
    eval 'sub SCR_WAIT_RESEL () {0x50000000;}' unless defined(&SCR_WAIT_RESEL);
    eval 'sub SCR_SET {
        local($f) = @_;
	    eval q((0x58000000 | ($f)));
    }' unless defined(&SCR_SET);
    eval 'sub SCR_CLR {
        local($f) = @_;
	    eval q((0x60000000 | ($f)));
    }' unless defined(&SCR_CLR);
    eval 'sub SCR_CARRY () {0x400;}' unless defined(&SCR_CARRY);
    eval 'sub SCR_TRG () {0x200;}' unless defined(&SCR_TRG);
    eval 'sub SCR_ACK () {0x40;}' unless defined(&SCR_ACK);
    eval 'sub SCR_ATN () {0x8;}' unless defined(&SCR_ATN);
    eval 'sub SCR_NO_FLUSH () {0x1000000;}' unless defined(&SCR_NO_FLUSH);
    eval 'sub SCR_COPY {
        local($n) = @_;
	    eval q((0xc0000000 |  &SCR_NO_FLUSH | ($n)));
    }' unless defined(&SCR_COPY);
    eval 'sub SCR_COPY_F {
        local($n) = @_;
	    eval q((0xc0000000 | ($n)));
    }' unless defined(&SCR_COPY_F);
    eval 'sub SCR_REG_OFS {
        local($ofs) = @_;
	    eval q((($ofs) << 16));
    }' unless defined(&SCR_REG_OFS);
    eval 'sub SCR_SFBR_REG {
        local($reg,$op,$data) = @_;
	    eval q((0x68000000 | ( &SCR_REG_OFS( &REG($reg))) | ($op) | (($data)<<8)));
    }' unless defined(&SCR_SFBR_REG);
    eval 'sub SCR_REG_SFBR {
        local($reg,$op,$data) = @_;
	    eval q((0x70000000 | ( &SCR_REG_OFS( &REG($reg))) | ($op) | (($data)<<8)));
    }' unless defined(&SCR_REG_SFBR);
    eval 'sub SCR_REG_REG {
        local($reg,$op,$data) = @_;
	    eval q((0x78000000 | ( &SCR_REG_OFS( &REG($reg))) | ($op) | (($data)<<8)));
    }' unless defined(&SCR_REG_REG);
    eval 'sub SCR_LOAD () {0x;}' unless defined(&SCR_LOAD);
    eval 'sub SCR_SHL () {0x1000000;}' unless defined(&SCR_SHL);
    eval 'sub SCR_OR () {0x2000000;}' unless defined(&SCR_OR);
    eval 'sub SCR_XOR () {0x3000000;}' unless defined(&SCR_XOR);
    eval 'sub SCR_AND () {0x4000000;}' unless defined(&SCR_AND);
    eval 'sub SCR_SHR () {0x5000000;}' unless defined(&SCR_SHR);
    eval 'sub SCR_ADD () {0x6000000;}' unless defined(&SCR_ADD);
    eval 'sub SCR_ADDC () {0x7000000;}' unless defined(&SCR_ADDC);
    eval 'sub SCR_FROM_REG {
        local($reg) = @_;
	    eval q( &SCR_REG_SFBR($reg, &SCR_OR,0));
    }' unless defined(&SCR_FROM_REG);
    eval 'sub SCR_TO_REG {
        local($reg) = @_;
	    eval q( &SCR_SFBR_REG($reg, &SCR_OR,0));
    }' unless defined(&SCR_TO_REG);
    eval 'sub SCR_LOAD_REG {
        local($reg,$data) = @_;
	    eval q( &SCR_REG_REG($reg, &SCR_LOAD,$data));
    }' unless defined(&SCR_LOAD_REG);
    eval 'sub SCR_LOAD_SFBR {
        local($data) = @_;
	    eval q(( &SCR_REG_SFBR ( &gpreg,  &SCR_LOAD, $data)));
    }' unless defined(&SCR_LOAD_SFBR);
    eval 'sub SCR_NO_OP () {0x80000000;}' unless defined(&SCR_NO_OP);
    eval 'sub SCR_JUMP () {0x80080000;}' unless defined(&SCR_JUMP);
    eval 'sub SCR_JUMPR () {0x80880000;}' unless defined(&SCR_JUMPR);
    eval 'sub SCR_CALL () {0x88080000;}' unless defined(&SCR_CALL);
    eval 'sub SCR_CALLR () {0x88880000;}' unless defined(&SCR_CALLR);
    eval 'sub SCR_RETURN () {0x90080000;}' unless defined(&SCR_RETURN);
    eval 'sub SCR_INT () {0x98080000;}' unless defined(&SCR_INT);
    eval 'sub SCR_INT_FLY () {0x98180000;}' unless defined(&SCR_INT_FLY);
    eval 'sub IFFALSE {
        local($arg) = @_;
	    eval q((0x80000 | ($arg)));
    }' unless defined(&IFFALSE);
    eval 'sub IFTRUE {
        local($arg) = @_;
	    eval q((0x | ($arg)));
    }' unless defined(&IFTRUE);
    eval 'sub WHEN {
        local($phase) = @_;
	    eval q((0x30000 | ($phase)));
    }' unless defined(&WHEN);
    eval 'sub IF {
        local($phase) = @_;
	    eval q((0x20000 | ($phase)));
    }' unless defined(&IF);
    eval 'sub DATA {
        local($D) = @_;
	    eval q((0x40000 | (($D) & 0xff)));
    }' unless defined(&DATA);
    eval 'sub MASK {
        local($D,$M) = @_;
	    eval q((0x40000 | ((($M ^ 0xff) & 0xff) << 8)|(($D) & 0xff)));
    }' unless defined(&MASK);
    eval 'sub CARRYSET () {(0x200000);}' unless defined(&CARRYSET);
    if(defined(&__OpenBSD__)) {
	require 'scsi/scsi_message.ph';
	eval 'sub M_COMPLETE () { &MSG_CMDCOMPLETE;}' unless defined(&M_COMPLETE);
	eval 'sub M_EXTENDED () { &MSG_EXTENDED;}' unless defined(&M_EXTENDED);
	eval 'sub M_SAVE_DP () { &MSG_SAVEDATAPOINTER;}' unless defined(&M_SAVE_DP);
	eval 'sub M_RESTORE_DP () { &MSG_RESTOREPOINTERS;}' unless defined(&M_RESTORE_DP);
	eval 'sub M_DISCONNECT () { &MSG_DISCONNECT;}' unless defined(&M_DISCONNECT);
	eval 'sub M_ID_ERROR () { &MSG_INITIATOR_DET_ERR;}' unless defined(&M_ID_ERROR);
	eval 'sub M_ABORT () { &MSG_ABORT;}' unless defined(&M_ABORT);
	eval 'sub M_REJECT () { &MSG_MESSAGE_REJECT;}' unless defined(&M_REJECT);
	eval 'sub M_NOOP () { &MSG_NOOP;}' unless defined(&M_NOOP);
	eval 'sub M_PARITY () { &MSG_PARITY_ERROR;}' unless defined(&M_PARITY);
	eval 'sub M_LCOMPLETE () { &MSG_LINK_CMD_COMPLETE;}' unless defined(&M_LCOMPLETE);
	eval 'sub M_FCOMPLETE () { &MSG_LINK_CMD_COMPLETEF;}' unless defined(&M_FCOMPLETE);
	eval 'sub M_RESET () { &MSG_BUS_DEV_RESET;}' unless defined(&M_RESET);
	eval 'sub M_ABORT_TAG () { &MSG_ABORT_TAG;}' unless defined(&M_ABORT_TAG);
	eval 'sub M_CLEAR_QUEUE () { &MSG_CLEAR_QUEUE;}' unless defined(&M_CLEAR_QUEUE);
	eval 'sub M_INIT_REC () { &MSG_INIT_RECOVERY;}' unless defined(&M_INIT_REC);
	eval 'sub M_REL_REC () { &MSG_REL_RECOVERY;}' unless defined(&M_REL_REC);
	eval 'sub M_TERMINATE () { &MSG_TERM_IO_PROC;}' unless defined(&M_TERMINATE);
	eval 'sub M_SIMPLE_TAG () { &MSG_SIMPLE_Q_TAG;}' unless defined(&M_SIMPLE_TAG);
	eval 'sub M_HEAD_TAG () { &MSG_HEAD_OF_Q_TAG;}' unless defined(&M_HEAD_TAG);
	eval 'sub M_ORDERED_TAG () { &MSG_ORDERED_Q_TAG;}' unless defined(&M_ORDERED_TAG);
	eval 'sub M_IGN_RESIDUE () { &MSG_IGN_WIDE_RESIDUE;}' unless defined(&M_IGN_RESIDUE);
	eval 'sub M_IDENTIFY () { &MSG_IDENTIFY(0, 0);}' unless defined(&M_IDENTIFY);
	eval 'sub M_X_SYNC_REQ () { &MSG_EXT_SDTR;}' unless defined(&M_X_SYNC_REQ);
	eval 'sub M_X_WIDE_REQ () { &MSG_EXT_WDTR;}' unless defined(&M_X_WIDE_REQ);
    } else {
	eval 'sub M_COMPLETE () {(0x);}' unless defined(&M_COMPLETE);
	eval 'sub M_EXTENDED () {(0x1);}' unless defined(&M_EXTENDED);
	eval 'sub M_SAVE_DP () {(0x2);}' unless defined(&M_SAVE_DP);
	eval 'sub M_RESTORE_DP () {(0x3);}' unless defined(&M_RESTORE_DP);
	eval 'sub M_DISCONNECT () {(0x4);}' unless defined(&M_DISCONNECT);
	eval 'sub M_ID_ERROR () {(0x5);}' unless defined(&M_ID_ERROR);
	eval 'sub M_ABORT () {(0x6);}' unless defined(&M_ABORT);
	eval 'sub M_REJECT () {(0x7);}' unless defined(&M_REJECT);
	eval 'sub M_NOOP () {(0x8);}' unless defined(&M_NOOP);
	eval 'sub M_PARITY () {(0x9);}' unless defined(&M_PARITY);
	eval 'sub M_LCOMPLETE () {(0xa);}' unless defined(&M_LCOMPLETE);
	eval 'sub M_FCOMPLETE () {(0xb);}' unless defined(&M_FCOMPLETE);
	eval 'sub M_RESET () {(0xc);}' unless defined(&M_RESET);
	eval 'sub M_ABORT_TAG () {(0xd);}' unless defined(&M_ABORT_TAG);
	eval 'sub M_CLEAR_QUEUE () {(0xe);}' unless defined(&M_CLEAR_QUEUE);
	eval 'sub M_INIT_REC () {(0xf);}' unless defined(&M_INIT_REC);
	eval 'sub M_REL_REC () {(0x10);}' unless defined(&M_REL_REC);
	eval 'sub M_TERMINATE () {(0x11);}' unless defined(&M_TERMINATE);
	eval 'sub M_SIMPLE_TAG () {(0x20);}' unless defined(&M_SIMPLE_TAG);
	eval 'sub M_HEAD_TAG () {(0x21);}' unless defined(&M_HEAD_TAG);
	eval 'sub M_ORDERED_TAG () {(0x22);}' unless defined(&M_ORDERED_TAG);
	eval 'sub M_IGN_RESIDUE () {(0x23);}' unless defined(&M_IGN_RESIDUE);
	eval 'sub M_IDENTIFY () {(0x80);}' unless defined(&M_IDENTIFY);
	eval 'sub M_X_MODIFY_DP () {(0x);}' unless defined(&M_X_MODIFY_DP);
	eval 'sub M_X_SYNC_REQ () {(0x1);}' unless defined(&M_X_SYNC_REQ);
	eval 'sub M_X_WIDE_REQ () {(0x3);}' unless defined(&M_X_WIDE_REQ);
    }
    eval 'sub S_GOOD () {(0x);}' unless defined(&S_GOOD);
    eval 'sub S_CHECK_COND () {(0x2);}' unless defined(&S_CHECK_COND);
    eval 'sub S_COND_MET () {(0x4);}' unless defined(&S_COND_MET);
    eval 'sub S_BUSY () {(0x8);}' unless defined(&S_BUSY);
    eval 'sub S_INT () {(0x10);}' unless defined(&S_INT);
    eval 'sub S_INT_COND_MET () {(0x14);}' unless defined(&S_INT_COND_MET);
    eval 'sub S_CONFLICT () {(0x18);}' unless defined(&S_CONFLICT);
    eval 'sub S_TERMINATED () {(0x20);}' unless defined(&S_TERMINATED);
    eval 'sub S_QUEUE_FULL () {(0x28);}' unless defined(&S_QUEUE_FULL);
    eval 'sub S_ILLEGAL () {(0xff);}' unless defined(&S_ILLEGAL);
    eval 'sub S_SENSE () {(0x80);}' unless defined(&S_SENSE);
    eval 'sub FE_LED0 () {(1<<0);}' unless defined(&FE_LED0);
    eval 'sub FE_WIDE () {(1<<1);}' unless defined(&FE_WIDE);
    eval 'sub FE_ULTRA () {(1<<2);}' unless defined(&FE_ULTRA);
    eval 'sub FE_ULTRA2 () {(1<<3);}' unless defined(&FE_ULTRA2);
    eval 'sub FE_DBLR () {(1<<4);}' unless defined(&FE_DBLR);
    eval 'sub FE_QUAD () {(1<<5);}' unless defined(&FE_QUAD);
    eval 'sub FE_ERL () {(1<<6);}' unless defined(&FE_ERL);
    eval 'sub FE_CLSE () {(1<<7);}' unless defined(&FE_CLSE);
    eval 'sub FE_WRIE () {(1<<8);}' unless defined(&FE_WRIE);
    eval 'sub FE_ERMP () {(1<<9);}' unless defined(&FE_ERMP);
    eval 'sub FE_BOF () {(1<<10);}' unless defined(&FE_BOF);
    eval 'sub FE_DFS () {(1<<11);}' unless defined(&FE_DFS);
    eval 'sub FE_PFEN () {(1<<12);}' unless defined(&FE_PFEN);
    eval 'sub FE_LDSTR () {(1<<13);}' unless defined(&FE_LDSTR);
    eval 'sub FE_RAM () {(1<<14);}' unless defined(&FE_RAM);
    eval 'sub FE_CLK80 () {(1<<15);}' unless defined(&FE_CLK80);
    eval 'sub FE_DIFF () {(1<<16);}' unless defined(&FE_DIFF);
    eval 'sub FE_BIOS () {(1<<17);}' unless defined(&FE_BIOS);
    eval 'sub FE_CACHE_SET () {( &FE_ERL| &FE_CLSE| &FE_WRIE| &FE_ERMP);}' unless defined(&FE_CACHE_SET);
    eval 'sub FE_SCSI_SET () {( &FE_WIDE| &FE_ULTRA| &FE_ULTRA2| &FE_DBLR| &FE_QUAD| &F_CLK80);}' unless defined(&FE_SCSI_SET);
    eval 'sub FE_SPECIAL_SET () {( &FE_CACHE_SET| &FE_BOF| &FE_DFS| &FE_LDSTR| &FE_PFEN| &FE_RAM);}' unless defined(&FE_SPECIAL_SET);
}
1;
