.\"
.\" $XFree86: xc/programs/setxkbmap/setxkbmap.man,v 3.7 2003/05/29 22:16:23 herrb Exp $
.\"
.TH SETXKBMAP 1 __xorgversion__
.SH NAME
setxkbmap
\- set the keyboard using the X Keyboard Extension
.SH SYNOPSIS
.B setxkbmap [
.I args
.B ] [
.I layout
.B [
.I variant
.B [
.I option  ...
.B ] ] ]
.SH DESCRIPTION
The
.B setxkbmap
command maps the keyboard to use the layout determined by the options
specified on the command line.
.P
An XKB keymap is constructed from a number of components which are compiled
only as needed.  The source for all of the components can be found in
.IR __projectroot__/lib/X11/xkb .
.SH OPTIONS
.TP 8
.B \-help
Prints a message describing the valid input to \fIsetxkbmap\fP.
.TP 8
.B \-compat \fIname\fP
Specifies the name of the compatibility map component used to construct
a keyboard layout.
.TP 8
.B \-config \fIfile\fP
Specifies the name of an XKB configuration file which describes the
keyboard to be used.
.TP 8
.B \-display \fIdisplay\fP
Specifies the display to be updated with the new keyboard layout.
.TP 8
.B \-geometry \fIname\fP
Specifies the name of the geometry component used to construct
a keyboard layout.
.TP 8
.B \-keymap \fIname\fP
Specifies the name of the keymap description used to construct
a keyboard layout.
.TP 8
.B \-layout \fIname\fP
Specifies the name of the layout used to determine the components which
make up the keyboard description.  Only one layout may be specified on
the command line.
.TP 8
.B \-model \fIname\fP
Specifies the name of the keyboard model used to determine the components 
which make up the keyboard description.  Only one model may be specified
on the command line.
.TP 8
.B \-option \fIname\fP
Specifies the name of an option to determine the components which make up 
the keyboard description;  multiple options may be specified, one per
\fI-option\fP flag. Note that
.B setxkbmap
summarize options specified in the command
line with options was set before (saved in root window properties). If you
want only specified options will be set use the \fI-option\fP flag with
an empty argument first.
.TP 8
.B \-print
With this option the \fBsetxkbmap\fP just prints component names in a format
acceptable by an \fBxkbcomp\fP (an XKB keymap compiler) and exits. The option
can be used for tests instead of a verbose option and in case when one need
to run both the \fBsetxkbmap\fP and the \fBxkbcomp\fP in chain (see below).
.TP 8
.B \-rules \fIfile\fP
Specifies the name of the rules file used to resolve the request layout
and model to a set of component names.
.TP 8
.B \-symbols \fIname\fP
Specifies the name of the symbols component used to construct
a keyboard layout.
.TP 8
.B \-synch
Force synchronization for X requests.
.TP 8
.B \-types \fIname\fP
Specifies the name of the types component used to construct
a keyboard layout.
.TP 8
.B \-variant \fIname\fP
Specifies which variant of the keyboard layout should be used to determine 
the components which make up the keyboard description.  Only one variant
may be specified on the command line.
.SH USING WITH xkbcomp
If you have an Xserver and a client shell running on different computers and
XKB configuration files sets on those machines are different you can get
problems specifying a keyboard map by model, layout, options names.
The thing is the \fBsetxkbcomp\fP converts these names to names of XKB
configuration files according to files that are on the client side computer. 
Then it sends the file names to the server where the \fBxkbcomp\fP has to
compose a complete keyboard map using files which the server has.
Thus if the sets of files differ significantly the names that the
\fBsetxkbmap\fP generates can be unacceptable on the server side.  You can
solve this problem running the \fBxkbcomp\fP on the client side too.
With the \fI-print\fP option \fBsetxkbmap\fP just prints the files names
in an appropriate format to its stdout and this output can be piped
directly to the \fBxkbcomp\fP input. For example, a command

\fBsetxkbmap us -print | xkbcomp - $DISPLAY\fP

makes both step on the same (client) machine and loads a keyboard map into
the server.
.ig
.SH SEE ALSO
keyboards(1)
..
.SH FILES
.I __projectroot__/lib/X11/xkb
