.\" $XFree86$
.\"
.\" Copyright (C) 2002 The XFree86 Project, Inc.  All Rights Reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person
.\" obtaining a copy of this software and associated documentation
.\" files (the "Software"), to deal in the Software without
.\" restriction, including without limitation the rights to use, copy,
.\" modify, merge, publish, distribute, sublicense, and/or sell copies
.\" of the Software, and to permit persons to whom the Software is
.\" furnished to do so, subject to the following conditions:
.\" 
.\" The above copyright notice and this permission notice shall be
.\" included in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
.\" EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
.\" NONINFRINGEMENT.  IN NO EVENT SHALL THE XFREE86 PROJECT BE LIABLE
.\" FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
.\" CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
.\" WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of the XFree86 Project
.\" shall not be used in advertising or otherwise to promote the sale,
.\" use or other dealings in this Software without prior written
.\" authorization from the XFree86 Project.  
.\"
.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH USBTABLET __drivermansuffix__ __vendorversion__
.SH NAME
usbtablet \- USB tablet input driver for *BSD
.SH SYNOPSIS
.nf
.B "Section \*qInputDevice\*q"
.BI "  Identifier \*q" idevname \*q
.B  "  Driver \*qusbtablet\*q"
.BI "  Option \*qDevice\*q   \*q" devpath \*q
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B usbtablet 
is an XFree86 input driver for USB tablet devices.
.PP
The
.B usbtablet
driver functions as a pointer input device, and may be used as the
X server's core pointer.
.SH SUPPORTED HARDWARE
This driver supports most USB tablets like the Wacom Graphire or
PenPartner tablets. 
.SH CONFIGURATION DETAILS
Please refer to XF86Config(__filemansuffix__) for general configuration
details and for options that can be used with all input drivers.  This
section only covers configuration details specific to this driver.
.PP
Each device
supports the following entries:
.RS 8
.TP 4
.B Option \fI"Type"\fP \fI"stylus"|"eraser"|"cursor"\fP
sets the type of tool the device represent. This option is mandatory.
.TP 4
.B Option \fI"Device"\fP \fI"path"\fP
sets the path to the special file which represents serial line where
the tablet is plugged.  You have to specify it for each subsection with
the same value if you want to have multiple devices with the same tablet.
This option is mandatory.
.TP 4
.B Option \fI"Suppress"\fP \fI"Inumber"\fP
sets the position increment under which not to transmit coordinates.
 If you don't specify this entry, the default value is 2.
.TP 4
.B Option \fI"Threshold"\fP \fI"number"\fP
sets the pressure threshold used to generate a button 1 events of stylus
devices. The default value is 5. 
.TP 4
.B Option \fI"Mode"\fP \fI"Relative"|"Absolute"\fP
sets the mode of the device.
.TP 4
.B Option \fI"HistorySize"\fP \fI"number"\fP
sets the motion history size. By default the value is zero.
.TP 4
.B Option \fI"FactorX"\fP \fI"number"\fP
Scaling factor between tablet coordinates and X screen coordinates. If
you don't specify it, it will be calculated to match the width of your
tablet to the width of your screen. 
.TP 4
.B Option \fI"FactorY"\fP \fI"number"\fP
Scaling factor between tablet coordinates and X screen coordinates. If
you don't specify it, it will be calculated to match the height of your
tablet to the height of your screen. 
.TP 4
.TP 4
.B Option \fI"DebugLevel"\fP \fInumber \fP
sets the level of debugging info reported.
.TP 4
.RE
.SH "SEE ALSO"
XFree86(1), XF86Config(__filemansuffix__), xf86config(1), Xserver(1), X(__miscmansuffix__).
.SH AUTHORS
Lennart Augustsson <augustss@netbsd.org> wrote the original version
for XFree86 3.3.6, Matthieu Herrb <matthieu@openbsd.org> adapted it to
XFree86 4.x. 

